<?php
/**
 * Description of ClienteForm
 *
 * @author carlos
 */

class PagoForm extends Form
{
    public function __construct()
    {
        $this->setActionForm('Pago.php');
        $this->setName('pago');
        $this->setEnctype('multipart/form-data');
        $this->setMethod('post');
        $this->setClass('pago');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'status',
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'fecha',
            'label'=>'Fecha',
            'validators'=>array('date'),
            'required'=> true,
            'class'=>'_datetimepicker'
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'cuenta_bancaria_ordenante',
            'label'=>'Cuenta Ordenante',
            'multiOptions'=>array('0'=>'Seleccionar una opcion...'),
            'required'=> false,
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'cuenta_bancaria',
                'label'=>'Cuenta beneficiario',
            'multiOptions'=>$this->listCuentasBancarias('propias'),
            'required'=> false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'forma_de_pago',
            'label'=>'Forma de pago',
            'multiOptions'=>$this->getListFormasDePago(),
            'optionals'=>array('onchange'=>'setNumCuentaPago();formaDePagoRequiereBanco(this);'),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'num_operacion',
            'label'=>'Num. operacion',
            'required'=> false
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'monto_original',
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'suma_de_pagos',
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'monto',
            'label'=>'Importe',
            'validators'=>array('double'),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'moneda',
            'label'=>'Moneda',
            'multiOptions'=>$this->getListMonedas(),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'tipo_de_cambio',
            'label'=>'Tipo de cambio',
           // 'validators'=>array('double'),
            'required'=> true
        ));

        $this->addElement(array(
            'type'=>'select',
            'name'=>'cliente',
            'label'=>'Cliente',
            'multiOptions'=>$this->getListClientes(),
            'optionals'=>array('onchange'=>'getListFacturasClientes()'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'notas',
            'label'=>'Comentarios',
            'required'=> false
        ));

        $this->addElement(array(
            'type'=>'submit',
            'name'=>'send',
            'value'=>$this->_getTranslation('Guardar'),
            'class'=>'btn btn-primary'
        ));

        $this->addElement(array(
            'id'=> 'adjuntos',
            'type' => 'file',
            'name' => "adjuntos[]",
            'label' => 'Adjuntos',
            'class' => 'file upload',
            'required' => false,
            'optionals' => array(
                'title' => 'Documentos adjuntos',
                'multiple'=>'',
                'data-show-preview'=>false,
                'data-show-upload'=>false

            )
        ));

    }

    public function addItem($idCompra)
    {
        $this->addElement(array(
            'type' => 'text',
            'name' => "pago[$idCompra]",
            'optionals'=>array('style'=>'text-align:right','readOnly'=>'true'),
            'class'=>'ammountPymt',
            'col-size-element'=>'12',
            'required'=>true
        ));
    }

    #Para pagos de consignas.

    #En info consigna guardo serializada la info de la consigna que se paga, esto es para no tener que consultar otra vez.

    #Especialmente consultar y obtener la info de liquidacion de la consigna es tardado.

    #Por eso de opto por guardar asi la info.

    public function addItems($elementId, $consignaData)
    {
        $this->addElement(array(

            'type' => 'text',

            'name' => "pago[$elementId]",

            'optionals'=>array('style'=>'width:90px;text-align:right'),

            'class'=>'ammountPymt',

            'required'=>true

        ));



        $this->addElement(array('type'=>'hidden','name'=>"infoConsigna[$elementId]",'value'=>addslashes(serialize($consignaData))));
    }



    public function setFacturasAPagar($facturas)
    {
        if (!is_array($facturas)) {
            return null;
        }

        foreach ($facturas as $factura => $value) {
            $this->addItem($factura);

            $this->setValueToElement($value, "pago[$factura]");
        }
    }



    public function getListMonedas()
    {
        $repository = new FacturaRepository();

        $result = $repository->getListMoneda();



        $array = array(''=>'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    public function getListClientes()
    {
        $repository = new ClienteRepository();
        $result = $repository->getListSelectClientes();

        if ($result) {
            $array = array(null => 'Selecciona una opcion');
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function getListStatus()
    {
        $repo = new PagoRepository();
        $status = $repo->getListStatus();
        $array = array(''=>'Seleccionar una opcion...');

        foreach ($status as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }

    public function listCuentasBancarias()
    {
        $repository = new CuentaBancariaRepository();
        $result = $repository->getListSelectCuentasBancarias();

        $array = array('0' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function listCuentasBancariasCliente($cliente)
    {
        $repoCliente = new ClienteRepository();
        $result = $repoCliente->getListCuentasBancariasByIdCliente($cliente);

        $array = array('0' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }

    public function getListFormasDePago()
    {
        $repository = new FacturaRepository();
        $result = $repository->getListSelectFormasPago();

        if (count($result)>1) {
            $array = array(''=>'Seleccionar una opcion...');
        }

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function populate($data)
    {
        $this->setPropiedad('cuenta_bancaria_ordenante', array('multiOptions'=>$this->listCuentasBancariasCliente($data['cliente'])));

        $tools = new Tools();
        if ($tools->isValidaDateYYYMMDD($data['fecha'])) {
            $data['fecha'] = $tools->setFormatDateToForm($data['fecha']);
        }

        parent::populate($data);
    }
}
