<?php
class PaymentTermForm extends Form
{
    public function __construct()
    {
        $this->setActionForm('PaymentTerm.php');
        $this->setName('paymentterm');
        $this->setClass('paymentterm');
        $this->setMethod('post');
        $this->setDefaultFormLabelsColSize(4);
        $this->setDefaultFormElementsColSize(8);
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $attributes_wrapper_append_date = array('id'=>'dateDatePicker');
        $login = new Login();
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'name',
            'label'=>'Nombre',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'days',
            'validators'=>array('double'),
            'label'=>'Dias',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions' => $this->getListStatus(),
            'required'=> true
        ));
    }
    
    public function getListStatus()
    {
        $repository = new PaymentTermRepository();
        $list = $repository->getListStatus();
         
        $array = array();
        if ($list) {
            foreach ($list as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }
}
