<?php
class ProductoForm extends Form
{
    public function __construct()
    {
        $this->setActionForm('Producto.php');
        $this->setName('producto');
        $this->setEnctype('multipart/form-data');
        $this->setClass('producto form-horizontal');
        $this->setMethod('post');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'codigo',
            'label'=>'Codigo',
            'value'=>$this->getNextIdProduct(),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'unidad_de_medida',
            'label'=>'Unidad medida',
            'class'=>'triggerable',
            'multiOptions'=>$this->getListaUnidadDeMedida(),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'precio_unitario',
            'label'=>'Precio unitario',
            'validators'=>array('double'),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'descuento',
            'label'=>'Descuento',
            'validators'=>array('double'),
            'required'=>false
        ));
        
        
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'sat_producto_descripcion',
            'label'=>'Buscar por nombre',
            'optionals'=>array('onKeyPress'=>'onEnterSAT(event.keyCode,this)'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'impuestos_incluidos',
            'label'=>'Impuestos incluidos',
            'class'=>'triggerable',
            'multiOptions'=>array(''=>'Seleccionar una opcion...','Si'=>'Si','No'=>'No'),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'impuestos',
            'label'=>'Impuestos',
            'class'=>'triggerable',
            'multiOptions'=>$this->getListaImpuestos(),
            'required'=>false
        ));
        

        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'class'=>'triggerable',
            'multiOptions'=>array('1'=>'Activo','2'=>'Inactivo'),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comentarios',
            'label'=>'Comentarios',
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'tipo',
            'label'=>'Tipo',
            'multiOptions'=>array(''=>'Seleccionar una opcion...','1'=>'Producto','2'=>'Servicio'),
            'optionals'=>array('onchange'=>'setListaDivisiones()'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'division',
            'label'=>'Division',
            'multiOptions'=>array(''=>'Seleccionar una opcion...'),
            'optionals'=>array('onchange'=>'setListaGrupos()'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'grupo',
            'label'=>'Grupo',
            'multiOptions'=>array(''=>'Seleccionar una opcion...'),
            'optionals'=>array('onchange'=>'setListaProductosSAT()'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'sat_producto_clave',
            'label'=>'Producto',
            'required'=>false
        ));
         
        $this->addElement(array(
            'type' => 'select',
            'name' => 'producto_clave',
            'label' => 'Producto',
            'multiOptions' => array('' => 'Seleccionar una opcion...'),
             'optionals'=>array('onchange'=>'SetClaveProductoSat()'),
            'required' => false
        ));

        $this->addElement(array(
            'type' => 'submit',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'class'=>'w-30 btn btn-primary m-t-1 m-b-1'
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'class'=>'btn btn-default _closeModalProduct'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'guardarProducto',
            'value'=> $this->_getTranslation('Guardar'),
            'class'=>'btn btn-primary',
            'optionals'=>array('onclick'=>'saveProductoModal()'),
            'col-size-element'=>'12',
        ));
    }

    public function getListaDivisiones($tipo)
    {
        $repository = new ProductoRepository();

        $result = $repository->getListaDivisionesSATProdServ($tipo);

        

        $array = array('' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }

        return $array;
    }

    

    public function getListaGrupos($division)
    {
        $repository = new ProductoRepository();

        $result = $repository->getListaGruposSATProdServ($division);

        

        $array = array('' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }

        return $array;
    }

    

    public function getListaSATProductos($grupo)
    {
        $repository = new ProductoRepository();

        $result = $repository->getListaSATProductos($grupo);

        

        $array = array('' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }

        return $array;
    }
    
    public function getListSatProducts()
    {
        $repository = new ProductoRepository();
        $result = $repository->getListaProductosSAT($grupo = null);
        $array = array('' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }

        return $array;
    }

    

    public function getListaImpuestos()
    {
        $repository = new ProductoRepository();

        $result = $repository->getListaImpuestos();

        

        $array = array();

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }
    
    public function getModalFormString()
    {
        $formString = "<div class='col-lg-6'>";
        $formString .= $this->getElementString('codigo');
        $formString .= $this->getElementString('nombre');
        $formString .= $this->getElementString('unidad_de_medida');
        $formString .= $this->getElementString('precio_unitario');
        $formString .= $this->getElementString('descuento');
        $formString .= "</div>";
            
        $formString .= "<div class='col-lg-6'>";
        $formString .= $this->getElementString('impuestos');
        $formString .= $this->getElementString('impuestos_incluidos');
        $formString .= $this->getElementString('status');
        $formString .= $this->getElementString('comentarios');
        $formString .= "</div>";
        
        return $formString;
    }
    
    public function getModalFormString2()
    {
        $formString = "<div class='col-md-4'>
            <p><var>Utilizar asistente </var></p>
            <hr style='margin: 0px;margin-bottom: 10px'/>";
        $formString .= $this->getElementString('tipo');
        $formString .= $this->getElementString('division');
        $formString .= $this->getElementString('grupo');
        $formString .= $this->getElementString('producto_clave');
        $formString .= "</div>";
            
        $formString .= "<div class='col-lg-4'>         
            <p><var>Buscar por nombre </var></p>
            <hr style='margin: 0px;margin-bottom: 10px'/>";
        $formString .= $this->getElementString('sat_producto_descripcion');
        $formString .= "</div>
                <div class='col-lg-4'>         
                <p><var>Utilizar clave SAT </var></p>
                <hr style='margin: 0px;margin-bottom: 10px'/> ";
        $formString .= $this->getElementString('sat_producto_clave');
        $formString .= "</div></div>";
        return $formString;
    }

    

    public function getListaUnidadDeMedida()
    {
        $repository = new ProductoRepository();

        $result = $repository->getListaUndadesMedida();

        

        $array = array('' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    

    public function getNextIdProduct()
    {
        $repo = new ProductoRepository();

        $lastId = $repo->getLastIdProduct();

        $nextId = $lastId + 1;

        

        return $nextId;
    }

    

    public function isValid()
    {
        $valid = parent::isValid();
        $flashmessenger = new FlashMessenger();

        $idProducto = $this->getId();
        $codigo = $this->getElement('codigo');
       
        $repository = new ProductoRepository();
        $producto = $repository->existeCodigo($codigo['value'], $idProducto);

        if ($producto) {
            $message  = $this->_getTranslation('Ya se esta utilizando este codigo para el producto: ');
            $message .= $producto['nombre'];
            $flashmessenger->addMessage(array('info'=>$message));
            return null;
        }

        return $valid;
    }

    

    public function populate($data)
    {
        $this->addProperties('division', array('multiOptions'=>$this->getListaDivisiones($data['tipo'])));
        $this->addProperties('grupo', array('multiOptions'=>$this->getListaGrupos($data['division'])));
        // $this->addProperties('sat_producto_clave', array('multiOptions'=>$this->getListaSATProductos($data['grupo'])));
        $this->addProperties('producto_clave', array('multiOptions'=>$this->getListaSATProductos($data['grupo'])));
        $data['producto_clave'] = $data['sat_producto_clave'];

        parent::populate($data);
    }
}
