<?php

/**
 * Description of LoginForm
 * @author carlos augusto vazquez lara
 */

class ReporteForm extends Form
{
    public function __construct()
    {
        $this->setActionForm('Reportes.php');
        $this->setName('reportes');
        $this->setMethod('post');
        $this->setActionController('create');
        $this->setClass('form-horizontal');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'reporte',
            'required' => true
        ));

        $this->addElement(array(
            'label' => 'Formato',
            'type' => 'select',
            'name' => 'output',
            'required' => true
        ));



        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'optionsFromGet',
            'required' => true
        ));

        $attributes_wrapper_append_date = array('class' => 'date', 'id' => 'fechaDatePicker');
        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";

        $this->addElement(array(
            'type' => 'text',
            'name' => 'fechaInicio',
            'label' => 'Fecha inicio',
            'required' => false,
            'append' => $append,
            'wrapper_attributes' => $attributes_wrapper_append_date
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'fechaFin',
            'label' => 'Fecha fin',
            'required' => false,
            'append' => $append,
            'wrapper_attributes' => $attributes_wrapper_append_date
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'serie',
            'label' => 'Serie',
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'folio_below_limit',
            'label' => 'Folio entre',
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'folio_up_limit',
            'label' => 'y',
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'importe_below_limit',
            'label' => 'Importe entre',
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'importe_up_limit',
            'label' => 'y',
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'iva_total_below_limit',
            'label' => 'IVA entre',
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'iva_total_up_limit',
            'label' => 'y',
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'rfc',
            'label' => 'RFC',
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'checkbox',
            'name' => 'saldo_pendiente',
            'label' => 'Con Saldo Pendiente',
            'required' => false,
            'value' => '1',
            'class' => 'switch'
        ));

        $this->addElement(array(
            'type' => 'checkbox',
            'name' => 'saldoInicial',
            'label' => 'Saldo Inicial',
            'required' => false,
            'value' => '1',
            'class' => 'switch'
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'sucursal',
            'label' => 'Sucursal',
            'multiOptions' => $this->getListaSucursales(),
            'required' => true
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'cliente',
            'label' => 'Cliente',
            'multiOptions' => $this->getListaClientes(),
            'required' => true
        ));

        $this->addElement(array(
            'type' => 'submit',
            'name' => 'enviar',
            'value' => 'Enviar',
            'class' => 'btn btn-lg btn-primary'
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'to',
            'label' => 'Para',
            'optionals' => array('style' => 'width:350px;')
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'cc',
            'label' => 'Copia',
            'optionals' => array('style' => 'width:350px;')
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'subject',
            'label' => 'Titulo',
            'optionals' => array('style' => 'width:350px;')
        ));

        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'message',
            'label' => 'Mensaje',
            'optionals' => array('style' => 'width:350px;height:100px')
        ));

        /*PARA ENVIO DE FACTURA POR MAIL*/
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'id_invoice'
        ));
        /* END */

        $this->addElement(array(
            'type' => 'button',
            'name' => 'sendMail',
            'label' => '',
            'value' => $this->_getTranslation('Enviar correo'),
            'class' => 'btn btn-primary',
            'optionals' => array('onclick' => 'sendReportToMail()')
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'cerrar',
            'value' => $this->_getTranslation('Cerrar'),
            'class' => 'btn btn-default btn-lg',
            'optionals' => array(
                'data-dismiss' => 'modal',
                'aria-hidden' => 'true',
            ),
            'col-size-element' => '12',
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'sendInvoice',
            'label' => '',
            'value' => $this->_getTranslation('Enviar correo'),
            'class' => 'btn btn-primary',
            'optionals' => array('onclick' => 'sendInvoiceToMail()')
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'sendNotaCredito',
            'label' => '',
            'value' => $this->_getTranslation('Enviar correo'),
            'class' => 'btn btn-primary',
            'optionals' => array('onclick' => 'sendNotaCreditoToMail()')
        ));

        #crear un nuevo boton para poder usar en el modal de pagosEmail.....

        $this->addElement(array(
            'type' => 'button',
            'name' => 'sendInvoicePago',
            'label' => '',
            'value' => $this->_getTranslation('Enviar correo'),
            'class' => 'btn btn-primary',
            'optionals' => array('onclick' => 'sendInvoiceToMailPago()')
        ));
    }



    public function getListaSucursales()
    {
        $repository = new SucursalRepository();
        $login = new Login();
        $result = $repository->getListSelectSucursales($login->getSucursal());

        $array = array('' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }

    public function getListaClientes()
    {
        $repository = new ClienteRepository();
        $result = $repository->getListSelectClientes();

        $array = array('' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }


    public function getStringFiltersForm($report)
    {
        $formString = '';
        $this->setValueToElement($report, 'reporte');
        switch ($report) {
            case 'facturasPorFecha':
                $this->setPropiedad('output', array('multiOptions' => [
                    'pantalla' => 'Pantalla',
                    'pdf' => 'PDF',
                    'excel' => 'Excel'
                ]));

                $formString .= $this->openForm();
                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('sucursal');
                $formString .= $this->getElementString('cliente');
                $formString .= $this->getElementString('rfc');
                $formString .= $this->getElementString('serie');
                $formString .= $this->getElementString('folio_below_limit');
                $formString .= $this->getElementString('folio_up_limit');
                $formString .= $this->getElementString('importe_below_limit');
                $formString .= $this->getElementString('importe_up_limit');
                $formString .= $this->getElementString('iva_total_below_limit');
                $formString .= $this->getElementString('iva_total_up_limit');
                $formString .= $this->getElementString('saldo_pendiente');
                $formString .= $this->getElementString('reporte');
                $formString .= $this->getElementString('output');
                $formString .= $this->showActionController();
                $formString .= $this->closeForm();
                break;
            case 'facturas_detalles':
                $this->setPropiedad('output', array('multiOptions' => [
                    'excel' => 'excel',
                ]));
                $this->setTarget('_blank');
                $formString .= $this->openForm();
                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('sucursal');
                $formString .= $this->getElementString('cliente');
                $formString .= $this->getElementString('saldoInicial');
                $formString .= $this->getElementString('reporte');
                $formString .= $this->getElementString('output');
                $formString .= $this->showActionController();
                $formString .= $this->closeForm();
                break;
            case 'estado_de_cuenta':
                $this->setPropiedad('output', array('multiOptions' => [
                    'Pdf' => 'pdf',
                    'Excel' => 'excel',
                ]));

                $this->setTarget('_blank');
                $formString .= $this->openForm();
                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('sucursal');
                $formString .= $this->getElementString('cliente');
                $formString .= $this->getElementString('saldoInicial');
                $formString .= $this->getElementString('reporte');
                $formString .= $this->getElementString('output');
                $formString .= $this->showActionController();
                $formString .= $this->closeForm();
                break;
            case 'facturas_detalles_excel':
                $this->setPropiedad('output', array('multiOptions' => [
                    'Excel' => 'excel',
                ]));

                $this->setTarget('_blank');
                $formString .= $this->openForm();

                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('sucursal');
                $formString .= $this->getElementString('cliente');
                $formString .= $this->getElementString('saldoInicial');
                $formString .= $this->getElementString('reporte');
                $formString .= $this->getElementString('output');
                $formString .= $this->showActionController();
                $formString .= $this->closeForm();
                break;
        }

        return $formString;
    }
}
