<?php
/**
 * Description of DatosFacturacionForm
 *
 * @author carlos
 */

class SucursalForm extends Form
{
    public function __construct()
    {
        $this->setName('sucursal');
        $this->setClass('sucursal');
        $this->setMethod('post');
        $this->setEnctype('multipart/form-data');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'regimen_fiscal',
            'label'=>'Regimen fiscal',
            'multiOptions'=>$this->getListaRegimenFiscal(),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'file',
            'name' => 'logo',
            'label' => 'Logo',
            'class' => 'upload',
            'required' => false,
            'optionals' => array(
                'title' => 'Logo para factura'
            ),
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'certificado_independiente',
            'label'=>'Certificado independiente',
            'multiOptions'=>array('No'=>'No','Si'=>'Si'),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'file',
            'name' => "file_key",
            'label' => 'Archivo key',
            'class' => 'upload',
            'required' => false,
            'optionals' => array(
                'title' => 'Archivo key'
            ),
        ));

        $this->addElement(array(
            'type' => 'file',
            'name' => "file_cer",
            'label' => 'Archivo cer',
            'class' => 'upload',
            'required' => false,
            'optionals' => array(
                'title' => 'Archivo cer'
            ),
        ));

        $this->addElement(array(
            'type' => 'password',
            'name' => 'contrasena',
            'label'=>'Clave Privada',
            'required'=> false
        ));

        $this->addElement(array(

            'type' => 'text',

            'name' => 'calle',

            'label'=>'Calle',

            'required'=> false

        ));

        

        $this->addElement(array(

            'type' => 'text',

            'name' => 'numero_exterior',

            'label'=>'Numero exterior',

            'required'=> false,

            'col-size-label'=>'7',

            'col-size-element'=>'5',

        ));

        

        $this->addElement(array(

            'type' => 'text',

            'name' => 'numero_interior',

            'label'=>'Numero interior',

            'required'=> false,

            'col-size-label'=>'7',

            'col-size-element'=>'5',

        ));

                

        $this->addElement(array(

            'type' => 'select',

            'name' => 'pais',

            'label'=>'Pais',

            'multiOptions'=>array('Mexico'=>'Mexico'),

            'required'=>true

        ));

                

        $this->addElement(array(

            'type' => 'select',

            'name' => 'estado',

            'label'=>'Estado (Geográfico)',

            'multiOptions'=>$this->getListEstados(),

            'optionals'=>array('onchange'=>'setMunicipios()'),

            'required'=>false

        ));

                        

        $this->addElement(array(

            'type' => 'select',

            'name' => 'ciudad',

            'label'=>'Ciudad',

            'multiOptions'=>array(''=>'Seleccionar una opcion...'),

            'required'=>false

        ));

                

        $this->addElement(array(

            'type' => 'text',

            'name' => 'codigo_postal',

            'label'=>'Codigo postal',

            'validators'=>array('codigoPostal'),

            #'multiOptions'=>array(0=>'Seleccionar una opcion...'),

            #'optionals'=>array('onchange'=>'setColonias();'),

            'required'=> true

        ));



                

        $this->addElement(array(

            'type' => 'text',

            'name' => 'colonia',

            'label'=>'Colonia',

            #'multiOptions'=>array(0=>'Seleccionar una opcion...'),

            'required'=> false

        ));

        

        $this->addElement(array(

            'type' => 'text',

            'name' => 'nombre_contacto',

            'label'=>'Nombre contacto',

            'required'=> false

        ));

        

        $this->addElement(array(

            'type' => 'text',

            'name' => 'telefono',

            'label'=>'Telefono',

            'required'=> false

        ));

        

        $this->addElement(array(

            'type' => 'text',

            'name' => 'email',

            'label'=>'E-mail',

            'required'=> false

        ));

        

        $this->addElement(array(

            'type' => 'select',

            'name' => 'serie_de_facturacion',

            'label'=>'Serie de facturacion',

            'multiOptions'=>$this->getListSerieDeFacturacion(),

            'required'=>true

        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'serie_de_notas_de_credito',
            'label'=>'Serie de notas de credito',
            'multiOptions'=>$this->getListSerieDeFacturacion(),
            'required'=>true
        ));

        

        $this->addElement(array(

            'type' => 'select',

            'name' => 'serie_de_pago',

            'label'=>'Serie de pagos',

            'multiOptions'=>$this->getListSerieDePagos(),

            'required'=>true

        ));
        
        $this->addElement(array(

            'type' => 'select',

            'name' => 'serie_de_cuenta_de_gastos',

            'label'=>'Serie Cuenta de Gastos',

            'multiOptions'=>$this->getListSerieDeCuentaDeGastos(),

            'required'=>true

        ));

        

        $this->addElement(array(

            'type' => 'select',

            'name' => 'rango_de_facturacion',

            'label'=>'Rango de facturacion',

            'multiOptions'=>$this->getListRangosDeFacturacion(),

            'required'=>true

        ));

        

        $this->addElement(array(

            'type' => 'select',

            'name' => 'status',

            'label'=>'Estado',

            'multiOptions'=>array('1'=>'Activo','2'=>'Inactivo'),

            'required'=>true

        ));

        

        $this->addElement(array(

            'type' => 'button',

            'name' => 'send',

            'value'=> $this->_getTranslation('Terminar'),

            'optionals'=>array(

                'onclick'=>"submit()"),

            'class'=>'btn btn-primary m-t-1'

        ));

        

        $this->addElement(array(

            'type' => 'button',

            'name' => 'cancelar',

            'value'=> $this->_getTranslation('Cancelar'),

            'class'=>'btn btn-default m-t-1 _closeModalUser'

        ));
    }

    

    public function getListaRegimenFiscal()
    {
        $repository = new EmpresaRepository();

        $result = $repository->getListaRegimenFiscal();

        

        $array = array('' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    

    public function getListEstados()
    {
        $repository = new EmpresaRepository();

        $result = $repository->getListEstados();

        

        $array = array('' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    

    public function getListCodigosPostales($estado)
    {
        $repository = new EmpresaRepository();

        $result = $repository->getListSelectCodigosPostales($estado);

        

        $array = array('0' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    

    public function getListCiudades($estado)
    {
        $repository = new EmpresaRepository();

        $result = $repository->getListSelectMunicipios($estado);

        

        $array = array('' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    

    public function getListColonias($codigoPostal)
    {
        $repository = new EmpresaRepository();

        $result = $repository->getListSelectColonias($codigoPostal);

        

        $array = array('0' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    

    public function getListSerieDeFacturacion()
    {
        $repository = new EmpresaRepository();

        $result = $repository->getListSelectSerieDeNotasDeCredito();

        

        $array = array('0' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    

    public function getListSerieDePagos()
    {
        $repository = new EmpresaRepository();

        $result = $repository->getListSelectSerieDePagos();

        

        $array = array('0' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }
    
    public function getListSerieDeCuentaDeGastos()
    {
        $repository = new EmpresaRepository();
        $result = $repository->getListSelectSerieDeCuentaDeGastos();

        $array = array('0' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }

    public function getListRangosDeFacturacion()
    {
        $repository = new EmpresaRepository();

        $result = $repository->getListSelectRangosDeFacturacion();

        

        $array = array('0' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }

            return $array;
        }
    }

    

    public function populate($data)
    {
        unset($data['logo']);
        if ($data['estado'] != null && $data['estado'] != '0') {
            $this->addProperties('ciudad', array('multiOptions'=>$this->getListCiudades($data['estado'])));
        }
        parent::populate($data);
    }

    public function isValid()
    {
        $valid = parent::isValid();
        $flashmessenger = new FlashMessenger();
         
        return $valid;
    }
}
