<?php
/**
 * Description of UsuarioForm
 *
 * @author carlos < te la comes
 */

class TicketForm extends Form {

    public function __construct() {
        $this->setActionForm('Ticket.php');
        $this->setClass('ticket');
        $this->setMethod('post');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init() {  
        $this->addElement(array(
            'type' => 'select',
            'name' => 'sucursal',
            'label'=>'Sucursal',
            'multiOptions' => $this->getListSucursales(),
            'required'=> true
        ));
        
        $attributes_wrapper_append_date = array('id'=>'datePicker');
        $append = "<span class = 'btn input-group-addon' title='Ver documento en PDF'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fecha',
            'label'=>'Fecha',
			'optionals'=>array('placeholder'=>'Formato MM/DD/AAAA Ej. 02/28/2000'),
            'validators'=>array('date'),
            'required'=>true,
            'append'=>$append,
            'wrapper_attributes'=>$attributes_wrapper_append_date
        ));
        
        #Id ticket que se muestra en Ticket
        $this->addElement(array(
            'type' => 'text',
            'name' => 'ticket',
			'optionals'=>array('placeholder'=>'Ej. 601'),
            'label'=>'Ticket (Chk)',
            'required'=> true
        ));
        
        #id de la tabla ticket
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'id_ticket_table',
            'value'=>'0',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'total',
            'label'=>'Venta con IVA',
			'optionals'=>array('placeholder'=>'Ej. 199.50'),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'forma_de_pago',
            'label'=>'Forma de pago',
            'multiOptions'=>$this->getListFormasDePago(),
            'optionals'=>array('onchange'=>'setNumCuentaPago()'),
            'required'=>true
        ));    
       
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'num_cuenta_pago',
            //'label'=>'Num cuenta de pago',			'label'=>'',
            'required'=>false
        ));       
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/User.php'"),
            'class'=>'btn btn-danger m-t-1'
        ));
    }
    
   
    
     public function getListSucursales(){
        $repository = new SucursalRepository();
        $list = $repository->getListSelectSucursales();
         
        $array = array(''=>'Seleccionar una opcion...');
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;
            
    }
    
     public function getListFormasDePago(){
        $repository = new FacturaRepository();
        $result = $repository->getListSelectFormasPago();
        
        if(count($result)>1){ $array = array(''=>'Seleccionar una opcion...');}
        if ($result) {               
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function populate($data){
        if(isset($data['sucursal']) && $data['sucursal']!=null && is_array($data['sucursal'])){
            $sucursales = array();
            foreach($data['sucursal'] as $doctor){
                $sucursales[$doctor] = $doctor;
            }
            $data['sucursal'] = $sucursales;
        }
        parent::populate($data);
    }
}