<?php
class UsuarioForm extends Form
{
    public function __construct()
    {
        $this->setActionForm('Usuario.php');
        $this->setName('usuario');
        $this->setClass('usuario');
        $this->setMethod('post');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'usuario',
            'label'=>'Usuario',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'password',
            'name' => 'contrasena',
            'label'=>'Contrasena',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'apellido',
            'label'=>'Apellido paterno',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'telefono',
            'label'=>'Telefono',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'email',
            'label'=>'Email',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'role',
            'label'=>'Role',
            'multiOptions' => $this->getListRoles(),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'sucursal',
            'label'=>'Sucursal',
            'multiOptions' => $this->getListSucursales(),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions' => $this->getListStatus(),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit(usuario)"),
            'class'=>'btn btn-primary m-t-1'
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'class'=>'btn btn-default m-t-1 _closeModalUser'
        ));
    }
    
    public function getListRoles()
    {
        $repository = new UsuarioRepository();
        $list = $repository->getListRoles();
        $array = array('0' => 'Seleccionar una opcion...');

        foreach ($list as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }

    public function getListStatus()
    {
        $repository = new UsuarioRepository();
        $list = $repository->getListStatus();
        $array = array('0'=>'Seleccionar una opcion...');

        foreach ($list as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }
    
    public function getListSucursales()
    {
        $repository = new SucursalRepository();
        $list = $repository->getListSelectSucursales();
        $array = array('0'=>'Seleccionar una opcion...');

        foreach ($list as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }
    
    public function isValid()
    {
        $valid = parent::isValid();
        $flashmessenger = new FlashMessenger();
         
        return $valid;
    }

    public function populate($data)
    {
        if (isset($data['sucursal']) && $data['sucursal']!=null && is_array($data['sucursal'])) {
            $sucursales = array();
            foreach ($data['sucursal'] as $doctor) {
                $sucursales[$doctor] = $doctor;
            }
            $data['sucursal'] = $sucursales;
        }
        parent::populate($data);
    }
    
    public function setEditForm()
    {
        $this->noRequired(array('contrasena'));
    }
}
