<div class="box-body">
    <div class="box box-primary">
        <div class="box-body">
            <div id="ventas_por_anyo_container" class="col-lg-12 col-xs-12">
                <canvas id="ventas_por_anyo"></canvas>
            </div>
        </div>
    </div>
</div>
<?php

$repo = new FacturaRepository();

$data = $repo->getVentasPorAnyo();

$colors = [
    "#4062bb",
    "#f5d547",
    "#d77c7c",
    "#d26c6c",
    "#003049",
    "#35B022",
    "#e5989b",
    "#457b9d",
    "#a8dadc",
    "#14B250",
    "#2F50E3",
    "#00b4d8",
];
?>
<script>
    var config = {
        type: 'bar',
        data: {
            labels: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiempre', 'Octubre', 'Noviembre', 'Diciembre'],
            datasets: [<?php
                        for ($i = 0; $i < count($data); $i++) {
                            echo "{label: 'Ventas Anuales " . $data[$i]['year'] . "', ";
                            echo "data: [";
                            for ($j = 0; $j < count($data[$i]["months"]); $j++) {
                                echo $data[$i]["months"][$j]["value"];
                                echo ($j < count($data[$i]["months"]) - 1) ? ", " : null;
                            }
                            echo "], ";
                            echo "backgroundColor: [" . str_repeat("'{$colors[$i]}', ", 11) . "'{$colors[$i]}']\n";
                            echo ($i < count($data) - 1) ? "}," : "}";
                        }
                        ?>]
        },
        options: {
            responsive: true,
            legend: {
                position: 'left',
                display: true,
                labels: {
                    fontStyle: 'bold'
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            console.log(context);
                            var label = context.dataset.label || '';

                            if (label) {
                                label += ': ';
                            }
                            if (context.parsed.y !== null) {
                                label += "$ " + number_format(context.parsed.y, 2);
                            }
                            return label;
                        }
                    }
                },
            },
            scales: {
                y: {
                    ticks: {
                        // Include a dollar sign in the ticks
                        callback: function(value, index, values) {
                            return '$ ' + number_format(value, 2);
                        }
                    }
                }
            }
        }
    };

    window.onload = function() {
        var context = document.getElementById('ventas_por_anyo').getContext('2d');
        window.VentasAnuales = new Chart(context, config);
    };
</script>