<!-- START TOP CUSTOMERS -->

<div class="box-body">
    <div class="box box-primary">
        <div class="box-header">
            <div class="pull-right box-tools">
                <span class="btn btn-primary btn-sm pull-right"><i class="fa fa-users"></i></span>
            </div>

            <i class="fa fa-line-chart"></i>
            <h3 class="box-title"><?php echo $_translator->_getTranslation('Top Customers'); ?></h3>
        </div>
        <div class="box-body">
            <div class="col-lg-12 col-xs-12">
                <?php
                $clienteRepo = new ClienteRepository();
                $topCustomerData  = $clienteRepo->getTopCustomers();
                ?>
                <table style="width: 100%;">
                    <thead>
                        <tr>
                            <th>Clientes</th>
                            <th>Pagos Recibidos</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($topCustomerData as $row) : ?>
                            <tr>
                                <td style="text-align:right; padding: 0 15px;width:40%"><?php echo $row['cliente'] ?></td>
                                <td style="padding: 12px 0;width: 35%;">
                                    <div style="margin-bottom:0;position:relative;background-color: #dadada;" class="progress">
                                        <div class="progress-bar progress-bar-striped progress-bar-<?php echo $row['status'] ?>" role="progressbar" aria-valuenow="<?php echo number_format(100 - $row['percentage'] * 100, 0) ?>" aria-valuemin="0" aria-valuemax="100" style="min-width:0.2em; width: <?php echo number_format(100 - $row['percentage'] * 100, 0) ?>%;">
                                        </div>
                                        <div style="position:absolute;left:0;width:100%" class="text-center">$ <?php echo number_format($row['total_facturado'], 2) ?></div>
                                    </div>
                                </td>
                                <td title="$ <?php echo number_format($row['saldo_pendiente'], 2) ?>" style="vertical-align:middle;padding: 0 12px">
                                    <h4 style="margin-top: 0; margin-bottom:5px"><span class="label label-<?php echo $row['status'] ?>"><?php echo number_format(100 - $row['percentage'] * 100, 2) ?> %</span></h4>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- END TOP CUSTOMERS -->


<?php require_once ROOT . '/View/Charts/ventas_por_anyo.php'; ?>

<div class="box-body">
    <div class="box box-primary">
        <div class="box-header">
            <i class="fa fa-file-text-o"></i>
            <h3 class="box-title"><?php echo $_translator->_getTranslation('Facturas pendientes'); ?></h3>
        </div>
        <div class="box-body">
            <?php
            /* Esta parte comprueba si existen facturas pendientes por crearles su pago o pendientes por cobrar,
             * devuelve un arreglo, si existen muestra una lista.
             */
            $entity = new ReporteListRepository();
            $array = $entity->_gadget_facturasPendientesDePago();

            if ($array) { ?>
                <div class="col-lg-12 col-md-6">
                    <div class='table-responsive'>
                        <div class="clear"></div>
                        <table id="tblSalesOrders" class="table table-striped table-hover table-condensed font-size-12" style="width:100%">
                            <tfoot>
                                <th class="filter"><?php echo $_translator->_getTranslation('Fecha'); ?></th>
                                <th class="filter"><?php echo $_translator->_getTranslation('Serie'); ?></th>
                                <th class="filter"><?php echo $_translator->_getTranslation('Folio'); ?></th>
                                <th class="filter"><?php echo $_translator->_getTranslation('Razon Social'); ?></th>
                                <th class="filter"><?php echo $_translator->_getTranslation('Total'); ?></th>
                                <th class="filter"><?php echo $_translator->_getTranslation('Saldo pendiente'); ?></th>
                                <th class="filter"><?php echo $_translator->_getTranslation('Timbrado'); ?></th>
                                <th class="filter"><?php echo $_translator->_getTranslation('Envio'); ?></th>
                                <th class="filter"><?php echo $_translator->_getTranslation('Pago'); ?></th>
                                <th></th>
                            </tfoot>
                            <thead>
                                <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Fecha'); ?></th>
                                <th class="text-center"><?php echo $_translator->_getTranslation('Serie'); ?></th>
                                <th class="text-center"><?php echo $_translator->_getTranslation('Folio'); ?></th>
                                <th class="col-lg-4 col-md-4 text-center"><?php echo $_translator->_getTranslation('Razon Social'); ?></th>
                                <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Total'); ?></th>
                                <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Saldo pendiente'); ?></th>
                                <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Timbrado'); ?></th>
                                <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Envio'); ?></th>
                                <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Pago'); ?></th>
                                <th class="col-lg-2 col-md-2 text-center">Accion</th>
                                <?php

                                foreach ($array as $a) {
                                    $status_timbrado = $a['status'];
                                    $fecha = $a['creado_fecha'];
                                    //echo $a['status'];
                                ?>
                                    <tr>
                                        <td class="text-center"><?php echo substr($fecha, '0', '10'); ?></td>
                                        <td class="text-center"><?php echo $a['serie'] ?></td>
                                        <td class="text-center"><?php echo $a['folio'] ?></td>
                                        <td class="text-center"><?php echo $a['razon_social'] ?></td>
                                        <td class="text-center"><?php echo number_format($a['total'], 2) ?></td>
                                        <td class="text-center"><?php echo number_format($a['saldo_pendiente'], 2) ?></td>
                                        <td class="text-center">
                                            <?php if ($a['status'] == 2) { ?> <a class="btn btn-xs btn-green" href="Factura.php?action=edit&id=<?php echo $a['id'] ?>" title="La factura se timbro."><i class="fa fa-check"></i></a> <?php } else { ?> <a class="btn btn-xs btn-red" href="Factura.php?action=edit&id=<?php echo $a['id'] ?>" title="La factura no se ha timbrado."><i class="fa fa-minus"></i></a> <?php } ?>
                                        </td>
                                        <td class="text-center">
                                            <?php if ($a['enviado'] == 1) { ?> <a class="btn btn-xs btn-green" href="Factura.php?action=edit&id=<?php echo $a['id'] ?>" title="Factura enviada por correo electronico."><i class="fa fa-check"></i></a> <?php } else { ?> <a class="btn btn-xs btn-red" ref="#" onclick="setDataInvoice(this)" data-idinvoice="<?php echo $a['id']; ?> " data-toggle='modal' data-target='#modalInvoiceToMail' title="La factura no se ha enviado por correo electronico."><i class="fa fa-minus"></i></a> <?php } ?>
                                        </td>
                                        <td class="text-center">
                                            <?php if ($a['saldo_pendiente'] == 0) { ?> <a class="btn btn-xs btn-green" href="Factura.php?action=edit&id=<?php echo $a['id'] ?>" title="Ya se recibio el pago de la factura."><i class="fa fa-check"></i></a> <?php } else { ?> <a class="btn btn-xs btn-red" ref="#" title="Aun no se recibe pago."><i class="fa fa-minus"></i></a> <?php } ?>
                                        </td>

                                        <td class="text-center">
                                            <a class="btn btn-xs btn-default" href="Factura.php?action=edit&id=<?php echo $a['id'] ?>" title="Editar"><i class="fa fa-edit"></i></a>
                                            <a class="btn btn-xs btn-default" href="#" onclick="setDataInvoice(this)" data-idinvoice="<?php echo $a['id']; ?>" data-toggle='modal' data-target='#modalInvoiceToMail' title="Enviar por correo electronico"><i class="fa fa-envelope"></i></a>
                                            <a class="btn btn-xs btn-default" href="#" onclick="javascript: void window.open('Factura.php?action=import&flag=pdf&id=<?php echo $a['id'] ?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')" title="Abrir en PDF"><i class="fa fa-file-pdf-o fa-"></i></a>
                                            <a class="btn btn-xs btn-default" href="Pago.php" title="Pagar factura"><i class="fa fa-money"></i></a>
                                        </td>


                                    </tr>
                                <?php
                                }
                                ?>
                            </thead>
                        </table>
                        <span class="pull-right">
                            <a href="Factura.php?action=list" title="Ver lista de facturas">
                                <i class="fa fa-arrow-circle-right ">

                                </i>
                            </a></span>
                        <div class="clearfix"></div>
                    </div>
                </div>
            <?php } ?>
        </div>

    </div>
</div>

<style>
    tfoot {
        display: table-header-group;
    }
</style>

<script>

    $('#tblSalesOrders').DataTable({
        searching: true,
        paginate: false,
        filter: true,
        bFilter: true,
        aaSorting: [],
        dom: 'Bfrtip',
        buttons: [
            'excel',
        ]
    });
    $('#tblSalesOrders')
        .removeClass('display')
        .addClass('table table-striped table-bordered');

    $('#tblSalesOrders tfoot th.filter').each(function() {
        $(this).html('<input type="text" placeholder="<?php echo $_translator->_getTranslation('Buscar') ?>"style="width:100%" />');
    });

    var table = $('#tblSalesOrders').DataTable();
    // Apply the search
    table.columns().every(function() {
        var that = this;
        $('input', this.footer()).on('keyup change', function() {
            if (that.search() !== this.value) {
                that
                    .search(this.value.replace("/;/g", "|"), true, false)
                    .draw();
            }
        });
    });
</script>