<section class="content-header">
    <?php
    $folio = "";
    $statusTitle = null;
    if (isset($facturaData)) :
        $folio = " #{$facturaData['serie']}-{$facturaData['folio']}";
        if (strtoupper($facturaData['statusName']) == 'TIMBRADA' && $facturaData['saldo_pendiente'] == 0) {
            $facturaData['statusName'] = 'Pagada';
        }
        $statusTitle = "{$facturaData['statusName']}";
        $labelStatusType = "default";
        switch (strtoupper($facturaData['statusName'])):
            case 'SIN TIMBRAR':
                $labelStatusType = "info";
                break;
            case 'TIMBRADA':
                $labelStatusType = "primary";
                break;
            case 'CANCELADA':
                $labelStatusType = "danger";
                break;
            case 'PAGADA':
                $labelStatusType = "success";
                break;
        endswitch;
    endif;
    ?>
    <h1>
        <i class='fa-fw fa fa-file-text-o'></i>
        <?php echo $_translator->_getTranslation('Factura') ?>
        <?php echo $folio ?>
    </h1>
    <?php if (isset($facturaData)) : ?>
        <h2 class="label label-<?php echo $labelStatusType ?>"><?php echo $statusTitle ?></h2>
        <?php if (strtoupper($facturaData['statusName']) == 'TIMBRADA') : ?>
            <h2 class="label label-default">UUID: <?php echo $facturaData['uuid'] ?></h2>
        <?php endif; ?>
    <?php endif; ?>
    <ol class="breadcrumb">
        <li><a href="<?php echo ROOT_HOST ?>/Controller/Home.php"><i class="fa fa-dashboard"></i><?php echo $_translator->_getTranslation('Inicio') ?></a></li>
        <li><a href="<?php echo ROOT_HOST ?>/Controller/Factura.php?action=list"><?php echo $_translator->_getTranslation('Lista de facturas') ?></a></li>
        <li class="active"><?php echo $_translator->_getTranslation('Facturas'); ?></li>
    </ol>
</section>
<section class="content">
    <div class="box">
        <?php echo $form->openForm(); ?>
        <div style="display: none"><?php
                                    echo $form->showActionController();
                                    echo $form->showId();
                                    $form->showElement('type');
                                    $form->showElement('status');
                                    $form->showElement('tipo_documento'); ?>
        </div>
        <div class='flashmessenger'><?php $flashmessenger->showMessage(); ?></div>
        <?php
        if ($action == 'edit') : ?>
            <div class="box-body">
                <div class="col-md-12 col-xs-12 text-right">
                    <?php if ($form->getValueElement('status') != '3') : ?>
                        <a href="Factura.php?action=delete&id=<?php echo $facturaData['id'] ?>" class="btn btn-cancelar"><i class="fa fa-ban"></i> Cancelar</a>
                    <?php endif; ?>
                    <?php if ($form->getValueElement('status') == '1') : ?>
                        <a class="btn btn-info" onclick="timbrarFactura()"><span class="fa fa-plus fa-bell"></span> <?php echo $_translator->_getTranslation('Timbrar factura'); ?></a>
                    <?php else : ?>
                        <?php if ($_esCuentaDeGastos == true) : ?>
                            <a class="btn btn-imprimir" onclick="javascript: void window.open('Factura.php?action=import&flag=cuenta_de_gastos&id=<?php echo $form->getId() ?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')"><span class="fa fa-print"></span> <?php echo $_translator->_getTranslation('Imprimir'); ?></a>
                        <?php endif; ?>
                        <?php if ($_esCuentaDeGastos == null) : ?>
                            <a class="btn btn-imprimir" onclick="javascript: void window.open('Factura.php?action=import&flag=factura&id=<?php echo $form->getId() ?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')"><span class="fa fa-print"></span> <?php echo $_translator->_getTranslation('Imprimir'); ?></a>
                        <?php endif; ?>
                        <?php if ($form->getValueElement('status') != '3') : ?>
                            <a class="btn btn-success" href="Factura.php?action=descargar&idFactura=<?php echo $form->getId() ?>" title="Descargar"><i class="fa fa-cloud-download"></i> <?php echo $_translator->_getTranslation('Descargar'); ?></a>
                            <a class="btn btn-info" href="#" onclick="setDataInvoice(this)" data-idinvoice="<?php echo $form->getId(); ?>" data-toggle='modal' data-target='#modalInvoiceToMail' title="Enviar por correo"><i class="fa fa-envelope"></i> <?php echo $_translator->_getTranslation('Enviar por correo'); ?></a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if ($facturaData['saldo_pendiente'] > 0 && strtoupper($facturaData['statusName']) == 'TIMBRADA') : ?>
                        <a data-toggle="modal" href="#modalPagarDesdeFactura" class="btn btn-pagar btn-pagar-factura" data-id-factura="<?php echo $id ?>"><i class="fa fa-money"></i> Pagar</a>
                    <?php endif; ?>
                    <a href="/Controller/Factura.php?action=copy&reference_id=<?php echo $id ?>" class="btn btn-primary"><span class="fa fa-plus"></span> <?php echo $_translator->_getTranslation('Copiar factura'); ?></a>
                    <a href="/Controller/Factura.php" class="btn btn-primary"><span class="fa fa-plus"></span> <?php echo $_translator->_getTranslation('Agregar factura'); ?></a>
                </div>
            </div>
            <div class="clear"></div>
        <?php endif; ?>
        <div class="box-body">
            <div class="card">
                <ul class="nav nav-tabs" role="tablist">
                    <li role="presentation" class="active"><a href="#general" aria-controls="home" role="tab" data-toggle="tab"><?php echo $_translator->_getTranslation('Factura') ?></a></li>
                    <li role="presentation"><a href="#uuids_relacionados" aria-controls="profile" role="tab" data-toggle="tab"><?php echo $_translator->_getTranslation('Relacionar UUID') ?></a></li>
                    <li role="presentation" class="_cuentas"><a href="#cuenta_de_gastos" aria-controls="profile" role="tab" data-toggle="tab"><?php echo $_translator->_getTranslation('Cuenta de Gastos') ?></a></li>
                    <li role="presentation" class="_cuentas"><a href="#adjuntos" aria-controls="profile" role="tab" data-toggle="tab"><?php echo $_translator->_getTranslation('Documentos adjuntos') ?></a></li>
                </ul>
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="general">
                        <div class="box-body">
                            <div class="col-xs-12 col-md-6">
                                <?php
                                $form->showElement('date');
                                $form->showElement('sucursal');
                                $form->showElement('id_cliente');
                                $form->showElement('forma_de_pago');
                                $form->showElement('metodo_de_pago');
                                $form->showElement('num_cuenta_pago'); ?>
                            </div>
                            <div class="col-xs-12 col-md-6">
                                <?php
                                $form->showElement('payment_terms');
                                $form->showElement('due_date');
                                $form->showElement('moneda');
                                $form->showElement('tipo_de_cambio');
                                $form->showElement('uso_cfdi'); ?>
                            </div>
                            <div class="box-body">
                                <div class="clear"></div>
                                <div class='row'>
                                    <h5>Detalles de Factura</h5>
                                    <hr />
                                    <?php
                                    $compraAjax = new FacturaAjax();
                                    $listCompraDetalles = $compraAjax->getListFacturaDetalles($form->getTokenForm()); //echo "<pre>";var_dump($listCompraDetalles); echo "</pre>";exit;
                                    ?>
                                    <table id='detalles-table' style="font-size:11px" class="table table-condensed table-striped table-hover table-thead-customize table-tfoot-customize">
                                        <thead>
                                            <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Accion') ?></th>
                                            <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Codigo'); ?></th>
                                            <th class="col-lg-4"><?php echo $_translator->_getTranslation('Descripcion'); ?></th>
                                            <th class="col-lg-1 text-right"><?php echo $_translator->_getTranslation('Cantidad') ?></th>
                                            <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('UM') ?></th>
                                            <th class="col-lg-1 text-right"><?php echo $_translator->_getTranslation('P.Unit') ?></th>

                                            <th class="col-lg-1 text-right"><?php echo $_translator->_getTranslation('Descuento') ?></th>
                                            <th class="col-lg-1 text-right"><?php echo $_translator->_getTranslation('Total') ?></th>

                                        </thead>
                                        <tbody>
                                            <?php echo $listCompraDetalles['facturaDetalles']; ?>
                                        </tbody>
                                    </table>
                                    <div style="display: none">
                                        <?php
                                        $form->showElement('total_impuestos_retenidos');
                                        $form->showElement('total_impuestos_trasladados');
                                        $form->showElement('subtotal');
                                        $form->showElement('descuento');
                                        $form->showElement('total');
                                        $form->showElement('total_cuenta_de_gastos'); ?>
                                    </div>

                                    <div class="col-xs-12 col-md-3 pull-right">
                                        <div class="col-xs-8 col-md-8 text-right"><?php echo $_translator->_getTranslation('Subtotal') ?></div>
                                        <div id="div-subtotal" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['totalSubtotal'], 2); ?></div>
                                        <div class="col-xs-8 col-md-8 text-right"><?php echo $_translator->_getTranslation('Descuento') ?></div>
                                        <div id="div-descuento" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['totalDescuento'], 2); ?></div>
                                        <div class="col-xs-8 col-md-8 text-right">Subtotal</div>
                                        <div id="div-grandSubtotal" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['grandSubtotal'], 2); ?></div>
                                    </div>

                                    <div class="clear"></div>
                                    <div id="totalImpuestos" class="col-xs-3 col-md-3 pull-right">
                                        <?php echo $listCompraDetalles['stringImpuestos'] ?>
                                    </div>
                                    <div class="clear"></div>
                                    <div class="col-xs-3 col-md-3 pull-right">
                                        <div class="col-xs-8 col-md-8 text-right"><?php echo $_translator->_getTranslation('Total') ?></div>
                                        <div id="div-total" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['total'], 2) ?></div>
                                    </div>
                                </div>
                                <div class="row">
                                    <?php $form->showElement('idDetailTemp'); ?>
                                    <div class='col-lg-4'>
                                        <?php $element = $form->getElement('id_producto'); ?>
                                        <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                    <div class='col-lg-4'>
                                        <?php $element = $form->getElement('descripcion'); ?>
                                        <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                    <div class='col-lg-1'>
                                        <?php $element = $form->getElement('cantidad'); ?>
                                        <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>

                                    <div class='col-lg-2'>
                                        <?php $element = $form->getElement('precio_unitario'); ?>
                                        <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                    <div class='col-lg-1'>
                                        <?php $element = $form->getElement('descuento_detalle'); ?>
                                        <div class='col-lg-12 p-a-0'><label><small><?php echo $element['label'] ?></small></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                </div>

                                <div class="row" style="margin-top: 30px;">
                                    <div class="col-lg-4">
                                        <?php $element = $form->getElement('comentarios'); ?>
                                        <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="pull-right">
                                        <?php $element = $form->getElement('buscar'); ?>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="uuids_relacionados">
                        <div class="box-body">
                            <div class="col-xs-12 col-md-6">
                                <?php $form->showElement('tipo_relacion');
                                $form->showElement('uuid_relacionados');
                                $form->showElement('uuid_relacionados_otros');
                                $form->showElement('add_uuid_relacionados_otros'); ?>
                            </div>
                        </div>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="adjuntos">
                        <div class="box-body">
                            <div class="col-lg-6">
                                <?php // $form->showElement('adjunto[]');
                                ?>
                                <div class="form-group">
                                    <label class="adjunto[] control-label col-lg-3 col-md-3 col-sm-3 col-xs-12"> Documentos adjuntos</label>
                                    <input type="file" id="adjunto" name="adjunto[]" value="" class="form-control file upload" title="Documentos adjuntos" multiple="" data-show-preview="" data-show-upload="">

                                    <?php if (isset($facturaData['status']) && $facturaData['status'] != '1') : ?>
                                        <button style="margin-top:1em" class="btn btn-primary pull-right" id="adjuntar-archivo">Adjuntar</button>
                                    <?php endif; ?>
                                </div>
                                <?php $factura->getListFiles($form->getId()); ?>
                            </div>
                        </div>
                    </div>

                    <?php
                    if ($_cuentaDeGastosActiva == '1') { ?>
                        <div role="tabpanel" class="tab-pane" id="cuenta_de_gastos">
                            <div class="box-body">
                                <?php $compraAjax = new FacturaAjax();
                                $listCompraDetalles = $compraAjax->getListCuentaDeGastosDetalles(); //echo "<pre>";var_dump($listCompraDetalles); echo "</pre>";exit;
                                ?>
                                <h5>Detalles Cuenta de Gastos</h5>
                                <hr />
                                <table id='cg-detalles-table' style="font-size:11px" class="table table-condensed table-striped table-hover table-thead-customize table-tfoot-customize">
                                    <thead>
                                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Accion') ?></th>
                                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Codigo'); ?></th>
                                        <th class="col-lg-8"><?php echo $_translator->_getTranslation('Descripcion'); ?></th>
                                        <th class="col-lg-2 text-right"><?php echo $_translator->_getTranslation('Total') ?></th>
                                    </thead>
                                    <tbody>
                                        <?php echo $listCompraDetalles['cuentaDeGastosDetalles']; ?>
                                    </tbody>
                                </table>


                                <div class="col-xs-12 col-md-3 pull-right">
                                    <div class="col-xs-8 col-md-8 text-right"><?php echo $_translator->_getTranslation('Total') ?></div>
                                    <div id="div-cg-total" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['total'], 2) ?></div>
                                </div>
                                <div class="clear"></div>
                                <div class="row">
                                    <?php echo $form->showElement('cg_idDetailTemp'); ?>
                                    <div class='col-lg-4'>
                                        <?php $element = $form->getElement('cg_id_producto'); ?>
                                        <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                    <div class='col-lg-4'>
                                        <?php $element = $form->getElement('cg_descripcion'); ?>
                                        <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                    <div class='col-lg-1'>
                                        <?php $element = $form->getElement('cg_precio_unitario'); ?>
                                        <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                    <div class='col-lg-2 m-t-2 p-t-1'>
                                        <?php $element = $form->getElement('buscar_cg'); ?>
                                        <div class='col-lg-12 p-a-0'><label></label></div>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                </div>
            </div>
            <hr style="margin: 0; padding: 5px" />
            <div class="row" style="">
                <div class="pull-right">
                    <div class='col-lg-6 p-t-3'>
                        <?php $element = $form->getElement('terminar'); ?>
                        <?php echo $form->createElement($element); ?>
                    </div>
                </div>
            </div>
        </div><!-- /.box-body -->

        <?php echo $form->closeForm(); ?>
    </div><!-- /.box -->
</section>
<style>
    form.factura label.tipo_documento,
    form.factura label.lugar_de_expedicion,
    form.factura label.tipo_de_cambio,
    form.factura label.forma_de_pago,
    form.factura label.metodo_de_pago,
    form.factura label.num_cuenta_pago,
    form.factura label.condiciones_de_pago,
    form.factura label.aux_uuid_relacionados_otros,
    form.factura label.uso_cfdi {
        padding-top: 0px;
    }

    form.factura #subtotal,
    form.factura #descuento,
    form.factura #total {
        padding: 0px;
        border: 0px;
        box-shadow: 0px 0px 0px;
        text-align: right;
        height: 21px;
    }

    .breadcrumb {
        display: inline-block;
        text-align: left;
        padding: 0px;
    }

    .thumbnail {
        height: 35px;
        width: 260px;
    }

    .thumbnail .caption {
        padding-top: 2px;
        padding-bottom: 0px;
        padding-left: 0px;
        padding-right: 0px;
    }

    .lista {
        display: inline;
        float: right;
        padding: 5px;
        margin: 0;
    }

    #trash {
        width: 6;
        height: 6;
    }
</style>
<script>
    $('#forma_de_pago').select2();
    $('#payment_terms').select2();
    $('#metodo_de_pago').select2();
    $('#moneda').select2();
    $('#uso_cfdi').select2();
    $('#tipo_relacion').select2();
    $('#uuid_relacionados').select2();
    $('select#id_cliente.no-autocomplete').select2();
    $('select#id_producto.no-autocomplete').select2();

    $('select#id_cliente.autocomplete').select2({
        ajax: {
            delay: 800,
            url: '/Controller/Cliente.php',
            data: function(params) {
                var query = {
                    search: params.term,
                    action: 'ajax',
                    request: 'getClientList'
                }

                // Query parameters will be ?search=[term]&type=public
                return query;
            },
            processResults: function(data) {
                var orig = $.parseJSON(data);
                var formatted = [];
                orig.forEach(element => {
                    formatted.push({
                        id: element.id,
                        text: element.razon_social
                    });
                });
                return {
                    results: formatted
                };
            }
        }
    });


    $('select#id_producto.autocomplete').select2({
        ajax: {
            delay: 800,
            url: '/Controller/Producto.php',
            data: function(params) {
                var query = {
                    search: params.term,
                    action: 'ajax',
                    request: 'getProductListBySearchTerm'
                }

                // Query parameters will be ?search=[term]&type=public
                return query;
            },
            processResults: function(data) {
                var orig = $.parseJSON(data);
                var formatted = [];
                orig.forEach(element => {
                    formatted.push({
                        id: element.id,
                        text: element.nombre
                    });
                });
                return {
                    results: formatted
                };
            }
        }
    });


    $(".datePicker").datetimepicker({
        format: 'MM/DD/YYYY'
    });
    $('#form_factura').on('change', '#payment_terms', function(e) {
        $.post('PaymentTerm.php', {
            action: 'ajax',
            request: 'setDueDate',
            date: $('#form_factura #date').val(),
            payment_terms: $(e.currentTarget).val()
        }, function(data) {
            if (data.response)
                $('#form_factura #date').val(data.due_date);
        })
    });

    $('#uuid_relacionados_otros').select2().on("select2:unselect", function(e) {
        var data = e.params.data;
        $("#uuid_relacionados_otros option[value='" + data.id + "']").remove();
    });

    $('#id_cliente').on('change', function() {
        getVendorMethodPaymentOnSale();
    });
    $('#date').on('dp.change', function() {
        setDueDate();
    });
    $('#payment_terms').on('change', function() {
        setDueDate();
    });

    $(document).ready(function() {
        switch ($('#form_factura #moneda').val()) {
            case 'MXN':
                $('#form_factura #tipo_de_cambio').val("1.0").attr({
                    readOnly: 'readOnly'
                });
                break;
            default:
                $('#form_factura #tipo_de_cambio').attr({
                    readOnly: null
                }).val(null);
                break;
        }
    });

    $('#form_factura #moneda').on('change', function() {
        var curr = $(this).val();
        switch (curr) {
            case 'MXN':
                $('#form_factura #tipo_de_cambio').val("1.0").attr({
                    readOnly: 'readOnly'
                });
                break;
            default:
                $('#form_factura #tipo_de_cambio').attr({
                    readOnly: null
                }).val(null);
                break;
        }

        $('#form_factura #tipo_de_cambio').focus();
    });

    $('._addProduct').on('click', function() {
        clearForm('producto');
        $('form[name=producto] #action').val('insert');
        $('form[name=producto] #id').val('');
        $('.flashmessenger').html('');
        _getTranslation('Agregar producto', function(msj) {
            $('#title_modal_user').html(msj);
        });
        $('#modalAddProduct').modal('show');
    });

    $(function() {
        var products = new Bloodhound({
            datumTokenizer: Bloodhound.tokenizers.whitespace,
            queryTokenizer: Bloodhound.tokenizers.whitespace,
            remote: {
                url: '<?php echo ROOT_HOST ?>/Controller/Ajax.php?action=ajax&request=searchByDescriptionWildCard&wildCard=%QUERY',
                wildcard: '%QUERY'
            }
        });
        $('#sat_producto_descripcion').typeahead(null, {
            name: 'products',
            display: 'descripcion',
            source: products,
            minLength: 3,
            limit: 50
        });
        $('#sat_producto_descripcion').bind('typeahead:select', function(ev, suggestion) {
            $('#sat_producto_clave').val(suggestion.clave);
        });
        $('#sat_producto_descripcion').bind('typeahead:autocomplete', function(ev, suggestion) {
            $('#sat_producto_clave').val(suggestion.clave);
        });
    });

    //DOCUMENTOS ADJUNTOS
    $("#adjunto").fileinput({
        showPreview: false,
        showUpload: false,
        maxFileSize: 1000,
        removeFromPreviewOnError: true,
        elErrorContainer: '#kartik-file-errors',
        allowedFileExtensions: ["pdf"]
        //uploadUrl: '/site/file-upload-single'
    });

    $('#adjuntar-archivo').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();

        var form = document.getElementById('form_factura');
        var formData = new FormData(form);

        formData.append('action', 'ajax');
        formData.append('request', 'uploadFileOnly');

        $.ajax({
            url: '/Controller/Factura.php',
            type: "post",
            dataType: 'text json',
            data: formData,
            cache: false,
            contentType: false,
            processData: false

        }).done(function(data) {
            $('.flashmessenger').html(data.message);

            if (data.response) {
                document.location = document.location;
            }
        });
    });

    $(".invoiceFile").on("click", function() {
        deleteFilesFacturas(this);
    });
    //FIN DOCUMENTOS ADJUNTOS

    $("._addCustomer").on('click', function() {
        $("#modalAddCustomerModalModal").modal("show");
    });

    $('._saveCliente').on('click', function() {
        _gadgetSaveForm('cliente', function(data) {
            if (data.response) {
                getCustomerList(function(r) {
                    $('#id_cliente').html(r.customerList);
                    $('#id_cliente').val(data.customer_id).trigger('select2:select');
                    $('#modalAddCustomerModalModal').modal('hide');
                });
            }
        });
    });
</script>
<?php include ROOT . "/View/Modal/addProductFactura.php"; ?>
<?php include ROOT . "/View/Modal/enviarFacturaPorMail.php"; ?>
<?php include ROOT . "/View/Modal/addCustomerModal.php"; ?>
<?php include ROOT . "/View/Modal/pagarDesdeFactura.php"; ?>