<section class="content-header">
    <h1><i class='fa-fw fa fa-file-text-o'></i> <?php echo $_translator->_getTranslation('Lista de facturas'); ?></small></h1>
    <ol class="breadcrumb">
        <li><a href="<?php echo ROOT_HOST ?>/Controller/Home.php"><i class="fa fa-dashboard"></i><?php echo $_translator->_getTranslation('Inicio') ?></a></li>
        <li class="active"><?php echo $_translator->_getTranslation('Lista de facturas'); ?></li>
    </ol>
</section>
<section class="content">
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"></h3>

            <div class="box-tools pull-right">
                <a href="Factura.php" class="btn btn-primary"><i class='fa fa-plus'></i> <?php echo $_translator->_getTranslation('Agregar factura') ?></a>
                <span class="btn btn-info _advancedSearch"><i class='fa fa-search-plus'></i> <?php echo $_translator->_getTranslation('Busqueda avanzada') ?></span>
            </div><!-- /.box-tools -->
        </div><!-- /.box-header -->
        <div class="box-body">

            <div class='flashmessenger'><?php $flashmessenger->showMessage(); ?></div>
            <div class="clear"></div>
            <div class='table-responsive'>
                <div class="clear"></div>
                <table id="tblFactura" class="table table-striped table-hover table-condensed font-size-12 datatable_whit_filter_column _hideSearch" style="width:100%">
                    <thead>
                        <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Fecha'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Serie'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Folio'); ?></th>
                        <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('RFC'); ?></th>
                        <th class="col-lg-4 col-md-4 text-center"><?php echo $_translator->_getTranslation('Razon Social'); ?></th>
                        <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Total'); ?></th>
                        <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Saldo pendiente'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Estado'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Vencimiento'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Enviado'); ?></th>
                        <th class="col-lg-2 col-md-2 text-center">Accion</th>
                    </thead>
                    <tfoot>
                        <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Fecha'); ?></th>
                        <th class="filter text-center"><?php echo $_translator->_getTranslation('Serie'); ?></th>
                        <th class="filter text-center"><?php echo $_translator->_getTranslation('Folio'); ?></th>
                        <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('RFC'); ?></th>
                        <th class="filter col-md-4 text-center"><?php echo $_translator->_getTranslation('Razon Social'); ?></th>
                        <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Total'); ?></th>
                        <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Saldo pendiente'); ?></th>
                        <th class="filter text-center"><?php echo $_translator->_getTranslation('Estado'); ?></th>
                        <th class="filter text-center"><?php echo $_translator->_getTranslation('Vencimiento'); ?></th>
                        <th class="text-center"></th>
                        <th></th>
                    </tfoot>
                    <tbody>
                        <?php
                        if ($_listFactura) {
                            foreach ($_listFactura as $factura) {
                                $datosEmisor = unserialize($factura['datos_emisor']); ?>
                                <tr>
                                    <td class="text-center"><?php echo $factura['fecha'] ?></td>
                                    <td class="text-center"><?php echo $factura['serie'] ?></td>
                                    <td class="text-center"><?php echo $factura['folio'] ?></td>
                                    <td class="text-center"><?php echo $factura['rfc'] ?></td>
                                    <td class="text-center"><?php echo $factura['razon_social'] ?></td>
                                    <td class="text-center"><?php echo number_format($factura['total'], 2) ?></td>
                                    <td class="text-center"><?php echo number_format($factura['saldo_pendiente'], 2) ?></td>
                                    <td class="text-center">
                                        <?php if (strtoupper($factura['statusName']) === 'SIN TIMBRAR') : ?>
                                            <span style="font-size: 10px" title="<?php echo $factura['statusName']; ?>" class="label label-info"><?php echo $factura['statusName']; ?></span>
                                        <?php elseif (strtoupper($factura['statusName']) === 'TIMBRADA') : ?>
                                            <?php if (strtoupper($factura['saldo_pendiente']) == 0): ?>
                                                <a style="font-size: 10px" class="label label-success" href="Pago.php?action=list&factura_id=<?php echo $factura['id'] ?>">Pagada <i class="fa fa-external-link"></i></a>
                                            <?php else: ?>
                                                <span style="font-size: 10px" title="<?php echo $factura['statusName']; ?>" class="label label-primary"><?php echo $factura['statusName']; ?></span>
                                            <?php endif; ?>
                                        <?php elseif (strtoupper($factura['statusName']) === 'CANCELADA') : ?>
                                            <span style="font-size: 10px" title="<?php echo $factura['statusName']; ?>" class="label label-danger"><?php echo $factura['statusName']; ?></span>
                                        <?php else : ?>
                                            <span style="font-size: 10px" class="label label-default"><?php echo $factura['statusName']; ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php $facturaDueDate = strtotime($factura['due_date']); ?>
                                        <?php if (empty($facturaDueDate)) : ?>
                                            <span class="text-muted">N/A</span>
                                        <?php elseif (strtotime(date('Y-m-d')) > $facturaDueDate) : ?>
                                            <i class="fa fa-warning text-danger"></i><strong style="padding-left: 8px" class="text-warning"><?php echo date('m/d/Y', $facturaDueDate); ?></strong>
                                        <?php else : ?>
                                            <strong class="text-primary"><?php echo date('m/d/Y', $facturaDueDate); ?></strong>
                                        <?php endif; ?>
                                    </td>

                                    <?php if ($factura['enviado'] == 1) { ?> <td class="text-center"><i class="fa fa-check" title="La factura se envio por correo electronico."></i></td> <?php } else { ?> <td class="text-center"></td> <?php } ?>

                                    <td class="text-right" style="white-space: nowrap;">
                                        <a class="btn btn-sm btn-default" href="Factura.php?action=edit&id=<?php echo $factura['id'] ?>" title="Editar"><i class="fa fa-pencil"></i></a>&nbsp;
                                        <?php if ($factura['tipo_documento'] != 'CG') { ?>
                                            <a class="btn btn-sm btn-warning" title="Ver documento en PDF" href="#" onclick="javascript: void window.open('Factura.php?action=import&flag=factura&id=<?php echo $factura['id'] ?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')"><i class="fa fa-file-pdf-o"></i></a>&nbsp; <?php } else { ?>
                                            <a class="btn btn-sm btn-warning"><i class="fa fa-file-pdf-o"></i></a>&nbsp;<?php
                                            } ?>
                                            <?php if ($factura['status'] != '1' && $factura['status'] != '3') { ?>
                                                <a class="btn btn-sm btn-success" href="Factura.php?action=descargar&idFactura=<?php echo $factura['id'] ?>" title="Descargar documento en formato ZIP"><i class="fa fa-cloud-download"></i></a>&nbsp;
                                                <a class="btn btn-sm btn-info _mail" href="#" onclick="setDataInvoice(this)" data-idinvoice="<?php echo $factura['id']; ?>" data-toggle='modal' data-target='#modalInvoiceToMail' title="Enviar por correo"><i class="fa fa-envelope"></i></a>&nbsp;
                                            <?php } else { ?>
                                                <a class="btn btn-sm btn-default disabled"><i class="fa fa-cloud-download"></i></a>&nbsp;
                                                <a class="btn btn-sm btn-default disabled"><i class="fa fa-envelope"></i></a>&nbsp;
                                            <?php } ?>
                                            <?php
                                                $info = "Creada por: {$factura['creado_por_nombre']}&#10;";
                                                setlocale(LC_TIME, "es_CO");
                                $info .= "Creada: ".iconv('ISO-8859-2', 'UTF-8', strftime("%l:%M %P del %A, %e de %B de %Y", strtotime($factura['creado_fecha'])))."&#10;&#10;";
                                $info .= (!empty($factura['ultima_mod_por_nombre'])) ? "Modificada por: {$factura['ultima_mod_por_nombre']}&#10;":null;
                                $info .= (!empty($factura['ultima_mod_por_nombre'])) ? "Modificada: ".iconv('ISO-8859-2', 'UTF-8', strftime("%l:%M %P del %A, %e de %B de %Y", strtotime($factura['ultima_mod_fecha'])))."&#10;&#10;":null;
                                $info .= (!empty($factura['fecha_timbrado'])) ? "Timbrada: ".iconv('ISO-8859-2', 'UTF-8', strftime("%l:%M %P del %A, %e de %B de %Y", strtotime($factura['ultima_mod_fecha'])))."&#10;&#10;":null;
                                $info .= (!empty($factura['ultima_mod_por_nombre']) && $factura['status'] == 3) ? "Cancelada: ".iconv('ISO-8859-2', 'UTF-8', strftime("%l:%M %P del %A, %e de %B de %Y", strtotime($factura['ultima_mod_fecha'])))."&#10;&#10;":null; ?>
                                            <a title="<?php echo $info; ?>" class="btn btn-sm btn-default"><i class="fa fa-commenting-o"></i></a>
                                            <div class="btn-group dropup">
                                                <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu  dropdown-menu-right">
                                                    <?php if ($factura['status'] == '1') { ?>
                                                        <li><a onclick="return deleteRegistry('Factura.php?action=delete&id=<?php echo $factura['id'] ?>')" href="#"><i class="fa fa-trash" style="color: red;"></i> Eliminar en sistema</a></li>
                                                    <?php } elseif ($factura['status'] == '2') { ?>
                                                        <li><a onclick="return deleteRegistry('Factura.php?action=delete&id=<?php echo $factura['id'] ?>')" href="#"><i class="fa fa-trash" style="color: red;"></i> Cancelar en sistema</a></li>
                                                        <li role="separator" class="divider"></li>
                                                        <li><a href="#" onclick="cancelarFactura(this)" data-idfactura='<?php echo $factura['id'] ?>'><i class="fa fa-bell-slash" style="color: red;"></i> Cancelar en SAT</a></li>
                                                        <li><a href="https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=<?php echo $factura['uuid'] ?>&re=<?php echo $datosEmisor['Emisor']['Rfc'] ?>&rr=<?php echo $factura['rfc_receptor'] ?>&tt=<?php echo $factura['total'] ?>&fe=<?php echo substr($factura['sello_sat'], -8); ?>" target='_sat'><i class="fa fa-external-link" style="color: #00cdff;"></i> Seguir en SAT</a></li>
                                                    <?php } elseif ($factura['status'] == '3') { ?>
                                                        <li><a href="#" onclick="cancelarFactura(this)" data-idfactura='<?php echo $factura['id'] ?>'><i class="fa fa-bell-slash" style="color: red;"></i> Cancelar en SAT</a></li>
                                                        <li><a href="https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=<?php echo $factura['uuid'] ?>&re=<?php echo $datosEmisor['Emisor']['Rfc'] ?>&rr=<?php echo $factura['rfc_receptor'] ?>&tt=<?php echo $factura['total'] ?>&fe=<?php echo substr($factura['sello_sat'], -8); ?>" target='_sat'><i class="fa fa-external-link" style="color: #00cdff;"></i> Seguir en SAT</a></li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                    </td>
                                </tr><?php
                            }
                        } ?>
                    </tbody>
                </table>
            </div>
        </div><!-- /.box-body -->
    </div><!-- /.box -->
</section>
<?php include ROOT . "/View/Modal/enviarFacturaPorMail.php"; ?>
<?php include ROOT . "/View/Modal/advancedSearch.php"; ?>
<style>
    tfoot {
        display: table-header-group;
    }

    .dataTables_filter {
        display: none;
    }
</style>
<script type="text/javascript" language="javascript">
    $('#status').select2();
    // DataTable
    $('#tblFactura').DataTable({
        paginate: true,
        pageLength: 15,
        filter: true,
        bFilter: true,
        aaSorting: [],
        dom: 'Bfrtip',
        buttons: [
            'excel',
        ],
        language: {
            "zeroRecords": "No se encontraron registros",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros disponibles",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "paginate": {
                "previous": "Anterior",
                "next":"Siguiente"
            }
        }
    });

    $('#tblFactura')
        .removeClass('display')
        .addClass('table table-striped table-bordered');


    $('#tblFactura tfoot th.filter').each(function() {
        var title = $(this).text();
        $(this).html('<input type="text" placeholder="Buscar ' + title + '" style="width:100%" />');
    });

    var table = $('#tblFactura').DataTable();
    // Apply the search
    table.columns().every(function() {
        var that = this;
        $('input', this.footer()).on('keyup change', function() {
            if (that.search() !== this.value) {
                that
                    .search(this.value.replace("/;/g", "|"), true, false)
                    .draw();
            }
        });
    });
    $('._advancedSearch').on('click', function() {
        $('form[name=advanced_search] #startDate,form[name=advanced_search] #endDate').datetimepicker({
            format: 'MM/DD/YYYY'
        });
        $('form[name=advanced_search] select').select2();
        $('#modalAdvancedSearch').modal('show');
    });

    $('._closeModalAdvancedSearch').on('click', function() {
        $('.flashmessenger').html('');
        $('#modalAdvancedSearch').modal('hide');
    });

    $(document).ready(function() {
        $('._relojChecador').hide();
    });
</script>