<?php $formPagarFactura = new PagoForm(); ?>
<!-- Modal -->
<div id="modalPagarDesdeFactura" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <?php echo $formPagarFactura->openForm() ?>
    <div class="modal-dialog" role="document" style="width: 70%">
        <div class="modal-content">
            <div class="modal-body">
                <div class="box box-primary">
                    <div class="box-header  with-border">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h3 id="myModalLabel"><i class="fa fa-money"></i> <?php echo $_translator->_getTranslation('Pagar Factura'); ?></h3>
                        <div class="flashmessenger"></div>
                        <div class="errors"></div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php $formPagarFactura->showElement('fecha'); //text
                                ?>
                                <?php $formPagarFactura->showElement('forma_de_pago'); //select
                                ?>
                                <div class="clear"></div>
                                <input type="hidden" id="cliente" name="cliente" value="<?php echo $facturaData['id_cliente']; ?>">
                                <?php $formPagarFactura->showElement('cuenta_bancaria_ordenante'); //select
                                ?>
                                <div class="clear"></div>
                                <?php $formPagarFactura->showElement('cuenta_bancaria'); //select
                                ?>
                                <div class="clear"></div>
                                <?php $formPagarFactura->showElement('num_operacion'); //text
                                ?>
                            </div>
                            <div class="col-md-6">
                                <?php $formPagarFactura->showElement('monto'); //text
                                ?>
                                <?php $formPagarFactura->showElement('moneda'); //select
                                ?>
                                <div class="clear"></div>
                                <?php $formPagarFactura->showElement('tipo_de_cambio'); //text
                                ?>
                                <?php $formPagarFactura->showElement('notas'); //textarea
                                ?>
                                <?php $formPagarFactura->showElement('adjuntos[]'); //file[]
                                ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 text-right">
                                <div class="buttons" role="group" aria-label="...">
                                    <button type="button" class="btn btn-info" disabled name="timbrar">Timbrar</button>
                                    <button type="button" class="btn btn-primary" name="send">Guardar</button>

                                    <?php $formPagarFactura->showElement('status'); //hidden
                                    ?>
                                    <?php $formPagarFactura->showElement('monto_original'); //hidden
                                    ?>
                                    <?php $formPagarFactura->showElement('suma_de_pagos'); //hidden
                                    ?>
                                    <input type="hidden" name="id_factura" value="<?php echo $id //hidden
                                                                                    ?>" />
                                    <input type="hidden" name="id_pago_desde_factura" value="" />
                                    <input type="hidden" name="saldo_pendiente_factura" value="<?php echo $facturaData['saldo_pendiente'] //hidden
                                                                                                ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-footer">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $formPagarFactura->closeForm(); ?>
</div>
<script>
    $('#modalPagarDesdeFactura form').on('change', 'input[name=monto]', function(e) {
        var number = parseFloat($(e.currentTarget).val());

        if (isNaN(number)) $(e.currentTarget).val('0.00');
        else $(e.currentTarget).val(numberWithCommas(number.toFixed(2)));

    });
    $('#modalPagarDesdeFactura').on('shown.bs.modal', function(e) {
        $('#modalPagarDesdeFactura form button[name=send]').removeAttr('disabled');
        $('#modalPagarDesdeFactura form button[name=timbrar]').attr('disabled', 'disabled');

        $('#modalPagarDesdeFactura form select[name=moneda]').val('MXN').trigger('change');
        $('#modalPagarDesdeFactura form select[name=forma_de_pago]').val('01').trigger('change');


        $.post('Pago.php', {
            action: 'ajax',
            request: 'getFacturaDetails',
            idFactura: $('.btn.btn-pagar.btn-pagar-factura').data('id-factura')
        }, function(data) {
            if (data.response) {

                var number = parseFloat(data.data.saldo_pendiente);
                $('#modalPagarDesdeFactura form #monto')
                    .val(numberWithCommas(number.toFixed(2)))
                    .focus()
                    .select();
            }
        }, 'json');

        $.post('Pago.php', {
            action: 'ajax',
            request: 'getListCuentaBancariasAsArray',
            id_cliente: $("#modalPagarDesdeFactura form #cliente").val()
        }, function(r) {
            if (r.response) {
                var option = "<option value=\"0\">Selecciona una opcion...</option>";
                r.data.forEach(element => {
                    option += "<option value =\"" + element.id + "\">" + element.bancoName + " - " + element.cuenta + "</option>";
                });
                $("#modalPagarDesdeFactura select#cuenta_bancaria_ordenante").html(option);
            } else {
                $("#modalPagarDesdeFactura select#cuenta_bancaria_ordenante").html("<option value=\"0\">Selecciona una opcion...</option>");
            }
        }, 'json');
    });
    $("#modalPagarDesdeFactura #fecha").datetimepicker({
        format: 'MM/DD/YYYY'
    });
    $('#modalPagarDesdeFactura #moneda').on('change', function() {
        var curr = $(this).val();
        switch (curr) {
            case 'MXN':
                $('#modalPagarDesdeFactura #tipo_de_cambio').val("1.0").attr({
                    readOnly: 'readOnly'
                });
                break;
            default:
                $('#modalPagarDesdeFactura #tipo_de_cambio').attr({
                    readOnly: null
                }).val(null);
                break;
        }

        $('#modalPagarDesdeFactura #tipo_de_cambio').focus();
    });
    $('#modalPagarDesdeFactura form button[name=timbrar]').on('click', function() {
        var id_factura = $('#modalPagarDesdeFactura form input[name=id_factura]').val();
        $.post('Factura.php', {
            action: 'ajax',
            request: 'timbrarPagoDesdeFactura',
            id_pago: $('#modalPagarDesdeFactura form input[name=id_pago_desde_factura]').val(),
            id_factura: id_factura
        }, function(data) {
            $('.flashmessenger').html(data.message);

            if (data.response) {
                $('#modalPagarDesdeFactura').modal('hide');

                // cierro modal y regreso los botones a su estado inicial, guardar sin poder timbrar
                $('#modalPagarDesdeFactura form button[name=send]').removeAttr('disabled');
                $('#modalPagarDesdeFactura form button[name=timbrar]').attr('disabled', 'disabled');

                // ya esta timbrado, no lo necesito y preparo en caso de que se requiera agregar otro pago
                $('#modalPagarDesdeFactura form input[name=id_pago_desde_factura]').val('');
            }
        }, 'json')
    });

    $('#modalPagarDesdeFactura form button[name=send]').on('click', function() {
        var form = document.getElementById('form_pago');
        var formData = new FormData(form);

        formData.append('action', 'ajax');
        formData.append('request', 'pagarDesdeFactura');
        $.ajax({
            url: '/Controller/Factura.php',
            type: "post",
            dataType: 'text json',
            data: formData,
            cache: false,
            contentType: false,
            processData: false

        }).done(function(data) {
            $('.flashmessenger').html(data.message);

            if (data.response) {
                $('#modalPagarDesdeFactura form :input').each(function(e) {
                    $(this).closest('.form-group').removeClass('has-error');
                });

                // todo esto para resetear
                $('#modalPagarDesdeFactura form')[0].reset();
                $('#modalPagarDesdeFactura form select').each(function() {
                    $(this).val('').change();
                });

                // habilito timbrar, sin poder volver a guardar
                $('#modalPagarDesdeFactura form button[name=timbrar]').removeAttr('disabled');
                $('#modalPagarDesdeFactura form button[name=send]').attr('disabled', 'disabled');


                // temporalmente guardo el id del pago para el timbrado...
                $('#modalPagarDesdeFactura form input[name=id_pago_desde_factura]').val(data.id_pago);
            }

            if (data.errors != undefined) {
                data.errors.forEach(element => {
                    $('#modalPagarDesdeFactura form input[name=' + element + ']').closest('.form-group').addClass('has-error');
                });
            }
        });
    });


    $('#form_pago #forma_de_pago').select2();
    $('#form_pago #cuenta_bancaria_ordenante').select2();
    $('#form_pago #cuenta_bancaria').select2();
    $('#form_pago #moneda').select2();
</script>