<?php $formPagoNota = new PagoForm(); ?>
<!-- Modal -->
<div id="modalPagarDesdeNotaDeCredito" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <?php echo $formPagoNota->openForm() ?>
    <div class="modal-dialog" role="document" style="width: 70%">
        <div class="modal-content">
            <div class="modal-body">
                <div class="box box-primary">
                    <div class="box-header  with-border">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h3 id="myModalLabel"><i class="fa fa-money"></i> <?php echo $_translator->_getTranslation('Pagar Factura'); ?></h3>
                        <div class="flashmessenger"></div>
                        <div class="errors"></div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php $formPagoNota->showElement('fecha'); //text
                                ?>
                                <?php $formPagoNota->showElement('forma_de_pago'); //select
                                ?>
                                <input type="hidden" name="cliente" value="<?php echo $facturaData['id_cliente']; ?>">
                                <?php $formPagoNota->showElement('cuenta_bancaria_ordenante'); //select
                                ?>
                                <?php $formPagoNota->showElement('cuenta_bancaria'); //select
                                ?>
                                <?php $formPagoNota->showElement('num_operacion'); //text
                                ?>
                            </div>
                            <div class="col-md-6">
                                <?php $formPagoNota->showElement('monto'); //text
                                ?>
                                <?php $formPagoNota->showElement('moneda'); //select
                                ?>
                                <?php $formPagoNota->showElement('tipo_de_cambio'); //text
                                ?>
                                <?php $formPagoNota->showElement('notas'); //textarea
                                ?>
                                <?php $formPagoNota->showElement('adjuntos[]'); //file[]
                                ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 text-right">
                                <div class="buttons" role="group" aria-label="...">
                                    <button type="button" class="btn btn-info" disabled name="timbrar">Timbrar</button>
                                    <button type="button" class="btn btn-primary" name="send">Guardar</button>

                                    <?php $formPagoNota->showElement('status'); //hidden
                                    ?>
                                    <?php $formPagoNota->showElement('monto_original'); //hidden
                                    ?>
                                    <?php $formPagoNota->showElement('suma_de_pagos'); //hidden
                                    ?>
                                    <input type="hidden" name="id_notadecredito" value="<?php echo $id //hidden
                                                                                        ?>" />
                                    <input type="hidden" name="id_pago_desde_notadecredito" value="" />
                                    <input type="hidden" name="saldo_pendiente_notadecredito" value="<?php echo $facturaData['saldo_pendiente'] //hidden
                                                                                                        ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-footer">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $formPagoNota->closeForm(); ?>
</div>
<script>
    $('#modalPagarDesdeNotaDeCredito').on('shown.bs.modal', function(e) {
        $('#modalPagarDesdeNotaDeCredito form button[name=send]').removeAttr('disabled');
        $('#modalPagarDesdeNotaDeCredito form button[name=timbrar]').attr('disabled', 'disabled');
        $.post('Pago.php', {
            action: 'ajax',
            request: 'getNotaDetails',
            idNotaDeCredito: $('.btn.btn-pagar.btn-pagar-notadecredito').data('id-notadecredito')
        }, function(data) {
            if (data.response) {
                $('#modalPagarDesdeNotaDeCredito form #monto')
                    .val(data.data.saldo_pendiente)
                    .focus()
                    .select();
            }
        }, 'json');
    });
    $("#modalPagarDesdeNotaDeCredito #fecha").datetimepicker({
        format: 'MM/DD/YYYY'
    });
    $('#modalPagarDesdeNotaDeCredito #moneda').on('change', function() {
        var curr = $(this).val();
        switch (curr) {
            case 'MXN':
                $('#modalPagarDesdeNotaDeCredito #tipo_de_cambio').val("1.0").attr({
                    readOnly: 'readOnly'
                });
                break;
            default:
                $('#modalPagarDesdeNotaDeCredito #tipo_de_cambio').attr({
                    readOnly: null
                }).val(null);
                break;
        }

        $('#modalPagarDesdeNotaDeCredito #tipo_de_cambio').focus();
    });
    $('#modalPagarDesdeNotaDeCredito form button[name=timbrar]').on('click', function() {
        var id_notadecredito = $('#modalPagarDesdeNotaDeCredito form input[name=id_notadecredito]').val();
        $.post('Factura.php', {
            action: 'ajax',
            request: 'timbrarPagoDesdeNotaDeCredito',
            id_pago: $('#modalPagarDesdeNotaDeCredito form input[name=id_pago_desde_notadecredito]').val(),
            id_notadecredito: id_notadecredito
        }, function(data) {
            $('.flashmessenger').html(data.message);

            if (data.response) {
                $('#modalPagarDesdeNotaDeCredito').modal('hide');

                // cierro modal y regreso los botones a su estado inicial, guardar sin poder timbrar
                $('#modalPagarDesdeNotaDeCredito form button[name=send]').removeAttr('disabled');
                $('#modalPagarDesdeNotaDeCredito form button[name=timbrar]').attr('disabled', 'disabled');

                // ya esta timbrado, no lo necesito y preparo en caso de que se requiera agregar otro pago
                $('#modalPagarDesdeNotaDeCredito form input[name=id_pago_desde_notadecredito]').val('');
            }
        }, 'json')
    });

    $('#modalPagarDesdeNotaDeCredito form button[name=send]').on('click', function() {
        var form = document.getElementById('form_pago');
        var formData = new FormData(form);

        formData.append('action', 'ajax');
        formData.append('request', 'pagarDesdeNotaDeCredito');
        $.ajax({
            url: '/Controller/Factura.php',
            type: "post",
            dataType: 'text json',
            data: formData,
            cache: false,
            contentType: false,
            processData: false

        }).done(function(data) {
            $('.flashmessenger').html(data.message);

            if (data.response) {
                $('#modalPagarDesdeNotaDeCredito form :input').each(function(e) {
                    $(this).closest('.form-group').removeClass('has-error');
                });

                // todo esto para resetear
                $('#modalPagarDesdeNotaDeCredito form')[0].reset();
                $('#modalPagarDesdeNotaDeCredito form select').each(function() {
                    $(this).val('').change();
                });

                // habilito timbrar, sin poder volver a guardar
                $('#modalPagarDesdeNotaDeCredito form button[name=timbrar]').removeAttr('disabled');
                $('#modalPagarDesdeNotaDeCredito form button[name=send]').attr('disabled', 'disabled');


                // temporalmente guardo el id del pago para el timbrado...
                $('#modalPagarDesdeNotaDeCredito form input[name=id_pago_desde_notadecredito]').val(data.id_pago);
            }

            if (data.errors != undefined) {
                data.errors.forEach(element => {
                    $('#modalPagarDesdeNotaDeCredito form input[name=' + element + ']').closest('.form-group').addClass('has-error');
                });
            }
        });
    });

    $('#form_pago #forma_de_pago').select2();
    $('#form_pago #cuenta_bancaria_ordenante').select2();
    $('#form_pago #cuenta_bancaria').select2();
    $('#form_pago #moneda').select2();
</script>