<?php
$folio = "";
$statusTitle = null;
if (isset($facturaData)) :
    $folio = " #{$facturaData['serie']}-{$facturaData['folio']}";




    if (strtoupper($facturaData['statusName']) == 'TIMBRADA' && $facturaData['saldo_pendiente'] == 0) {
        $facturaData['statusName'] = 'Pagada';
    }
    $statusTitle = "({$facturaData['statusName']})";
    $labelStatusType = "default";
    switch (strtoupper($facturaData['statusName'])):
        case 'SIN TIMBRAR':
            $labelStatusType = "info";
            break;
        case 'TIMBRADA':
            $labelStatusType = "primary";
            break;
        case 'CANCELADA':
            $labelStatusType = "danger";
            break;
        case 'PAGADA':
            $labelStatusType = "success";
            break;
    endswitch;
endif;
?>
<section class="content-header">
    <h1>
        <i class='fa-fw fa fa-file-text-o'></i>
        <?php echo $_translator->_getTranslation('Notas de Credito'); ?>
        <?php echo $folio ?>
    </h1>
    <?php if (isset($facturaData)) : ?><h2 class="label label-<?php echo $labelStatusType ?>"><?php echo $statusTitle ?></h2><?php endif; ?>
    <ol class="breadcrumb">
        <li><a href="<?php echo ROOT_HOST ?>/Controller/Home.php"><i class="fa fa-dashboard"></i><?php echo $_translator->_getTranslation('Inicio') ?></a></li>
        <li><a href="<?php echo ROOT_HOST ?>/Controller/NotaCredito.php?action=list"><?php echo $_translator->_getTranslation('Lista notas de credito') ?></a></li>
        <li class="active"><?php echo $_translator->_getTranslation('Notas de Credito'); ?></li>
    </ol>
</section>
<section class="content">
    <div class="box">
        <?php echo $form->openForm(); ?>
        <div style="display: none"><?php
                                    echo $form->showActionController();
                                    echo $form->showId();
                                    echo $form->showElement('type');
                                    echo $form->showElement('status');
                                    echo $form->showElement('tipo_documento'); ?>
        </div>
        <div class='flashmessenger'><?php $flashmessenger->showMessage(); ?></div>
        <div class="box-body">
            <?php
            if ($action == 'edit') { ?>
                <div class="col-md-12 col-xs-12 text-right">
                    <?php if (strtoupper($facturaData['statusName']) != 'CANCELADA') : ?>
                        <a href="NotaCredito.php?action=delete&id=<?php echo $facturaData['id']; ?>" class="btn btn-cancelar"><i class="fa fa-ban"></i> Cancelar</a>
                    <?php endif; ?>
                    <?php if (strtoupper($facturaData['statusName']) == 'SIN TIMBRAR') : ?>
                        <a class="btn btn-info" onclick="timbrarNotaCredito()"><span class="fa fa-plus fa-bell"></span> <?php echo $_translator->_getTranslation('Timbrar nota de credito'); ?></a>
                    <?php endif; ?>
                    <?php if (strtoupper($facturaData['statusName']) == 'TIMBRADA') : ?>
                        <a class="btn btn-success" href="NotaCredito.php?action=descargar&idNotaCredito=<?php echo $form->getId() ?>" title="Descargar"><i class="fa fa-cloud-download"></i> <?php echo $_translator->_getTranslation('Descargar'); ?></a>
                        <a class="btn btn-imprimir" href="#" onclick="setDataNotaCredito(this)" data-idnotacredito="<?php echo $form->getId(); ?>" title="Enviar por correo"><i class="fa fa-envelope"></i> <?php echo $_translator->_getTranslation('Enviar por correo'); ?></a>
                    <?php endif; ?>
                    <a href="/Controller/NotaCredito.php" class="btn btn-primary"><span class="fa fa-plus"></span> <?php echo $_translator->_getTranslation('Agregar nota de credito'); ?></a>

                </div>
                <div class="clear"></div>
            <?php } ?>
        </div>
        <div class="box-body">

            <div class="card">
                <ul class="nav nav-tabs" role="tablist">
                    <li role="presentation" class="active"><a href="#general" aria-controls="home" role="tab" data-toggle="tab"><?php echo $_translator->_getTranslation('Nota de credito') ?></a></li>
                    <li role="presentation"><a href="#uuids_relacionados" aria-controls="profile" role="tab" data-toggle="tab"><?php echo $_translator->_getTranslation('Relacionar UUID') ?></a></li>
                </ul>
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="general">
                        <div class="box-body">
                            <div class="col-xs-12 col-md-6">
                                <?php $form->showElement('sucursal');
                                $form->showElement('id_cliente');
                                $form->showElement('forma_de_pago');
                                $form->showElement('metodo_de_pago');
                                $form->showElement('num_cuenta_pago'); ?>
                            </div>
                            <div class="col-xs-12 col-md-6">
                                <?php $form->showElement('moneda');
                                $form->showElement('tipo_de_cambio');
                                $form->showElement('uso_cfdi');
                                $form->showElement('comentarios'); ?>
                            </div>
                        </div>
                        <div class="clear"></div>

                        <div class='row'>
                            <div class="box-body">
                                <h5>Detalles de Nota de credito</h5>
                                <hr />
                                <?php
                                $compraAjax = new NotaCreditoAjax();
                                $listCompraDetalles = $compraAjax->getListNotaCreditoDetalles($form->getValueElement('status'), $form->getTokenForm()); //echo "<pre>";var_dump($listCompraDetalles); echo "</pre>";exit;
                                ?>
                                <table id='detalles-table' style="font-size:11px" class="table table-condensed table-striped table-hover table-thead-customize table-tfoot-customize">
                                    <thead>
                                        <th class="col-lg-1 text-center"></th>
                                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Codigo'); ?></th>
                                        <th class="col-lg-4"><?php echo $_translator->_getTranslation('Descripcion'); ?></th>
                                        <th class="col-lg-1 text-right"><?php echo $_translator->_getTranslation('Cantidad') ?></th>
                                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('UM') ?></th>
                                        <th class="col-lg-1 text-right"><?php echo $_translator->_getTranslation('P.Unit') ?></th>

                                        <th class="col-lg-1 text-right"><?php echo $_translator->_getTranslation('Descuento') ?></th>
                                        <th class="col-lg-1 text-right"><?php echo $_translator->_getTranslation('Total') ?></th>

                                    </thead>
                                    <tbody>
                                        <?php echo $listCompraDetalles['facturaDetalles']; ?>
                                    </tbody>
                                </table>
                                <div style="display: none">
                                    <?php
                                    $form->showElement('total_impuestos_retenidos');
                                    $form->showElement('total_impuestos_trasladados');
                                    $form->showElement('subtotal');
                                    $form->showElement('descuento');
                                    $form->showElement('total'); ?>
                                </div>

                                <div class="col-xs-12 col-md-3 pull-right">
                                    <div class="col-xs-8 col-md-8 text-right"><?php echo $_translator->_getTranslation('Subtotal') ?></div>
                                    <div id="div-subtotal" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['totalSubtotal'], 2); ?></div>
                                    <div class="col-xs-8 col-md-8 text-right"><?php echo $_translator->_getTranslation('Descuento') ?></div>
                                    <div id="div-descuento" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['totalDescuento'], 2); ?></div>
                                    <div class="col-xs-8 col-md-8 text-right">Subtotal</div>
                                    <div id="div-grandSubtotal" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['grandSubtotal'], 2); ?></div>
                                </div>

                                <div class="clear"></div>
                                <div id="totalImpuestos" class="col-xs-3 col-md-3 pull-right">
                                    <?php echo $listCompraDetalles['stringImpuestos'] ?>
                                </div>
                                <div class="clear"></div>
                                <div class="col-xs-3 col-md-3 pull-right">
                                    <div class="col-xs-8 col-md-8 text-right"><?php echo $_translator->_getTranslation('Total') ?></div>
                                    <div id="div-total" class="col-xs-4 col-md-4 text-right p-r-0"><?php echo number_format($listCompraDetalles['total'], 2) ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <?php
                                $form->showElement('idDetailTemp');
                                $form->showElement('descripcion');
                                $form->showElement('cantidad');
                                $form->showElement('descuento_detalle'); ?>
                                <div class='col-lg-4'>
                                    <?php $element = $form->getElement('id_producto'); ?>
                                    <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                    <?php echo $form->createElement($element); ?>
                                </div>
                                <div class='col-lg-2'>
                                    <?php $element = $form->getElement('precio_unitario'); ?>
                                    <div class='col-lg-12 p-a-0'><label><?php echo $element['label'] ?></label></div>
                                    <?php echo $form->createElement($element); ?>
                                </div>
                                <div class="col-lg-6">
                                    <div class='col-lg-12 p-a-0'>&nbsp;</div>
                                    <?php $form->showElement('buscar'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="pull-right">
                                    <div class='col-lg-6 p-t-3'>
                                        <?php $element = $form->getElement('terminar'); ?>
                                        <?php echo $form->createElement($element); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div role="tabpanel" class="tab-pane" id="uuids_relacionados">
                        <div class="box-body">
                            <div class="col-xs-12 col-md-6">
                                <?php $form->showElement('tipo_relacion');
                                $form->showElement('uuid_relacionados');
                                $form->showElement('uuid_relacionados_otros');
                                $form->showElement('add_uuid_relacionados_otros'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div><!-- /.box-body -->
        <?php echo $form->closeForm(); ?>
    </div><!-- /.box -->
</section>
<?php if ($action == 'edit') { ?><script>
        $('#idDetailTemp').val(<?php echo $listCompraDetalles['idDetailTemp']; ?>);
    </script><?php } ?>
<style>
    form.notaCredito label.tipo_documento,
    form.notaCredito label.lugar_de_expedicion,
    form.notaCredito label.tipo_de_cambio,
    form.notaCredito label.forma_de_pago,
    form.notaCredito label.metodo_de_pago,
    form.notaCredito label.num_cuenta_pago,
    form.notaCredito label.condiciones_de_pago,
    form.notaCredito label.aux_uuid_relacionados_otros,
    form.notaCredito label.uso_cfdi {
        padding-top: 0px;
    }

    form.notaCredito #subtotal,
    form.notaCredito #descuento,
    form.notaCredito #total {
        padding: 0px;
        border: 0px;
        box-shadow: 0px 0px 0px;
        text-align: right;
        height: 21px;
    }
</style>
<?php if (isset($_disabled) && $_disabled) { ?> <script>
        $('#detalles-table tr td a').addClass('disabled');
    </script><?php } ?>
<script>
    $('#uuid_relacionados_otros').select2().on("select2:unselect", function(e) {
        var data = e.params.data;
        $("#uuid_relacionados_otros option[value='" + data.id + "']").remove();
    });
    $(function() {
        defaultExchangeRate($('#moneda').val());
    });
    $('#form_notaCredito #forma_de_pago').select2();
    $('#form_notaCredito #payment_terms').select2();
    $('#form_notaCredito #metodo_de_pago').select2();
    $('#form_notaCredito #moneda').select2();
    $('#form_notaCredito #uso_cfdi').select2();
    $('#form_notaCredito #tipo_relacion').select2();
    $('#form_notaCredito #uuid_relacionados').select2();
    $('#form_notaCredito #id_cliente').select2({
        ajax: {
            delay: 800,
            url: '/Controller/Cliente.php',
            data: function(params) {
                var query = {
                    search: params.term,
                    action: 'ajax',
                    request: 'getClientList'
                }

                // Query parameters will be ?search=[term]&type=public
                return query;
            },
            processResults: function(data) {
                var orig = $.parseJSON(data);
                var formatted = [];
                orig.forEach(element => {
                    formatted.push({
                        id: element.id,
                        text: element.razon_social
                    });
                });
                return {
                    results: formatted
                };
            }
        }
    });


    $('#form_notaCredito #id_producto').select2({
        ajax: {
            delay: 800,
            url: '/Controller/Producto.php',
            data: function(params) {
                var query = {
                    search: params.term,
                    action: 'ajax',
                    request: 'getProductListBySearchTerm'
                }

                // Query parameters will be ?search=[term]&type=public
                return query;
            },
            processResults: function(data) {
                var orig = $.parseJSON(data);
                var formatted = [];
                orig.forEach(element => {
                    formatted.push({
                        id: element.id,
                        text: element.nombre
                    });
                });
                return {
                    results: formatted
                };
            }
        }
    });
</script>
<?php include ROOT . "/View/Modal/enviarNotaCreditoPorMail.php"; ?>
<?php include ROOT . "/View/Modal/pagarDesdeNotaDeCredito.php"; ?>