<section class="content-header">
    <h1><i class='fa-fw fa fa-file-text-o'></i> <?php echo $_translator->_getTranslation('Lista notas de credito');?></small></h1>
    <ol class="breadcrumb">
        <li><a href="<?php echo ROOT_HOST?>/Controller/Home.php"><i class="fa fa-dashboard"></i><?php echo $_translator->_getTranslation('Inicio')?></a></li>
        <li class="active"><?php echo $_translator->_getTranslation('Lista notas de credito');?></li>
    </ol>
</section>
<section class="content">
<div class="box">
    <div class="box-header with-border">
        <h3 class="box-title"></h3>
        <div class="box-tools pull-right">
            <a href="NotaCredito.php" class="btn btn-primary"><i class='fa fa-plus'></i> <?php echo $_translator->_getTranslation('Agregar nota de credito')?></a>
            <span class="btn btn-info _advancedSearch"><i class='fa fa-search-plus'></i> <?php echo $_translator->_getTranslation('Busqueda avanzada')?></span>  
        </div><!-- /.box-tools -->
    </div><!-- /.box-header -->
    <div class="box-body">
    <div class='flashmessenger'><?php $flashmessenger->showMessage();?></div>
    <div class="clear"></div>
        <div class='table-responsive'>
            <div class="clear"></div>
        <table id="tblFactura" class="table table-striped table-hover table-condensed font-size-12 datatable_whit_filter_column _hideSearch" style="width:100%">
            <thead>                        
            <th  class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Fecha');?></th>                                     
            <th class="text-center"><?php echo $_translator->_getTranslation('Serie');?></th>
            <th class="text-center"><?php echo $_translator->_getTranslation('Folio');?></th>    
            <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('RFC');?></th>
            <th class="col-lg-4 col-md-4 text-center"><?php echo $_translator->_getTranslation('Razon Social');?></th>          
            <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Total'); ?></th>
            <th class="col-lg-1 col-md-1 text-center"><?php echo $_translator->_getTranslation('Estado');?></th>
            <th class="text-center"><?php echo $_translator->_getTranslation('Enviado');?></th>
            <th class="col-lg-2 col-md-2 text-center">Accion</th>
            </thead>
            <tfoot>                        
            <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Fecha');?></th>
            <th class="filter text-center"><?php echo $_translator->_getTranslation('Serie');?></th>                    
            <th class="filter text-center"><?php echo $_translator->_getTranslation('Folio');?></th>
            <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('RFC');?></th>
            <th class="filter col-md-4 text-center"><?php echo $_translator->_getTranslation('Razon Social');?></th>                   
            <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Total'); ?></th>
            <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Estado');?></th>
            <th class="text-center"></th>
            <th></th>
            </tfoot>
            <tbody>
            <?php
                if ($_listNotaCredito) {
                    foreach ($_listNotaCredito as $factura) {
                        $datosEmisor = unserialize($factura['datos_emisor']); ?>                             
                        <tr>
                            <td class="text-center"><?php echo $factura['fecha']?></td>  
                            <td class="text-center"><?php echo $factura['serie']?></td>
                            <td class="text-center"><?php echo $factura['folio']?></td>
                             <td class="text-center"><?php echo $factura['rfc']?></td>   
                            <td class="text-center"><?php echo $factura['razon_social']?></td>                                    
                            <td class="text-center"><?php echo number_format($factura['total'], 2)?></td>  
                                    <td class="text-center">
                                        <?php if (strtoupper($factura['statusName']) === 'SIN TIMBRAR'): ?>
                                        <span style="font-size:10px;" title="<?php echo $factura['statusName']; ?>" class="label label-info"><?php echo $factura['statusName']; ?></span>
                                        <?php elseif (strtoupper($factura['statusName']) === 'TIMBRADA'): ?>
                                        <span style="font-size:10px;" title="<?php echo $factura['statusName']; ?>" class="label label-primary"><?php echo $factura['statusName']; ?></span>
                                        <?php elseif (strtoupper($factura['statusName']) === 'CANCELA'): ?>
                                        <span style="font-size:10px;" title="<?php echo $factura['statusName']; ?>" class="label label-danger">Cancelada</span>
                                        <?php else: ?>
                                        <span style="font-size:10px;" title="<?php echo $factura['statusName']; ?>" class="label label-default"><?php echo $factura['statusName']; ?></span>
                                        <?php endif; ?>
                                    </td>

                           <?php if ($factura['enviado'] == 1) { ?> <td class="text-center" ><i class="fa fa-check" title="La Nota de Credito se envio por correo electronico."></i></td> <?php } else { ?> <td class="text-center"></td> <?php } ?>

                            <td class="text-center" style="white-space: nowrap;">
                                <a class="btn btn-sm btn-default" href="NotaCredito.php?action=edit&id=<?php echo $factura['id']?>" title="Editar"><i class="fa fa-pencil"></i></a>
                                <a class="btn btn-sm btn-warning" title="Ver documento en formato PDF" href="#" onclick="javascript: void window.open('NotaCredito.php?action=import&flag=nota_de_credito&id=<?php echo $factura['id']?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')"><i class="fa fa-file-pdf-o"></i></a>

                            <?php if ($factura['status'] == '2') { ?>                                 
                                        <a class="btn btn-sm btn-success" href="NotaCredito.php?action=descargar&idNotaCredito=<?php echo $factura['id']?>" title="Descargar documento en formato ZIP"><i class="fa fa-cloud-download"></i></a>
                                        <a class="btn btn-sm btn-info" href="#" onclick="setDataNotaCredito(this)" data-idnotacredito="<?php echo $factura['id']; ?>" title="Enviar por correo"><i class="fa fa-envelope"></i></a>
                            <?php } else {?>
                                    <a class="btn btn-sm btn-default disabled"><i class="fa fa-cloud-download"></i></a>
                                    <a class="btn btn-sm btn-default disabled"><i class="fa fa-envelope"></i></a>
                            <?php } ?>
                            <?php
                                $info = "Creada por: {$factura['creado_por_nombre']}&#10;";
                        $info .= "Creada: ".date_format(date_create($factura['creado_fecha']), 'g:i A j \d\e M, Y')."&#10;&#10;";
                        $info .= (!empty($factura['ultima_mod_por_nombre'])) ? "Modificada por: {$factura['ultima_mod_por_nombre']}&#10;":null;
                        $info .= (!empty($factura['ultima_mod_por_nombre'])) ? "Modificada: ".date_format(date_create($factura['ultima_mod_fecha']), 'g:i A j \d\e M, Y')."&#10;&#10;":null;
                        $info .= (!empty($factura['fecha_timbrado'])) ? "Timbrada: ".date_format(date_create($factura['ultima_mod_fecha']), 'g:i A j \d\e M, Y')."&#10;&#10;":null;
                        $info .= (!empty($factura['ultima_mod_por_nombre']) && $factura['status'] == 3) ? "Cancelada: ".date_format(date_create($factura['ultima_mod_fecha']), 'g:i A j \d\e M, Y')."&#10;&#10;":null; ?>
                            <a title="<?php echo $info; ?>" class="btn btn-sm btn-default"><i class="fa fa-commenting-o"></i></a>

                                <div class="btn-group dropup">
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                      <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu  dropdown-menu-right">
                                        <?php if ($factura['status'] == '1') {?>                                                   
                                                <li><a onclick="return deleteRegistry('NotaCredito.php?action=delete&id=<?php echo $factura['id']?>')" href="#"><i class="fa fa-trash" style="color: red;"></i> Eliminar en sistema</a></li>
                                        <?php } elseif ($factura['status'] == '2') {?>    
                                                <li><a onclick="return deleteRegistry('NotaCredito.php?action=delete&id=<?php echo $factura['id']?>')" href="#"><i class="fa fa-trash" style="color: red;"></i> Cancelar en sistema</a></li>
                                                <li role="separator" class="divider"></li>
                                                <li><a href="#" onclick="cancelarNotaCredito(this)" data-idfactura='<?php echo $factura['id']?>'><i class="fa fa-bell-slash" style="color: red;"></i> Cancelar en SAT</a></li>
                                                <li><a href="https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=<?php echo $factura['uuid']?>&re=<?php echo $datosEmisor['Emisor']['Rfc']?>&rr=<?php echo $factura['rfc_receptor'] ?>&tt=<?php echo $factura['total']?>&fe=<?php echo substr($factura['sello_sat'], -8);?>" target='_sat'><i class="fa fa-external-link" style="color: #00cdff;"></i> Seguir en SAT</a></li>
                                        <?php } elseif ($factura['status'] == '3') {?>
                                                <li><a href="#" onclick="cancelarNotaCredito(this)" data-idfactura='<?php echo $factura['id']?>'><i class="fa fa-bell-slash" style="color: red;"></i> Cancelar en SAT</a></li>
                                                <li><a href="https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=<?php echo $factura['uuid']?>&re=<?php echo $datosEmisor['Emisor']['Rfc']?>&rr=<?php echo $factura['rfc_receptor'] ?>&tt=<?php echo $factura['total']?>&fe=<?php echo substr($factura['sello_sat'], -8);?>" target='_sat'><i class="fa fa-external-link" style="color: #00cdff;"></i> Seguir en SAT</a></li>
                                        <?php } ?>                                        
                                    </ul>
                                </div>                                            
                            </td>
                        </tr><?php
                    }
                }?>
            </tbody>
        </table>
        </div>
  </div><!-- /.box-body -->
</div><!-- /.box -->
</section>
<?php  include ROOT."/View/Modal/enviarNotaCreditoPorMail.php"; ?>
<?php include ROOT."/View/Modal/advancedSearch.php";?>
<style>
    tfoot {
    display: table-header-group;
}

</style>

<script type="text/javascript" language="javascript">   
    // DataTable
    $('#tblFactura').DataTable( { 
        paginate:false,
        filter:true,
        bFilter:false,
        aaSorting:[],
        dom: 'Bfrtip',
        buttons: [
            'excel',
        ]});
    
    $('#tblFactura')
            .removeClass( 'display' )
            .addClass('table table-striped table-bordered');
        

    $('#tblFactura tfoot th.filter').each( function () {
        var title = $(this).text();
        $(this).html( '<input type="text" placeholder="Buscar '+title+'" style="width:100%" />' );
    } );  

 

    var table = $('#tblFactura').DataTable();
    // Apply the search
    table.columns().every( function () {
        var that = this; 
        $( 'input', this.footer() ).on( 'keyup change', function () {
            if ( that.search() !== this.value ) {
                that
                    .search (this.value.replace("/;/g", "|"), true, false)
                    .draw();
            }
        } );
    } );
</script>