<section class="content-header">
    <h1><i class='fa-fw fa fa-dollar'></i> <?php echo $_translator->_getTranslation('Pagos'); ?></small></h1>
    <?php if(isset($pago) && $pago->getOptions()['status'] == 2): ?>
        <span class="label label-default"><?php echo $pago->getOptions()['uuid'] ?></span>
    <?php endif ?>
    <ol class="breadcrumb">
        <li><a href="<?php echo ROOT_HOST ?>/Controller/Inicio.php"><i class="fa fa-dashboard"></i><?php echo $_translator->_getTranslation('Inicio') ?></a></li>
        <li><a href="<?php echo ROOT_HOST ?>/Controller/Pago.php?action=list"><i></i><?php echo $_translator->_getTranslation('Lista de pagos') ?></a></li>
        <li class="active"><?php echo $_translator->_getTranslation('Pagos'); ?></li>
    </ol>
</section>
<section class="content">
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"></h3>
            <div class="box-tools pull-right">
                <?php if ($action === 'edit') : ?>
                    <?php if ($pago->getOptions()['status'] != '3') : ?>
                        <a href="Pago.php?action=delete&id=<?php echo $id; ?>" class="btn btn-cancelar"><i class='fa fa-ban'></i> <?php echo $_translator->_getTranslation('Cancelar') ?></a>
                        <?php if ($pago->getOptions()['status'] == '2') : ?>
                            <button onclick="javascript: void window.open('Pago.php?action=import&flag=pdf&id=<?php echo $id ?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')" class="btn btn-imprimir"><i class='fa fa-print'></i> Imprimir</button>
                            <a target="_blank" href="Pago.php?action=descargar&idPago=<?php echo $id ?>" class="btn btn-success"><i class='fa fa-cloud-download'></i> Descargar</a>
                            <a class="btn btn-info" href="#" onclick="setDataInvoicePago(this)" data-idinvoice="<?php echo $id; ?>" data-toggle='modal' data-target='#modalInvoiceToMailP' title="Enviar por correo"><i class="fa fa-envelope"></i> Enviar por correo</a>
                        <?php endif; ?>
                        <?php /* SIN TIMBRAR */ if ($pago->getOptions()['status'] == '1') : ?>
                            <a class="btn btn-info timbrar-pago" data-pago-id="<?php echo $id; ?>"><span class="fa fa-plus fa-bell"></span> <?php echo $_translator->_getTranslation('Timbrar pago'); ?></a>
                        <?php endif ?>
                        <a href="Pago.php" class="btn btn-primary"><i class='fa fa-plus'></i> <?php echo $_translator->_getTranslation('Agregar pago') ?></a>
                    <?php endif; ?>
                <?php endif; ?>
            </div><!-- /.box-tools -->
        </div><!-- /.box-header -->
        <div class="box-body">
            <div class='flashmessenger'><?php $flashmessenger->showMessage(); ?></div>
            <div class="clear"></div>
            <?php echo $form->openForm(); ?>
            <div style="display: none"><?php
                                        echo $form->showActionController();
                                        echo $form->showId();
                                        echo $form->showElement('status');
                                        echo $form->showElement('monto_original');
                                        echo $form->showElement('suma_de_pagos');
                                        ?>
            </div>


            <div class="panel panel-default">
                <div class="panel-heading"><?php echo $_translator->_getTranslation('Informacion general del pago') ?></div>
                <div class="panel-body">
                    <div class="col-md-5 col-xs-5">
                        <?php $form->showElement('fecha');
                        $form->showElement('forma_de_pago');
                        $form->showElement('cliente');
                        $form->showElement('cuenta_bancaria_ordenante');
                        $form->showElement('cuenta_bancaria');
                        $form->showElement('num_operacion'); ?>
                    </div>
                    <div class="col-md-5 col-xs-5">
                        <?php $form->showElement('monto');
                        $form->showElement('moneda');
                        $form->showElement('tipo_de_cambio');
                        $form->showElement('notas');
                        $form->showElement('adjuntos[]');

                        if (isset($id) && PagoRepository::hasAttachments($id)) {
                            echo PagoRepository::getAttachmentsHmtlList($id);
                        }
                        ?>
                    </div>
                    <div class="col-md-2 col-xs-2 text-right">
                        <?php
                        $labelMontoPago = trim($form->getValueElement('monto'));
                        $labelSumaPago = trim($form->getValueElement('suma_de_pagos'));
                        if ($labelMontoPago == '') {
                            $labelMontoPago = 0;
                        }
                        if ($labelSumaPago == '') {
                            $labelSumaPago = 0;
                        }
                        ?>
                        <h3 id="label_monto_pago" style="margin: 0px;">$<?php echo number_format($labelMontoPago, 2) ?></h3>
                        <i><?php echo $_translator->_getTranslation('Monto de pago') ?></i>
                        <div class="m-t-3"></div>
                        <h3 id="label_suma_pagos" style="margin: 0px;">$<?php echo number_format($labelSumaPago, 2) ?></h3>
                        <i><?php echo $_translator->_getTranslation('Suma de pagos') ?></i>
                    </div>
                </div>
            </div>

            <div class="clear"></div>

            <div class="panel panel-default">
                <div class="panel-heading"><?php echo $_translator->_getTranslation(' Facturas con saldo pendiente') ?></div>
                <div class="panel-body">
                    <table class="table table-striped">
                        <thead>
                            <th class='text-center'><?php echo $_translator->_getTranslation('Factura') ?></th>
                            <th class='text-center'><?php echo $_translator->_getTranslation('Cliente') ?></th>
                            <th class='text-center'><?php echo $_translator->_getTranslation('Fecha') ?></th>
                            <th class='text-right'><?php echo $_translator->_getTranslation('Monto original') ?></th>
                            <th class='text-right'><?php echo $_translator->_getTranslation('Saldo') ?></th>
                            <th class='text-center'><?php echo $_translator->_getTranslation('Agregar') ?></th>
                        </thead>
                        <tbody id="listFacturasClientes">
                            <?php
                            #Status de pago en general
                            if ($form->getValueElement('status') == '1' || $form->getValueElement('status') == '') {
                                $ajaxPago = new PagoAjax();
                                $facturasPendientes = $ajaxPago->getListFacturasByCliente(array('cliente' => $form->getValueElement('cliente')));
                                echo $facturasPendientes['listFacturas'];
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="clear"></div>

            <div class="panel panel-default">
                <div class="panel-heading"><?php echo $_translator->_getTranslation('Facturas a pagar') ?></div>
                <div class="panel-body">
                    <table class="table table-striped">
                        <thead>
                            <th><?php echo $_translator->_getTranslation('Edit') ?></th>
                            <th><?php echo $_translator->_getTranslation('Factura') ?></th>
                            <th><?php echo $_translator->_getTranslation('Cliente') ?></th>
                            <th><?php echo $_translator->_getTranslation('Fecha') ?></th>
                            <th class="text-right"><?php echo $_translator->_getTranslation('Monto original') ?></th>
                            <th class="text-right"><?php echo $_translator->_getTranslation('Saldo') ?></th>
                            <th class="text-right"><?php echo $_translator->_getTranslation('Pago') ?></th>
                        </thead>
                        <tbody id="listFacturasAPagar">
                            <?php if (isset($_listFacturas)) {
                                $entity = new FacturaRepository();
                                foreach ($_facturas as $factura => $value) {
                                    $result = $entity->getById($factura);
                                    if ($result) {   ?>
                                        <tr id="deleteInvoice_<?php echo $factura ?>">
                                            <td>
                                                <a onclick="deleteInvoiceFromPayment('<?php echo $factura ?>')" class='btn btn-sm btn-danger'><i class='fa fa-trash'></i></a>
                                            </td>
                                            <td><?php echo $result['serie'] . $result['folio'] ?></td>
                                            <td><?php echo $result['clienteName'] ?></td>
                                            <td><?php echo $result['fecha'] ?></td>
                                            <td class="text-right"><?php echo number_format($result['total'], 2) ?></td>
                                            <td class="text-right"><?php echo number_format($result['saldo_pendiente'], 2); ?></td>
                                            <td class="text-right"><?php $form->showElement("pago[$factura]"); ?></td>
                                        </tr>
                                        <script>
                                            $('#addInvoice_<?php echo $factura ?>').hide();
                                        </script>

                            <?php    }
                                }
                            } ?>
                        </tbody>
                        <tr>
                            <td colspan="6" class="text-right"><label><b>Total</b></label></td>
                            <td class="text-right">
                                <h3 class='sumPagos'></h3>
                            </td>
                        </tr>
                    </table>
                    <div class="col-md-2 col-xs-12 pull-right text-right"><?php $form->showElement('send'); ?></div>
                </div>
            </div>

            <?php echo $form->closeForm(); ?>
        </div><!-- /.box-body -->
    </div><!-- /.box -->
</section>
<?php include ROOT . "/View/Modal/enviarPagoPorMail.php"; ?>
<style>
    label.forma_de_pago,
    label.cuenta_bancaria_ordenante,
    label.cuenta_bancaria {
        margin-top: -3px;
    }
</style>
<script>
    $('#forma_de_pago, #proveedor, #cliente, #cuenta_bancaria_ordenante, #cuenta_bancaria, #moneda').select2();
    //$("#fecha").datetimepicker({format: 'dd/mm/yyyy'});
    $('#fecha').datetimepicker({
        format: 'MM/DD/YYYY'
    });

    $("#proveedor").on('select2:select', function() {
        getListFacturasProveedores();
        $("#listFacturasAPagar").html('');
    });

    $('#monto').on('blur', function() {
        var monto = this.value;
        if (monto.trim() === '') {
            monto = '0';
        }
        $('#monto_original').val(monto);
        setLabelMonto(monto);
    });

    $('#monto').on('change', function() {
        if ($('#monto_original').val() === '') {
            return null;
        } else {
            limpiarFacturasAPagarPorCambioMonto();
        }
    });

    $('button.delete-file').on('click', function() {
        var button = this;
        if (confirm('Deseas eliminar definitivamente el archivo: ' + $(this).data('fileusername'))) {
            $.post('Pago.php', {
                action: 'ajax',
                request: 'deleteAttachment',
                filename: $(this).data('filename')
            }, function(data) {
                if (data.response) {
                    $(button).parent().remove();
                }
                $('.flashmessenger').html(data.message);
            }, 'json');
        }
    });

    $('a.timbrar-pago').on('click', function(e) {
        var idPago = $(e.currentTarget).data('pago-id');
        $(e.currentTarget).addClass('disabled');
        $.post('Pago.php', {
            action: 'ajax',
            id_pago: idPago,
            request: 'timbrarPago'
        }, function(data) {
            if (data.response) {
                window.location.href = '/Controller/Pago.php?action=edit&id=' + idPago;
            }
        }, 'json');
    });

    $("#form_pago #cliente").on('change', function(e) {
        $.post('Pago.php', {
            action: 'ajax',
            request: 'getListCuentaBancariasAsArray',
            id_cliente: $(e.currentTarget).val()
        }, function(r) {
            if (r.response) {
                var option = "<option value=\"0\">Selecciona una opcion...</option>";
                r.data.forEach(element => {
                    option += "<option value =\"" + element.id + "\">" + element.bancoName + " - " + element.cuenta + "</option>";
                });
                $("select#cuenta_bancaria_ordenante").html(option);
            } else {
                $("select#cuenta_bancaria_ordenante").html("<option value=\"0\">Selecciona una opcion...</option>");
            }
        }, 'json');
    });
</script>