<section class="content-header">
    <h1>
        <i class='fa-fw fa fa-upload'></i> <?php echo $_translator->_getTranslation('Lista de pagos'); ?>
        <?php if (isset($_factura)) : ?>
            de <a class="label label-primary" href="Factura.php?action=edit&id=<?php echo $_factura['id']; ?>">Factura #<?php echo $_factura['serie'] ?><?php echo $_factura['folio'] ?></a>
            <small><a class="label label-default small" href="Pago.php?action=list">Limpiar filtro</a></small>
        <?php endif; ?>
    </h1>
    <ol class="breadcrumb">
        <li><a href="<?php echo ROOT_HOST ?>/Controller/Home.php"><i class="fa fa-dashboard"></i><?php echo $_translator->_getTranslation('Inicio') ?></a></li>
        <li class="active"><?php echo $_translator->_getTranslation('Lista de pagos'); ?></li>
    </ol>
</section>
<section class="content">
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"></h3>
            <div class="box-tools pull-right">
                <a href="Pago.php" class="btn btn-primary"><i class='fa fa-plus'></i> <?php echo $_translator->_getTranslation('Agregar pago') ?></a>
                <span class="btn btn-info _advancedSearch"><i class='fa fa-search-plus'></i> <?php echo $_translator->_getTranslation('Busqueda avanzada') ?></span>
            </div><!-- /.box-tools -->
        </div><!-- /.box-header -->
        <div class="box-body">
            <div class='flashmessenger'><?php $flashmessenger->showMessage(); ?></div>
            <div class="clear"></div>
            <div class='table-responsive'>
                <table id="tblPagos" class="table table-bordered table-striped table-hover table-condensed datatable_whit_filter_column">
                    <thead>
                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Fecha'); ?></th>
                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Serie'); ?></th>
                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Folio'); ?></th>
                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Cliente'); ?></th>
                        <th class="col-lg-4 text-right"><?php echo $_translator->_getTranslation('Monto'); ?></th>
                        <th class="col-lg-1 text-center"><?php echo $_translator->_getTranslation('Status'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Enviado'); ?></th>
                        <th class="col-lg-1 text-center">Accion</th>
                    </thead>
                    <tfoot>
                        <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Fecha'); ?></th>
                        <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Serie'); ?></th>
                        <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Folio'); ?></th>
                        <th class="filter col-md-3 text-center"><?php echo $_translator->_getTranslation('Cliente'); ?></th>
                        <th class="filter col-md-1 text-right"><?php echo $_translator->_getTranslation('Monto'); ?></th>
                        <th class="filter col-md-1 text-center"><?php echo $_translator->_getTranslation('Status'); ?></th>

                        <th></th>
                        <th></th>
                    </tfoot>
                    <tbody>
                        <?php
                        if ($_listPagos) {
                            foreach ($_listPagos as $pago) { ?>
                                <?php
                                $datosEmisor = unserialize($pago['datos_emisor']);
                                $datosReceptor = unserialize($pago['datos_receptor']);
                                ?>
                                <tr>
                                    <td class="text-center"><?php echo $pago['fecha'] ?></td>
                                    <td class="text-center"><?php echo $pago['serie'] ?></td>
                                    <td class="text-center"><?php echo $pago['folio'] ?></td>
                                    <td class="text-center"><?php echo $pago['clienteName'] ?></td>
                                    <td class="text-right"><?php echo number_format($pago['monto'], 2) ?></td>
                                    <td class="text-center">
                                        <?php switch (strtoupper($pago['statusName'])):
                                            case "TIMBRADO": ?>
                                            <span style="font-size:10px;" class="label label-primary">Timbrado</span>
                                        <?php break; ?>
                                        <?php case "SIN TIMBRAR": ?>
                                            <span style="font-size:10px;" class="label label-info">Sin Timbrar</span>
                                        <?php break; ?>
                                        <?php case "CANCELADO": ?>
                                            <span style="font-size:10px;" class="label label-danger">Cancelado</span>
                                        <?php break; ?>
                                        <?php default: ?>
                                            <span style="font-size:10px;" class="label label-default"><?php echo $pago['statusName'] ?></span>
                                        <?php break; ?>
                                        <?php endswitch; ?>
                                    </td>
                                    <td class="text-center" <?php if ($pago['enviado'] == 1) { ?>><i class="fa fa-check" title="El pago se envio por correo electronico."></i></td> <?php } else {
                                            } ?>
                                </td>
                                <td class="text-center" style="white-space: nowrap;">
                                    <a class="btn btn-sm btn-default" title="Editar" href="Pago.php?action=edit&id=<?php echo $pago['id'] ?>"><i class="fa fa-pencil"></i></a>
                                    <?php if ($pago['status'] == '2') { ?>
                                        <a class="btn btn-sm btn-warning" href="#" onclick="javascript: void window.open('Pago.php?action=import&flag=pdf&id=<?php echo $pago['id'] ?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')"><i class="fa fa-file-pdf-o fa-" title="Ver documento en formato PDF"></i></a>
                                        <a class="btn btn-sm btn-success" href="Pago.php?action=descargar&idPago=<?php echo $pago['id'] ?>" title="Descargar documento en formato ZIP"><i class="fa fa-cloud-download"></i></a>
                                        <a class="btn btn-sm btn-info" href="#" onclick="setDataInvoicePago(this)" data-idinvoice="<?php echo $pago['id']; ?>" data-toggle='modal' data-target='#modalInvoiceToMailP' title="Enviar por correo"><i class="fa fa-envelope"></i></a>
                                    <?php } else { ?>
                                        <a class="btn btn-sm btn-warning" href="#" onclick="javascript: void window.open('Pago.php?action=import&flag=pdf&id=<?php echo $pago['id'] ?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')"><i class="fa fa-file-pdf-o fa-" title="Ver documento en formato PDF"></i></a>
                                        <a class="btn btn-sm btn-default disabled" href="#" title="Descargar documento en formato ZIP"><i class="fa fa-cloud-download"></i></a>
                                        <a class="btn btn-sm btn-default disabled" href="#" title="Enviar por correo"><i class="fa fa-envelope"></i></a>
                                    <?php } ?>
                                    <?php
                                    $info = "Creado por: {$pago['creado_por_nombre']}&#10;";
                                    $info .= "Creado: " . date_format(date_create($pago['creado_fecha']), 'g:i A j \d\e M, Y') . "&#10;&#10;";
                                    $info .= (!empty($pago['ultima_mod_por_nombre'])) ? "Modificado por: {$pago['ultima_mod_por_nombre']}&#10;" : null;
                                    $info .= (!empty($pago['ultima_mod_por_nombre'])) ? "Modificado: " . date_format(date_create($pago['ultima_mod_fecha']), 'g:i A j \d\e M, Y') . "&#10;&#10;" : null;
                                    $info .= (!empty($pago['fecha_timbrado'])) ? "Timbrado: " . date_format(date_create($pago['ultima_mod_fecha']), 'g:i A j \d\e M, Y') . "&#10;&#10;" : null;
                                    $info .= (!empty($pago['ultima_mod_por_nombre']) && $pago['status'] == 3) ? "Cancelada: " . date_format(date_create($pago['ultima_mod_fecha']), 'g:i A j \d\e M, Y') . "&#10;&#10;" : null;
                                    ?>
                                    <a title="<?php echo $info; ?>" class="btn btn-sm btn-default"><i class="fa fa-commenting-o"></i></a>
                                    <div class="btn-group dropup">
                                        <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu  dropdown-menu-right">
                                            <?php if ($pago['status'] == '1') { ?>
                                                <li><a onclick="return deleteRegistry('Pago.php?action=delete&id=<?php echo $pago['id'] ?>')" href="#"><i class="fa fa-trash" style="color: red;"></i> Eliminar en sistema</a></li>
                                            <?php } elseif ($pago['status'] == '2') { ?>
                                                <li><a onclick="return deleteRegistry('Pago.php?action=delete&id=<?php echo $pago['id'] ?>')" href="#"><i class="fa fa-trash" style="color: red;"></i> Cancelar en sistema</a></li>
                                                <li><a href="#" onclick="cancelarPago(this)" data-idpago='<?php echo $pago['id'] ?>'><i class="fa fa-bell-slash" style="color: red;"></i> Cancelar en SAT</a></li>
                                                <li><a href="https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=<?php echo $pago['uuid'] ?>&re=<?php echo $datosEmisor['Emisor']['Rfc'] ?>&rr=<?php echo $datosReceptor['Receptor']['Rfc'] ?>&tt=<?php echo $pago['monto'] ?>&fe=<?php echo substr($pago['sello_sat'], -8); ?>" target='_sat'>Seguir en SAT</a></li>
                                            <?php } elseif ($pago['status'] == '3') { ?>
                                                <li><a href="#" onclick="cancelarPago(this)" data-idpago='<?php echo $pago['id'] ?>'><i class="fa fa-bell-slash" style="color: red;"></i> Cancelar en SAT</a></li>
                                                <li><a href="https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=<?php echo $pago['uuid'] ?>&re=<?php echo $datosEmisor['Emisor']['Rfc'] ?>&rr=<?php echo $datosReceptor['Receptor']['Rfc']  ?>&tt=<?php echo $pago['monto'] ?>&fe=<?php echo substr($pago['sello_sat'], -8); ?>" target='_sat'><i class="fa fa-external-link" style="color: #00cdff;"></i> Seguir en SAT</a></li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </td>
                                </tr><?php
                                        // var_dump($pago);
                                    }
                        } ?>
                    </tbody>
                </table>
            </div>
        </div><!-- /.box-body -->
    </div><!-- /.box -->
</section>
<?php include ROOT . "/View/Modal/enviarPagoPorMail.php"; ?>
<?php include ROOT . "/View/Modal/advancedSearch.php"; ?>
<style>
    tfoot {
        display: table-header-group;
    }

    .dataTables_filter {
        display: none;
    }
</style>
<script type="text/javascript" language="javascript">
    // DataTable
    $('#tblPagos').DataTable({
        paginate: true,
        pageLength: 15,
        filter: true,
        bFilter: true,
        aaSorting: [],
        dom: 'Bfrtip',
        buttons: [
            'excel',
        ],
        language: {
            "zeroRecords": "No se encontraron registros",
            "info": "Mostrando pjgina _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros disponibles",
            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
            "paginate": {
                "previous": "Anterior",
                "next": "Siguiente"
            }
        }
    });
    $('#tblPagos')
        .removeClass('display')
        .addClass('table table-striped table-bordered');

    $('#tblPagos tfoot th.filter').each(function() {
        var title = $(this).text();
        $(this).html('<input type="text" placeholder="Buscar ' + title + '" style="width:100%" />');
    });

    var table = $('#tblPagos').DataTable();
    // Apply the search
    table.columns().every(function() {
        var that = this;
        $('input', this.footer()).on('keyup change', function() {
            if (that.search() !== this.value) {
                that
                    .search(this.value.replace("/;/g", "|"), true, false)
                    .draw();
            }
        });
    });
</script>