<?php

// var_dump($data['data'][9]); exit;
//$sucursales = $data['stores'];
$objPHPExcel = new PHPExcel();

// este arreglo determina que columnas se van a mostrar y en que orden
// no necesarimente existen en el arreglo original; para eso se estandariza el arreglo en cada iteracion correspondiente
$facturaColumnOrder = [
    'fecha',
    'fecha_timbrado',
    'serie',
    'folio',
    'uuid',
    'comprobante',
    'importe',
    'descuento',
    'saldo',
    'tipo_de_cambio',
    'estado',
    'saldo_pendiente'
];
$activeSheet = $objPHPExcel->getActiveSheet();

// Encabezado de reporte
$activeSheet->mergeCells("A1:L1");
$activeSheet->getRowDimension('1')->setRowHeight(50);
$activeSheet->getStyle("A1")->getFont()->setBold(true);
$activeSheet->setCellValue("A1", $this->headerExcelReport);
$activeSheet->getStyle('A1')->getAlignment()->setWrapText(true);
$activeSheet->getStyle("A1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$activeSheet->getStyle("A1")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

// valores iniciales
$columnIndex = 0;
$rowIndex = 2;
$columnsPrinted = false;

// $data['data'][] = $data['data']['2'];
foreach ($facturaColumnOrder as $value) {
    $activeSheet->setCellValueByColumnAndRow($columnIndex++, $rowIndex, $value);
}
$columnIndex = 0;
$rowIndex = 3;
$activeSheet->freezePaneByColumnAndRow(0,3);

foreach ($data['data'] as $cliente) { // cliente level
    $columnsPrinted = false;
    @$activeSheet->mergeCellsByColumnAndRow($columnIndex, $rowIndex, 9, $rowIndex);

    $clienteCellValue = "Nombre: {$cliente['datosCliente']['nombre']}\nRFC: {$cliente['datosCliente']['rfc']}";

    // Seteo de la celda con la informacion del cliente
    $cell = @$activeSheet->getCellByColumnAndRow($columnIndex, $rowIndex);
    $activeSheet->getRowDimension($cell->getRow())->setRowHeight(40);
    $activeSheet->getStyle($cell->getCoordinate())->getAlignment()->setWrapText(true);
    $cell->setValue($clienteCellValue);

    // Saldo inicial, en la misma linea que el cliente
    @$activeSheet->setCellValueByColumnAndRow(10, $rowIndex, 'Saldo Inicial');
    @$activeSheet->setCellValueByColumnAndRow(11, $rowIndex, $cliente['saldoInicial']);

    // salto a la siguiente fila, despues de haber ingresado la informacion del cliente y el saldo inicial
    $rowIndex++;

    //nombre de las columnas para cada cliente
    foreach ($facturaColumnOrder as $value) {
        @$activeSheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, $value);

        $columnIndex++;
    }
    $rowIndex++; //salto de linea despues de los nombres de las columnas
    $columnIndex = 0; //de vuelta a la izquierda

    $saldoTotalPendiente = 0;
    foreach ($cliente['facturas'] as $factura) { // row level
        // just standardizing the array so we can iterate easier
        $factura['fecha'] = $factura['fecha'];
        $factura['fecha_timbrado'] = $factura['fecha_timbrado'];
        $factura['serie'] = $factura['serie'];
        $factura['folio'] = $factura['folio'];
        $factura['uuid'] = $factura['uuid'];
        $factura['comprobante'] = 'Factura';
        $factura['importe'] = $factura['total'];
        $factura['descuento'] = $factura['descuento'];
        $factura['saldo'] = $factura['total'];
        $factura['tipo_de_cambio'] = $factura['tipo_de_cambio'];
        $factura['estado'] = $factura['statusName'];
        $factura['saldo_pendiente'] = $factura['saldo_pendiente'];


        $saldoTotalPendiente += $factura['saldo_pendiente'];

        // valor de las columnas para cada factura
        foreach ($facturaColumnOrder as $key) { //column level
            @$activeSheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, $factura[$key]);
            $columnIndex++;
        }

        $columnIndex = 0;
        $rowIndex++;

        // por cada factura, reviso si existen pagos; de ser asi, se iteran
        if (isset($factura['pagos']) && is_array($factura['pagos'])) {
            $value = $factura['pagos'];
            foreach ($value as $pago) {

                // just standardizing the array so we can iterate easier
                $saldoFactura = $factura['saldo'] - $pago['monto'];
                $pago['fecha'] = $pago['fecha'];
                $pago['serie'] = "";
                $pago['folio'] = "";
                $pago['comprobante'] = 'Pago';
                $pago['importe'] = $pago['monto'];
                $pago['saldo'] = $saldoFactura;
                $pago['tc'] = $pago['tipo_de_cambio'];
                $pago['estado'] = $pago['statusName'];
                $pago['saldo_pendiente'] = "";

                foreach ($facturaColumnOrder as $key) {
                    @$activeSheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, $pago[$key]);
                    $columnIndex++;
                }
                $rowIndex++;
                $columnIndex = 0;
            }
        }
    }
    $activeSheet->setCellValueByColumnAndRow(10, $rowIndex, 'Saldo Total Pendiente');
    $activeSheet->setCellValueByColumnAndRow(11, $rowIndex++, $saldoTotalPendiente);
}

// finalizando el documento
$objPHPExcel->setActiveSheetIndex(0);
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

if ($this->saveFile == true) {
    $objWriter->save($this->getTempFolder() . "/" . $this->getNombreArchivo() . ".xlsx");
} else {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment;filename=" . $this->getNombreArchivo() . ".xlsx");
    header('Cache-Control: max-age=0');
    $objWriter->save('php://output');
    exit();
}
unset($objWriter);
