<?php

$excel = new PHPExcel();


$as = $excel->getActiveSheet();

$c = 0;
$as->setCellValueByColumnAndRow($c++,2,'Serie');
$as->setCellValueByColumnAndRow($c++,2,'Folio');
$as->setCellValueByColumnAndRow($c++,2,'UUID');
$as->setCellValueByColumnAndRow($c++,2,'Fecha y Hora de Timbrado');
$as->setCellValueByColumnAndRow($c++,2,'Fecha');
$as->setCellValueByColumnAndRow($c++,2,'Cliente');
$as->setCellValueByColumnAndRow($c++,2,'Importe');
$as->setCellValueByColumnAndRow($c++,2,'IVA');
$as->setCellValueByColumnAndRow($c++,2,'IEPS');
$as->setCellValueByColumnAndRow($c++,2,'Total');
$as->setCellValueByColumnAndRow($c++,2,'Saldo Pendiente');
$as->setCellValueByColumnAndRow($c++,2,'Moneda');
$as->setCellValueByColumnAndRow($c++,2,'Tipo de Cambio');
$as->setCellValueByColumnAndRow($c++,2,'Terminos de Pago');
$as->setCellValueByColumnAndRow($c++,2,'Fecha de Pago');
$as->setCellValueByColumnAndRow($c++,2,'Sucursal');
$as->setCellValueByColumnAndRow($c++,2,'Estado');



$as->mergeCells("A1:Q1");
$as->getRowDimension('1')->setRowHeight(50);
$as->getStyle("A1")->getFont()->setBold(true);
$as->setCellValue("A1", $this->headerExcelReport);
$as->getStyle('A1')->getAlignment()->setWrapText(true);
$as->getStyle("A1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$as->getStyle("A1")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$rows = $data['data'];
$r = 3;
$c = 0;
foreach($rows as $row) {
    $cliente = unserialize(utf8_decode($row['datos_receptor']));
    if (isset($cliente['Receptor']['nombre'])) {
        $cliente['Receptor']['Nombre'] = $cliente['Receptor']['nombre'];
    }
    if (isset($cliente['Receptor']['rfc'])) {
        $cliente['Receptor']['Rfc'] = $cliente['Receptor']['rfc'];
    }

    $impuestos = unserialize(utf8_decode($row['detalles_impuestos_aplicables']));
    $ieps = 0;
    $iva = 0;
    if ('3.3' == $row['version_cfdi']) {
        if (isset($impuestos['Trasladable']['2'])) {
            $ieps = $impuestos['Trasladable']['2']['Importe'];
        }
        if (isset($impuestos['Trasladable']['1'])) {
            $iva = $impuestos['Trasladable']['1']['Importe'];
        }
    } elseif ('3.2' == $row['version_cfdi']) {
        if (isset($impuestos['Trasladable']['2'])) {
            $ieps = $impuestos['Trasladable']['2']['monto'];
        }
        if (isset($impuestos['Trasladable']['1'])) {
            $iva = $impuestos['Trasladable']['1']['monto'];
        }
    }
    // var_dump($row); exit;
    $as->setCellValueByColumnAndRow($c++,$r,$row['serie']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['folio']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['uuid']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['ultima_mod_fecha']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['fecha_timbrado_solo_fecha']);
    $as->setCellValueByColumnAndRow($c++,$r,$cliente['Receptor']['Nombre']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['subtotal']);
    $as->setCellValueByColumnAndRow($c++,$r,$iva);
    $as->setCellValueByColumnAndRow($c++,$r,$ieps);
    $as->setCellValueByColumnAndRow($c++,$r,$row['total']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['saldo_pendiente']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['moneda']);
    $as->setCellValueByColumnAndRow($c++,$r,number_format($row['tipo_de_cambio'], 2));
    $as->setCellValueByColumnAndRow($c++,$r,$row['payment_term']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['ultimo_pago']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['sucursalName']);
    $as->setCellValueByColumnAndRow($c++,$r,$row['statusName']);

    $c = 0;
    $r++;
}
// Setting: Monto de facturacion
//$as->setCellValueByColumnAndRow(7, $r,'Monto de facturacion');
$as->setCellValue(PHPExcel_Cell::stringFromColumnIndex(10).$r, "=SUM(K2:K".($r-1).")");
$as->setCellValue(PHPExcel_Cell::stringFromColumnIndex(9).$r, "=SUM(J2:J".($r-1).")");
$as->setCellValue(PHPExcel_Cell::stringFromColumnIndex(8).$r, "=SUM(I2:I".($r-1).")");
$as->setCellValue(PHPExcel_Cell::stringFromColumnIndex(7).$r, "=SUM(H2:H".($r-1).")");
$as->setCellValue(PHPExcel_Cell::stringFromColumnIndex(6).$r, "=SUM(G2:G".($r-1).")");
$as->freezePaneByColumnAndRow(0,3);

// $as->mergeCells('P1:S4');
// $as->setCellValue('P1', $data['ventasGeneradas']);
// $as->getStyle('P1')->getFont()->setSize(28);
// $as->mergeCells('P5:S5');
// $as->setCellValue('P5', 'Facturas Generadas');


$objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment;filename=" . $this->getNombreArchivo() . ".xlsx");
header('Cache-Control: max-age=0');
$objWriter->save('php://output');
unset($objWriter, $excel);
exit();