<?php

// var_dump($data['data'][10]['facturas']); exit;

$excel = new PHPExcel();


$as = $excel->getActiveSheet();

// Encabezado de reporte
$as->mergeCells("A1:S1");
$as->getRowDimension('1')->setRowHeight(50);
$as->getStyle("A1")->getFont()->setBold(true);
$as->setCellValue("A1", $this->headerExcelReport);
$as->getStyle('A1')->getAlignment()->setWrapText(true);
$as->getStyle("A1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$as->getStyle("A1")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$as->freezePaneByColumnAndRow(0,3);

// Asignacion de columnas
$c = 0;
$as->setCellValueByColumnAndRow($c++, 2, 'Serie');
$as->setCellValueByColumnAndRow($c++, 2, 'Folio');
$as->setCellValueByColumnAndRow($c++, 2, 'Fecha');
$as->setCellValueByColumnAndRow($c++, 2, 'Codigo');
$as->setCellValueByColumnAndRow($c++, 2, 'Nombre(Producto,Servicio,Paquete)');
$as->setCellValueByColumnAndRow($c++, 2, 'Descripcion');
$as->setCellValueByColumnAndRow($c++, 2, 'Unidad de Medida');
$as->setCellValueByColumnAndRow($c++, 2, 'Clave Unidad de Medida');
$as->setCellValueByColumnAndRow($c++, 2, 'Clave SAT');
$as->setCellValueByColumnAndRow($c++, 2, 'Cantidad');
$as->setCellValueByColumnAndRow($c++, 2, 'Precio Unitario');
$as->setCellValueByColumnAndRow($c++, 2, 'Descuento');
$as->setCellValueByColumnAndRow($c++, 2, 'Importe');
$as->setCellValueByColumnAndRow($c++, 2, 'IVA 16%');
$as->setCellValueByColumnAndRow($c++, 2, 'IVA 8%');
$as->setCellValueByColumnAndRow($c++, 2, 'IEPS');
$as->setCellValueByColumnAndRow($c++, 2, 'Moneda');
$as->setCellValueByColumnAndRow($c++, 2, 'Tipo de Cambio');
$as->setCellValueByColumnAndRow($c++, 2, 'Total');

$clientes = $data['data'];
$c = 0;
$r = 3;

foreach ($clientes as $key => $cliente) {
    $datosCliente = "Cliente: {$cliente['datosCliente']['nombre']} - {$cliente['datosCliente']['rfc']}";
    $as->mergeCells("A$r:S$r");
    $as->getRowDimension($r)->setRowHeight(35);
    $as->getStyle("A$r")->getFont()->setBold(true);
    $as->setCellValueByColumnAndRow($c, $r++, $datosCliente);
    $as->setCellValueByColumnAndRow($c++, $r, 'Serie');
    $as->setCellValueByColumnAndRow($c++, $r, 'Folio');
    $as->setCellValueByColumnAndRow($c++, $r, 'Fecha');
    $as->setCellValueByColumnAndRow($c++, $r, 'Codigo');
    $as->setCellValueByColumnAndRow($c++, $r, 'Nombre(Producto,Servicio,Paquete)');
    $as->setCellValueByColumnAndRow($c++, $r, 'Descripcion');
    $as->setCellValueByColumnAndRow($c++, $r, 'Unidad de Medida');
    $as->setCellValueByColumnAndRow($c++, $r, 'Clave Unidad de Medida');
    $as->setCellValueByColumnAndRow($c++, $r, 'Clave SAT');
    $as->setCellValueByColumnAndRow($c++, $r, 'Cantidad');
    $as->setCellValueByColumnAndRow($c++, $r, 'Precio Unitario');
    $as->setCellValueByColumnAndRow($c++, $r, 'Descuento');
    $as->setCellValueByColumnAndRow($c++, $r, 'Importe');
    $as->setCellValueByColumnAndRow($c++, $r, 'IVA 16%');
    $as->setCellValueByColumnAndRow($c++, $r, 'IVA 8%');
    $as->setCellValueByColumnAndRow($c++, $r, 'IEPS');
    $as->setCellValueByColumnAndRow($c++, $r, 'Moneda');
    $as->setCellValueByColumnAndRow($c++, $r, 'Tipo de Cambio');
    $as->setCellValueByColumnAndRow($c++, $r, 'Total');

    $c = 0;
    $r++;

    foreach ($cliente['facturas'] as $folio => $factura) {
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['serie']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['folio']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['fecha']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['codigo']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['nombreProducto']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['descripcion']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['unidad_de_medida_desc']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['clave_unidad_medida']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['sat_producto_clave']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['cantidad']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['precio_unitario']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['descuento_monto']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['importe']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['impuestos']['IVA 16%']}");
        $as->setCellValueByColumnAndRow($c++, $r, isset($factura['impuestos']['IVA 8%']) ? $factura['impuestos']['IVA 8%'] : null);
        $as->setCellValueByColumnAndRow($c++, $r, isset($factura['impuestos']['IEPS']) ? $factura['impuestos']['IEPS'] : null);
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['moneda']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['tipo_de_cambio']}");
        $as->setCellValueByColumnAndRow($c++, $r, "{$factura['total']}");

        $r++;
        $c = 0;
    }
}


$objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment;filename=" . $this->getNombreArchivo() . ".xlsx");
header('Cache-Control: max-age=0');
$objWriter->save('php://output');
unset($objWriter, $excel);
exit();
