<div class="box-header">
    <h3 class="inline"><i class='fa-fw fa fa-shopping-basket'></i><?php echo $_translator->_getTranslation(ucfirst($_reporte->getTituloReporte())); ?></h3>
    <span class="dropdown">
        <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
            <i class='icon fa fa-tasks' id="moreOptions" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"></i>
            <span class="caret"></span>
        </button>
        <ul class="dropdown-menu">
            <li><a href="<?php echo $_reporte->getStringToSendGET() . '&output=excel'; ?>"><i class="fa fa-file-excel-o"></i>Exportar a excel</a></li>
            <!-- <li><a href="<?php echo $_reporte->getStringToSendGET() . '&enviarPorMail'; ?>" class="linkSendMail"><i class="fa fa-envelope"></i>Send to email</a></li> -->
        </ul>
    </span>
</div>
<div class='box-body'>
    <div class='row'>
        <div class="col-lg-12">
            <?php
            $result = $_reporte->getReporte();
            $data = empty($result['data']) ? [] : $result['data'];
            if (count($data) <= 0) {
                echo $_translator->_getTranslation('There is not any data.');
                exit;
            }
            ?>
            <div class="col-lg-3 col-md-6 pull-right">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <div class="row">
                            <div class="col-xs-3">
                                <i class="fa fa-desktop fa-5x"></i>
                            </div>
                            <div class="col-xs-9 text-right">
                                <div class="huge"><h1><?php echo $result['ventasGeneradas']; ?></h1></div>
                                <div><?php echo $_translator->_getTranslation('Facturas generadas'); ?></div>
                            </div>
                        </div>
                    </div>
                    <a href="#">
                        <div class="panel-footer">
                            <div class="clearfix"></div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 pull-right">
                <div class="panel panel-green">
                    <div class="panel-heading">
                        <div class="row">
                            <div class="col-xs-3">
                                <i class="fa fa-usd fa-5x"></i>
                            </div>
                            <div class="col-xs-9 text-right">
                                <div class="huge"><h1><?php echo $result['ventasMonto']; ?></h1></div>
                                <div><?php echo $_translator->_getTranslation('Monto de facturacion'); ?></div>
                            </div>
                        </div>
                    </div>
                    <a href="#">
                        <div class="panel-footer">
                            <div class="clearfix"></div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="table-responsive">
                <table id="tblReport" class="table table-striped table-bordered table-condensed table-hover">
                    <thead class="table-header">
                        <tr>
                            <td class="text-center"><?php echo $_translator->_getTranslation('Serie'); ?></td>
                            <td class="text-center"><?php echo $_translator->_getTranslation('Folio'); ?></td>
                            <!--<td class="text-center"><?php //echo $_translator->_getTranslation('Ticket');
                                                        ?></td> -->
                            <td class="text-center"><?php echo $_translator->_getTranslation('Fecha'); ?></td>
                            <td class="text-center"><?php echo $_translator->_getTranslation('Cliente'); ?></td>
                            <td class="text-center"><?php echo $_translator->_getTranslation('Importe'); ?></td>
                            <td class="text-center"><?php echo $_translator->_getTranslation('IVA'); ?></td>
                            <td class="text-right"><?php echo $_translator->_getTranslation('IEPS'); ?></td>
                            <td class="text-right"><?php echo $_translator->_getTranslation('Total'); ?></td>
                            <td class="text-right"><?php echo $_translator->_getTranslation('Saldo Pendiente'); ?></td>
                            <td class="text-right"><?php echo $_translator->_getTranslation('Sucursal'); ?></td>
                            <td class="text-center"><?php echo $_translator->_getTranslation('Status'); ?></td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($data as $row) {
                            $cliente = unserialize(utf8_decode($row['datos_receptor']));
                            if (isset($cliente['Receptor']['nombre'])) {
                                $cliente['Receptor']['Nombre'] = $cliente['Receptor']['nombre'];
                            }
                            if (isset($cliente['Receptor']['rfc'])) {
                                $cliente['Receptor']['Rfc'] = $cliente['Receptor']['rfc'];
                            }

                            /* PARA PCG */

                            $impuestos = unserialize(utf8_decode($row['detalles_impuestos_aplicables']));
                            $ieps = 0;
                            $iva = 0;

                            if ('3.3' == $row['version_cfdi']) {
                                if (isset($impuestos['Trasladable']['2'])) {
                                    $ieps = $impuestos['Trasladable']['2']['Importe'];
                                }
                                if (isset($impuestos['Trasladable']['1'])) {
                                    $iva = $impuestos['Trasladable']['1']['Importe'];
                                }
                            } elseif ('3.2' == $row['version_cfdi']) {
                                if (isset($impuestos['Trasladable']['2'])) {
                                    $ieps = $impuestos['Trasladable']['2']['monto'];
                                }
                                if (isset($impuestos['Trasladable']['1'])) {
                                    $iva = $impuestos['Trasladable']['1']['monto'];
                                }
                            } ?>
                            <tr>
                                <td class="text-center"><?php echo $row['serie']; ?></td>
                                <td class="text-center"><?php echo $row['folio']; ?></td>
                                <!--<td class="text-center"><?php //echo $row['ticket'];
                                                            ?></td>-->
                                <!--<td class="text-center"><?php echo $row['uuid']; ?></td>-->
                                <td class="text-center"><?php echo $row['fecha_timbrado_solo_fecha']; ?></td>
                                <td class="text-center"><?php echo htmlentities($cliente['Receptor']['Nombre']); ?></td>
                                <td class="text-right"><?php echo number_format($row['subtotal'], 2); ?></td>
                                <td class="text-right"><?php echo number_format($iva, 2); ?></td>
                                <td class="text-right"><?php echo number_format($ieps, 2); ?></td>
                                <td class="text-right"><?php echo number_format($row['total'], 2); ?></td>
                                <td class="text-right"><?php echo number_format($row['saldo_pendiente'], 2); ?></td>
                                <td class="text-center"><?php echo $row['sucursalName']; ?></td>
                                <td class="text-center"><?php echo $row['statusName']; ?></td>
                            </tr><?php
                                } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript" language="javascript">
    $('#tblReport').DataTable({
        paginate: false,
        filter: true,
        fixedHeader: true,
        aaSorting: [],
        dom: 'Bfrtip',
        buttons: [
            'excel'
        ]
    });


    $('#tblReport')
        .removeClass('display')
        .addClass('table table-striped table-bordered');
</script>