<div class="box-header"> 
    <h3><i class='fa-fw fa fa-shopping-basket'></i><?php echo $_translator->_getTranslation(ucfirst($_reporte->getTituloReporte()));?></h3>
    <div class='box-icon dropdown'>
        <i class='icon fa fa-tasks' id="moreOptions" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"></i>
        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="moreOptions">
            <li><a href="<?php echo $_reporte->getStringToSendGET().'&output=excel' ?>"><i class="fa fa-file-excel-o"></i>Export to excel</a></li>
            <li><a href="<?php echo $_reporte->getStringToSendGET().'&enviarPorMail' ?>" class="linkSendMail"><i class="fa fa-envelope"></i>Send to email</a></li>
        </ul>
    </div>
</div>
<div class='box-content'>
    <div class='row'>
        <div class="col-lg-12">
            <?php
            $result = $_reporte->getReporte();
            $data = $result['data'];
            if (count($data)<= 0) {
                echo $_translator->_getTranslation('There is not any data.');
                exit;
            }
            ?>            
            <div class="col-lg-3 col-md-6 pull-right">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <div class="row">
                            <div class="col-xs-3">
                                <i class="fa fa-desktop fa-5x"></i>
                            </div>
                            <div class="col-xs-9 text-right">
                                <div class="huge"><?php echo $result['ventasGeneradas'];?></div>
                                <div><?php echo $_translator->_getTranslation('Facturas generadas')?></div>
                            </div>
                        </div>
                    </div>
                    <a href="#">
                        <div class="panel-footer">
                            <div class="clearfix"></div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 pull-right">
                <div class="panel panel-green">
                    <div class="panel-heading">
                        <div class="row">
                            <div class="col-xs-3">
                                <i class="fa fa-usd fa-5x"></i>
                            </div>
                            <div class="col-xs-9 text-right">
                                <div class="huge"><?php echo $result['ventasMonto'];?></div>
                                <div><?php echo $_translator->_getTranslation('Monto de facturacion')?></div>
                            </div>
                        </div>
                    </div>
                    <a href="#">
                        <div class="panel-footer">
                            <div class="clearfix"></div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="table-responsive">
            <table id="tblReport" class="table table-striped table-bordered table-condensed table-hover">
            <thead class="table-header">
            <tr>
                <td class="text-center"><?php echo $_translator->_getTranslation('Serie');?></td>
                <td class="text-center"><?php echo $_translator->_getTranslation('Folio');?></td>
                <td class="text-center"><?php echo $_translator->_getTranslation('Ticket');?></td>
                <td class="text-center"><?php echo $_translator->_getTranslation('Fecha');?></td>
                <td class="text-center"><?php echo $_translator->_getTranslation('Cliente');?></td>                
                <td class="text-center"><?php echo $_translator->_getTranslation('RFC');?></td>                
                <td class="text-right"><?php echo $_translator->_getTranslation('Subtotal');?></td>                
                <td class="text-right"><?php echo $_translator->_getTranslation('IEPS');?></td>                
                <td class="text-right"><?php echo $_translator->_getTranslation('IVA');?></td>
                <td class="text-right"><?php echo $_translator->_getTranslation('Total');?></td>
                <td class="text-right"><?php echo $_translator->_getTranslation('Sucursal');?></td>
                <td class="text-center"><?php echo $_translator->_getTranslation('Status');?></td>
            </tr>
            </thead>
            <tbody>
            <?php
                foreach ($data as $row) {
                    $cliente = unserialize(utf8_decode($row['datos_receptor']));
                    if (isset($cliente['Receptor']['nombre'])) {
                        $cliente['Receptor']['Nombre'] = $cliente['Receptor']['nombre'];
                    }
                    if (isset($cliente['Receptor']['rfc'])) {
                        $cliente['Receptor']['Rfc'] = $cliente['Receptor']['rfc'];
                    }
                    
                    /* PARA PCG */
                    
                    $impuestos = unserialize(utf8_decode($row['detalles_impuestos_aplicables']));
                    $ieps = 0;
                    $iva = 0;
                   
                    if ($row['version_cfdi'] == '3.3') {
                        if (isset($impuestos['Trasladable']['2'])) {
                            $ieps = $impuestos['Trasladable']['2']['Importe'];
                        }
                        if (isset($impuestos['Trasladable']['1'])) {
                            $iva = $impuestos['Trasladable']['1']['Importe'];
                        }
                    } elseif ($row['version_cfdi'] == '3.2') {
                        if (isset($impuestos['Trasladable']['2'])) {
                            $ieps = $impuestos['Trasladable']['2']['monto'];
                        }
                        if (isset($impuestos['Trasladable']['1'])) {
                            $iva = $impuestos['Trasladable']['1']['monto'];
                        }
                    } ?>              
                    <tr>
                        <td class="text-center"><?php echo $row['serie']; ?></td>
                        <td class="text-center"><?php echo $row['folio']; ?></td>
                        <td class="text-center"><?php echo $row['ticket']; ?></td>
                        <!--<td class="text-center"><?php echo $row['uuid']; ?></td>-->
                        <td class="text-center"><?php echo $row['fecha_timbrado_solo_fecha']; ?></td>                  
                        <td class="text-center"><?php echo htmlentities($cliente['Receptor']['Nombre']); ?></td>                                                
                        <td class="text-center"><?php echo $cliente['Receptor']['Rfc']; ?></td>
                        <td class="text-right"><?php echo number_format($row['subtotal'], 2); ?></td>
                        <td class="text-right"><?php echo number_format($ieps, 2); ?></td>
                        <td class="text-right"><?php echo number_format($iva, 2); ?></td>
                        <td class="text-right"><?php echo number_format($row['total'], 2); ?></td>
                        <td class="text-center"><?php echo $row['sucursalName']; ?></td>
                        <td class="text-center"><?php echo $row['statusName']; ?></td>
                    </tr><?php
                }?>
            </tbody>
            </table>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript" language="javascript">
    $('#tblReport').DataTable( {paginate:false,filter:true,fixedHeader: true,aaSorting:[]});
    $('#tblReport')
        .removeClass( 'display' )
        .addClass('table table-striped table-bordered');
</script>