<?php
        $estadoDeCuenta = $data['data'];

        $options = $this->getOptions();
        $pdf = new PDF('P', 'mm', 'LETTER');
        $pdf->AddPage('', '');
        // Go to 1.5 cm from bottom
        // Select Arial italic 8
        $pdf->SetFont('Arial', '', '10');
        // Print centered page number

        $pdf->Text(95, 270, "Pagina " . $pdf->PageNo() . " de {nb}");


        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        $pic = 'data://text/plain;base64,' . base64_encode($empresa->getLogo());
        // extract dimensions from image $info = getimagesize($pic);
        $image_type = explode("/", $empresa->getImageType());
        $pdf->Image($pic, 20, 5, 35, 30, $image_type[1]);

        $pdf->SetFont('Arial', '', '12');
        $pdf->SetTextColor(0);
        $pdf->Cell(80, 7, "", '', 0, 'C'); //<== margin left
        $pdf->Cell(110, 10, $empresa->getNombre(), '0', 1, 'R');

        $pdf->SetY(30);
        $pdf->SetFont('Arial', '', '12');
        $pdf->SetTextColor(255);
        $pdf->SetFillColor(51, 153, 255);
        $pdf->SetX(0);

        // $pdf->Cell(80,10, "Estado de cuenta de cliente", '0', 0, 'R',true);
        $pdf->Cell(80, 7, '', '', 0);

        $pdf->SetY(45);
        $pdf->SetFont('Arial', 'B', '10');
        $pdf->SetTextColor(0);

        $inicio =  "Del". ($options['fechaInicio'] != null ? $options['fechaInicio'] : " inicio de los tiempos");
        $fin = ($options['fechaFin'] != null ? $options['fechaFin'] : date('m/d/Y'));
        $pdf->setY(25);

        $pdf->setX(140);
        $pdf->cell(100, 7, $inicio. " al ".$fin, 0, 1, 'L');
        $pdf->setX(140);
        $pdf->cell(100, 7, "Creado el: " .date('m/d/Y'), 0, 1, 'L');

        $pagosRecibidos = 0;
        $totalFacturado = 0;

        $pdf->setY(50);
        $saldoInicialVal = 0;
        $trackingY = 0;
        foreach ($estadoDeCuenta as $idCliente => $info) {
            $saldoInicialVal += $info['saldoInicial'];

            $datosCliente = $info['datosCliente'];
            $saldoPendienteTotalPorCliente = 0;
            $totalFacturado = 0;
            $pagosRecibidos = 0;

            $pdf->SetFont('Arial', 'B', '8');

            $pdf->cell(100, 4, "CLIENTE: " .$datosCliente['nombre'], 0, 1, 'L');
            $pdf->cell(100, 4, "RFC: " .$datosCliente['rfc'], 0, 1, 'L');
            // $pdf->cell(100, 4,"TELEFONO: " .$datosCliente['telefono'], 0,1, 'L');
            // $pdf->cell(100, 4,"CORREO: " .$datosCliente['email'], 0,1, 'L');
            //  $datosCliente['nombre'];

            $pdf->SetFont('Arial', 'B', '10');
            $pdf->Cell(15, 5, "Fecha", 'B', 0, 'C');
            $pdf->Cell(15, 5, "Serie", 'B', 0, 'C');
            $pdf->Cell(15, 5, "Folio", 'B', 0, 'C');
            $pdf->Cell(25, 5, "Comprobante", 'B', 0, 'C');
            $pdf->Cell(30, 5, "Importe", 'B', 0, 'R');
            $pdf->Cell(30, 5, "Saldo", 'B', 0, 'R');
            $pdf->Cell(15, 5, "TC", 'B', 0, 'C');
            $pdf->Cell(20, 5, "Estado", 'B', 0, 'C');
            $pdf->Cell(30, 5, "Saldo", 'B', 1, 'R');
            $pdf->Ln(1);

            $pdf->SetFont('Arial', '', '8');
            $pdf->Cell(130, 5, "", '0', 0, 'R');
            $pdf->Cell(35, 5, "Saldo Inicial", '1', 0, 'R');
            $pdf->Cell(30, 5, '$'.number_format($saldoInicialVal, 2), '1', 1, 'R');

            foreach ($info['facturas'] as $factura) {
                $pdf->SetFillColor(241, 241, 241);
                $totalFacturado += $factura['total'];

                $saldoPendiente = $factura['total'];
                $saldoPendienteTotalPorCliente +=  $factura['saldo_pendiente'];

                $pdf->Cell(15, 5, $factura['fecha'], '0', 0, 'C', true);
                $pdf->Cell(15, 5, $factura['serie'], '0', 0, 'C', true);
                $pdf->Cell(15, 5, htmlentities($factura['folio']), '0', 0, 'C', true);
                $pdf->Cell(25, 5, 'CFDI', '0', 0, 'C', true);
                $pdf->Cell(30, 5, '$'.number_format($factura['total'], 2), '0', 0, 'R', true);
                $pdf->Cell(30, 5, '$'.number_format($factura['total'], 2), '0', 0, 'R', true);
                $pdf->Cell(15, 5, number_format($factura['tipo_de_cambio'], 2), '0', 0, 'C', true);
                $pdf->Cell(20, 5, $factura['statusName'], '0', 0, 'C', true);
                $pdf->Cell(30, 5, '$'.number_format($factura['saldo_pendiente'], 2), '0', 1, 'R', true);

                #Si no existen pagos no se recoree array
                if (isset($factura['pagos']) && $factura['pagos'] != '' && $factura['pagos'] != null) {
                    $pagos = $factura['pagos'];

                    foreach ($pagos as $pago) {

                        $comprobante = "Pago";
                        if ($pago['status'] != '1') {
                            $comprobante= "CFDI Pago";
                        }

                        $monto = $pago['monto'];
                        if ($pago['status']!='3') {
                            $saldoPendiente -=  $monto;
                        }

                        $pdf->Cell(15, 5, $pago['fecha'], '0', 0, 'C');
                        $pdf->Cell(15, 5, $pago['serie'], '0', 0, 'C');
                        $pdf->Cell(15, 5, htmlentities($pago['folio']), '0', 0, 'C');
                        //comprobante
                        $pdf->Cell(25, 5, htmlentities($comprobante), '0', 0, 'C');
                        //importe
                        $pdf->Cell(30, 5, '$' . number_format($pago['monto'], 2), '0', 0, 'R');
                        //saldo resto de deuda
                        $pdf->Cell(30, 5, '$' .number_format($saldoPendiente, 2), '0', 0, 'R');
                        //tipoDeCambio ?????
                        $pdf->Cell(15, 5, number_format($pago['tipo_de_cambio'], 2), '0', 0, 'C');
                        //estado de doc
                        $pdf->Cell(20, 5, $pago['statusName'], '0', 0, 'C');
                        //saldopendiente
                        $pdf->Cell(30, 5, '', 0, 1, 'R');
                        $pagosRecibidos += $monto;

                        if ($trackingY > $pdf->GetY()) {
                            $pdf->SetFont('Arial', '', '10');
                            $pdf->Text(95, 270, "Pagina " . $pdf->PageNo() . " de {nb}");
                            $pdf->SetFont('Arial', '', '8');
                        }
                        $trackingY = $pdf->GetY();
                    }
                    $pdf->Ln(5);
                }
            }
            $pdf->Ln(1);
            $pdf->Cell(100, 5, '$'.number_format($pagosRecibidos, 2), '1', 0, 'R');
            $pdf->Cell(30, 5, '$'.number_format($totalFacturado, 2), '1', 0, 'R');
            $pdf->Cell(35, 5, "Saldo Total Pendiente", '1', 0, 'R');
            $pdf->Cell(30, 5, '$'.number_format($saldoPendienteTotalPorCliente + $saldoInicialVal, 2), '1', 1, 'R');
            $pdf->Ln(5);
        }


        $pdf->AliasNbPages();

        if ($this->saveFile == true) {
            $pdf->Output($this->getTempFolder()."/".$this->getNombreArchivo().".pdf", "F");
        } else {
            $pdf->Output();
        }
