<?php

$printableFields = [
    'serie' => 'Serie',
    'folio' => 'Folio',
    'fecha_timbrado' => 'Fecha',
    'nombre_cliente' => 'Cliente',
    // 'ieps' => 'IEPS'
];

$pdf = new PDF();
$pdf->AddPage('L', '');
$pdf->SetFont('Arial', 'B', '8');

$pdf->SetFont('Arial', 'B', '24');
$pdf->SetXY(150,5);
$pdf->MultiCell(150,30,'$ '.$data['ventasMonto']);
$pdf->SetFont('Arial', 'B', '8');
$pdf->SetXY(150,12);
$pdf->MultiCell(150,30,'Monto de facturacion');

$pdf->SetFont('Arial', 'B', '24');
$pdf->SetXY(220,5);
$pdf->MultiCell(150,30,$data['ventasGeneradas']);
$pdf->SetFont('Arial', 'B', '8');
$pdf->SetXY(220,12);
$pdf->MultiCell(150,30,'Facturas Generadas');

$pdf->SetY(45);
$pdf->Cell(10, 7, "Serie", 'B', 0, 'C');
$pdf->Cell(10, 7, "Folio", 'B', 0, 'C');
$pdf->Cell(20, 7, "Fecha", 'B', 0, 'C');
$pdf->Cell(60, 7, "Cliente", 'B', 0, 'C');
$pdf->Cell(20, 7, "IEPS", 'B', 0, 'C');
$pdf->Cell(30, 7, "Total", 'B', 0, 'C');
$pdf->Cell(30, 7, "Saldo Pendiente", 'B', 0, 'C');
$pdf->Cell(60, 7, "Sucursal", 'B', 0, 'C');
$pdf->Cell(30, 7, "Estado", 'B', 0, 'C');
$pdf->Ln(7);

$rows = $data['data'];

foreach ($rows as $row) {
    $cliente = unserialize(utf8_decode($row['datos_receptor']));
    if (isset($cliente['Receptor']['nombre'])) {
        $cliente['Receptor']['Nombre'] = $cliente['Receptor']['nombre'];
    }
    if (isset($cliente['Receptor']['rfc'])) {
        $cliente['Receptor']['Rfc'] = $cliente['Receptor']['rfc'];
    }

    $impuestos = unserialize(utf8_decode($row['detalles_impuestos_aplicables']));
    $ieps = 0;
    $iva = 0;
    if ('3.3' == $row['version_cfdi']) {
        if (isset($impuestos['Trasladable']['2'])) {
            $ieps = $impuestos['Trasladable']['2']['Importe'];
        }
        if (isset($impuestos['Trasladable']['1'])) {
            $iva = $impuestos['Trasladable']['1']['Importe'];
        }
    } elseif ('3.2' == $row['version_cfdi']) {
        if (isset($impuestos['Trasladable']['2'])) {
            $ieps = $impuestos['Trasladable']['2']['monto'];
        }
        if (isset($impuestos['Trasladable']['1'])) {
            $iva = $impuestos['Trasladable']['1']['monto'];
        }
    }

    $pdf->Cell(10, 7, $row['serie'], 0, 0, 'C');
    $pdf->Cell(10, 7, $row['folio'], 0, 0, 'C');
    $pdf->Cell(20, 7, $row['fecha_timbrado_solo_fecha'], 0, 0, 'C');
    $pdf->Cell(60, 7, $cliente['Receptor']['Nombre'], 0, 0, 'C');
    $pdf->Cell(20, 7, "$ " . number_format($ieps, 2), 0, 0, 'C');
    $pdf->Cell(30, 7, "$ " . number_format($row['total'], 2), 0, 0, 'C');
    $pdf->Cell(30, 7, "$ " . number_format($row['saldo_pendiente'], 2), 0, 0, 'C');
    $pdf->Cell(60, 7, $row['sucursalName'], 0, 0, 'C');
    $pdf->Cell(30, 7, $row['statusName'], 0, 0, 'C');
    $pdf->Ln(7);
}





$pdf->Output();
