<?php
        $facturas_detalles = $data['data'];
        $options = $this->getOptions();
            $pdf = new PDF();
            $pdf->AddPage('L', '');

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        $pic = 'data://text/plain;base64,' . base64_encode($empresa->getLogo());
        // extract dimensions from image $info = getimagesize($pic);
        $image_type = explode("/", $empresa->getImageType());
        //$pdf->Image($pic, 20, 5, 35, 30, $image_type[1]);

        $pdf->SetFont('Arial', '', '12');
        $pdf->SetTextColor(0);
        $pdf->Cell(80, 7, "", '', 0, 'C'); //<== margin left
        $pdf->Cell(110, 5, $empresa->getNombre(), '0', 1, 'C');

        $pdf->Cell(80, 7, "", '', 0, 'C'); //<== margin left
        $pdf->Cell(110, 5, "Facturacion detallado por cliente", '0', 1, 'C');


        /*$pdf->SetY(42);
        $pdf->SetFont('Arial','','10');
        $pdf->SetTextColor(0); */

        $inicio =  "Del". ($options['fechaInicio'] != null ? $options['fechaInicio'] : " inicio de los tiempos");
        $fin = ($options['fechaFin'] != null ? $options['fechaFin'] : date('m/d/Y'));
        $pdf->Cell(80, 7, "", '', 0, 'C'); //<== margin left
        $pdf->cell(110, 5, $inicio. " al ".$fin, 0, 1, 'C');
        $pdf->Cell(80, 7, "", '', 0, 'C'); //<== margin left
        $pdf->cell(110, 5, "Creado el: " .date('m/d/Y'), 0, 1, 'C');

        $pdf->SetY(40);
        $pdf->SetFont('Arial', '', '6');
        $pdf->SetTextColor(0);

        $diferentesImpuestosAplicadosTotal = array();
        $diferentesImpuestosAplicadosTotalGeneral = array();
        if (count($data['diferentesImpuestosAplicados']) > 0) {
            foreach ($data['diferentesImpuestosAplicados'] as $nombre => $value) {
                $diferentesImpuestosAplicadosTotal[$nombre] = 0;
                $diferentesImpuestosAplicadosTotalGeneral[$nombre] = 0;
            }
        }

        $totalGeneralCantidad = 0;
        $totalGeneralImporte = 0;
        $totalGeneralDescuento = 0;
        $totalGeneralImpuesto = 0;
        $totalGeneralTotal = 0;
        $totalImpuestoDetalle2 = 0;

        foreach ($facturas_detalles as $idCliente => $info) {
            $totalCantidad = 0;
            $totalImporte = 0;
            $totalDescuento = 0;
            $totalImpuesto = 0;
            $totalTotal = 0;

            foreach ($diferentesImpuestosAplicadosTotal as $nombre => $value) {
                $diferentesImpuestosAplicadosTotal[$nombre] = 0;
            }

            $datosCliente = $info['datosCliente'];
            $pdf->SetFont('Arial', 'B', '8');
            $pdf->Cell(20, 5, "Factura", 'B', 0, 'C');
            $pdf->Cell(25, 5, "Fecha", 'B', 0, 'C');
            $pdf->Cell(15, 5, "Codigo", 'B', 0, 'C');
            $pdf->Cell(50, 5, "Nombre(Producto,Servicio,Paquete)", 'B', 0, 'C');
            $pdf->Cell(20, 5, "Cantidad", 'B', 0, 'C');
            $pdf->Cell(20, 5, "Unidad", 'B', 0, 'C');
            $pdf->Cell(20, 5, "Importe", 'B', 0, 'R');
            $pdf->Cell(20, 5, "Descuento", 'B', 0, 'R');

            # Creamos columna dependiendo el nombre del impuesto
            if (!is_null($data['diferentesImpuestosAplicados'])) {
                if (count($data['diferentesImpuestosAplicados']) > 0) {
                    foreach ($data['diferentesImpuestosAplicados'] as $impuestosNombre => $nombre) {
                        $pdf->Cell(20, 5, $nombre, 'B', 0, 'C');
                    }
                }
            }

            $pdf->Cell(20, 5, "Total", 'B', 1, 'R');
            $pdf->Ln(1);
            $saldoPendienteTotalPorCliente = 0;
            $pdf->SetFont('Arial', 'B', '8');
            $pdf->cell(100, 4, "CLIENTE:      " .$datosCliente['nombre'], 0, 1, 'L');

            $pdf->SetFont('Arial', '', '8');

            foreach ($info['facturas'] as $factura) {
                # SACAR IMPORTE DE CADA
                $impuestos_aplicables = unserialize($factura['impuestos_aplicables']);

                # TOTAL CANTIDAD FACTURA
                $totalCantidad += $factura['cantidad'];
                # TOTAL IMPORTE FACTURA
                $totalImporte += $factura['importe'];
                # TOTAL DESCUENTO FACTURA
                $totalDescuento += $factura['descuento_monto'];
                # TOTAL IMPUESTO FACTURA
                $totalImpuestoDetalle = 0;
                # TOTAL DE FACTURA
                $totalFactura = 0;




                $pdf->SetFillColor(241, 241, 241);
                $saldoPendiente = $factura['total'];
                $pdf->Cell(20, 5, $factura['serie'].$factura['folio'], '0', 0, 'C', true);
                $pdf->Cell(25, 5, $factura['creado_fecha2'], '0', 0, 'C', true);
                $pdf->Cell(15, 5, $factura['codigo'], '0', 0, 'C', true);
                $pdf->Cell(50, 5, $factura['nombreProducto'], '0', 0, 'C', true);
                $pdf->Cell(20, 5, $factura['cantidad'], '0', 0, 'R', true);
                $pdf->Cell(20, 5, $factura['unidadMedida'], '0', 0, 'C', true);
                $pdf->Cell(20, 5, '$'.number_format($factura['importe'], 2), '0', 0, 'R', true);
                $pdf->Cell(20, 5, '$'.number_format($factura['descuento_monto'], 2), '0', 0, 'R', true);

                # Asignamos el valor del impuesto y mas
                foreach ($data['diferentesImpuestosAplicados'] as $nombre => $value) {
                    if (key_exists($nombre, $factura['impuestos'])) {
                        $diferentesImpuestosAplicadosTotal[$nombre] += $factura['impuestos'][$nombre];
                        $diferentesImpuestosAplicadosTotalGeneral[$nombre] += $factura['impuestos'][$nombre];

                        # x Detalle
                        $totalImpuestoDetalle += $factura['impuestos'][$nombre];

                        # x Factura
                        $totalImpuesto += $totalImpuestoDetalle ;

                        $totalTotal += $factura['importe'] + $totalImpuestoDetalle;

                        $pdf->Cell(20, 5, "$".number_format($totalImpuestoDetalle, 2), '0', 0, 'R', true);
                    } else {
                        $pdf->Cell(20, 5, "", '0', 0, 'R', true);
                    }
                }

                $pdf->Cell(20, 5, '$'. number_format($factura['importe'] + $totalImpuestoDetalle, 2), '0', 1, 'R', true);
            }

            # Totales de todas las facturas
            $totalGeneralCantidad += $totalCantidad;
            $totalGeneralImporte += $totalImporte;
            $totalGeneralDescuento += $totalDescuento;
            $totalGeneralTotal += $totalTotal ;

            # Totales x Factura
            $pdf->Ln(1);
            $pdf->Cell(110, 5, "Total Cliente: ", 0, 0, 'R');
            $pdf->Cell(20, 5, $totalCantidad, "T", 0, 'R');
            $pdf->Cell(40, 5, "$".number_format($totalImporte, 2), 'T', 0, 'R');
            $pdf->Cell(20, 5, "$".number_format($totalDescuento, 2), 'T', 0, 'R');
            foreach ($diferentesImpuestosAplicadosTotal as $nombre => $value) {
                $pdf->Cell(20, 5, "$".number_format($value, 2), 'T', 0, 'R');
            }

            $pdf->Cell(20, 5, "$".number_format($totalTotal, 2), 'T', 0, 'R');
            $pdf->Ln(8);
        }


        # Totales generales
        $pdf->Ln(5);
        $pdf->Cell(110, 5, "Total General: ", 0, 0, 'R');
        $pdf->Cell(20, 5, $totalGeneralCantidad, "T", 0, 'R');
        $pdf->Cell(40, 5, "$".number_format($totalGeneralImporte, 2), "T", 0, 'R');
        $pdf->Cell(20, 5, "$".number_format($totalGeneralDescuento, 2), "T", 0, 'R');
        foreach ($diferentesImpuestosAplicadosTotalGeneral as $nombre => $value) {
            $pdf->Cell(20, 5, "$".number_format($value, 2), 'T', 0, 'R');
        }
        $pdf->Cell(20, 5, "$".number_format($totalGeneralTotal, 2), "T", 0, 'R');


        if ($this->saveFile == true) {
            $pdf->Output($this->getTempFolder()."/".$this->getNombreArchivo().".pdf", "F");
        } else {
            $pdf->Output();
        }
