<?php
$facturaObj = new FacturaRepository();
$facturaObj->setOptions($factura->getById($_GET['id']));
$facturaObj->setId($_GET['id']);

$cliente = new ClienteRepository();
$cliente->setOptions($cliente->getById($facturaObj->getIdCliente()));

$empresa = new EmpresaRepository();
$empresa->setOptions($empresa->getById(1));

$sucursal = new SucursalRepository();
$sucursal->setOptions($sucursal->getById($facturaObj->getSucursal()));
?>
<html lang="en">
<style>
    table {
        border: 1px solid black;
        width: 100%;
    }

    td {
        border: 1px solid black;
        border-collapse: collapse;
    }

    img.logo {
        max-width: 190px;
    }

    .datos-fiscales div,
    .datos-fiscales h4 {
        text-align: right;
    }
</style>

<body>
    <table>
        <tr>
            <td style="width: 50%;">
                <img class="logo" src="data:image/jpeg;base64,<?php echo base64_encode($sucursal->getLogo()) ?>" alt="">
            </td>
            <td style="width: 50%;">
                <div class="datos-fiscales" style="vertical-align: top;">
                    <h4 class="nombre-empresa"><?php echo $empresa->getNombre(); ?></h4>
                    <div class="rfc"><?php echo $empresa->getRFC(); ?></div>
                    <div class="regimen-fiscal"><span class="numero"><?php echo $empresa->getRegimenFiscal(); ?></span> - <span class="nombre"><?php echo $empresa->getRegimenFiscalNombre(); ?></span></div>
                    <div class="calle-numero"><?php echo $empresa->getCalleNum(); ?></div>
                    <div class="colonia"><span class="colonia"><?php echo $empresa->getColonia(); ?></span> <span class="codigo-postal"><?php echo $empresa->getCodigoPostal(); ?></span></div>
                </div>
            </td>
        </tr>
        <tr>
            <td style="height: 10px">
                <h3 style="padding: 20px; width: 100px; text-align:left; background: steelblue">FACTURA <?php echo $facturaObj->getSerie() ?><?php echo $facturaObj->getFolio() ?></h3>
            </td>
            <td></td>
        </tr>
    </table>
</body>

</html>