<?php
$login = new Login();


if (!isset($_SESSION['picture_logo'])) {
  $empresa = new EmpresaRepository();
  $empresa->setOptions($empresa->getById(1));
  $logo = $empresa->getLogo();

  if(is_null($logo)) {
    $logo = file_get_contents(dirname(__FILE__) . "/../../app/resources/docs/1.png");
  }

  $pic = 'data:image/jpg;base64,' . base64_encode($logo);
  $_SESSION['picture_logo'] = $pic;
} else {
  $pic = $_SESSION['picture_logo'];
}
?>
<header class="main-header">
    <!-- Logo -->
    <a href="Home.php" class="logo">
      <!-- mini logo for sidebar mini 50x50 pixels -->
      <span class="logo-mini"><b>S</b>PR</span>
      <!-- logo for regular state and mobile devices -->
      <span class="logo-lg"><b>Lunis</b>CFDI</span>
    </a>
    <!-- Header Navbar: style can be found in header.less -->
    <nav class="navbar navbar-static-top">
      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">Toggle navigation</span>
      </a>

      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
        <!-- Messages: style can be found in dropdown.less-->
            <li class="dropdown messages-menu">
                <a href="#" class="_relojChecador" data-target="#modalGadgetTimeClock" data-toggle="modal"><i class="fa fa-clock-o"></i> </a>
            </li>
            <li class="dropdown notifications-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
                    <i class="fa fa-flag"></i>
                </a>
                <ul class="dropdown-menu" style='width: 160px'>
                  <li class="header text-center"><?php echo $_translator->_getTranslation('Idiomas');?></li>
                  <li>
                    <ul class="menu">
                      <li>
                        <a href="#" class="_language" data-language='_es'>
                          <i class="fa fa-flag"></i><?php echo $_translator->_getTranslation('Español');?>
                        </a>
                      </li>
                      <li>
                        <a href="#" class="_language" data-language='_en'>
                          <i class="fa fa-flag"></i><?php echo $_translator->_getTranslation('Ingles');?>
                        </a>
                      </li>
                    </ul>
                  </li>
                </ul>
              </li>
          </li>
            <!-- User Account: style can be found in dropdown.less -->
            <li class="dropdown user user-menu">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                <img src="<?php echo $pic?>" class="user-image" alt="User Image">
                <span class="hidden-xs"><?php echo $login->getNombreCompleto() ?></span>
              </a>
              <ul class="dropdown-menu">
                <!-- User image -->
                <li class="user-header">
                  <img src="<?php echo $pic ?>" class="img-circle" alt="User Image">
                  <p><?php echo $login->getNombreCompleto(); ?></p>
                </li>
                <!-- Menu Footer-->
                <li class="user-footer">
                  <div class="pull-left">
                    <a href="#" class="btn btn-default btn-flat"><?php echo $_translator->_getTranslation('Perfil'); ?></a>
                  </div>
                  <div class="pull-right">
                    <a href="<?php echo ROOT_HOST;?>/class/Login/Logout.php" class="btn btn-default btn-flat"><?php echo $_translator->_getTranslation('Salir'); ?></a>
                  </div>
                </li>
              </ul>
            </li>

            <!-- Control Sidebar Toggle Button -->
             <!--
            <li>
              <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
            </li>-->
        </ul>
      </div>
    </nav>
  </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
      <div class="user-panel">
        <div class="pull-left image">
          <img src="<?php echo $pic ?>" class="img-circle" alt="User Image">
        </div>
        <div class="pull-left info">
            <p><?php echo $login->getNombreCompleto() ?></p>
          <a href="#"><i class="fa fa-circle text-success"></i> Online</a>
        </div>
      </div>
      <!-- sidebar menu: : style can be found in sidebar.less -->
      <ul class="sidebar-menu" data-widget="tree">
        <li class="header text-uppercase"><?php echo $_translator->_getTranslation('Navegacion'); ?></li>
        <li><a href="Inicio.php"><i class="fa fa-dashboard"></i> <span><?php echo $_translator->_getTranslation('Inicio') ?></span></a></li>
        <!-- FACTURAS -->
        <li class="treeview">
          <a href="#">
            <i class="fa fa-file-text"></i> <span><?php echo $_translator->_getTranslation('Facturas') ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <li><a href="Factura.php"><i class="fa fa-circle-o text-primary"></i> <span><?php echo $_translator->_getTranslation('Crear nueva') ?></span></a></li>
            <li><a class="active" href="Factura.php?action=list"><i class="fa fa-circle-o text-primary"></i> <span><?php echo $_translator->_getTranslation('Lista de facturas') ?></span></a></li>
          </ul>
        </li>
        <!-- /FACTURAS -->

        <!-- NOTAS DE CREDITO -->
        <li class="treeview">
          <a href="#">
            <i class="fa fa-file-text"></i> <span><?php echo $_translator->_getTranslation('Notas de credito') ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <li><a href="NotaCredito.php"><i class="fa fa-circle-o text-primary"></i> <span><?php echo $_translator->_getTranslation('Agregar nueva') ?></span></a></li>
            <li><a href="NotaCredito.php?action=list"><i class="fa fa-circle-o text-primary"></i> <span><?php echo $_translator->_getTranslation('Lista notas de credito') ?></span></a></li>
          </ul>
        </li>
        <!-- /NOTAS DE CREDITO -->

        <!-- RECIBOS DE PAGO -->
        <li class="treeview">
          <a href="#">
            <i class="fa fa-dollar"></i> <span><?php echo $_translator->_getTranslation('Recibos de pago') ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <li><a href="Pago.php"><i class="fa fa-circle-o text-primary"></i> <span><?php echo $_translator->_getTranslation('Crear nuevo') ?></span></a></li>
            <li><a href="Pago.php?action=list"><i class="fa fa-circle-o text-primary"></i> <span><?php echo $_translator->_getTranslation('Lista de pagos') ?></span></a></li>
          </ul>
        </li>
        <!-- /RECIBOS DE PAGO -->

        <!-- CLIENTES -->
        <li><a href="Cliente.php"><i class="fa fa-users"></i> <span><?php echo $_translator->_getTranslation('Clientes') ?></span></a></li>
        <!-- /CLIENTES -->

        <!-- PRODUCTOS-SERVICIOS -->
        <li><a href="Producto.php"><i class="fa fa-database"></i> <span><?php echo $_translator->_getTranslation('Productos/Servicios') ?></span></a></li>
        <!-- /PRODUCTOS-SERVICIOS -->

        <!-- REPORTES -->
        <li><a href="Reportes.php"><i class="fa fa-pie-chart"></i> <span><?php echo $_translator->_getTranslation('Reportes') ?></span></a></li>
        <!-- /REPORTES -->

        <!-- CATALOGO -->
        <li class="treeview">
          <a href="#">
            <i class="fa fa-list"></i><span><?php echo $_translator->_getTranslation('Catalogos') ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
              <!-- CUENTAAS BANCARIAS -->
                <li><a href="CuentaBancaria.php"><i class="fa fa-circle-o text-primary"></i> <span><?php echo $_translator->_getTranslation('Cuentas Bancarias') ?></span></a></li>
                <!-- /CUENTAAS BANCARIAS -->
            <li><a href="PaymentTerm.php"><i class="fa fa-circle-o text-primary"></i> <span><?php echo $_translator->_getTranslation('Terminos de pago') ?></span></a></li>
          </ul>
        </li>
        <!-- /CATALOGO -->

        <!-- CONFIGURACION -->
        <li class="treeview">
          <a href="#">
            <i class="fa fa-gears"></i><span><?php echo $_translator->_getTranslation('Configuracion') ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <!-- EMPRESA -->
            <li><a href="Empresa.php"><i class="fa fa-university"></i> <span><?php echo $_translator->_getTranslation('Empresa') ?></span></a></li>
            <!-- /EMPRESA -->

            <!-- SUCURSALES -->
            <li><a href="Sucursal.php"><i class="fa fa-bookmark"></i> <span><?php echo $_translator->_getTranslation('Sucursales') ?></span></a></li>
            <!-- /SUCURSALES -->

            <!-- USUARIOS -->
            <li><a href="Usuario.php"><i class="fa fa-user"></i> <span><?php echo $_translator->_getTranslation('Usuarios') ?></span></a></li>
            <!-- /USUARIOS -->
          </ul>
        </li>
        <!-- CONFIGURACION -->
        <!-- AYUDA -->
        <li><a href="http://ayudacfdi.lunis.mx/" target="_blank"><i class="fa fa-question-circle"></i> <span><?php echo $_translator->_getTranslation('Ayuda') ?></span></a></li>
        <!-- /AYUDA -->

      </ul>
    </section>
    <!-- /.sidebar -->
  </aside>