<?php
/**
 * Description of crear_xml_factura
 *
 * @author carlos
 */
class crear_xml_factura {    
    private $archivosSAT = null;    
    private $datosComprobante = array();    
    private $datosCFDIRelacionados = array();
    private $datosEmisor = array();   
    private $datosReceptor = array();
    private $datosConceptos = array();     
    private $datosImpuestos = array();   
    
    public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
    }
  
    public function getOptions(){
        return $this->options;
    }
    
    public function setDatosComprobante(array $datosComprobante){
        $this->datosComprobante = $datosComprobante;
    }
    
    public function setDatosCFDIRelacionados(array $datosCFDIRelacionados){
        $this->datosCFDIRelacionados = $datosCFDIRelacionados;
    }
    
    public function setDatosEmisor(array $datosEmisor){
        $this->datosEmisor = $datosEmisor;
    }
    
    public function setDatosReceptor(array $datosReceptor){
        $this->datosReceptor = $datosReceptor;
    }
    
    public function setDatosConceptos(array $datosConceptos){
        $this->datosConceptos = $datosConceptos;
    }
    
    public function setArchivosSAT($archivosSAT){
        $this->archivosSAT = $archivosSAT;
    }
    
     public function setDatosImpuestos(array $datosImpuestos){
        $this->datosImpuestos = $datosImpuestos;
    }    
    
    private function getStringTagComprobante(){
        #cfdi:Comprobante
        $stringComprobante = '<cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd"'."\r\n";

        foreach ($this->datosComprobante as $key => $value){
            if(trim($value) != ''){
                $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
                $stringComprobante .= $key.'="'.trim($value).'" ';
            }
        }
        
        $stringComprobante = trim($stringComprobante);
        $stringComprobante .= ">\r\n";
       
        return $stringComprobante;
    }
    
    private function getStringTagCfdiRelacionados(){
        #cfdi:CFDIs Relacionados      
        if($this->datosCFDIRelacionados['CFDIRelacionados'] != null){
            $stringCFDIsRelacionados = '<cfdi:CfdiRelacionados TipoRelacion="'.$this->datosCFDIRelacionados['TipoRelacion'].'" >';
            foreach($this->datosCFDIRelacionados['CFDIRelacionados'] as $key => $value){
                $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
                 $stringCFDIsRelacionados .= "\r\n".'<cfdi:CfdiRelacionado UUID="'.trim($value).'" />';
            }        

            $stringCFDIsRelacionados .= "\r\n</cfdi:CfdiRelacionados>";                

            return $stringCFDIsRelacionados;
        }        
    }
    
     private function getStringTagEmisor(){
        #cfdi:Emisor      
        $stringEmisor = "<cfdi:Emisor ";
        foreach($this->datosEmisor['Emisor'] as $key => $value){
            $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
            $stringEmisor .= $key.'="'.trim($value).'" ';
        }        
        $stringEmisor = trim($stringEmisor);
        $stringEmisor .= "/>\r\n";                
        
        return $stringEmisor;
    }
    
    private function getStringTagReceptor(){
        #cfdi:Receptor         
        $stringReceptor = "<cfdi:Receptor ";
        foreach($this->datosReceptor['Receptor'] as $key => $value){
            $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
            $stringReceptor .= $key.'="'.trim($value).'" ';
        }        
        $stringReceptor = trim($stringReceptor);
        $stringReceptor .= "/>\r\n";        
        
        return $stringReceptor;
    }
    
    private function getStringTagConceptos(){
        #cfdi:Conceptos  
        $stringConceptos = "<cfdi:Conceptos>\r\n";
        foreach($this->datosConceptos as $concepto){
            $stringConceptos .= "<cfdi:Concepto ";
            
            foreach($concepto as $key => $value){
                if($key !== 'ImpuestosAplicables' && trim($value) != ''){
                    $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
                    $stringConceptos .= $key.'="'.trim($value).'" ';
                }elseif($key === 'ImpuestosAplicables' && $value !== null && (is_array($value['Trasladable']) || is_array($value['Retenible']))){
                    $stringConceptos .= "><cfdi:Impuestos>";
                    $impuestos = $value;
                    if(key_exists('Trasladable', $impuestos) && is_array($impuestos['Trasladable']) && count($impuestos['Trasladable']) >0){
                        $stringConceptos .= "<cfdi:Traslados>";
                        foreach($impuestos['Trasladable'] as $impuesto){                             
                            $stringConceptos .= "<cfdi:Traslado ";
                            foreach($impuesto as $key => $value){
                                $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
                                $stringConceptos .= $key.'="'.trim($value).'" ';
                            }  
                            $stringConceptos = trim($stringConceptos);
                            $stringConceptos .= "/>\r\n";
                        }
                        $stringConceptos .= "</cfdi:Traslados>\r\n";
                    }
                    if(key_exists('Retenible', $impuestos) && is_array($impuestos['Retenible']) && count($impuestos['Retenible']) >0){                                                    
                        $stringConceptos .= "<cfdi:Retenciones>";
                        foreach($impuestos['Retenible'] as $impuesto){                            
                            $stringConceptos .= "<cfdi:Retencion ";
                            foreach($impuesto as $key => $value){
                                $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
                                $stringConceptos .= $key.'="'.trim($value).'" ';
                            }   
                            $stringConceptos = trim($stringConceptos);
                            $stringConceptos .= "/>\r\n";
                        }
                        $stringConceptos .= "</cfdi:Retenciones>\r\n";
                    }
                    
                     $stringConceptos .= "</cfdi:Impuestos>\r\n";
                }else{
                    $stringConceptos .=">";
                }

            }         
            
            $stringConceptos = trim($stringConceptos);
            $stringConceptos .= "</cfdi:Concepto>\r\n";
        }      
        
        $stringConceptos .= "</cfdi:Conceptos>\r\n";    
        
        return $stringConceptos;
    }
    
    public function getStringTagImpuestos(){
        $cadena_xml ='<cfdi:Impuestos ';
        
        if($this->datosImpuestos['Retenciones']!= null){
            $cadena_xml .= 'TotalImpuestosRetenidos="'.$this->datosImpuestos['Retenciones']['totalImpuestosRetenidos'].'" ';
        }
        
        if($this->datosImpuestos['Traslados']!= null){
            $cadena_xml .= 'TotalImpuestosTrasladados="'.$this->datosImpuestos['Traslados']['totalImpuestosTrasladados'].'" ';
        }
        
        $cadena_xml .= '>'."\r";  
        
        if($this->datosImpuestos['Retenciones']!= null){
            $cadena_xml.='<cfdi:Retenciones>'."\r";
            foreach($this->datosImpuestos['Retenciones']['detalles'] as $detalle){
                $cadena_xml .= '<cfdi:Retencion Impuesto="'.$detalle['Impuesto'].'" Importe="'.$detalle['Importe'].'"/>'."\r\n";
            }
            $cadena_xml.='</cfdi:Retenciones>'."\r\n";        
        }	
         
        if($this->datosImpuestos['Traslados']!= null){
            $cadena_xml.='<cfdi:Traslados>'."\r";
            foreach($this->datosImpuestos['Traslados']['detalles'] as $detalle){
                $cadena_xml .= '<cfdi:Traslado Impuesto="'.$detalle['Impuesto'].'" TipoFactor="'.$detalle['TipoFactor'].'" TasaOCuota="'.$detalle['TasaOCuota'].'" Importe="'.$detalle['Importe'].'"/>'."\r\n";
            }
            $cadena_xml.='</cfdi:Traslados>'."\r\n";        
        }	    
        
        $cadena_xml.='</cfdi:Impuestos>'."\r\n"; 
        
        return $cadena_xml;
    }  
   
     public function crearXML($rutaParaGuardarXML,$nombreArchivo){ 
        $xml_string = '<?xml version="1.0" encoding="UTF-8"?>'."\r\n";       
        $xml_string .= $this->getStringTagComprobante(); 
        $xml_string .= $this->getStringTagCfdiRelacionados();
        $xml_string .= utf8_encode($this->getStringTagEmisor());
        $xml_string .= utf8_encode($this->getStringTagReceptor());
        $xml_string .= utf8_encode($this->getStringTagConceptos());
        $xml_string .= $this->getStringTagImpuestos();
        $xml_string .= '</cfdi:Comprobante>';
        
        $xml_string =  preg_replace ("/ +/"," ",$xml_string);        
        //echo "<pre>";echo htmlentities($xml_string);echo "</pre>";exit;
        // echo $rutaParaGuardarXML.$nombreArchivo;exit;
        $archivo_xml = fopen ($rutaParaGuardarXML.$nombreArchivo.".xml", "w");
        fwrite($archivo_xml,$xml_string);
        fclose($archivo_xml);      
    }
}
