<?php
/**
 * Description of crear_xml_factura
 *
 * @author carlos
 */
class crear_xml_pago {    
    private $archivosSAT = null;    
    private $datosComprobante = array();    
    private $datosComplemento = array();
    private $datosEmisor = array();   
    private $datosReceptor = array();
    private $datosConceptos = array();     
    private $datosImpuestos = array();   
    
    public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
    }
  
    public function getOptions(){
        return $this->options;
    }
    
    public function setDatosComprobante(array $datosComprobante){
        $this->datosComprobante = $datosComprobante;
    }
    
    public function setDatosComplemento(array $datosComplemento){
        $this->datosComplemento = $datosComplemento;
    }
    
    public function setDatosEmisor(array $datosEmisor){
        $this->datosEmisor = $datosEmisor;
    }
    
    public function setDatosReceptor(array $datosReceptor){
        $this->datosReceptor = $datosReceptor;
    }
    
    public function setDatosConceptos(array $datosConceptos){
        $this->datosConceptos = $datosConceptos;
    }
    
    public function setArchivosSAT($archivosSAT){
        $this->archivosSAT = $archivosSAT;
    }
    
     public function setDatosImpuestos(array $datosImpuestos){
        $this->datosImpuestos = $datosImpuestos;
    }    
    
    private function getStringTagComprobante(){
        #cfdi:Comprobante
        $stringComprobante = '<cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd http://www.sat.gob.mx/Pagos http://www.sat.gob.mx/sitio_internet/cfd/Pagos/Pagos10.xsd" '."\r\n";

        foreach ($this->datosComprobante as $key => $value){
            if(trim($value) != ''){
                $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
                $stringComprobante .= $key.'="'.trim($value).'" ';
            }
        }
        
        $stringComprobante = trim($stringComprobante);
        $stringComprobante .= ">\r\n";
       
        return $stringComprobante;
    }
    
    private function getStringTagComplemento(){
        #cfdi:CFDIs Relacionados      
        $stringComplemento = '<cfdi:Complemento>'
            . '<pago10:Pagos xmlns:pago10="http://www.sat.gob.mx/Pagos" Version="1.0">'
            . '<pago10:Pago ';
        
        foreach($this->datosComplemento['pago'] as $key => $value){
            if(trim($value) != ''){
                $value = str_ireplace('`',"&apos;",str_ireplace('<',"&lt;",str_ireplace('>',"&gt;",str_ireplace('"',"&quot;",str_ireplace("&","&amp;",$value)))));
                $stringComplemento .= $key.'="'.trim($value).'" ';
            }
        }
        
        $stringComplemento = trim($stringComplemento);
        $stringComplemento .= ">"; #cierre con '>' de <pago10:Pago       
        
        foreach($this->datosComplemento['documentosRelacionados'] as $documento){
            $stringComplemento .= "\r\n<pago10:DoctoRelacionado ";
            foreach ($documento as $key => $value) {
                if (trim($value) != '') {
                    $value = str_ireplace('`', "&apos;", str_ireplace('<', "&lt;", str_ireplace('>', "&gt;", str_ireplace('"', "&quot;", str_ireplace("&", "&amp;", $value)))));
                    $stringComplemento .= $key . '="' . trim($value) . '" ';
                }
            }
            $stringComplemento .= "/>"; #cierres <pago10:DoctoRelacionado
        }        
        
        $stringComplemento .= "\r\n</pago10:Pago>";  #cierre de <pago10:Pago con' </'              
        $stringComplemento .= "\r\n</pago10:Pagos>";  #cierre de <pago10:Pagos con' </'              
        $stringComplemento .= "\r\n</cfdi:Complemento>";  #cierre de <pago10:Pagos con' </' 

        return $stringComplemento;
        
    }
    
     private function getStringTagEmisor(){
        #cfdi:Emisor      
        $stringEmisor = "<cfdi:Emisor ";
        foreach ($this->datosEmisor['Emisor'] as $key => $value) {
            if (trim($value) != '') {
                $value = str_ireplace('`', "&apos;", str_ireplace('<', "&lt;", str_ireplace('>', "&gt;", str_ireplace('"', "&quot;", str_ireplace("&", "&amp;", $value)))));
                $stringEmisor .= $key . '="' . trim($value) . '" ';
            }
        }
        $stringEmisor = trim($stringEmisor);
        $stringEmisor .= "/>\r\n";                
        
        return $stringEmisor;
    }
    
    private function getStringTagReceptor(){
        #cfdi:Receptor         
        $stringReceptor = "<cfdi:Receptor ";
        foreach ($this->datosReceptor['Receptor'] as $key => $value) {
            if (trim($value) != '') {
                $value = str_ireplace('`', "&apos;", str_ireplace('<', "&lt;", str_ireplace('>', "&gt;", str_ireplace('"', "&quot;", str_ireplace("&", "&amp;", $value)))));
                $stringReceptor .= $key . '="' . trim($value) . '" ';
            }
        }
        $stringReceptor = trim($stringReceptor);
        $stringReceptor .= "/>\r\n";        
        
        return $stringReceptor;
    }
    
    private function getStringTagConceptos(){
        #cfdi:Conceptos  
        $stringConceptos = "<cfdi:Conceptos>\r\n";
        foreach($this->datosConceptos as $concepto){
            $stringConceptos .= "<cfdi:Concepto ";
            
            foreach ($concepto as $key => $value) {
                if (trim($value) != '') {
                    $value = str_ireplace('`', "&apos;", str_ireplace('<', "&lt;", str_ireplace('>', "&gt;", str_ireplace('"', "&quot;", str_ireplace("&", "&amp;", $value)))));
                    $stringConceptos .= $key . '="' . trim($value) . '" ';
                }
            }
            $stringConceptos .=">"; 
            
            $stringConceptos = trim($stringConceptos);
            $stringConceptos .= "</cfdi:Concepto>\r\n";
        }      
        
        $stringConceptos .= "</cfdi:Conceptos>\r\n";    
        
        return $stringConceptos;
    }  
    
    public function getStringTagImpuestos(){
        $cadena_xml ='<cfdi:Impuestos ';
        
        if($this->datosImpuestos['Retenciones']!= null){
            $cadena_xml .= 'TotalImpuestosRetenidos="'.$this->datosImpuestos['Retenciones']['totalImpuestosRetenidos'].'" ';
        }
        
        if($this->datosImpuestos['Traslados']!= null){
            $cadena_xml .= 'TotalImpuestosTrasladados="'.$this->datosImpuestos['Traslados']['totalImpuestosTrasladados'].'" ';
        }
        
        $cadena_xml .= '>'."\r";  
        
        if($this->datosImpuestos['Retenciones']!= null){
            $cadena_xml.='<cfdi:Retenciones>'."\r";
            foreach($this->datosImpuestos['Retenciones']['detalles'] as $detalle){
                $cadena_xml .= '<cfdi:Retencion Impuesto="'.$detalle['Impuesto'].'" Importe="'.$detalle['Importe'].'"/>'."\r\n";
            }
            $cadena_xml.='</cfdi:Retenciones>'."\r\n";        
        }	
         
        if($this->datosImpuestos['Traslados']!= null){
            $cadena_xml.='<cfdi:Traslados>'."\r";
            foreach($this->datosImpuestos['Traslados']['detalles'] as $detalle){
                $cadena_xml .= '<cfdi:Traslado Impuesto="'.$detalle['Impuesto'].'" TipoFactor="'.$detalle['TipoFactor'].'" TasaOCuota="'.$detalle['TasaOCuota'].'" Importe="'.$detalle['Importe'].'"/>'."\r\n";
            }
            $cadena_xml.='</cfdi:Traslados>'."\r\n";        
        }	    
        
        $cadena_xml.='</cfdi:Impuestos>'."\r\n"; 
        
        return $cadena_xml;
    }  
   
     public function crearXML($rutaParaGuardarXML,$nombreArchivo){ 
        $xml_string = '<?xml version="1.0" encoding="UTF-8"?>'."\r\n";       
        $xml_string .= $this->getStringTagComprobante(); 
        $xml_string .= utf8_encode($this->getStringTagEmisor());
        $xml_string .= utf8_encode($this->getStringTagReceptor());
        $xml_string .= utf8_encode($this->getStringTagConceptos());        
        $xml_string .= $this->getStringTagComplemento();
        #$xml_string .= $this->getStringTagImpuestos();
        $xml_string .= '</cfdi:Comprobante>';
        
        $xml_string =  preg_replace ("/ +/"," ",$xml_string);
        
        // echo "<pre>";echo htmlentities($xml_string);echo "</pre>";exit;
        
        $archivo_xml = fopen ($rutaParaGuardarXML.$nombreArchivo.".xml", "w");
        fwrite($archivo_xml,$xml_string);
        fclose($archivo_xml);      
    }
}
