<?php
/**
 * Description of Login
 *
 * @author carlos
 */
class Login extends LoginRepository {
    private $user = array();
    private $isLogged = null;
    
    public function __construct($options = null) {    
        if(null === $options){
            if(isset($_SESSION['usuario'])){
                $this->user = $_SESSION['usuario'];
                $this->isLogged = true;
            }
        }else{
            $this->isLoginCorrect($options['usuario'], $options['contrasena']);
        }
    } 
       
    public function isLoginCorrect($user, $password) {
        $data = parent::isLoginCorrect($user, $password);
        
        if($data){
            $data['controller'] = null;
            $this->setUser($data);
            $this->isLogged = true;
        }
         return null;
    }    
    
    public function setUser($data){
        $this->user = $data;
        $this->setDefaultController();
        $this->setRFC();
        $_SESSION['usuario'] = $this->user;
    }
    
    private function setRFC(){
        $repoEmpresa = new EmpresaRepository();
        $dataEmpresa = $repoEmpresa->getById(1);
       
        $this->user['rfc'] = $dataEmpresa['rfc'];
    }
    
    public function addPropiertieLogged($propierties){
        foreach($propierties as $propiertie => $value){
            $_SESSION[$propiertie] = $value;
        }
    }
    
    private function setVersionSystem(){
        $settings = new SettingsRepository();
        $this->user['versionSystem'] = $settings->_get('version_system');
    }
    
    public function getVersionSystem(){
        return $this->user['versionSystem'];
    }
    
    private function setDefaultController(){
        switch($this->getRole()){
            default:
                    $this->user['defaultController'] = 'Home.php';
                break;
        }
    }
    
    public function getDefaultController(){
        return $this->user['defaultController'];
    }
    
    
    public function getId(){
        return $this->user['id'];
    }
    
    public function getUusario(){
        return $this->user['usuario'];
    }
    
    public function getNombreCompleto(){
        return $this->user['nombre']." ".$this->user['apellido'];
    }
    
    public function getRole(){
        return $this->user['role'];
    }    
        
    public function getCustomer(){
        return $this->user['id_customer'];
    }
    
    public function getSucursal(){
        return $this->user['sucursal'];
    }
    
    public function isLogged(){
        return $this->isLogged;
    }
    
    public function getRFC(){
        if (isset($this->user['rfc']))
            return $this->user['rfc'];

        return null;
    }
    
    public function setCurrentController($controller){
        $_SESSION['usuario']['controller'] = $controller;
    }
    
    public function getCurrentController(){
        return  $this->user['controller'];
    }
    
    public function getIdioma(){
        return $_SESSION['usuario']['language'];
    }
    
    public function getDefaultLocationForOutsourcing(){
        return  $this->user['default_location_for_outsourcing'];
    }
}