<?php
class QuotationRepository extends EntityRepository {

    private $table = 'quotations';
    public $flashmessenger = null;
    private $options_files = array(
        'allowedExtensions'=>array('pdf'),
        'maxFileSizeAllowed'=>1000000,
        'pathToSave'=>PATH_SALE_INVOICES
    );
    private $options = array (
        'id'=>null,
        'num_venta'=>null,
        'date' => null,
        'customer'=>null,
        'project'=>null,
        'reference' => null,   
        'discount_general_type'=>null,
        'discount_general'=>null,
        'total'=>null,
        'method_payment'=>null,
        'credit_days'=>null,
        'due_date'=>null,
        'comments'=>null,
        'status'=>null,
        'invoice_file'=>null);
    
    private $options_aux = array(
        'customerName'=>null,
        'userName'=>null,
        'projectName'=>null,
        'statusName'=>null,
        'methodPaymentName'=>null,
        'formatedDueDate'=>null,
        'formatedDate'=>null,
        'token_form'=>null
    );      
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
        
        foreach ($this->options_aux as $option => $value){
            if(isset($data[$option])){
              $this->options_aux[$option] = $data[$option];
            }
        }
    }
    
    public function getCustomerName(){        
        return $this->options_aux['customerName'];
    }

    public function getProjectName(){        
        return $this->options_aux['projectName'];
    }

    public function getMethodPaymentName(){        
        return $this->options_aux['methodPaymentName'];
    }
    
    public function getCreditDays(){        
        return $this->options['credit_days'];
    }
    
    public function getUserName(){        
        return $this->options_aux['userName'];
    }
    
    public function getStatusName(){        
        return $this->options_aux['statusName'];
    }
    
    public function getDate(){
        return $this->options['date'];
    }
    
    public function getFormatedDate(){
        return $this->options_aux['formatedDate'];
    }
    
    public function getFormatedDueDate(){
        return $this->options_aux['formatedDueDate'];
    }
    
    public function getVendor(){
        return $this->options['customer'];
    }

    public function getProject(){
        return $this->options['project'];
    }
    
    public function getReference(){
        return $this->options['reference'];
    }
    
    public function getTotal(){
        return $this->options['total'];
    }
    
    public function getComments(){
        return $this->options['comments'];
    }
    
    public function getStatus(){
        return $this->options['status'];
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function getId() {
       return $this->options['id'];
    }
    
    public function getCustomerInfoComplete(){
        $proveedor = new CustomerRepository();        
        return $proveedor->getById($this->options['customer']);
    }
    
    public function getSaldoPendiente(){
        return $this->options['total'] - $this->options['payments'];
    }
    
    public function getTokenForm(){
        return $this->options_aux['token_form'];
    }
    
    public function saveFiles($files,$idVenta,$numFactura){       
        $file = new UploadFile();
        $file->setAllowedExtensions($this->options_files['allowedExtensions']);
        $file->setMaxFileSizeAllowed($this->options_files['maxFileSizeAllowed']);
        $file->setTempFolder($this->options_files['pathToSave']);
        
        $rsUpload = $file->uploadFile($files['invoice_file'],null,"Factura_de_venta_".$idVenta."_".$numFactura); 
        
        if(!$rsUpload){
            $this->flashmessenger->addMessage(array('info'=>$file->getMessageError()));  
            return null;
        }        
        
        return true;        
    }

    public function save(array $data, $table = null) {             
        $login = new Login();
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);    
        $data['due_date'] = $tools->setFormatDateToDB($data['due_date']);
        $data['status'] = '1';
        $data['num_venta'] = $this->getNextSaleNum(); 
        
        $invoice_file = $data['invoice_file'];
        unset($data['invoice_file']);
        
        if($data['id']==null || $data['id']==''){unset($data['id']);}
        
        $this->startTransaction();        
        $rs = parent::save($data, $this->table);
        $idVenta = $this->getInsertId();
        $this->setLastInsertId($idVenta);//Para utilizarlo en el Controller action insert
        
        if($rs){
            $purchaseDetailsTemp = new QuotationDetailsTempRepository();

            if($purchaseDetailsTemp->saveDetalles($idVenta,$this->getTokenForm())){   
                $this->commit();
                $purchaseDetailsTemp->truncate($this->getTokenForm());

                if($invoice_file['invoice_file']['name'] != ''){
                    $this->saveFiles($invoice_file,$idVenta,$data['reference']);
                }

                return true;
            }
        }        
        
        $this->rollback();    
        $this->flashmessenger->addMessage(array(
            'error'=>$this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')));
        return null;        
    }
    
    public function delete($id, $table = null) {
        $currentData = $this->getById($id);
        if($currentData['status'] == '3'){return true;}

        $rs = parent::update($id, array('status'=>'3'), $this->table);
        
        if($rs){
            return true;
        }

        return null;
    }

    public function update($id, $data, $table = null) {        
        
        $tools = new Tools();
        $currentData = $this->getById($id);
        $data['date'] = $tools->setFormatDateToDB($data['date']); 
        $data['due_date'] = $tools->setFormatDateToDB($data['due_date']);

        $invoice_file = $data['invoice_file'];
        unset($data['invoice_file']);   
        
        $this->startTransaction();
        $result = parent::update($id, $data, $this->table);        
        if($result){
            $repository = new QuotationDetailsTempRepository();
            if($repository->updateDetalles($id,$this->getTokenForm())){                   
                $this->commit();
                $repository->truncate($this->getTokenForm());   
                
                 if($invoice_file['invoice_file']['name']!=''){    
                    $this->saveFiles($invoice_file,$id,$data['reference']);
                }         
               return true;
            }
        }
        
        $this->rollback();
        return null;
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "DATE_FORMAT(date,'%d/%m/%Y')as formatedDate,"
                . "DATE_FORMAT(due_date,'%d/%m/%Y')as formatedDueDate,"
                . "fxGetProjectName(project) as projectName,"
                . "fxGetCustomerName(customer) as customerName,"
                . "fxGetFormaPagoName(method_payment) as methodPaymentName,"
                . "fxGetStatusName(status,'Quotation')as statusName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        return parent::isUsedInRecord($id, array('compras' => 'id')," AND status = 2 AND (type != 'BienesyServicios' AND type != 'Consigna' AND type != 'MateriaPrima')");
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();        
        $query = "CREATE TABLE IF NOT EXISTS quotations_details_".$login->getId()." 
                 (  
                    `token_form` char(50) NOT NULL,
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_quotation` int(11) NULL,
                    `id_product` int(11) NOT NULL,
                    `description_details` TEXT NOT NULL,
                    `description` varchar(255) NULL,
                    `quantity` double NOT NULL,
                    `price` double NOT NULL,
                    `cost_without_tax` double NOT NULL,
                    `discount` double NOT NULL,
                    `discount_type` char(15) NOT NULL,
                    `discount_amount` double NOT NULL,
                    `discount_general` double NOT NULL,
                    `discount_general_type` char(15) NOT NULL,
                    `discount_general_amount` double NOT NULL,
                    `taxes` int(11) NOT NULL,
                    `taxes_rate` double NOT NULL,
                    `taxes_amount` double NOT NULL,
                    `taxes_included` CHAR(50) NOT NULL,
                    `amount` double NOT NULL,
                    `total` double NOT NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function insertDetalle($data){
        $saleDetailsTemp = new QuotationDetailsTempRepository();        
        return $saleDetailsTemp->save($data);
    }
    
    public function getQuotationsDetails($token_form){
        $login = new Login();
        $query = "SELECT v.*,
                    v.id as idDetailTemp,
                    p.code,
                    fxGetTaxDescription(v.taxes)as taxName,
                    v.description as product,
                    fxGetCategoryDescription(p.category)as category,
                    fxGetBrandDescription(p.brand)as brand,
                    fxGetPresentationDescription(p.presentation)as presentation
                  FROM quotations_details_".$login->getId()." v LEFT JOIN products p
                  ON v.id_product = p.id
                  WHERE token_form = '$token_form'
                  ORDER BY v.id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getQuotationDetailSaved($id){
        $query = "SELECT c.*,
                    p.code as code
                    FROM quotations_details_ c LEFT JOIN products p ON c.id_product = p.id
                    WHERE c.id = '$id'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result)[0];
            return $result;
        }
        
        return null;
    }
    
    public function getQuotationDetailsSaved($id){
        $query = "SELECT c.*,
                    fxGetTaxDescription(c.taxes)as taxName
                    FROM quotations_details c LEFT JOIN products p ON c.id_product = p.id
                    WHERE c.id_quotation = '$id'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    public function getQuotationDetails($token_form){
        $login = new Login();
        $query = "SELECT v.*,
                    v.id as idDetailTemp,
                    p.code,
                    fxGetTaxDescription(v.taxes)as taxName,
                    v.description as product,
                    fxGetCategoryDescription(p.category)as category,
                    fxGetBrandDescription(p.brand)as brand,
                    fxGetPresentationDescription(p.presentation)as presentation
                  FROM quotations_details_".$login->getId()." v LEFT JOIN products p
                  ON v.id_product = p.id
                  WHERE token_form = '$token_form'
                  ORDER BY v.id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function setQuotationDetailsById($idVenta,$tokenForm){
        $repository = new QuotationDetailsTempRepository();
        
        return $repository->setQuotationDetailsById($idVenta,$tokenForm);
    }
    
    public function getProductById($idProducto){
        $query = "SELECT * FROM products WHERE id = '$idProducto' LIMIT 1";
        $result = $this->query($query);

        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }        
        return null;
    }
    
    public function getListQuotation(){       
        $store_id = null;
        
        $login = new Login();
        if($login->getRole() != '1'){
            $store_id = " AND c.num_venta = '{$login->getStoreId()}'; ";
        }
        
        $query = "SELECT c.*,
                DATE_FORMAT(c.date,'%d/%m/%Y')as date,
                fxGetStatusName(c.`status`,'Quotation')as statusName,
                fxGetProjectName(c.project) as projectName,
                fxGetCustomerName(c.customer) as customerName
                FROM quotations c
                WHERE  1=1 
                $store_id " 
              . "GROUP BY c.id "
              . "ORDER BY c.id DESC ";

    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        
        
        return null;
  }
    
    public function getDueDate($date,$creditDays){
        $query = "SELECT DATE_ADD('{$date}',INTERVAL $creditDays DAY)as due_date";
        $result = $this->query($query);
        
        if($result){
            $result = $result->fetch_object();
            return $result->due_date;
        }
        return '';
    }
  
  public function getListMetodoPago(){
        $query = "SELECT id,description FROM payment_methods WHERE tipo = 'Metodo pago'";
        $result = $this->query($query);
        
        if($result){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->description;
            }
            
            return $array;
        }
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['startDate']) && !isset($options['endDate'])){return null;}        
        $startDate = $options['startDate'];
        $endDate = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($startDate!=null){
            $startDate = $tools->setFormatDateToDB($startDate);
            if($endDate!=null){
                $endDate = $tools->setFormatDateToDB($endDate);
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$endDate}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$startDate}' ";
            }
        }elseif($endDate!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$endDate}' AND '{$endDate}' ";
        }
        
        return $fecha;
    }

    public function getNextSaleNum(){
        $login = new Login();
        $query = "SELECT num_venta FROM quotations ORDER BY num_venta DESC LIMIT 1";        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $numVenta = $result->num_venta;
            $numVenta = $numVenta + 1;
            return str_pad($numVenta, 7, '0', STR_PAD_LEFT);
        }else{
            return str_pad(1, 7, '0', STR_PAD_LEFT);
        }
    } 
  
}