-- MySQL dump 10.10
--
-- Host: sw2    Database: demo
-- ------------------------------------------------------
-- Server version	5.1.15-beta

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE IF NOT EXISTS demo;
use demo;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `CategoryID` int(11) NOT NULL AUTO_INCREMENT,
  `CategoryName` varchar(15) DEFAULT NULL,
  `Description` text,
  `Picture` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`CategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `categories`
--


/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
LOCK TABLES `categories` WRITE;
INSERT INTO `categories` VALUES (1,'Beverages','Soft drinks, coffees, teas, beers, and ales',NULL),(2,'Condiments','Sweet and savory sauces, relishes, spreads, and seasonings',''),(3,'Confections','Desserts, candies, and sweet breads',''),(4,'Dairy Products','Cheeses',''),(5,'Grains/Cereals','Breads, crackers, pasta, and cereal',''),(6,'Meat/Poultry','Prepared meats',''),(7,'Produce','Dried fruit and bean curd',''),(8,'Seafood','Seaweed and fish','');
UNLOCK TABLES;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `CustomerID` varchar(5) NOT NULL DEFAULT '',
  `CompanyName` varchar(40) DEFAULT NULL,
  `ContactName` varchar(30) DEFAULT NULL,
  `ContactTitle` varchar(30) DEFAULT NULL,
  `Address` varchar(60) DEFAULT NULL,
  `City` varchar(15) DEFAULT NULL,
  `Region` varchar(15) DEFAULT NULL,
  `PostalCode` varchar(10) DEFAULT NULL,
  `Country` varchar(15) DEFAULT NULL,
  `Phone` varchar(24) DEFAULT NULL,
  `Fax` varchar(24) DEFAULT NULL,
  PRIMARY KEY (`CustomerID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `customers`
--


/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
LOCK TABLES `customers` WRITE;
INSERT INTO `customers` VALUES ('ALFKI','Alfreds Futterkiste','Maria Anders','Sales Representative','Obere Str. 57','Berlin','','12209','Germany','030-0074321','030-0076545'),('ANATR','Ana Trujillo Emparedados y helados','Ana Trujillo','Owner','Avda. de la Constituci?n 2222','M?xico D.F.','','05021','Mexico','(5) 555-4729','(5) 555-3745'),('ANTON','Antonio Moreno Taquer?a','Antonio Moreno','Owner','Mataderos  2312','M?xico D.F.','','05023','Mexico','(5) 555-3932',''),('AROUT','Around the Horn','Thomas Hardy','Sales Representative','120 Hanover Sq.','London','','WA1 1DP','United Kingdom','(171) 555-7788','(171) 555-6750'),('BERGS','Berglunds snabbk?p','Christina Berglund','Order Administrator','Berguvsv?gen  8','Lule?','','S-958 22','Sweden','0921-12 34 65','0921-12 34 67'),('BLAUS','Blauer See Delikatessen','Hanna Moos','Sales Representative','Forsterstr. 57','Mannheim','','68306','Germany','0621-08460','0621-08924'),('BLONP','Blondel p?re et fils','Fr?d?rique Citeaux','Marketing Manager','24, place Kl?ber','Strasbourg','','67000','France','88.60.15.31','88.60.15.32'),('BOLID','B?lido Comidas preparadas','Mart?n Sommer','Owner','C/ Araquil, 67','Madrid','','28023','Spain','(91) 555 22 82','(91) 555 91 99'),('BONAP','Bon app\'','Laurence Lebihan','Owner','12, rue des Bouchers','Marseille','','13008','France','91.24.45.40','91.24.45.41'),('BOTTM','Bottom-Dollar Markets','Elizabeth Lincoln','Accounting Manager','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada','(604) 555-4729','(604) 555-3745'),('BSBEV','B\'s Beverages','Victoria Ashworth','Sales Representative','Fauntleroy Circus','London','','EC2 5NT','United Kingdom','(171) 555-1212',''),('CACTU','Cactus Comidas para llevar','Patricio Simpson','Sales Agent','Cerrito 333','Buenos Aires','','1010','Argentina','(1) 135-5555','(1) 135-4892'),('CENTC','Centro comercial Moctezuma','Francisco Chang','Marketing Manager','Sierras de Granada 9993','M?xico D.F.','','05022','Mexico','(5) 555-3392','(5) 555-7293'),('CHOPS','Chop-suey Chinese','Yang Wang','Owner','Hauptstr. 29','Bern','','3012','Switzerland','0452-076545',''),('COMMI','Com?rcio Mineiro','Pedro Afonso','Sales Associate','Av. dos Lus?adas, 23','S?o Paulo','SP','05432-043','Brazil','(11) 555-7647',''),('CONSH','Consolidated Holdings','Elizabeth Brown','Sales Representative','Berkeley Gardens\r\n12  Brewery','London','','WX1 6LT','United Kingdom','(171) 555-2282','(171) 555-9199'),('DRACD','Drachenblut Delikatessen','Sven Ottlieb','Order Administrator','Walserweg 21','Aachen','','52066','Germany','0241-039123','0241-059428'),('DUMON','Du monde entier','Janine Labrune','Owner','67, rue des Cinquante Otages','Nantes','','44000','France','40.67.88.88','40.67.89.89'),('EASTC','Eastern Connection','Ann Devon','Sales Agent','35 King George','London','','WX3 6FW','United Kingdom','(171) 555-0297','(171) 555-3373'),('ERNSH','Ernst Handel','Roland Mendel','Sales Manager','Kirchgasse 6','Graz','','8010','Austria','7675-3425','7675-3426'),('FAMIA','Familia Arquibaldo','Aria Cruz','Marketing Assistant','Rua Or?s, 92','S?o Paulo','SP','05442-030','Brazil','(11) 555-9857',''),('FISSA','FISSA Fabrica Inter. Salchichas S.A.','Diego Roel','Accounting Manager','C/ Moralzarzal, 86','Madrid','','28034','Spain','(91) 555 94 44','(91) 555 55 93'),('FOLIG','Folies gourmandes','Martine Ranc','Assistant Sales Agent','184, chauss?e de Tournai','Lille','','59000','France','20.16.10.16','20.16.10.17'),('FOLKO','Folk och f? HB','Maria Larsson','Owner','?kergatan 24','Br?cke','','S-844 67','Sweden','0695-34 67 21',''),('FRANK','Frankenversand','Peter Franken','Marketing Manager','Berliner Platz 43','M?nchen','','80805','Germany','089-0877310','089-0877451'),('FRANR','France restauration','Carine Schmitt','Marketing Manager','54, rue Royale','Nantes','','44000','France','40.32.21.21','40.32.21.20'),('FRANS','Franchi S.p.A.','Paolo Accorti','Sales Representative','Via Monte Bianco 34','Torino','','10100','Italy','011-4988260','011-4988261'),('FURIB','Furia Bacalhau e Frutos do Mar','Lino Rodriguez','Sales Manager','Jardim das rosas n. 32','Lisboa','','1675','Portugal','(1) 354-2534','(1) 354-2535'),('GALED','Galer?a del gastr?nomo','Eduardo Saavedra','Marketing Manager','Rambla de Catalu?a, 23','Barcelona','','08022','Spain','(93) 203 4560','(93) 203 4561'),('GODOS','Godos Cocina T?pica','Jos? Pedro Freyre','Sales Manager','C/ Romero, 33','Sevilla','','41101','Spain','(95) 555 82 82',''),('GOURL','Gourmet Lanchonetes','Andr? Fonseca','Sales Associate','Av. Brasil, 442','Campinas','SP','04876-786','Brazil','(11) 555-9482',''),('GREAL','Great Lakes Food Market','Howard Snyder','Marketing Manager','2732 Baker Blvd.','Eugene','OR','97403','United States','(503) 555-7555',''),('GROSR','GROSELLA-Restaurante','Manuel Pereira','Owner','5? Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela','(2) 283-2951','(2) 283-3397'),('HANAR','Hanari Carnes','Mario Pontes','Accounting Manager','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil','(21) 555-0091','(21) 555-8765'),('HILAA','HILARI?N-Abastos','Carlos Hern?ndez','Sales Representative','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela','(5) 555-1340','(5) 555-1948'),('HUNGC','Hungry Coyote Import Store','Yoshi Latimer','Sales Representative','City Center Plaza\r\n516 Main St.','Elgin','OR','97827','United States','(503) 555-6874','(503) 555-2376'),('HUNGO','Hungry Owl All-Night Grocers','Patricia McKenna','Sales Associate','8 Johnstown Road','Cork','Co. Cork','','Ireland','2967 542','2967 3333'),('ISLAT','Island Trading','Helen Bennett','Marketing Manager','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom','(198) 555-8888',''),('KOENE','K?niglich Essen','Philip Cramer','Sales Associate','Maubelstr. 90','Brandenburg','','14776','Germany','0555-09876',''),('LACOR','La corne d\'abondance','Daniel Tonini','Sales Representative','67, avenue de l\'Europe','Versailles','','78000','France','30.59.84.10','30.59.85.11'),('LAMAI','La maison d\'Asie','Annette Roulet','Sales Manager','1 rue Alsace-Lorraine','Toulouse','','31000','France','61.77.61.10','61.77.61.11'),('LAUGB','Laughing Bacchus Wine Cellars','Yoshi Tannamuri','Marketing Assistant','1900 Oak St.','Vancouver','BC','V3F 2K1','Canada','(604) 555-3392','(604) 555-7293'),('LAZYK','Lazy K Kountry Store','John Steel','Marketing Manager','12 Orchestra Terrace','Walla Walla','WA','99362','United States','(509) 555-7969','(509) 555-6221'),('LEHMS','Lehmanns Marktstand','Renate Messner','Sales Representative','Magazinweg 7','Frankfurt a.M.','','60528','Germany','069-0245984','069-0245874'),('LETSS','Let\'s Stop N Shop','Jaime Yorres','Owner','87 Polk St.\r\nSuite 5','San Francisco','CA','94117','United States','(415) 555-5938',''),('LILAS','LILA-Supermercado','Carlos Gonz?lez','Accounting Manager','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela','(9) 331-6954','(9) 331-7256'),('LINOD','LINO-Delicateses','Felipe Izquierdo','Owner','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela','(8) 34-56-12','(8) 34-93-93'),('LONEP','Lonesome Pine Restaurant','Fran Wilson','Sales Manager','89 Chiaroscuro Rd.','Portland','OR','97219','United States','(503) 555-9573','(503) 555-9646'),('MAGAA','Magazzini Alimentari Riuniti','Giovanni Rovelli','Marketing Manager','Via Ludovico il Moro 22','Bergamo','','24100','Italy','035-640230','035-640231'),('MAISD','Maison Dewey','Catherine Dewey','Sales Agent','Rue Joseph-Bens 532','Bruxelles','','B-1180','Belgium','(02) 201 24 67','(02) 201 24 68'),('MEREP','M?re Paillarde','Jean Fresni?re','Marketing Assistant','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada','(514) 555-8054','(514) 555-8055'),('MORGK','Morgenstern Gesundkost','Alexander Feuer','Marketing Assistant','Heerstr. 22','Leipzig','','04179','Germany','0342-023176',''),('NORTS','North/South','Simon Crowther','Sales Associate','South House\r\n300 Queensbridge','London','','SW7 1RZ','United Kingdom','(171) 555-7733','(171) 555-2530'),('OCEAN','Oc?ano Atl?ntico Ltda.','Yvonne Moncada','Sales Agent','Ing. Gustavo Moncada 8585\r\nPiso 20-A','Buenos Aires','','1010','Argentina','(1) 135-5333','(1) 135-5535'),('OLDWO','Old World Delicatessen','Rene Phillips','Sales Representative','2743 Bering St.','Anchorage','AK','99508','United States','(907) 555-7584','(907) 555-2880'),('OTTIK','Ottilies K?seladen','Henriette Pfalzheim','Owner','Mehrheimerstr. 369','K?ln','','50739','Germany','0221-0644327','0221-0765721'),('PARIS','Paris sp?cialit','Marie Bertrand','Owner','265, boulevard Charonne','Paris','','75012','France','(1) 42.34.22.66','(1) 42.34.22.77'),('PERIC','Pericles Comidas cl?sicas','Guillermo Fern?ndez','Sales Representative','Calle Dr. Jorge Cash 321','M?xico D.F.','','05033','Mexico','(5) 552-3745','(5) 545-3745'),('PICCO','Piccolo und mehr','Georg Pipps','Sales Manager','Geislweg 14','Salzburg','','5020','Austria','6562-9722','6562-9723'),('PRINI','Princesa Isabel Vinhos','Isabel de Castro','Sales Representative','Estrada da sa?de n. 58','Lisboa','','1756','Portugal','(1) 356-5634',''),('QUEDE','Que Del?cia','Bernardo Batista','Accounting Manager','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil','(21) 555-4252','(21) 555-4545'),('QUEEN','Queen Cozinha','L?cia Carvalho','Marketing Assistant','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil','(11) 555-1189',''),('QUICK','QUICK-Stop','Horst Kloss','Accounting Manager','Taucherstra?e 10','Cunewalde','','01307','Germany','0372-035188',''),('RANCH','Rancho grande','Sergio Guti?rrez','Sales Representative','Av. del Libertador 900','Buenos Aires','','1010','Argentina','(1) 123-5555','(1) 123-5556'),('RATTC','Rattlesnake Canyon Grocery','Paula Wilson','Assistant Sales Representative','2817 Milton Dr.','Albuquerque','NM','87110','United States','(505) 555-5939','(505) 555-3620'),('REGGC','Reggiani Caseifici','Maurizio Moroni','Sales Associate','Strada Provinciale 124','Reggio Emilia','','42100','Italy','0522-556721','0522-556722'),('RICAR','Ricardo Adocicados','Janete Limeira','Assistant Sales Agent','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil','(21) 555-3412',''),('RICSU','Richter Supermarkt','Michael Holz','Sales Manager','Grenzacherweg 237','Gen?ve','','1203','Switzerland','0897-034214',''),('ROMEY','Romero y tomillo','Alejandra Camino','Accounting Manager','Gran V?a, 1','Madrid','','28001','Spain','(91) 745 6200','(91) 745 6210'),('SANTG','Sant? Gourmet','Jonas Bergulfsen','Owner','Erling Skakkes gate 78','Stavern','','4110','Norway','07-98 92 35','07-98 92 47'),('SAVEA','Save-a-lot Markets','Jose Pavarotti','Sales Representative','187 Suffolk Ln.','Boise','ID','83720','United States','(208) 555-8097',''),('SEVES','Seven Seas Imports','Hari Kumar','Sales Manager','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom','(171) 555-1717','(171) 555-5646'),('SIMOB','Simons bistro','Jytte Petersen','Owner','Vinb?ltet 34','K?benhavn','','1734','Denmark','31 12 34 56','31 13 35 57'),('SPECD','Sp?cialit?s du monde','Dominique Perrier','Marketing Manager','25, rue Lauriston','Paris','','75016','France','(1) 47.55.60.10','(1) 47.55.60.20'),('SPLIR','Split Rail Beer & Ale','Art Braunschweiger','Sales Manager','P.O. Box 555','Lander','WY','82520','United States','(307) 555-4680','(307) 555-6525'),('SUPRD','Supr?mes d?lices','Pascale Cartrain','Accounting Manager','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium','(071) 23 67 22 20','(071) 23 67 22 21'),('THEBI','The Big Cheese','Liz Nixon','Marketing Manager','89 Jefferson Way\r\nSuite 2','Portland','OR','97201','United States','(503) 555-3612',''),('THECR','The Cracker Box','Liu Wong','Marketing Assistant','55 Grizzly Peak Rd.','Butte','MT','59801','United States','(406) 555-5834','(406) 555-8083'),('TOMSP','Toms Spezialit?ten','Karin Josephs','Marketing Manager','Luisenstr. 48','M?nster','','44087','Germany','0251-031259','0251-035695'),('TORTU','Tortuga Restaurante','Miguel Angel Paolino','Owner','Avda. Azteca 123','M?xico D.F.','','05033','Mexico','(5) 555-2933',''),('TRADH','Tradi??o Hipermercados','Anabela Domingues','Sales Representative','Av. In?s de Castro, 414','S?o Paulo','SP','05634-030','Brazil','(11) 555-2167','(11) 555-2168'),('TRAIH','Trail\'s Head Gourmet Provisioners','Helvetius Nagy','Sales Associate','722 DaVinci Blvd.','Kirkland','WA','98034','United States','(206) 555-8257','(206) 555-2174'),('VAFFE','Vaffeljernet','Palle Ibsen','Sales Manager','Smagsl?get 45','?rhus','','8200','Denmark','86 21 32 43','86 22 33 44'),('VICTE','Victuailles en stock','Mary Saveley','Sales Agent','2, rue du Commerce','Lyon','','69004','France','78.32.54.86','78.32.54.87'),('VINET','Vins et alcools Chevalier','Paul Henriot','Accounting Manager','59 rue de l\'Abbaye','Reims','','51100','France','26.47.15.10','26.47.15.11'),('WANDK','Die Wandernde Kuh','Rita M?ller','Sales Representative','Adenauerallee 900','Stuttgart','','70563','Germany','0711-020361','0711-035428'),('WARTH','Wartian Herkku','Pirkko Koskitalo','Accounting Manager','Torikatu 38','Oulu','','90110','Finland','981-443655','981-443655'),('WELLI','Wellington Importadora','Paula Parente','Sales Manager','Rua do Mercado, 12','Resende','SP','08737-363','Brazil','(14) 555-8122',''),('WHITC','White Clover Markets','Karl Jablonski','Owner','305 - 14th Ave. S.\r\nSuite 3B','Seattle','WA','98128','United States','(206) 555-4112','(206) 555-4115'),('WILMK','Wilman Kala','Matti Karttunen','Owner/Marketing Assistant','Keskuskatu 45','Helsinki','','21240','Finland','90-224 8858','90-224 8858'),('WOLZA','Wolski  Zajazd','Zbyszek Piestrzeniewicz','Owner','ul. Filtrowa 68','Warszawa','','01-012','Poland','(26) 642-7012','(26) 642-7012');
UNLOCK TABLES;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;

--
-- Table structure for table `employees`
--

DROP TABLE IF EXISTS `employees`;
CREATE TABLE `employees` (
  `EmployeeID` int(11) NOT NULL AUTO_INCREMENT,
  `LastName` varchar(20) DEFAULT NULL,
  `FirstName` varchar(10) DEFAULT NULL,
  `Title` varchar(30) DEFAULT NULL,
  `TitleOfCourtesy` varchar(25) DEFAULT NULL,
  `BirthDate` date DEFAULT NULL,
  `HireDate` date DEFAULT NULL,
  `Address` varchar(60) DEFAULT NULL,
  `City` varchar(15) DEFAULT NULL,
  `Region` varchar(15) DEFAULT NULL,
  `PostalCode` varchar(10) DEFAULT NULL,
  `Country` varchar(15) DEFAULT NULL,
  `HomePhone` varchar(24) DEFAULT NULL,
  `Extension` varchar(4) DEFAULT NULL,
  `Photo` varchar(40) DEFAULT NULL,
  `Notes` text,
  `ReportsTo` int(11) DEFAULT NULL,
  PRIMARY KEY (`EmployeeID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `employees`
--


/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
LOCK TABLES `employees` WRITE;
INSERT INTO `employees` VALUES (1,'Davolio','Nancy','Sales Representative','Ms.','1968-12-08','1992-05-01','507 - 20th Ave. E.\r\nApt. 2A','Seattle','WA','98122','United States','(206) 555-9857','5467','','Education includes a BA in psychology from Colorado State University.  She also completed \"The Art of the Cold Call.\"  Nancy is a member of Toastmasters International.',2),(2,'Fuller','Andrew','Vice President, Sales','Dr.','1952-02-19','1992-08-14','908 W. Capital Way','Tacoma','WA','98401','United States','(206) 555-9482','3457','','Andrew received his BTS commercial and a Ph.D. in international marketing from the University of Dallas.  He is fluent in French and Italian and reads German.  He joined the company as a sales representative, was promoted to sales manager and was then named vice president of sales.  Andrew is a member of the Sales Management Roundtable, the Seattle Chamber of Commerce, and the Pacific Rim Importers Association.',0),(3,'Leverling','Janet','Sales Representative','Ms.','1963-08-30','1992-04-01','722 Moss Bay Blvd.','Kirkland','WA','98033','United States','(206) 555-3412','3355','','Janet has a BS degree in chemistry from Boston College).  She has also completed a certificate program in food retailing management.  Janet was hired as a sales associate and was promoted to sales representative.',2),(4,'Peacock','Margaret','Sales Representative','Mrs.','1958-09-19','1993-05-03','4110 Old Redmond Rd.','Redmond','WA','98052','United States','(206) 555-8122','5176','','Margaret holds a BA in English literature from Concordia College and an MA from the American Institute of Culinary Arts. She was temporarily assigned to the London office before returning to her permanent post in Seattle.',2),(5,'Buchanan','Steven','Sales Manager','Mr.','1955-03-04','1993-10-17','14 Garrett Hill','London','','SW1 8JR','United Kingdom','(71) 555-4848','3453','','Steven Buchanan graduated from St. Andrews University, Scotland, with a BSC degree.  Upon joining the company as a sales representative, he spent 6 months in an orientation program at the Seattle office and then returned to his permanent post in London, where he was promoted to sales manager.  Mr. Buchanan has completed the courses \"Successful Telemarketing\" and \"International Sales Management.\"  He is fluent in French.',2),(6,'Suyama','Michael','Sales Representative','Mr.','1963-07-02','1993-10-17','Coventry House\r\nMiner Rd.','London','','EC2 7JR','United Kingdom','(71) 555-7773','428','','Michael is a graduate of Sussex University (MA, economics) and the University of California at Los Angeles (MBA, marketing).  He has also taken the courses \"Multi-Cultural Selling\" and \"Time Management for the Sales Professional.\"  He is fluent in Japanese and can read and write French, Portuguese, and Spanish.',5),(7,'King','Robert','Sales Representative','Mr.','1960-05-29','1994-01-02','Edgeham Hollow\r\nWinchester Way','London','','RG1 9SP','United Kingdom','(71) 555-5598','465','','Robert King served in the Peace Corps and traveled extensively before completing his degree in English at the University of Michigan and then joining the company.  After completing a course entitled \"Selling in Europe,\" he was transferred to the London office.',5),(8,'Callahan','Laura','Inside Sales Coordinator','Ms.','1958-01-09','1994-03-05','4726 - 11th Ave. N.E.','Seattle','WA','98105','United States','(206) 555-1189','2344','','Laura received a BA in psychology from the University of Washington.  She has also completed a course in business French.  She reads and writes French.',2),(9,'Dodsworth','Anne','Sales Representative','Ms.','1969-07-02','1994-11-15','7 Houndstooth Rd.','London','','WG2 7LT','United Kingdom','(71) 555-4444','452','','Anne has a BA degree in English from St. Lawrence College.  She is fluent in French and German.',5);
UNLOCK TABLES;
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;

--
-- Table structure for table `order_details`
--

DROP TABLE IF EXISTS `order_details`;
CREATE TABLE `order_details` (
  `odID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `OrderID` int(11) DEFAULT '0',
  `ProductID` int(11) DEFAULT '0',
  `UnitPrice` float(10,2) DEFAULT '0.00',
  `Quantity` smallint(6) DEFAULT '1',
  `Discount` float(1,0) DEFAULT '0',
  PRIMARY KEY (`odID`)
) ENGINE=InnoDB AUTO_INCREMENT=2156 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `order_details`
--


/*!40000 ALTER TABLE `order_details` DISABLE KEYS */;
LOCK TABLES `order_details` WRITE;
INSERT INTO `order_details` VALUES (1,10248,11,294.73,12,0),(2,10248,42,611.91,10,0),(3,10248,72,174.35,5,0),(4,10249,14,35.00,9,0),(5,10249,51,650.98,40,0),(6,10250,41,148.90,10,0),(7,10250,51,790.57,35,0),(8,10250,65,505.15,15,0),(9,10251,22,153.02,6,0),(10,10251,57,248.67,15,0),(11,10251,65,783.29,20,0),(12,10252,20,169.45,40,0),(13,10252,33,496.39,25,0),(14,10252,60,972.58,40,0),(15,10253,31,372.72,20,0),(16,10253,39,944.85,42,0),(17,10253,49,605.11,40,0),(18,10254,24,190.00,15,0),(19,10254,55,133.65,21,0),(20,10254,74,97.27,21,0),(21,10255,2,84.40,20,0),(22,10255,16,129.19,35,0),(23,10255,36,391.77,25,0),(24,10255,59,570.26,30,0),(25,10256,53,674.97,15,0),(26,10256,77,663.10,12,0),(27,10257,27,289.58,25,0),(28,10257,39,457.62,6,0),(29,10257,77,418.35,15,0),(30,10258,2,717.90,50,0),(31,10258,5,333.42,65,0),(32,10258,32,512.43,6,0),(33,10259,21,560.87,10,0),(34,10259,37,266.05,1,0),(35,10260,41,646.66,16,0),(36,10260,57,434.14,50,0),(37,10260,62,229.73,15,0),(38,10260,70,845.21,21,0),(39,10261,21,535.87,20,0),(40,10261,35,142.73,20,0),(41,10262,5,105.03,12,0),(42,10262,7,95.98,15,0),(43,10262,56,163.79,2,0),(44,10263,16,530.01,60,0),(45,10263,24,157.68,28,0),(46,10263,30,197.37,60,0),(47,10263,74,512.80,36,0),(48,10264,2,970.90,35,0),(49,10264,41,315.10,25,0),(50,10265,17,661.81,30,0),(51,10265,70,362.74,20,0),(52,10266,12,827.26,12,0),(53,10267,40,47.10,50,0),(54,10267,59,752.73,70,0),(55,10267,76,621.33,15,0),(56,10268,29,847.48,10,0),(57,10268,72,372.40,4,0),(58,10269,33,318.55,60,0),(59,10269,72,474.54,20,0),(60,10270,36,416.06,30,0),(61,10270,43,655.70,25,0),(62,10271,33,29.29,24,0),(63,10272,20,178.36,6,0),(64,10272,31,802.93,40,0),(65,10272,72,478.59,24,0),(66,10273,10,983.13,24,0),(67,10273,31,478.87,15,0),(68,10273,33,443.99,20,0),(69,10273,40,782.33,60,0),(70,10273,76,578.68,33,0),(71,10274,71,545.43,20,0),(72,10274,72,990.08,7,0),(73,10275,24,313.10,12,0),(74,10275,59,594.28,6,0),(75,10276,10,31.09,15,0),(76,10276,13,371.62,10,0),(77,10277,28,763.84,20,0),(78,10277,62,703.32,12,0),(79,10278,44,224.11,16,0),(80,10278,59,9.56,15,0),(81,10278,63,374.48,8,0),(82,10278,73,842.73,25,0),(83,10279,17,89.21,15,0),(84,10280,24,916.86,12,0),(85,10280,55,315.66,20,0),(86,10280,75,826.74,30,0),(87,10281,19,185.72,1,0),(88,10281,24,447.35,6,0),(89,10281,35,678.61,4,0),(90,10282,30,50.00,6,0),(91,10282,57,213.17,2,0),(92,10283,15,914.84,20,0),(93,10283,19,933.72,18,0),(94,10283,60,923.05,35,0),(95,10283,72,813.10,3,0),(96,10284,27,295.33,15,0),(97,10284,44,36.37,21,0),(98,10284,60,294.85,20,0),(99,10284,67,364.15,5,0),(100,10285,1,935.19,45,0),(101,10285,40,582.51,40,0),(102,10285,53,105.96,36,0),(103,10286,35,781.27,100,0),(104,10286,62,587.47,40,0),(105,10287,16,592.56,40,0),(106,10287,34,199.36,20,0),(107,10287,46,218.14,15,0),(108,10288,54,491.59,10,0),(109,10288,68,802.57,3,0),(110,10289,3,537.06,30,0),(111,10289,64,276.59,9,0),(112,10290,5,770.79,20,0),(113,10290,29,23.17,15,0),(114,10290,49,802.50,15,0),(115,10290,77,941.97,10,0),(116,10291,13,301.37,20,0),(117,10291,44,679.95,24,0),(118,10291,51,494.61,2,0),(119,10292,20,432.20,20,0),(120,10293,18,676.17,12,0),(121,10293,24,83.26,10,0),(122,10293,63,386.80,5,0),(123,10293,75,683.23,6,0),(124,10294,1,254.72,18,0),(125,10294,17,222.91,15,0),(126,10294,43,349.39,15,0),(127,10294,60,77.22,21,0),(128,10294,75,336.92,6,0),(129,10295,56,451.97,4,0),(130,10296,11,248.08,12,0),(131,10296,16,883.47,30,0),(132,10296,69,672.12,15,0),(133,10297,39,709.21,60,0),(134,10297,72,528.66,20,0),(135,10298,2,514.68,40,0),(136,10298,36,986.44,40,0),(137,10298,59,387.14,30,0),(138,10298,62,975.39,15,0),(139,10299,19,714.53,15,0),(140,10299,70,645.47,20,0),(141,10300,66,82.74,30,0),(142,10300,68,476.33,20,0),(143,10301,40,132.41,10,0),(144,10301,56,232.06,20,0),(145,10302,17,762.07,40,0),(146,10302,28,113.16,28,0),(147,10302,43,278.61,12,0),(148,10303,40,52.57,40,0),(149,10303,65,426.02,30,0),(150,10303,68,971.37,15,0),(151,10304,49,577.81,30,0),(152,10304,59,973.95,10,0),(153,10304,71,135.31,2,0),(154,10305,18,753.71,25,0),(155,10305,29,361.61,25,0),(156,10305,39,545.93,30,0),(157,10306,30,643.82,10,0),(158,10306,53,580.29,10,0),(159,10306,54,969.00,5,0),(160,10307,62,103.12,10,0),(161,10307,68,607.62,3,0),(162,10308,69,727.72,1,0),(163,10308,70,814.76,5,0),(164,10309,4,889.62,20,0),(165,10309,6,2.83,30,0),(166,10309,42,344.27,2,0),(167,10309,43,711.89,20,0),(168,10309,71,525.64,3,0),(169,10310,16,491.53,10,0),(170,10310,62,879.74,5,0),(171,10311,42,923.10,6,0),(172,10311,69,975.28,7,0),(173,10312,28,106.08,4,0),(174,10312,43,603.57,24,0),(175,10312,53,698.62,20,0),(176,10312,75,681.40,10,0),(177,10313,36,310.15,12,0),(178,10314,32,505.52,40,0),(179,10314,58,596.16,30,0),(180,10314,62,463.23,25,0),(181,10315,34,526.68,14,0),(182,10315,70,242.72,30,0),(183,10316,41,632.54,10,0),(184,10316,62,433.53,70,0),(185,10317,1,269.05,20,0),(186,10318,41,43.67,20,0),(187,10318,76,410.20,6,0),(188,10319,17,918.99,8,0),(189,10319,28,363.35,14,0),(190,10319,76,58.79,30,0),(191,10320,71,202.90,30,0),(192,10321,35,837.14,10,0),(193,10322,52,576.00,20,0),(194,10323,15,367.56,5,0),(195,10323,25,108.82,4,0),(196,10323,39,440.41,4,0),(197,10324,16,874.60,21,0),(198,10324,35,50.76,70,0),(199,10324,46,628.99,30,0),(200,10324,59,991.68,40,0),(201,10324,63,70.41,80,0),(202,10325,6,376.03,6,0),(203,10325,13,667.92,12,0),(204,10325,14,210.50,9,0),(205,10325,31,47.73,4,0),(206,10325,72,606.18,40,0),(207,10326,4,886.68,24,0),(208,10326,57,613.86,16,0),(209,10326,75,408.28,50,0),(210,10327,2,198.82,25,0),(211,10327,11,768.24,50,0),(212,10327,30,243.76,35,0),(213,10327,58,913.07,30,0),(214,10328,59,833.06,9,0),(215,10328,65,425.11,40,0),(216,10328,68,625.37,10,0),(217,10329,19,850.53,10,0),(218,10329,30,375.52,8,0),(219,10329,38,325.00,20,0),(220,10329,56,497.47,12,0),(221,10330,26,511.33,50,0),(222,10330,72,63.24,25,0),(223,10331,54,781.20,15,0),(224,10332,18,715.29,40,0),(225,10332,42,231.84,10,0),(226,10332,47,12.33,16,0),(227,10333,14,365.12,10,0),(228,10333,21,787.64,10,0),(229,10333,71,841.81,40,0),(230,10334,52,845.12,8,0),(231,10334,68,699.19,10,0),(232,10335,2,959.58,7,0),(233,10335,31,699.35,25,0),(234,10335,32,617.00,6,0),(235,10335,51,985.96,48,0),(236,10336,4,77.81,18,0),(237,10337,23,430.15,40,0),(238,10337,26,916.33,24,0),(239,10337,36,290.20,20,0),(240,10337,37,701.01,28,0),(241,10337,72,633.45,25,0),(242,10338,17,63.22,20,0),(243,10338,30,414.74,15,0),(244,10339,4,883.06,10,0),(245,10339,17,170.08,70,0),(246,10339,62,200.22,28,0),(247,10340,18,489.86,20,0),(248,10340,41,847.66,12,0),(249,10340,43,767.69,40,0),(250,10341,33,294.47,8,0),(251,10341,59,168.29,9,0),(252,10342,2,957.04,24,0),(253,10342,31,279.34,56,0),(254,10342,36,524.58,40,0),(255,10342,55,783.89,40,0),(256,10343,64,344.70,50,0),(257,10343,68,370.83,4,0),(258,10343,76,819.04,15,0),(259,10344,4,981.71,35,0),(260,10344,8,450.45,70,0),(261,10345,8,306.13,70,0),(262,10345,19,178.28,80,0),(263,10345,42,972.01,9,0),(264,10346,17,324.19,36,0),(265,10346,56,703.95,20,0),(266,10347,25,546.15,10,0),(267,10347,39,617.92,50,0),(268,10347,40,450.16,4,0),(269,10347,75,396.03,6,0),(270,10348,1,628.67,15,0),(271,10348,23,954.25,25,0),(272,10349,54,884.23,24,0),(273,10350,50,557.43,15,0),(274,10350,69,133.46,18,0),(275,10351,38,993.99,20,0),(276,10351,41,568.58,13,0),(277,10351,44,859.93,77,0),(278,10351,65,592.91,10,0),(279,10352,24,383.75,10,0),(280,10352,54,139.04,20,0),(281,10353,11,542.95,12,0),(282,10353,38,296.64,50,0),(283,10354,1,853.32,12,0),(284,10354,29,375.70,4,0),(285,10355,24,317.53,25,0),(286,10355,57,459.56,25,0),(287,10356,31,344.21,30,0),(288,10356,55,341.37,12,0),(289,10356,69,673.22,20,0),(290,10357,10,340.98,30,0),(291,10357,26,684.24,16,0),(292,10357,60,397.27,8,0),(293,10358,24,932.61,10,0),(294,10358,34,470.24,10,0),(295,10358,36,552.36,20,0),(296,10359,16,350.08,56,0),(297,10359,31,92.33,70,0),(298,10359,60,410.43,80,0),(299,10360,28,774.13,30,0),(300,10360,29,638.39,35,0),(301,10360,38,868.55,10,0),(302,10360,49,426.60,35,0),(303,10360,54,526.32,28,0),(304,10361,39,350.80,54,0),(305,10361,60,174.05,55,0),(306,10362,25,816.85,50,0),(307,10362,51,561.10,20,0),(308,10362,54,353.96,24,0),(309,10363,31,85.50,20,0),(310,10363,75,364.60,12,0),(311,10363,76,565.53,12,0),(312,10364,69,732.84,30,0),(313,10364,71,966.61,5,0),(314,10365,11,633.52,24,0),(315,10366,65,266.77,5,0),(316,10366,77,432.31,5,0),(317,10367,34,360.24,36,0),(318,10367,54,503.27,18,0),(319,10367,65,434.63,15,0),(320,10367,77,662.33,7,0),(321,10368,21,6.78,5,0),(322,10368,28,45.90,13,0),(323,10368,57,208.18,25,0),(324,10368,64,902.17,35,0),(325,10369,29,885.32,20,0),(326,10369,56,719.08,18,0),(327,10370,1,938.45,15,0),(328,10370,64,534.02,30,0),(329,10370,74,853.73,20,0),(330,10371,36,665.59,6,0),(331,10372,20,765.78,12,0),(332,10372,38,831.12,40,0),(333,10372,60,857.28,70,0),(334,10372,72,792.03,42,0),(335,10373,58,387.29,80,0),(336,10373,71,559.37,50,0),(337,10374,31,633.98,30,0),(338,10374,58,490.79,15,0),(339,10375,14,551.01,15,0),(340,10375,54,281.70,10,0),(341,10376,31,754.45,42,0),(342,10377,28,926.14,20,0),(343,10377,39,366.35,20,0),(344,10378,71,52.32,6,0),(345,10379,41,161.55,8,0),(346,10379,63,649.79,16,0),(347,10379,65,763.30,20,0),(348,10380,30,866.14,18,0),(349,10380,53,39.79,20,0),(350,10380,60,599.53,6,0),(351,10380,70,877.29,30,0),(352,10381,74,586.86,14,0),(353,10382,5,301.41,32,0),(354,10382,18,745.50,9,0),(355,10382,29,822.27,14,0),(356,10382,33,873.84,60,0),(357,10382,74,901.38,50,0),(358,10383,13,884.40,20,0),(359,10383,50,716.84,15,0),(360,10383,56,930.01,20,0),(361,10384,20,498.52,28,0),(362,10384,60,701.56,15,0),(363,10385,7,11.26,10,0),(364,10385,60,950.60,20,0),(365,10385,68,718.21,8,0),(366,10386,24,738.28,15,0),(367,10386,34,535.74,10,0),(368,10387,24,462.87,15,0),(369,10387,28,706.12,6,0),(370,10387,59,140.99,12,0),(371,10387,71,585.60,15,0),(372,10388,45,504.03,15,0),(373,10388,52,762.33,20,0),(374,10388,53,298.58,40,0),(375,10389,10,204.89,16,0),(376,10389,55,127.72,15,0),(377,10389,62,22.91,20,0),(378,10389,70,730.41,30,0),(379,10390,31,582.31,60,0),(380,10390,35,719.34,40,0),(381,10390,46,848.75,45,0),(382,10390,72,84.72,24,0),(383,10391,13,876.37,18,0),(384,10392,69,126.71,50,0),(385,10393,2,3.40,25,0),(386,10393,14,635.90,42,0),(387,10393,25,168.27,7,0),(388,10393,26,932.66,70,0),(389,10393,31,157.51,32,0),(390,10394,13,988.57,10,0),(391,10394,62,469.29,10,0),(392,10395,46,379.76,28,0),(393,10395,53,489.93,70,0),(394,10395,69,309.38,8,0),(395,10396,23,76.08,40,0),(396,10396,71,451.28,60,0),(397,10396,72,27.15,21,0),(398,10397,21,780.92,10,0),(399,10397,51,822.16,18,0),(400,10398,35,767.04,30,0),(401,10398,55,367.70,120,0),(402,10399,68,536.40,60,0),(403,10399,71,577.87,30,0),(404,10399,76,279.19,35,0),(405,10399,77,661.31,14,0),(406,10400,29,467.99,21,0),(407,10400,35,355.03,35,0),(408,10400,49,370.15,30,0),(409,10401,30,784.69,18,0),(410,10401,56,811.99,70,0),(411,10401,65,704.88,20,0),(412,10401,71,87.45,60,0),(413,10402,23,321.59,60,0),(414,10402,63,344.62,65,0),(415,10403,16,757.34,21,0),(416,10403,48,751.81,70,0),(417,10404,26,486.04,30,0),(418,10404,42,173.77,40,0),(419,10404,49,409.75,30,0),(420,10405,3,526.41,50,0),(421,10406,1,401.82,10,0),(422,10406,21,428.88,30,0),(423,10406,28,937.95,42,0),(424,10406,36,402.09,5,0),(425,10406,40,195.60,2,0),(426,10407,11,770.73,30,0),(427,10407,69,265.86,15,0),(428,10407,71,16.10,15,0),(429,10408,37,281.93,10,0),(430,10408,54,360.36,6,0),(431,10408,62,955.01,35,0),(432,10409,14,692.96,12,0),(433,10409,21,598.75,12,0),(434,10410,33,913.89,49,0),(435,10410,59,772.20,16,0),(436,10411,41,118.31,25,0),(437,10411,44,273.95,40,0),(438,10411,59,13.83,9,0),(439,10412,14,246.31,20,0),(440,10413,1,189.04,24,0),(441,10413,62,205.28,40,0),(442,10413,76,458.27,14,0),(443,10414,19,674.53,18,0),(444,10414,33,996.81,50,0),(445,10415,17,959.48,2,0),(446,10415,33,805.96,20,0),(447,10416,19,150.37,20,0),(448,10416,53,332.95,10,0),(449,10416,57,212.67,20,0),(450,10417,38,63.49,50,0),(451,10417,46,678.43,2,0),(452,10417,68,200.68,36,0),(453,10417,77,967.10,35,0),(454,10418,2,232.47,60,0),(455,10418,47,260.04,55,0),(456,10418,61,601.79,16,0),(457,10418,74,227.83,15,0),(458,10419,60,332.79,60,0),(459,10419,69,979.45,20,0),(460,10420,9,897.88,20,0),(461,10420,13,550.06,2,0),(462,10420,70,55.64,8,0),(463,10420,73,627.02,20,0),(464,10421,19,967.17,4,0),(465,10421,26,953.79,30,0),(466,10421,53,866.43,15,0),(467,10421,77,469.79,10,0),(468,10422,26,748.67,2,0),(469,10423,31,332.99,14,0),(470,10423,59,417.95,20,0),(471,10424,35,89.75,60,0),(472,10424,38,193.90,49,0),(473,10424,68,699.26,30,0),(474,10425,55,913.59,10,0),(475,10425,76,469.16,20,0),(476,10426,56,604.05,5,0),(477,10426,64,611.78,7,0),(478,10427,14,245.72,35,0),(479,10428,46,392.29,20,0),(480,10429,50,223.26,40,0),(481,10429,63,938.46,35,0),(482,10430,17,21.49,45,0),(483,10430,21,291.08,50,0),(484,10430,56,389.92,30,0),(485,10430,59,75.36,70,0),(486,10431,17,206.04,50,0),(487,10431,40,803.13,50,0),(488,10431,47,396.52,30,0),(489,10432,26,572.22,10,0),(490,10432,54,670.52,40,0),(491,10433,56,634.94,28,0),(492,10434,11,162.14,6,0),(493,10434,76,904.90,18,0),(494,10435,2,37.07,10,0),(495,10435,22,469.63,12,0),(496,10435,72,235.97,10,0),(497,10436,46,769.94,5,0),(498,10436,56,140.80,40,0),(499,10436,64,393.16,30,0),(500,10436,75,542.41,24,0),(501,10437,53,531.58,15,0),(502,10438,19,29.66,15,0),(503,10438,34,552.57,20,0),(504,10438,57,672.89,15,0),(505,10439,12,705.71,15,0),(506,10439,16,508.87,16,0),(507,10439,64,426.24,6,0),(508,10439,74,603.57,30,0),(509,10440,2,738.15,45,0),(510,10440,16,879.02,49,0),(511,10440,29,179.67,24,0),(512,10440,61,260.30,90,0),(513,10441,27,761.48,50,0),(514,10442,11,25.49,30,0),(515,10442,54,842.03,80,0),(516,10442,66,132.68,60,0),(517,10443,11,136.31,6,0),(518,10443,28,282.52,12,0),(519,10444,17,2.66,10,0),(520,10444,26,164.76,15,0),(521,10444,35,814.80,8,0),(522,10444,41,578.73,30,0),(523,10445,39,448.26,6,0),(524,10445,54,504.09,15,0),(525,10446,19,174.69,12,0),(526,10446,24,360.19,20,0),(527,10446,31,275.85,3,0),(528,10446,52,297.70,15,0),(529,10447,19,659.95,40,0),(530,10447,65,405.67,35,0),(531,10447,71,47.47,2,0),(532,10448,26,19.33,6,0),(533,10448,40,953.25,20,0),(534,10449,10,707.27,14,0),(535,10449,52,675.59,20,0),(536,10449,62,255.15,35,0),(537,10450,10,247.97,20,0),(538,10450,54,473.41,6,0),(539,10451,55,622.14,120,0),(540,10451,64,689.45,35,0),(541,10451,65,579.85,28,0),(542,10451,77,829.89,55,0),(543,10452,28,408.92,15,0),(544,10452,44,553.91,100,0),(545,10453,48,541.78,15,0),(546,10453,70,46.17,25,0),(547,10454,16,604.52,20,0),(548,10454,33,883.09,20,0),(549,10454,46,600.87,10,0),(550,10455,39,354.09,20,0),(551,10455,53,966.85,50,0),(552,10455,61,770.97,25,0),(553,10455,71,953.32,30,0),(554,10456,21,452.68,40,0),(555,10456,49,402.44,21,0),(556,10457,59,653.15,36,0),(557,10458,26,57.46,30,0),(558,10458,28,326.81,30,0),(559,10458,43,460.70,20,0),(560,10458,56,322.07,15,0),(561,10458,71,227.25,50,0),(562,10459,7,169.04,16,0),(563,10459,46,162.44,20,0),(564,10459,72,304.09,40,0),(565,10460,68,32.11,21,0),(566,10460,75,247.27,4,0),(567,10461,21,139.05,40,0),(568,10461,30,952.43,28,0),(569,10461,55,343.99,60,0),(570,10462,13,861.66,1,0),(571,10462,23,275.35,21,0),(572,10463,19,790.77,21,0),(573,10463,42,126.80,50,0),(574,10464,4,260.68,16,0),(575,10464,43,921.98,3,0),(576,10464,56,826.89,30,0),(577,10464,60,367.52,20,0),(578,10465,24,355.92,25,0),(579,10465,29,676.02,18,0),(580,10465,40,311.36,20,0),(581,10465,45,527.73,30,0),(582,10465,50,703.56,25,0),(583,10466,11,933.64,10,0),(584,10466,46,556.51,5,0),(585,10467,24,980.61,28,0),(586,10467,25,232.54,12,0),(587,10468,30,219.85,8,0),(588,10468,43,400.65,15,0),(589,10469,2,342.71,40,0),(590,10469,16,510.59,35,0),(591,10469,44,523.81,2,0),(592,10470,18,86.27,30,0),(593,10470,23,858.92,15,0),(594,10470,64,34.82,8,0),(595,10471,7,596.31,30,0),(596,10471,56,876.09,20,0),(597,10472,24,590.52,80,0),(598,10472,51,323.34,18,0),(599,10473,33,844.13,12,0),(600,10473,71,249.64,12,0),(601,10474,14,714.82,12,0),(602,10474,28,824.18,18,0),(603,10474,40,975.42,21,0),(604,10474,75,403.55,10,0),(605,10475,31,90.52,35,0),(606,10475,66,240.94,60,0),(607,10475,76,932.14,42,0),(608,10476,55,936.90,2,0),(609,10476,70,887.05,12,0),(610,10477,1,623.56,15,0),(611,10477,21,455.67,21,0),(612,10477,39,406.66,20,0),(613,10478,10,665.28,20,0),(614,10479,38,105.42,30,0),(615,10479,53,530.27,28,0),(616,10479,59,334.09,60,0),(617,10479,64,78.63,30,0),(618,10480,47,389.88,30,0),(619,10480,59,712.52,12,0),(620,10481,49,391.95,24,0),(621,10481,60,821.19,40,0),(622,10482,40,929.11,10,0),(623,10483,34,180.98,35,0),(624,10483,77,116.57,30,0),(625,10484,21,38.89,14,0),(626,10484,40,843.74,10,0),(627,10484,51,101.06,3,0),(628,10485,2,973.05,20,0),(629,10485,3,561.08,20,0),(630,10485,55,885.23,30,0),(631,10485,70,741.93,60,0),(632,10486,11,52.94,5,0),(633,10486,51,37.93,25,0),(634,10486,74,29.81,16,0),(635,10487,19,34.29,5,0),(636,10487,26,81.00,30,0),(637,10487,54,301.12,24,0),(638,10488,59,261.59,30,0),(639,10488,73,403.61,20,0),(640,10489,11,232.26,15,0),(641,10489,16,949.49,18,0),(642,10490,59,49.68,60,0),(643,10490,68,398.93,30,0),(644,10490,75,844.59,36,0),(645,10491,44,25.16,15,0),(646,10491,77,591.05,7,0),(647,10492,25,878.78,60,0),(648,10492,42,619.73,20,0),(649,10493,65,461.32,15,0),(650,10493,66,446.40,10,0),(651,10493,69,847.03,10,0),(652,10494,56,894.95,30,0),(653,10495,23,932.65,10,0),(654,10495,41,977.43,20,0),(655,10495,77,88.17,5,0),(656,10496,31,507.57,20,0),(657,10497,56,272.34,14,0),(658,10497,72,837.98,25,0),(659,10497,77,371.87,25,0),(660,10498,24,344.41,14,0),(661,10498,40,605.45,5,0),(662,10498,42,993.03,30,0),(663,10499,28,147.80,20,0),(664,10499,49,758.92,25,0),(665,10500,15,350.18,12,0),(666,10500,28,473.15,8,0),(667,10501,54,314.23,20,0),(668,10502,45,150.67,21,0),(669,10502,53,809.65,6,0),(670,10502,67,595.26,30,0),(671,10503,14,546.37,70,0),(672,10503,65,945.04,20,0),(673,10504,2,85.09,12,0),(674,10504,21,589.34,12,0),(675,10504,53,690.42,10,0),(676,10504,61,683.10,25,0),(677,10505,62,343.24,3,0),(678,10506,25,665.91,18,0),(679,10506,70,298.81,14,0),(680,10507,43,495.32,15,0),(681,10507,48,579.19,15,0),(682,10508,13,408.98,10,0),(683,10508,39,306.35,10,0),(684,10509,28,303.80,3,0),(685,10510,29,598.94,36,0),(686,10510,75,82.31,36,0),(687,10511,4,613.72,50,0),(688,10511,7,820.69,50,0),(689,10511,8,261.30,10,0),(690,10512,24,843.41,10,0),(691,10512,46,432.16,9,0),(692,10512,47,629.56,6,0),(693,10512,60,850.33,12,0),(694,10513,21,361.96,40,0),(695,10513,32,257.80,50,0),(696,10513,61,202.14,15,0),(697,10514,20,236.28,39,0),(698,10514,28,574.01,35,0),(699,10514,56,160.18,70,0),(700,10514,65,77.89,39,0),(701,10514,75,907.89,50,0),(702,10515,9,304.77,16,0),(703,10515,16,799.20,50,0),(704,10515,27,80.69,120,0),(705,10515,33,4.85,16,0),(706,10515,60,781.18,84,0),(707,10516,18,890.33,25,0),(708,10516,41,107.13,80,0),(709,10516,42,863.67,20,0),(710,10517,52,995.97,6,0),(711,10517,59,387.83,4,0),(712,10517,70,950.23,6,0),(713,10518,24,586.67,5,0),(714,10518,38,81.65,15,0),(715,10518,44,647.23,9,0),(716,10519,10,990.19,16,0),(717,10519,56,8.29,40,0),(718,10519,60,69.85,10,0),(719,10520,24,323.38,8,0),(720,10520,53,406.38,5,0),(721,10521,35,60.73,3,0),(722,10521,41,83.53,10,0),(723,10521,68,234.47,6,0),(724,10522,1,920.74,40,0),(725,10522,8,899.31,24,0),(726,10522,30,733.32,20,0),(727,10522,40,967.68,25,0),(728,10523,17,637.45,25,0),(729,10523,20,283.21,15,0),(730,10523,37,502.71,18,0),(731,10523,41,662.92,6,0),(732,10524,10,805.46,2,0),(733,10524,30,37.53,10,0),(734,10524,43,770.29,60,0),(735,10524,54,737.84,15,0),(736,10525,36,377.33,30,0),(737,10525,40,672.12,15,0),(738,10526,1,227.61,8,0),(739,10526,13,120.68,10,0),(740,10526,56,919.57,30,0),(741,10527,4,234.80,50,0),(742,10527,36,414.32,30,0),(743,10528,11,366.21,3,0),(744,10528,33,587.06,8,0),(745,10528,72,835.69,9,0),(746,10529,55,416.28,14,0),(747,10529,68,573.32,20,0),(748,10529,69,616.76,10,0),(749,10530,17,362.82,40,0),(750,10530,43,962.83,25,0),(751,10530,61,724.69,20,0),(752,10530,76,733.97,50,0),(753,10531,59,494.79,2,0),(754,10532,30,271.03,15,0),(755,10532,66,869.78,24,0),(756,10533,4,534.83,50,0),(757,10533,72,63.78,24,0),(758,10533,73,713.43,24,0),(759,10534,30,374.81,10,0),(760,10534,40,732.74,10,0),(761,10534,54,538.28,10,0),(762,10535,11,492.20,50,0),(763,10535,40,845.14,10,0),(764,10535,57,748.10,5,0),(765,10535,59,204.07,15,0),(766,10536,12,775.07,15,0),(767,10536,31,262.13,20,0),(768,10536,33,984.45,30,0),(769,10536,60,134.88,35,0),(770,10537,31,720.01,30,0),(771,10537,51,194.44,6,0),(772,10537,58,811.17,20,0),(773,10537,72,471.50,21,0),(774,10537,73,923.02,9,0),(775,10538,70,199.58,7,0),(776,10538,72,227.85,1,0),(777,10539,13,539.50,8,0),(778,10539,21,12.95,15,0),(779,10539,33,445.25,15,0),(780,10539,49,186.40,6,0),(781,10540,3,595.24,60,0),(782,10540,26,416.00,40,0),(783,10540,38,293.29,30,0),(784,10540,68,217.44,35,0),(785,10541,24,206.33,35,0),(786,10541,38,378.33,4,0),(787,10541,65,271.65,36,0),(788,10541,71,222.29,9,0),(789,10542,11,295.48,15,0),(790,10542,54,809.54,24,0),(791,10543,12,160.27,30,0),(792,10543,23,371.70,70,0),(793,10544,28,376.70,7,0),(794,10544,67,767.41,7,0),(795,10545,11,705.96,10,0),(796,10546,7,226.57,10,0),(797,10546,35,13.94,30,0),(798,10546,62,389.01,40,0),(799,10547,32,902.25,24,0),(800,10547,36,343.19,60,0),(801,10548,34,8.23,10,0),(802,10548,41,10.56,14,0),(803,10549,31,27.13,55,0),(804,10549,45,102.95,100,0),(805,10549,51,432.38,48,0),(806,10550,17,852.04,8,0),(807,10550,19,962.07,10,0),(808,10550,21,253.23,6,0),(809,10550,61,378.93,10,0),(810,10551,16,133.97,40,0),(811,10551,35,532.05,20,0),(812,10551,44,257.34,40,0),(813,10552,69,689.54,18,0),(814,10552,75,674.69,30,0),(815,10553,11,303.81,15,0),(816,10553,16,494.01,14,0),(817,10553,22,557.61,24,0),(818,10553,31,305.01,30,0),(819,10553,35,851.23,6,0),(820,10554,16,340.13,30,0),(821,10554,23,145.97,20,0),(822,10554,62,708.44,20,0),(823,10554,77,103.29,10,0),(824,10555,14,390.14,30,0),(825,10555,19,639.81,35,0),(826,10555,24,27.62,18,0),(827,10555,51,217.69,20,0),(828,10555,56,4.60,40,0),(829,10556,72,368.93,24,0),(830,10557,64,829.84,30,0),(831,10557,75,41.41,20,0),(832,10558,47,716.55,25,0),(833,10558,51,457.52,20,0),(834,10558,52,136.93,30,0),(835,10558,53,311.10,18,0),(836,10558,73,143.70,3,0),(837,10559,41,784.22,12,0),(838,10559,55,489.00,18,0),(839,10560,30,91.33,20,0),(840,10560,62,988.67,15,0),(841,10561,44,668.33,10,0),(842,10561,51,374.65,50,0),(843,10562,33,867.25,20,0),(844,10562,62,211.31,10,0),(845,10563,36,453.78,25,0),(846,10563,52,633.99,70,0),(847,10564,17,807.61,16,0),(848,10564,31,135.08,6,0),(849,10564,55,251.56,25,0),(850,10565,24,851.56,25,0),(851,10565,64,502.11,18,0),(852,10566,11,954.86,35,0),(853,10566,18,266.98,18,0),(854,10566,76,469.34,10,0),(855,10567,31,544.73,60,0),(856,10567,51,314.66,3,0),(857,10567,59,938.09,40,0),(858,10568,10,745.46,5,0),(859,10569,31,912.06,35,0),(860,10569,76,322.90,30,0),(861,10570,11,877.32,15,0),(862,10570,56,416.91,60,0),(863,10571,14,451.60,11,0),(864,10571,42,6.26,28,0),(865,10572,16,675.49,12,0),(866,10572,32,357.67,10,0),(867,10572,40,760.87,50,0),(868,10572,75,730.34,15,0),(869,10573,17,368.09,18,0),(870,10573,34,648.41,40,0),(871,10573,53,136.82,25,0),(872,10574,33,737.85,14,0),(873,10574,40,277.77,2,0),(874,10574,62,174.33,10,0),(875,10574,64,37.35,6,0),(876,10575,59,662.75,12,0),(877,10575,63,200.71,6,0),(878,10575,72,14.28,30,0),(879,10575,76,468.27,10,0),(880,10576,1,297.53,10,0),(881,10576,31,81.81,20,0),(882,10576,44,515.47,21,0),(883,10577,39,330.93,10,0),(884,10577,75,107.25,20,0),(885,10577,77,542.45,18,0),(886,10578,35,389.49,20,0),(887,10578,57,319.10,6,0),(888,10579,15,426.03,10,0),(889,10579,75,171.84,21,0),(890,10580,14,580.13,15,0),(891,10580,41,384.12,9,0),(892,10580,65,179.22,30,0),(893,10581,75,742.75,50,0),(894,10582,57,175.07,4,0),(895,10582,76,646.11,14,0),(896,10583,29,704.34,10,0),(897,10583,60,582.39,24,0),(898,10583,69,797.90,10,0),(899,10584,31,241.34,50,0),(900,10585,47,811.99,15,0),(901,10586,52,334.94,4,0),(902,10587,26,237.73,6,0),(903,10587,35,182.82,20,0),(904,10587,77,199.92,20,0),(905,10588,18,450.13,40,0),(906,10588,42,649.88,100,0),(907,10589,35,898.02,4,0),(908,10590,1,539.44,20,0),(909,10590,77,2.15,60,0),(910,10591,3,391.45,14,0),(911,10591,7,949.80,10,0),(912,10591,54,573.65,50,0),(913,10592,15,17.84,25,0),(914,10592,26,367.26,5,0),(915,10593,20,781.76,21,0),(916,10593,69,806.01,20,0),(917,10593,76,683.79,4,0),(918,10594,52,999.93,24,0),(919,10594,58,947.25,30,0),(920,10595,35,735.49,30,0),(921,10595,61,834.67,120,0),(922,10595,69,965.91,65,0),(923,10596,56,324.51,5,0),(924,10596,63,723.84,24,0),(925,10596,75,644.68,30,0),(926,10597,24,50.87,35,0),(927,10597,57,319.30,20,0),(928,10597,65,442.91,12,0),(929,10598,27,255.65,50,0),(930,10598,71,948.53,9,0),(931,10599,62,974.69,10,0),(932,10600,54,26.84,4,0),(933,10600,73,209.13,30,0),(934,10601,13,964.15,60,0),(935,10601,59,192.37,35,0),(936,10602,77,68.38,5,0),(937,10603,22,763.80,48,0),(938,10603,49,612.87,25,0),(939,10604,48,771.96,6,0),(940,10604,76,20.16,10,0),(941,10605,16,783.95,30,0),(942,10605,59,858.24,20,0),(943,10605,60,938.36,70,0),(944,10605,71,116.08,15,0),(945,10606,4,764.32,20,0),(946,10606,55,472.38,20,0),(947,10606,62,67.93,10,0),(948,10607,7,921.51,45,0),(949,10607,17,402.76,100,0),(950,10607,33,248.26,14,0),(951,10607,40,32.02,42,0),(952,10607,72,414.34,12,0),(953,10608,56,974.63,28,0),(954,10609,1,629.12,3,0),(955,10609,10,220.73,10,0),(956,10609,21,215.27,6,0),(957,10610,36,413.18,21,0),(958,10611,1,419.09,6,0),(959,10611,2,854.92,10,0),(960,10611,60,16.31,15,0),(961,10612,10,515.82,70,0),(962,10612,36,529.14,55,0),(963,10612,49,97.24,18,0),(964,10612,60,897.77,40,0),(965,10612,76,196.15,80,0),(966,10613,13,286.44,8,0),(967,10613,75,842.73,40,0),(968,10614,11,353.35,14,0),(969,10614,21,237.56,8,0),(970,10614,39,126.73,5,0),(971,10615,55,919.97,5,0),(972,10616,38,218.65,15,0),(973,10616,56,332.37,14,0),(974,10616,70,4.87,15,0),(975,10616,71,26.24,15,0),(976,10617,59,115.62,30,0),(977,10618,6,498.35,70,0),(978,10618,56,143.90,20,0),(979,10618,68,223.45,15,0),(980,10619,21,684.53,42,0),(981,10619,22,751.34,40,0),(982,10620,24,702.07,5,0),(983,10620,52,255.36,5,0),(984,10621,19,169.56,5,0),(985,10621,23,80.75,10,0),(986,10621,70,894.05,20,0),(987,10621,71,227.00,15,0),(988,10622,2,451.86,20,0),(989,10622,68,577.29,18,0),(990,10623,14,529.88,21,0),(991,10623,19,916.54,15,0),(992,10623,21,992.07,25,0),(993,10623,24,209.71,3,0),(994,10623,35,71.36,30,0),(995,10624,28,726.65,10,0),(996,10624,29,418.17,6,0),(997,10624,44,909.93,10,0),(998,10625,14,294.10,3,0),(999,10625,42,739.73,5,0),(1000,10625,60,815.35,10,0),(1001,10626,53,856.54,12,0),(1002,10626,60,835.66,20,0),(1003,10626,71,607.68,20,0),(1004,10627,62,530.41,15,0),(1005,10627,73,828.01,35,0),(1006,10628,1,547.84,25,0),(1007,10629,29,254.16,20,0),(1008,10629,64,626.29,9,0),(1009,10630,55,367.96,12,0),(1010,10630,76,959.94,35,0),(1011,10631,75,694.82,8,0),(1012,10632,2,593.29,30,0),(1013,10632,33,881.00,20,0),(1014,10633,12,624.12,36,0),(1015,10633,13,476.60,13,0),(1016,10633,26,509.63,35,0),(1017,10633,62,117.36,80,0),(1018,10634,7,56.91,35,0),(1019,10634,18,931.45,50,0),(1020,10634,51,485.55,15,0),(1021,10634,75,632.39,2,0),(1022,10635,4,704.29,10,0),(1023,10635,5,623.27,15,0),(1024,10635,22,2.49,40,0),(1025,10636,4,141.64,25,0),(1026,10636,58,699.72,6,0),(1027,10637,11,72.68,10,0),(1028,10637,50,263.24,25,0),(1029,10637,56,97.17,60,0),(1030,10638,45,695.13,20,0),(1031,10638,65,183.13,21,0),(1032,10638,72,829.25,60,0),(1033,10639,18,595.89,8,0),(1034,10640,69,490.68,20,0),(1035,10640,70,664.73,15,0),(1036,10641,2,850.62,50,0),(1037,10641,40,257.93,60,0),(1038,10642,21,736.76,30,0),(1039,10642,61,909.01,20,0),(1040,10643,28,333.76,15,0),(1041,10643,39,940.80,21,0),(1042,10643,46,701.70,2,0),(1043,10644,18,685.10,4,0),(1044,10644,43,319.39,20,0),(1045,10644,46,540.67,21,0),(1046,10645,18,744.17,20,0),(1047,10645,36,97.84,15,0),(1048,10646,1,255.70,15,0),(1049,10646,10,983.97,18,0),(1050,10646,71,151.74,30,0),(1051,10646,77,805.79,35,0),(1052,10647,19,572.75,30,0),(1053,10647,39,445.39,20,0),(1054,10648,22,507.69,15,0),(1055,10648,24,201.28,15,0),(1056,10649,28,482.34,20,0),(1057,10649,72,806.86,15,0),(1058,10650,30,586.28,30,0),(1059,10650,53,509.82,25,0),(1060,10650,54,789.27,30,0),(1061,10651,19,415.90,12,0),(1062,10651,22,710.69,20,0),(1063,10652,30,304.73,2,0),(1064,10652,42,390.58,20,0),(1065,10653,16,37.70,30,0),(1066,10653,60,15.79,20,0),(1067,10654,4,964.84,12,0),(1068,10654,39,775.82,20,0),(1069,10654,54,983.60,6,0),(1070,10655,41,589.52,20,0),(1071,10656,14,995.81,3,0),(1072,10656,44,209.48,28,0),(1073,10656,47,58.97,6,0),(1074,10657,15,665.41,50,0),(1075,10657,41,149.13,24,0),(1076,10657,46,748.44,45,0),(1077,10657,47,293.82,10,0),(1078,10657,56,222.76,45,0),(1079,10657,60,231.36,30,0),(1080,10658,21,487.52,60,0),(1081,10658,40,742.51,70,0),(1082,10658,60,249.01,55,0),(1083,10658,77,16.51,70,0),(1084,10659,31,334.53,20,0),(1085,10659,40,622.10,24,0),(1086,10659,70,105.92,40,0),(1087,10660,20,662.28,21,0),(1088,10661,39,992.65,3,0),(1089,10661,58,975.43,49,0),(1090,10662,68,898.18,10,0),(1091,10663,40,563.63,30,0),(1092,10663,42,122.59,30,0),(1093,10663,51,921.09,20,0),(1094,10664,10,236.65,24,0),(1095,10664,56,418.99,12,0),(1096,10664,65,383.99,15,0),(1097,10665,51,661.99,20,0),(1098,10665,59,156.96,1,0),(1099,10665,76,797.84,10,0),(1100,10666,29,517.32,36,0),(1101,10666,65,192.07,10,0),(1102,10667,69,407.38,45,0),(1103,10667,71,459.71,14,0),(1104,10668,31,75.42,8,0),(1105,10668,55,996.96,4,0),(1106,10668,64,757.53,15,0),(1107,10669,36,795.77,30,0),(1108,10670,23,705.26,32,0),(1109,10670,46,137.99,60,0),(1110,10670,67,573.16,25,0),(1111,10670,73,450.85,50,0),(1112,10670,75,533.74,25,0),(1113,10671,16,315.18,10,0),(1114,10671,62,973.67,10,0),(1115,10671,65,921.82,12,0),(1116,10672,38,687.10,15,0),(1117,10672,71,669.05,12,0),(1118,10673,16,282.92,3,0),(1119,10673,42,406.44,6,0),(1120,10673,43,182.47,6,0),(1121,10674,23,692.03,5,0),(1122,10675,14,911.73,30,0),(1123,10675,53,481.57,10,0),(1124,10675,58,671.66,30,0),(1125,10676,10,912.57,2,0),(1126,10676,19,546.89,7,0),(1127,10676,44,995.74,21,0),(1128,10677,26,337.03,30,0),(1129,10677,33,696.93,8,0),(1130,10678,12,472.57,100,0),(1131,10678,33,271.03,30,0),(1132,10678,41,936.46,120,0),(1133,10678,54,868.21,30,0),(1134,10679,59,530.67,12,0),(1135,10680,16,47.70,50,0),(1136,10680,31,645.49,20,0),(1137,10680,42,83.36,40,0),(1138,10681,19,479.33,30,0),(1139,10681,21,145.57,12,0),(1140,10681,64,288.84,28,0),(1141,10682,33,6.52,30,0),(1142,10682,66,165.09,4,0),(1143,10682,75,804.86,30,0),(1144,10683,52,528.05,9,0),(1145,10684,40,224.66,20,0),(1146,10684,47,538.14,40,0),(1147,10684,60,15.73,30,0),(1148,10685,10,463.24,20,0),(1149,10685,41,268.00,4,0),(1150,10685,47,949.27,15,0),(1151,10686,17,941.36,30,0),(1152,10686,26,858.01,15,0),(1153,10687,9,464.96,50,0),(1154,10687,29,749.75,10,0),(1155,10687,36,352.87,6,0),(1156,10688,10,514.12,18,0),(1157,10688,28,510.98,60,0),(1158,10688,34,11.54,14,0),(1159,10689,1,523.77,35,0),(1160,10690,56,583.22,20,0),(1161,10690,77,343.80,30,0),(1162,10691,1,968.32,30,0),(1163,10691,29,809.19,40,0),(1164,10691,43,140.01,40,0),(1165,10691,44,271.48,24,0),(1166,10691,62,936.36,48,0),(1167,10692,63,866.37,20,0),(1168,10693,9,521.77,6,0),(1169,10693,54,8.73,60,0),(1170,10693,69,477.34,30,0),(1171,10693,73,359.53,15,0),(1172,10694,7,364.60,90,0),(1173,10694,59,743.44,25,0),(1174,10694,70,622.40,50,0),(1175,10695,8,880.69,10,0),(1176,10695,12,535.22,4,0),(1177,10695,24,33.04,20,0),(1178,10696,17,558.53,20,0),(1179,10696,46,692.52,18,0),(1180,10697,19,786.04,7,0),(1181,10697,35,851.62,9,0),(1182,10697,58,898.97,30,0),(1183,10697,70,939.02,30,0),(1184,10698,11,997.17,15,0),(1185,10698,17,167.81,8,0),(1186,10698,29,846.54,12,0),(1187,10698,65,728.28,65,0),(1188,10698,70,100.77,8,0),(1189,10699,47,318.03,12,0),(1190,10700,1,286.81,5,0),(1191,10700,34,478.97,12,0),(1192,10700,68,533.40,40,0),(1193,10700,71,229.11,60,0),(1194,10701,59,544.36,42,0),(1195,10701,71,33.44,20,0),(1196,10701,76,533.14,35,0),(1197,10702,3,564.38,6,0),(1198,10702,76,221.49,15,0),(1199,10703,2,413.29,5,0),(1200,10703,59,400.98,35,0),(1201,10703,73,764.02,35,0),(1202,10704,4,616.17,6,0),(1203,10704,24,787.79,35,0),(1204,10704,48,89.42,24,0),(1205,10705,31,82.75,20,0),(1206,10705,32,144.48,4,0),(1207,10706,16,473.16,20,0),(1208,10706,43,931.35,24,0),(1209,10706,59,236.27,8,0),(1210,10707,55,386.29,21,0),(1211,10707,57,221.63,40,0),(1212,10707,70,948.30,28,0),(1213,10708,5,75.61,4,0),(1214,10708,36,532.13,5,0),(1215,10709,8,432.82,40,0),(1216,10709,51,566.70,28,0),(1217,10709,60,534.07,10,0),(1218,10710,19,969.24,5,0),(1219,10710,47,242.97,5,0),(1220,10711,19,306.16,12,0),(1221,10711,41,800.88,42,0),(1222,10711,53,84.90,120,0),(1223,10712,53,20.88,3,0),(1224,10712,56,848.71,30,0),(1225,10713,10,179.91,18,0),(1226,10713,26,352.40,30,0),(1227,10713,45,221.27,110,0),(1228,10713,46,48.17,24,0),(1229,10714,2,576.02,30,0),(1230,10714,17,734.59,27,0),(1231,10714,47,943.88,50,0),(1232,10714,56,514.65,18,0),(1233,10714,58,740.62,12,0),(1234,10715,10,158.15,21,0),(1235,10715,71,567.87,30,0),(1236,10716,21,363.90,5,0),(1237,10716,51,114.91,7,0),(1238,10716,61,481.83,10,0),(1239,10717,21,63.41,32,0),(1240,10717,54,870.58,15,0),(1241,10717,69,161.67,25,0),(1242,10718,12,195.60,36,0),(1243,10718,16,491.98,20,0),(1244,10718,36,872.13,40,0),(1245,10718,62,883.69,20,0),(1246,10719,18,801.05,12,0),(1247,10719,30,353.19,3,0),(1248,10719,54,361.82,40,0),(1249,10720,35,748.51,21,0),(1250,10720,71,656.08,8,0),(1251,10721,44,33.87,50,0),(1252,10722,2,200.13,3,0),(1253,10722,31,898.03,50,0),(1254,10722,68,888.77,45,0),(1255,10722,75,748.77,42,0),(1256,10723,26,76.54,15,0),(1257,10724,10,135.37,16,0),(1258,10724,61,446.24,5,0),(1259,10725,41,824.09,12,0),(1260,10725,52,780.75,4,0),(1261,10725,55,430.45,6,0),(1262,10726,4,809.00,25,0),(1263,10726,11,752.66,5,0),(1264,10727,17,335.31,20,0),(1265,10727,56,417.58,10,0),(1266,10727,59,80.97,10,0),(1267,10728,30,151.11,15,0),(1268,10728,40,511.62,6,0),(1269,10728,55,103.78,12,0),(1270,10728,60,983.06,15,0),(1271,10729,1,602.95,50,0),(1272,10729,21,64.55,30,0),(1273,10729,50,512.90,40,0),(1274,10730,16,369.84,15,0),(1275,10730,31,309.51,3,0),(1276,10730,65,437.03,10,0),(1277,10731,21,255.64,40,0),(1278,10731,51,966.11,30,0),(1279,10732,76,62.61,20,0),(1280,10733,14,413.72,16,0),(1281,10733,28,879.77,20,0),(1282,10733,52,156.71,25,0),(1283,10734,6,143.21,30,0),(1284,10734,30,244.94,15,0),(1285,10734,76,794.06,20,0),(1286,10735,61,234.50,20,0),(1287,10735,77,789.30,2,0),(1288,10736,65,241.99,40,0),(1289,10736,75,841.04,20,0),(1290,10737,13,478.26,4,0),(1291,10737,41,867.18,12,0),(1292,10738,16,900.11,3,0),(1293,10739,36,898.02,6,0),(1294,10739,52,788.74,18,0),(1295,10740,28,248.68,5,0),(1296,10740,35,876.15,35,0),(1297,10740,45,633.72,40,0),(1298,10740,56,539.15,14,0),(1299,10741,2,793.59,15,0),(1300,10742,3,349.48,20,0),(1301,10742,60,365.66,50,0),(1302,10742,72,778.84,35,0),(1303,10743,46,796.23,28,0),(1304,10744,40,643.62,50,0),(1305,10745,18,828.42,24,0),(1306,10745,44,210.24,16,0),(1307,10745,59,564.95,45,0),(1308,10745,72,193.00,7,0),(1309,10746,13,269.18,6,0),(1310,10746,42,765.87,28,0),(1311,10746,62,20.85,9,0),(1312,10746,69,805.60,40,0),(1313,10747,31,964.47,8,0),(1314,10747,41,404.53,35,0),(1315,10747,63,128.27,9,0),(1316,10747,69,426.73,30,0),(1317,10748,23,747.84,44,0),(1318,10748,40,458.04,40,0),(1319,10748,56,45.64,28,0),(1320,10749,56,853.12,15,0),(1321,10749,59,127.66,6,0),(1322,10749,76,77.92,10,0),(1323,10750,14,5.65,5,0),(1324,10750,45,793.50,40,0),(1325,10750,59,949.52,25,0),(1326,10751,26,366.11,12,0),(1327,10751,30,981.01,30,0),(1328,10751,50,805.70,20,0),(1329,10751,73,84.46,15,0),(1330,10752,1,4.22,8,0),(1331,10752,69,766.71,3,0),(1332,10753,45,819.89,4,0),(1333,10753,74,798.30,5,0),(1334,10754,40,530.86,3,0),(1335,10755,47,258.41,30,0),(1336,10755,56,698.45,30,0),(1337,10755,57,716.03,14,0),(1338,10755,69,483.82,25,0),(1339,10756,18,269.97,21,0),(1340,10756,36,897.42,20,0),(1341,10756,68,676.20,6,0),(1342,10756,69,687.73,20,0),(1343,10757,34,409.06,30,0),(1344,10757,59,981.09,7,0),(1345,10757,62,677.28,30,0),(1346,10757,64,442.12,24,0),(1347,10758,26,177.77,20,0),(1348,10758,52,561.50,60,0),(1349,10758,70,273.20,40,0),(1350,10759,32,680.47,10,0),(1351,10760,25,581.75,12,0),(1352,10760,27,866.37,40,0),(1353,10760,43,585.57,30,0),(1354,10761,25,327.74,35,0),(1355,10761,75,881.01,18,0),(1356,10762,39,420.81,16,0),(1357,10762,47,460.02,30,0),(1358,10762,51,36.66,28,0),(1359,10762,56,802.25,60,0),(1360,10763,21,900.29,40,0),(1361,10763,22,93.68,6,0),(1362,10763,24,766.52,20,0),(1363,10764,3,550.58,20,0),(1364,10764,39,452.35,130,0),(1365,10765,65,609.01,80,0),(1366,10766,2,686.99,40,0),(1367,10766,7,606.94,35,0),(1368,10766,68,972.72,40,0),(1369,10767,42,41.79,2,0),(1370,10768,22,289.77,4,0),(1371,10768,31,322.50,50,0),(1372,10768,60,742.18,15,0),(1373,10768,71,742.39,12,0),(1374,10769,41,484.44,30,0),(1375,10769,52,194.00,15,0),(1376,10769,61,515.70,20,0),(1377,10769,62,995.49,15,0),(1378,10770,11,429.37,15,0),(1379,10771,71,159.37,16,0),(1380,10772,29,507.75,18,0),(1381,10772,59,59.61,25,0),(1382,10773,17,773.84,33,0),(1383,10773,31,689.33,70,0),(1384,10773,75,124.16,7,0),(1385,10774,31,551.82,2,0),(1386,10774,66,385.59,50,0),(1387,10775,10,271.48,6,0),(1388,10775,67,199.65,3,0),(1389,10776,31,182.82,16,0),(1390,10776,42,314.12,12,0),(1391,10776,45,21.17,27,0),(1392,10776,51,162.49,120,0),(1393,10777,42,747.95,20,0),(1394,10778,41,251.26,10,0),(1395,10779,16,11.45,20,0),(1396,10779,62,302.46,20,0),(1397,10780,70,476.95,35,0),(1398,10780,77,476.37,15,0),(1399,10781,54,949.99,3,0),(1400,10781,56,319.87,20,0),(1401,10781,74,748.36,35,0),(1402,10782,31,781.21,1,0),(1403,10783,31,659.98,10,0),(1404,10783,38,955.26,5,0),(1405,10784,36,795.34,30,0),(1406,10784,39,109.92,2,0),(1407,10784,72,162.57,30,0),(1408,10785,10,482.11,10,0),(1409,10785,75,921.84,10,0),(1410,10786,8,161.87,30,0),(1411,10786,30,42.81,15,0),(1412,10786,75,727.44,42,0),(1413,10787,2,507.76,15,0),(1414,10787,29,355.51,20,0),(1415,10788,19,253.28,50,0),(1416,10788,75,198.84,40,0),(1417,10789,18,233.35,30,0),(1418,10789,35,569.26,15,0),(1419,10789,63,145.23,30,0),(1420,10789,68,17.39,18,0),(1421,10790,7,650.23,3,0),(1422,10790,56,198.01,20,0),(1423,10791,29,38.35,14,0),(1424,10791,41,596.73,20,0),(1425,10792,2,867.57,10,0),(1426,10792,54,546.69,3,0),(1427,10792,68,129.72,15,0),(1428,10793,41,7.55,14,0),(1429,10793,52,647.59,8,0),(1430,10794,14,214.31,15,0),(1431,10794,54,127.76,6,0),(1432,10795,16,994.88,65,0),(1433,10795,17,590.14,35,0),(1434,10796,26,965.03,21,0),(1435,10796,44,53.72,10,0),(1436,10796,64,372.54,35,0),(1437,10796,69,700.55,24,0),(1438,10797,11,384.12,20,0),(1439,10798,62,817.93,2,0),(1440,10798,72,936.29,10,0),(1441,10799,13,226.69,20,0),(1442,10799,24,323.54,20,0),(1443,10799,59,936.66,25,0),(1444,10800,11,711.68,50,0),(1445,10800,51,747.41,10,0),(1446,10800,54,601.03,7,0),(1447,10801,17,761.91,40,0),(1448,10801,29,5.47,20,0),(1449,10802,30,740.62,25,0),(1450,10802,51,685.68,30,0),(1451,10802,55,205.56,60,0),(1452,10802,62,969.73,5,0),(1453,10803,19,230.98,24,0),(1454,10803,25,244.73,15,0),(1455,10803,59,529.68,15,0),(1456,10804,10,913.21,36,0),(1457,10804,28,976.00,24,0),(1458,10804,49,139.38,4,0),(1459,10805,34,767.88,10,0),(1460,10805,38,420.29,10,0),(1461,10806,2,796.78,20,0),(1462,10806,65,722.05,2,0),(1463,10806,74,218.89,15,0),(1464,10807,40,927.30,1,0),(1465,10808,56,978.85,20,0),(1466,10808,76,111.34,50,0),(1467,10809,52,619.15,20,0),(1468,10810,13,760.73,7,0),(1469,10810,25,945.21,5,0),(1470,10810,70,442.84,5,0),(1471,10811,19,377.57,15,0),(1472,10811,23,558.33,18,0),(1473,10811,40,657.96,30,0),(1474,10812,31,613.80,16,0),(1475,10812,72,94.11,40,0),(1476,10812,77,628.15,20,0),(1477,10813,2,857.43,12,0),(1478,10813,46,401.69,35,0),(1479,10814,41,435.15,20,0),(1480,10814,43,969.68,20,0),(1481,10814,48,541.98,8,0),(1482,10814,61,799.84,30,0),(1483,10815,33,372.25,16,0),(1484,10816,38,460.74,30,0),(1485,10816,62,185.94,20,0),(1486,10817,26,546.48,40,0),(1487,10817,38,173.57,30,0),(1488,10817,40,227.44,60,0),(1489,10817,62,615.46,25,0),(1490,10818,32,393.98,20,0),(1491,10818,41,122.53,20,0),(1492,10819,43,429.73,7,0),(1493,10819,75,780.03,20,0),(1494,10820,56,609.95,30,0),(1495,10821,35,708.68,20,0),(1496,10821,51,712.56,6,0),(1497,10822,62,435.76,3,0),(1498,10822,70,40.13,6,0),(1499,10823,11,892.34,20,0),(1500,10823,57,340.32,15,0),(1501,10823,59,23.58,40,0),(1502,10823,77,95.93,15,0),(1503,10824,41,407.94,12,0),(1504,10824,70,750.88,9,0),(1505,10825,26,529.59,12,0),(1506,10825,53,394.32,20,0),(1507,10826,31,381.83,35,0),(1508,10826,57,725.21,15,0),(1509,10827,10,479.52,15,0),(1510,10827,39,221.00,21,0),(1511,10828,20,665.44,5,0),(1512,10828,38,663.17,2,0),(1513,10829,2,318.56,10,0),(1514,10829,8,602.28,20,0),(1515,10829,13,54.71,10,0),(1516,10829,60,465.70,21,0),(1517,10830,6,163.40,6,0),(1518,10830,39,418.87,28,0),(1519,10830,60,603.16,30,0),(1520,10830,68,758.18,24,0),(1521,10831,19,980.42,2,0),(1522,10831,35,626.55,8,0),(1523,10831,38,190.51,8,0),(1524,10831,43,71.90,9,0),(1525,10832,13,786.95,3,0),(1526,10832,25,718.07,10,0),(1527,10832,44,228.50,16,0),(1528,10832,64,987.30,3,0),(1529,10833,7,249.99,20,0),(1530,10833,31,287.07,9,0),(1531,10833,53,684.35,9,0),(1532,10834,29,559.54,8,0),(1533,10834,30,743.67,20,0),(1534,10835,59,38.73,15,0),(1535,10835,77,961.64,2,0),(1536,10836,22,691.00,52,0),(1537,10836,35,569.10,6,0),(1538,10836,57,771.47,24,0),(1539,10836,60,149.08,60,0),(1540,10836,64,429.98,30,0),(1541,10837,13,701.67,6,0),(1542,10837,40,217.42,25,0),(1543,10837,47,981.08,40,0),(1544,10837,76,252.13,21,0),(1545,10838,1,316.42,4,0),(1546,10838,18,824.70,25,0),(1547,10838,36,173.26,50,0),(1548,10839,58,391.17,30,0),(1549,10839,72,435.08,15,0),(1550,10840,25,1000.91,6,0),(1551,10840,39,698.31,10,0),(1552,10841,10,487.82,16,0),(1553,10841,56,343.17,30,0),(1554,10841,59,251.38,50,0),(1555,10841,77,226.39,15,0),(1556,10842,11,376.80,15,0),(1557,10842,43,203.83,5,0),(1558,10842,68,887.77,20,0),(1559,10842,70,826.37,12,0),(1560,10843,51,467.51,4,0),(1561,10844,22,857.44,35,0),(1562,10845,23,883.66,70,0),(1563,10845,35,844.99,25,0),(1564,10845,42,572.96,42,0),(1565,10845,58,328.83,60,0),(1566,10845,64,924.28,48,0),(1567,10846,4,633.91,21,0),(1568,10846,70,395.71,30,0),(1569,10846,74,75.82,20,0),(1570,10847,1,190.98,80,0),(1571,10847,19,726.43,12,0),(1572,10847,37,58.23,60,0),(1573,10847,45,110.83,36,0),(1574,10847,60,378.47,45,0),(1575,10847,71,558.84,55,0),(1576,10848,5,657.81,30,0),(1577,10848,9,611.53,3,0),(1578,10849,3,83.22,49,0),(1579,10849,26,580.53,18,0),(1580,10850,25,651.97,20,0),(1581,10850,33,517.26,4,0),(1582,10850,70,629.38,30,0),(1583,10851,2,594.12,5,0),(1584,10851,25,81.45,10,0),(1585,10851,57,623.91,10,0),(1586,10851,59,874.20,42,0),(1587,10852,2,498.25,15,0),(1588,10852,17,867.65,6,0),(1589,10852,62,842.50,50,0),(1590,10853,18,608.57,10,0),(1591,10854,10,514.32,100,0),(1592,10854,13,744.90,65,0),(1593,10855,16,180.56,50,0),(1594,10855,31,667.10,14,0),(1595,10855,56,792.80,24,0),(1596,10855,65,961.69,15,0),(1597,10856,2,429.06,20,0),(1598,10856,42,259.25,20,0),(1599,10857,3,8.06,30,0),(1600,10857,26,261.53,35,0),(1601,10857,29,282.50,10,0),(1602,10858,7,626.90,5,0),(1603,10858,27,286.00,10,0),(1604,10858,70,548.32,4,0),(1605,10859,24,882.57,40,0),(1606,10859,54,766.90,35,0),(1607,10859,64,185.80,30,0),(1608,10860,51,627.27,3,0),(1609,10860,76,577.98,20,0),(1610,10861,17,7.09,42,0),(1611,10861,18,300.50,20,0),(1612,10861,21,480.23,40,0),(1613,10861,33,498.65,35,0),(1614,10861,62,51.55,3,0),(1615,10862,11,760.82,25,0),(1616,10862,52,648.46,8,0),(1617,10863,1,958.84,20,0),(1618,10863,58,847.80,12,0),(1619,10864,35,361.48,4,0),(1620,10864,67,263.02,15,0),(1621,10865,38,229.65,60,0),(1622,10865,39,358.19,80,0),(1623,10866,2,101.01,21,0),(1624,10866,24,429.45,6,0),(1625,10866,30,843.25,40,0),(1626,10867,53,926.89,3,0),(1627,10868,26,103.69,20,0),(1628,10868,35,736.77,30,0),(1629,10868,49,371.79,42,0),(1630,10869,1,647.62,40,0),(1631,10869,11,121.77,10,0),(1632,10869,23,664.95,50,0),(1633,10869,68,958.46,20,0),(1634,10870,35,796.46,3,0),(1635,10870,51,105.90,2,0),(1636,10871,6,139.14,50,0),(1637,10871,16,376.98,12,0),(1638,10871,17,466.47,16,0),(1639,10872,55,200.43,10,0),(1640,10872,62,601.74,20,0),(1641,10872,64,406.43,15,0),(1642,10872,65,225.90,21,0),(1643,10873,21,909.20,20,0),(1644,10873,28,867.31,3,0),(1645,10874,10,607.96,10,0),(1646,10875,19,436.88,25,0),(1647,10875,47,359.53,21,0),(1648,10875,49,485.99,15,0),(1649,10876,46,350.35,21,0),(1650,10876,64,292.80,20,0),(1651,10877,16,411.95,30,0),(1652,10877,18,180.35,25,0),(1653,10878,20,664.90,20,0),(1654,10879,40,782.44,12,0),(1655,10879,65,916.49,10,0),(1656,10879,76,234.15,10,0),(1657,10880,23,420.27,30,0),(1658,10880,61,397.92,30,0),(1659,10880,70,727.78,50,0),(1660,10881,73,444.13,10,0),(1661,10882,42,36.29,25,0),(1662,10882,49,848.10,20,0),(1663,10882,54,130.61,32,0),(1664,10883,24,107.74,8,0),(1665,10884,21,145.88,40,0),(1666,10884,56,405.19,21,0),(1667,10884,65,587.32,12,0),(1668,10885,2,720.01,20,0),(1669,10885,24,837.08,12,0),(1670,10885,70,24.40,30,0),(1671,10885,77,609.75,25,0),(1672,10886,10,974.56,70,0),(1673,10886,31,42.54,35,0),(1674,10886,77,288.02,40,0),(1675,10887,25,311.50,5,0),(1676,10888,2,692.42,20,0),(1677,10888,68,526.60,18,0),(1678,10889,11,554.75,40,0),(1679,10889,38,192.95,40,0),(1680,10890,17,299.52,15,0),(1681,10890,34,917.72,10,0),(1682,10890,41,689.04,14,0),(1683,10891,30,691.06,15,0),(1684,10892,59,387.18,40,0),(1685,10893,8,861.72,30,0),(1686,10893,24,146.04,10,0),(1687,10893,29,144.05,24,0),(1688,10893,30,281.14,35,0),(1689,10893,36,972.54,20,0),(1690,10894,13,18.27,28,0),(1691,10894,69,172.73,50,0),(1692,10894,75,807.86,120,0),(1693,10895,24,520.10,110,0),(1694,10895,39,175.90,45,0),(1695,10895,40,318.22,91,0),(1696,10895,60,62.39,100,0),(1697,10896,45,356.28,15,0),(1698,10896,56,593.22,16,0),(1699,10897,29,896.29,80,0),(1700,10897,30,700.78,36,0),(1701,10898,13,814.05,5,0),(1702,10899,39,966.87,8,0),(1703,10900,70,391.24,3,0),(1704,10901,41,54.56,30,0),(1705,10901,71,98.09,30,0),(1706,10902,55,325.79,30,0),(1707,10902,62,333.65,6,0),(1708,10903,13,689.88,40,0),(1709,10903,65,447.47,21,0),(1710,10903,68,166.71,20,0),(1711,10904,58,490.12,15,0),(1712,10904,62,949.50,35,0),(1713,10905,1,276.11,20,0),(1714,10906,61,531.05,15,0),(1715,10907,75,825.93,14,0),(1716,10908,7,535.49,20,0),(1717,10908,52,198.65,14,0),(1718,10909,7,385.81,12,0),(1719,10909,16,332.07,15,0),(1720,10909,41,501.93,5,0),(1721,10910,19,512.45,12,0),(1722,10910,49,55.47,10,0),(1723,10910,61,739.00,5,0),(1724,10911,1,527.57,10,0),(1725,10911,17,419.87,12,0),(1726,10911,67,515.65,15,0),(1727,10912,11,317.63,40,0),(1728,10912,29,40.22,60,0),(1729,10913,4,247.18,30,0),(1730,10913,33,114.24,40,0),(1731,10913,58,828.68,15,0),(1732,10914,71,799.68,25,0),(1733,10915,17,511.36,10,0),(1734,10915,33,156.75,30,0),(1735,10915,54,248.66,10,0),(1736,10916,16,772.05,6,0),(1737,10916,32,113.30,6,0),(1738,10916,57,249.32,20,0),(1739,10917,30,905.70,1,0),(1740,10917,60,779.56,10,0),(1741,10918,1,179.70,60,0),(1742,10918,60,558.81,25,0),(1743,10919,16,253.97,24,0),(1744,10919,25,592.42,24,0),(1745,10919,40,199.19,20,0),(1746,10920,50,217.67,24,0),(1747,10921,35,489.78,10,0),(1748,10921,63,794.89,40,0),(1749,10922,17,504.10,15,0),(1750,10922,24,134.85,35,0),(1751,10923,42,160.93,10,0),(1752,10923,43,399.09,10,0),(1753,10923,67,511.67,24,0),(1754,10924,10,360.10,20,0),(1755,10924,28,264.47,30,0),(1756,10924,75,241.07,6,0),(1757,10925,36,410.93,25,0),(1758,10925,52,330.45,12,0),(1759,10926,11,418.46,2,0),(1760,10926,13,99.96,10,0),(1761,10926,19,243.42,7,0),(1762,10926,72,916.21,10,0),(1763,10927,20,849.78,5,0),(1764,10927,52,499.28,5,0),(1765,10927,76,946.08,20,0),(1766,10928,47,231.53,5,0),(1767,10928,76,318.41,5,0),(1768,10929,21,896.45,60,0),(1769,10929,75,526.05,49,0),(1770,10929,77,939.87,15,0),(1771,10930,21,120.23,36,0),(1772,10930,27,780.54,25,0),(1773,10930,55,540.98,25,0),(1774,10930,58,362.31,30,0),(1775,10931,13,187.59,42,0),(1776,10931,57,850.03,30,0),(1777,10932,16,686.36,30,0),(1778,10932,62,880.71,14,0),(1779,10932,72,343.48,16,0),(1780,10932,75,74.27,20,0),(1781,10933,53,339.92,2,0),(1782,10933,61,475.79,30,0),(1783,10934,6,358.19,20,0),(1784,10935,1,362.56,21,0),(1785,10935,18,737.26,4,0),(1786,10935,23,597.62,8,0),(1787,10936,36,775.31,30,0),(1788,10937,28,82.67,8,0),(1789,10937,34,86.44,20,0),(1790,10938,13,183.19,20,0),(1791,10938,43,655.65,24,0),(1792,10938,60,727.66,49,0),(1793,10938,71,670.34,35,0),(1794,10939,2,167.72,10,0),(1795,10939,67,826.59,40,0),(1796,10940,7,628.81,8,0),(1797,10940,13,663.26,20,0),(1798,10941,31,428.86,44,0),(1799,10941,62,153.52,30,0),(1800,10941,68,480.01,80,0),(1801,10941,72,938.51,50,0),(1802,10942,49,251.52,28,0),(1803,10943,13,441.07,15,0),(1804,10943,22,449.78,21,0),(1805,10943,46,924.68,15,0),(1806,10944,11,273.07,5,0),(1807,10944,44,590.33,18,0),(1808,10944,56,131.42,18,0),(1809,10945,13,885.10,20,0),(1810,10945,31,30.24,10,0),(1811,10946,10,494.92,25,0),(1812,10946,24,382.88,25,0),(1813,10946,77,428.64,40,0),(1814,10947,59,993.58,4,0),(1815,10948,50,680.95,9,0),(1816,10948,51,423.00,40,0),(1817,10948,55,71.16,4,0),(1818,10949,6,85.79,12,0),(1819,10949,10,214.49,30,0),(1820,10949,17,814.09,6,0),(1821,10949,62,425.95,60,0),(1822,10950,4,686.50,5,0),(1823,10951,33,153.63,15,0),(1824,10951,41,707.64,6,0),(1825,10951,75,76.34,50,0),(1826,10952,6,257.77,16,0),(1827,10952,28,58.82,2,0),(1828,10953,20,519.80,50,0),(1829,10953,31,421.53,50,0),(1830,10954,16,547.24,28,0),(1831,10954,31,470.60,25,0),(1832,10954,45,710.32,30,0),(1833,10954,60,138.76,24,0),(1834,10955,75,561.86,12,0),(1835,10956,21,392.03,12,0),(1836,10956,47,273.54,14,0),(1837,10956,51,190.64,8,0),(1838,10957,30,131.58,30,0),(1839,10957,35,84.99,40,0),(1840,10957,64,29.18,8,0),(1841,10958,5,889.96,20,0),(1842,10958,7,361.23,6,0),(1843,10958,72,135.30,5,0),(1844,10959,75,591.79,20,0),(1845,10960,24,552.07,10,0),(1846,10960,41,983.97,24,0),(1847,10961,52,262.66,6,0),(1848,10961,76,360.36,60,0),(1849,10962,7,12.84,45,0),(1850,10962,13,982.12,77,0),(1851,10962,53,871.09,20,0),(1852,10962,69,408.07,9,0),(1853,10962,76,426.09,44,0),(1854,10963,60,905.23,2,0),(1855,10964,18,246.88,6,0),(1856,10964,38,517.71,5,0),(1857,10964,69,846.93,10,0),(1858,10965,51,680.49,16,0),(1859,10966,37,860.69,8,0),(1860,10966,56,260.98,12,0),(1861,10966,62,721.83,12,0),(1862,10967,19,825.19,12,0),(1863,10967,49,959.48,40,0),(1864,10968,12,320.80,30,0),(1865,10968,24,724.59,30,0),(1866,10968,64,659.54,4,0),(1867,10969,46,122.94,9,0),(1868,10970,52,635.08,40,0),(1869,10971,29,805.56,14,0),(1870,10972,17,121.57,6,0),(1871,10972,33,190.17,7,0),(1872,10973,26,585.15,5,0),(1873,10973,41,354.25,6,0),(1874,10973,75,14.78,10,0),(1875,10974,63,10.16,10,0),(1876,10975,8,5.47,16,0),(1877,10975,75,995.85,10,0),(1878,10976,28,961.85,20,0),(1879,10977,39,820.70,30,0),(1880,10977,47,216.97,30,0),(1881,10977,51,621.73,10,0),(1882,10977,63,456.75,20,0),(1883,10978,8,417.57,20,0),(1884,10978,21,716.58,40,0),(1885,10978,40,329.20,10,0),(1886,10978,44,495.26,6,0),(1887,10979,7,487.69,18,0),(1888,10979,12,951.67,20,0),(1889,10979,24,294.27,80,0),(1890,10979,27,615.34,30,0),(1891,10979,31,192.91,24,0),(1892,10979,63,117.51,35,0),(1893,10980,75,7.84,40,0),(1894,10981,38,685.65,60,0),(1895,10982,7,403.73,20,0),(1896,10982,43,960.70,9,0),(1897,10983,13,591.32,84,0),(1898,10983,57,73.49,15,0),(1899,10984,16,592.49,55,0),(1900,10984,24,740.98,20,0),(1901,10984,36,926.42,40,0),(1902,10985,16,408.17,36,0),(1903,10985,18,260.58,8,0),(1904,10985,32,77.41,35,0),(1905,10986,11,604.28,30,0),(1906,10986,20,788.20,15,0),(1907,10986,76,127.15,10,0),(1908,10986,77,270.16,15,0),(1909,10987,7,968.35,60,0),(1910,10987,43,30.28,6,0),(1911,10987,72,245.32,20,0),(1912,10988,7,134.79,60,0),(1913,10988,62,936.99,40,0),(1914,10989,6,279.59,40,0),(1915,10989,11,585.97,15,0),(1916,10989,41,90.07,4,0),(1917,10990,21,691.43,65,0),(1918,10990,34,185.94,60,0),(1919,10990,55,854.44,65,0),(1920,10990,61,713.36,66,0),(1921,10991,2,2.48,50,0),(1922,10991,70,871.33,20,0),(1923,10991,76,348.19,90,0),(1924,10992,72,125.98,2,0),(1925,10993,29,584.32,50,0),(1926,10993,41,542.65,35,0),(1927,10994,59,959.32,18,0),(1928,10995,51,167.62,20,0),(1929,10995,60,959.15,4,0),(1930,10996,42,291.89,40,0),(1931,10997,32,581.00,50,0),(1932,10997,46,28.32,20,0),(1933,10997,52,397.61,20,0),(1934,10998,24,902.09,12,0),(1935,10998,61,316.61,7,0),(1936,10998,74,875.81,20,0),(1937,10998,75,428.18,30,0),(1938,10999,41,512.50,20,0),(1939,10999,51,276.95,15,0),(1940,10999,77,846.24,21,0),(1941,11000,4,399.34,25,0),(1942,11000,24,457.00,30,0),(1943,11000,77,85.97,30,0),(1944,11001,7,57.86,60,0),(1945,11001,22,30.39,25,0),(1946,11001,46,977.36,25,0),(1947,11001,55,794.64,6,0),(1948,11002,13,40.10,56,0),(1949,11002,35,815.60,15,0),(1950,11002,42,956.71,24,0),(1951,11002,55,335.72,40,0),(1952,11003,1,807.50,4,0),(1953,11003,40,29.32,10,0),(1954,11003,52,723.13,10,0),(1955,11004,26,526.65,6,0),(1956,11004,76,462.89,6,0),(1957,11005,1,733.50,2,0),(1958,11005,59,277.81,10,0),(1959,11006,1,187.58,8,0),(1960,11006,29,103.46,2,0),(1961,11007,8,953.54,30,0),(1962,11007,29,456.31,10,0),(1963,11007,42,419.97,14,0),(1964,11008,28,729.88,70,0),(1965,11008,34,388.53,90,0),(1966,11008,71,751.98,21,0),(1967,11009,24,593.31,12,0),(1968,11009,36,709.62,18,0),(1969,11009,60,767.17,9,0),(1970,11010,7,706.01,20,0),(1971,11010,24,227.51,10,0),(1972,11011,58,18.52,40,0),(1973,11011,71,409.06,20,0),(1974,11012,19,988.76,50,0),(1975,11012,60,715.61,36,0),(1976,11012,71,610.77,60,0),(1977,11013,23,906.02,10,0),(1978,11013,42,696.79,4,0),(1979,11013,45,764.89,20,0),(1980,11013,68,733.08,2,0),(1981,11014,41,369.75,28,0),(1982,11015,30,648.48,15,0),(1983,11015,77,132.18,18,0),(1984,11016,31,714.46,15,0),(1985,11016,36,174.75,16,0),(1986,11017,3,729.37,25,0),(1987,11017,59,121.60,110,0),(1988,11017,70,418.88,30,0),(1989,11018,12,728.61,20,0),(1990,11018,18,385.41,10,0),(1991,11018,56,740.22,5,0),(1992,11019,46,543.87,3,0),(1993,11019,49,497.67,2,0),(1994,11020,10,855.76,24,0),(1995,11021,2,784.78,11,0),(1996,11021,20,355.62,15,0),(1997,11021,26,422.75,63,0),(1998,11021,51,45.89,44,0),(1999,11021,72,960.23,35,0),(2000,11022,19,662.45,35,0),(2001,11022,69,430.56,30,0),(2002,11023,7,164.47,4,0),(2003,11023,43,529.68,30,0),(2004,11024,26,153.97,12,0),(2005,11024,33,179.81,30,0),(2006,11024,65,436.15,21,0),(2007,11024,71,640.33,50,0),(2008,11025,1,892.18,10,0),(2009,11025,13,538.92,20,0),(2010,11026,18,17.05,8,0),(2011,11026,51,467.49,10,0),(2012,11027,24,285.29,30,0),(2013,11027,62,22.97,21,0),(2014,11028,55,258.00,35,0),(2015,11028,59,220.07,24,0),(2016,11029,56,325.36,20,0),(2017,11029,63,965.60,12,0),(2018,11030,2,850.92,100,0),(2019,11030,5,356.81,70,0),(2020,11030,29,230.26,60,0),(2021,11030,59,79.89,100,0),(2022,11031,1,707.69,45,0),(2023,11031,13,297.74,80,0),(2024,11031,24,364.67,21,0),(2025,11031,64,929.10,20,0),(2026,11031,71,550.51,16,0),(2027,11032,36,964.26,35,0),(2028,11032,38,168.75,25,0),(2029,11032,59,949.98,30,0),(2030,11033,53,242.67,70,0),(2031,11033,69,362.39,36,0),(2032,11034,21,82.93,15,0),(2033,11034,44,326.49,12,0),(2034,11034,61,382.66,6,0),(2035,11035,1,932.83,10,0),(2036,11035,35,515.18,60,0),(2037,11035,42,776.38,30,0),(2038,11035,54,335.39,10,0),(2039,11036,13,346.79,7,0),(2040,11036,59,726.77,30,0),(2041,11037,70,592.50,4,0),(2042,11038,40,781.17,5,0),(2043,11038,52,127.37,2,0),(2044,11038,71,292.35,30,0),(2045,11039,28,78.63,20,0),(2046,11039,35,515.11,24,0),(2047,11039,49,338.66,60,0),(2048,11039,57,146.95,28,0),(2049,11040,21,717.79,20,0),(2050,11041,2,147.10,30,0),(2051,11041,63,581.12,30,0),(2052,11042,44,463.28,15,0),(2053,11042,61,572.07,4,0),(2054,11043,11,469.52,10,0),(2055,11044,62,630.37,12,0),(2056,11045,33,742.29,15,0),(2057,11045,51,819.33,24,0),(2058,11046,12,868.77,20,0),(2059,11046,32,884.87,15,0),(2060,11046,35,817.05,18,0),(2061,11047,1,429.64,25,0),(2062,11047,5,696.03,30,0),(2063,11048,68,190.25,42,0),(2064,11049,2,862.16,10,0),(2065,11049,12,739.04,4,0),(2066,11050,76,107.72,50,0),(2067,11051,24,320.49,10,0),(2068,11052,43,278.28,30,0),(2069,11052,61,428.92,10,0),(2070,11053,18,308.76,35,0),(2071,11053,32,256.05,20,0),(2072,11053,64,352.97,25,0),(2073,11054,33,995.72,10,0),(2074,11054,67,918.67,20,0),(2075,11055,24,605.20,15,0),(2076,11055,25,269.01,15,0),(2077,11055,51,528.41,20,0),(2078,11055,57,834.05,20,0),(2079,11056,7,583.99,40,0),(2080,11056,55,416.82,35,0),(2081,11056,60,331.13,50,0),(2082,11057,70,404.20,3,0),(2083,11058,21,26.60,3,0),(2084,11058,60,919.39,21,0),(2085,11058,61,516.16,4,0),(2086,11059,13,821.64,30,0),(2087,11059,17,558.70,12,0),(2088,11059,60,327.57,35,0),(2089,11060,60,960.75,4,0),(2090,11060,77,820.06,10,0),(2091,11061,60,217.03,15,0),(2092,11062,53,623.98,10,0),(2093,11062,70,467.82,12,0),(2094,11063,34,466.14,30,0),(2095,11063,40,926.25,40,0),(2096,11063,41,231.83,30,0),(2097,11064,17,379.41,77,0),(2098,11064,41,200.56,12,0),(2099,11064,53,863.58,25,0),(2100,11064,55,715.21,4,0),(2101,11064,68,984.30,55,0),(2102,11065,30,774.86,4,0),(2103,11065,54,920.41,20,0),(2104,11066,16,276.45,3,0),(2105,11066,19,620.05,42,0),(2106,11066,34,269.88,35,0),(2107,11067,41,488.25,9,0),(2108,11068,28,630.62,8,0),(2109,11068,43,687.36,36,0),(2110,11068,77,543.92,28,0),(2111,11069,39,656.52,20,0),(2112,11070,1,649.83,40,0),(2113,11070,2,278.60,20,0),(2114,11070,16,442.53,30,0),(2115,11070,31,375.84,20,0),(2116,11071,7,550.61,15,0),(2117,11071,13,624.54,10,0),(2118,11072,2,469.88,8,0),(2119,11072,41,474.75,40,0),(2120,11072,50,963.13,22,0),(2121,11072,64,390.37,130,0),(2122,11073,11,61.49,10,0),(2123,11073,24,135.34,20,0),(2124,11074,16,491.20,14,0),(2125,11075,2,49.01,10,0),(2126,11075,46,770.46,30,0),(2127,11075,76,704.25,2,0),(2128,11076,6,208.87,20,0),(2129,11076,14,930.60,20,0),(2130,11076,19,25.39,10,0),(2131,11077,2,334.16,24,0),(2132,11077,3,593.61,4,0),(2133,11077,4,964.59,1,0),(2134,11077,6,41.10,1,0),(2135,11077,7,310.75,1,0),(2136,11077,8,429.44,2,0),(2137,11077,10,213.95,1,0),(2138,11077,12,780.41,2,0),(2139,11077,13,259.22,4,0),(2140,11077,14,953.86,1,0),(2141,11077,16,990.65,2,0),(2142,11077,20,90.67,1,0),(2143,11077,23,480.39,2,0),(2144,11077,32,128.92,1,0),(2145,11077,39,202.47,2,0),(2146,11077,41,624.56,3,0),(2147,11077,46,514.40,3,0),(2148,11077,52,697.32,2,0),(2149,11077,55,942.40,2,0),(2150,11077,60,619.06,2,0),(2151,11077,64,267.07,2,0),(2152,11077,66,477.16,1,0),(2153,11077,73,583.61,2,0),(2154,11077,75,485.55,4,0),(2155,11077,77,675.95,2,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `order_details` ENABLE KEYS */;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `OrderID` int(11) NOT NULL AUTO_INCREMENT,
  `CustomerID` varchar(5) DEFAULT NULL,
  `EmployeeID` int(11) DEFAULT NULL,
  `OrderDate` date DEFAULT NULL,
  `RequiredDate` date DEFAULT NULL,
  `ShippedDate` date DEFAULT NULL,
  `ShipVia` int(11) DEFAULT NULL,
  `Freight` float(1,0) DEFAULT '0',
  `ShipName` varchar(40) DEFAULT NULL,
  `ShipAddress` varchar(60) DEFAULT NULL,
  `ShipCity` varchar(15) DEFAULT NULL,
  `ShipRegion` varchar(15) DEFAULT NULL,
  `ShipPostalCode` varchar(10) DEFAULT NULL,
  `ShipCountry` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`OrderID`)
) ENGINE=InnoDB AUTO_INCREMENT=11078 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `orders`
--


/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
LOCK TABLES `orders` WRITE;
INSERT INTO `orders` VALUES (10248,'VINET',5,'1996-07-04','1996-08-01','1996-07-16',3,0,'Vins et alcools Chevalier','59 rue de l\'Abbaye','Reims','','51100','France'),(10249,'TOMSP',6,'1996-07-05','1996-08-16','1996-07-10',1,0,'Toms Spezialit?ten','Luisenstr. 48','M?nster','','44087','Germany'),(10250,'HANAR',4,'1996-07-08','1996-08-05','1996-07-12',2,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10251,'VICTE',3,'1996-07-08','1996-08-05','1996-07-15',1,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10252,'SUPRD',4,'1996-07-09','1996-08-06','1996-07-11',2,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10253,'HANAR',3,'1996-07-10','1996-07-24','1996-07-16',2,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10254,'CHOPS',5,'1996-07-11','1996-08-08','1996-07-23',2,0,'Chop-suey Chinese','Hauptstr. 31','Bern','','3012','Switzerland'),(10255,'RICSU',9,'1996-07-12','1996-08-09','1996-07-15',3,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(10256,'WELLI',3,'1996-07-15','1996-08-12','1996-07-17',2,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10257,'HILAA',4,'1996-07-16','1996-08-13','1996-07-22',3,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10258,'ERNSH',1,'1996-07-17','1996-08-14','1996-07-23',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10259,'CENTC',4,'1996-07-18','1996-08-15','1996-07-25',3,0,'Centro comercial Moctezuma','Sierras de Granada 9993','M?xico D.F.','','05022','Mexico'),(10260,'OTTIK',4,'1996-07-19','1996-08-16','1996-07-29',1,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(10261,'QUEDE',4,'1996-07-19','1996-08-16','1996-07-30',2,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10262,'RATTC',8,'1996-07-22','1996-08-19','1996-07-25',3,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10263,'ERNSH',9,'1996-07-23','1996-08-20','1996-07-31',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10264,'FOLKO',6,'1996-07-24','1996-08-21','1996-08-23',3,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10265,'BLONP',2,'1996-07-25','1996-08-22','1996-08-12',1,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10266,'WARTH',3,'1996-07-26','1996-09-06','1996-07-31',3,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10267,'FRANK',4,'1996-07-29','1996-08-26','1996-08-06',1,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10268,'GROSR',8,'1996-07-30','1996-08-27','1996-08-02',3,0,'GROSELLA-Restaurante','5? Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela'),(10269,'WHITC',5,'1996-07-31','1996-08-14','1996-08-09',1,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10270,'WARTH',1,'1996-08-01','1996-08-29','1996-08-02',1,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10271,'SPLIR',6,'1996-08-01','1996-08-29','1996-08-30',2,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10272,'RATTC',6,'1996-08-02','1996-08-30','1996-08-06',2,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10273,'QUICK',3,'1996-08-05','1996-09-02','1996-08-12',3,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10274,'VINET',6,'1996-08-06','1996-09-03','1996-08-16',1,0,'Vins et alcools Chevalier','59 rue de l\'Abbaye','Reims','','51100','France'),(10275,'MAGAA',1,'1996-08-07','1996-09-04','1996-08-09',1,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10276,'TORTU',8,'1996-08-08','1996-08-22','1996-08-14',3,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10277,'MORGK',2,'1996-08-09','1996-09-06','1996-08-13',3,0,'Morgenstern Gesundkost','Heerstr. 22','Leipzig','','04179','Germany'),(10278,'BERGS',8,'1996-08-12','1996-09-09','1996-08-16',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10279,'LEHMS',8,'1996-08-13','1996-09-10','1996-08-16',2,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10280,'BERGS',2,'1996-08-14','1996-09-11','1996-09-12',1,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10281,'ROMEY',4,'1996-08-14','1996-08-28','1996-08-21',1,0,'Romero y tomillo','Gran V?a, 1','Madrid','','28001','Spain'),(10282,'ROMEY',4,'1996-08-15','1996-09-12','1996-08-21',1,0,'Romero y tomillo','Gran V?a, 1','Madrid','','28001','Spain'),(10283,'LILAS',3,'1996-08-16','1996-09-13','1996-08-23',3,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10284,'LEHMS',4,'1996-08-19','1996-09-16','1996-08-27',1,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10285,'QUICK',1,'1996-08-20','1996-09-17','1996-08-26',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10286,'QUICK',8,'1996-08-21','1996-09-18','1996-08-30',3,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10287,'RICAR',8,'1996-08-22','1996-09-19','1996-08-28',3,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10288,'REGGC',4,'1996-08-23','1996-09-20','1996-09-03',1,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10289,'BSBEV',7,'1996-08-26','1996-09-23','1996-08-28',3,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10290,'COMMI',8,'1996-08-27','1996-09-24','1996-09-03',1,0,'Com?rcio Mineiro','Av. dos Lus?adas, 23','S?o Paulo','SP','05432-043','Brazil'),(10291,'QUEDE',6,'1996-08-27','1996-09-24','1996-09-04',2,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10292,'TRADH',1,'1996-08-28','1996-09-25','1996-09-02',2,0,'Tradi??o Hipermercados','Av. In?s de Castro, 414','S?o Paulo','SP','05634-030','Brazil'),(10293,'TORTU',1,'1996-08-29','1996-09-26','1996-09-11',3,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10294,'RATTC',4,'1996-08-30','1996-09-27','1996-09-05',2,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10295,'VINET',2,'1996-09-02','1996-09-30','1996-09-10',2,0,'Vins et alcools Chevalier','59 rue de l\'Abbaye','Reims','','51100','France'),(10296,'LILAS',6,'1996-09-03','1996-10-01','1996-09-11',1,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10297,'BLONP',5,'1996-09-04','1996-10-16','1996-09-10',2,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10298,'HUNGO',6,'1996-09-05','1996-10-03','1996-09-11',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10299,'RICAR',4,'1996-09-06','1996-10-04','1996-09-13',2,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10300,'MAGAA',2,'1996-09-09','1996-10-07','1996-09-18',2,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10301,'WANDK',8,'1996-09-09','1996-10-07','1996-09-17',2,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10302,'SUPRD',4,'1996-09-10','1996-10-08','1996-10-09',2,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10303,'GODOS',7,'1996-09-11','1996-10-09','1996-09-18',2,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(10304,'TORTU',1,'1996-09-12','1996-10-10','1996-09-17',2,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10305,'OLDWO',8,'1996-09-13','1996-10-11','1996-10-09',3,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10306,'ROMEY',1,'1996-09-16','1996-10-14','1996-09-23',3,0,'Romero y tomillo','Gran V?a, 1','Madrid','','28001','Spain'),(10307,'LONEP',2,'1996-09-17','1996-10-15','1996-09-25',2,0,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','United States'),(10308,'ANATR',7,'1996-09-18','1996-10-16','1996-09-24',3,0,'Ana Trujillo Emparedados y helados','Avda. de la Constituci?n 2222','M?xico D.F.','','05021','Mexico'),(10309,'HUNGO',3,'1996-09-19','1996-10-17','1996-10-23',1,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10310,'THEBI',8,'1996-09-20','1996-10-18','1996-09-27',2,0,'The Big Cheese','89 Jefferson Way\r\nSuite 2','Portland','OR','97201','United States'),(10311,'DUMON',1,'1996-09-20','1996-10-04','1996-09-26',3,0,'Du monde entier','67, rue des Cinquante Otages','Nantes','','44000','France'),(10312,'WANDK',2,'1996-09-23','1996-10-21','1996-10-03',2,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10313,'QUICK',2,'1996-09-24','1996-10-22','1996-10-04',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10314,'RATTC',1,'1996-09-25','1996-10-23','1996-10-04',2,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10315,'ISLAT',4,'1996-09-26','1996-10-24','1996-10-03',2,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10316,'RATTC',1,'1996-09-27','1996-10-25','1996-10-08',3,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10317,'LONEP',6,'1996-09-30','1996-10-28','1996-10-10',1,0,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','United States'),(10318,'ISLAT',8,'1996-10-01','1996-10-29','1996-10-04',2,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10319,'TORTU',7,'1996-10-02','1996-10-30','1996-10-11',3,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10320,'WARTH',5,'1996-10-03','1996-10-17','1996-10-18',3,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10321,'ISLAT',3,'1996-10-03','1996-10-31','1996-10-11',2,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10322,'PERIC',7,'1996-10-04','1996-11-01','1996-10-23',3,0,'Pericles Comidas cl?sicas','Calle Dr. Jorge Cash 321','M?xico D.F.','','05033','Mexico'),(10323,'KOENE',4,'1996-10-07','1996-11-04','1996-10-14',1,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10324,'SAVEA',9,'1996-10-08','1996-11-05','1996-10-10',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10325,'KOENE',1,'1996-10-09','1996-10-23','1996-10-14',3,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10326,'BOLID',4,'1996-10-10','1996-11-07','1996-10-14',2,0,'B?lido Comidas preparadas','C/ Araquil, 67','Madrid','','28023','Spain'),(10327,'FOLKO',2,'1996-10-11','1996-11-08','1996-10-14',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10328,'FURIB',4,'1996-10-14','1996-11-11','1996-10-17',3,0,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa','','1675','Portugal'),(10329,'SPLIR',4,'1996-10-15','1996-11-26','1996-10-23',2,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10330,'LILAS',3,'1996-10-16','1996-11-13','1996-10-28',1,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10331,'BONAP',9,'1996-10-16','1996-11-27','1996-10-21',1,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10332,'MEREP',3,'1996-10-17','1996-11-28','1996-10-21',2,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10333,'WARTH',5,'1996-10-18','1996-11-15','1996-10-25',3,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10334,'VICTE',8,'1996-10-21','1996-11-18','1996-10-28',2,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10335,'HUNGO',7,'1996-10-22','1996-11-19','1996-10-24',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10336,'PRINI',7,'1996-10-23','1996-11-20','1996-10-25',2,0,'Princesa Isabel Vinhos','Estrada da sa?de n. 58','Lisboa','','1756','Portugal'),(10337,'FRANK',4,'1996-10-24','1996-11-21','1996-10-29',3,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10338,'OLDWO',4,'1996-10-25','1996-11-22','1996-10-29',3,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10339,'MEREP',2,'1996-10-28','1996-11-25','1996-11-04',2,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10340,'BONAP',1,'1996-10-29','1996-11-26','1996-11-08',3,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10341,'SIMOB',7,'1996-10-29','1996-11-26','1996-11-05',3,0,'Simons bistro','Vinb?ltet 34','K?benhavn','','1734','Denmark'),(10342,'FRANK',4,'1996-10-30','1996-11-13','1996-11-04',2,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10343,'LEHMS',4,'1996-10-31','1996-11-28','1996-11-06',1,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10344,'WHITC',4,'1996-11-01','1996-11-29','1996-11-05',2,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10345,'QUICK',2,'1996-11-04','1996-12-02','1996-11-11',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10346,'RATTC',3,'1996-11-05','1996-12-17','1996-11-08',3,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10347,'FAMIA',4,'1996-11-06','1996-12-04','1996-11-08',3,0,'Familia Arquibaldo','Rua Or?s, 92','S?o Paulo','SP','05442-030','Brazil'),(10348,'WANDK',4,'1996-11-07','1996-12-05','1996-11-15',2,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10349,'SPLIR',7,'1996-11-08','1996-12-06','1996-11-15',1,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10350,'LAMAI',6,'1996-11-11','1996-12-09','1996-12-03',2,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10351,'ERNSH',1,'1996-11-11','1996-12-09','1996-11-20',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10352,'FURIB',3,'1996-11-12','1996-11-26','1996-11-18',3,0,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa','','1675','Portugal'),(10353,'PICCO',7,'1996-11-13','1996-12-11','1996-11-25',3,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10354,'PERIC',8,'1996-11-14','1996-12-12','1996-11-20',3,0,'Pericles Comidas cl?sicas','Calle Dr. Jorge Cash 321','M?xico D.F.','','05033','Mexico'),(10355,'AROUT',6,'1996-11-15','1996-12-13','1996-11-20',1,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10356,'WANDK',6,'1996-11-18','1996-12-16','1996-11-27',2,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10357,'LILAS',1,'1996-11-19','1996-12-17','1996-12-02',3,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10358,'LAMAI',5,'1996-11-20','1996-12-18','1996-11-27',1,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10359,'SEVES',5,'1996-11-21','1996-12-19','1996-11-26',3,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10360,'BLONP',4,'1996-11-22','1996-12-20','1996-12-02',3,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10361,'QUICK',1,'1996-11-22','1996-12-20','1996-12-03',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10362,'BONAP',3,'1996-11-25','1996-12-23','1996-11-28',1,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10363,'DRACD',4,'1996-11-26','1996-12-24','1996-12-04',3,0,'Drachenblut Delikatessen','Walserweg 21','Aachen','','52066','Germany'),(10364,'EASTC',1,'1996-11-26','1997-01-07','1996-12-04',1,0,'Eastern Connection','35 King George','London','','WX3 6FW','United Kingdom'),(10365,'ANTON',3,'1996-11-27','1996-12-25','1996-12-02',2,0,'Antonio Moreno Taquer?a','Mataderos  2312','M?xico D.F.','','05023','Mexico'),(10366,'GALED',8,'1996-11-28','1997-01-09','1996-12-30',2,0,'Galer?a del gastron?mo','Rambla de Catalu?a, 23','Barcelona','','8022','Spain'),(10367,'VAFFE',7,'1996-11-28','1996-12-26','1996-12-02',3,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10368,'ERNSH',2,'1996-11-29','1996-12-27','1996-12-02',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10369,'SPLIR',8,'1996-12-02','1996-12-30','1996-12-09',2,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10370,'CHOPS',6,'1996-12-03','1996-12-31','1996-12-27',2,0,'Chop-suey Chinese','Hauptstr. 31','Bern','','3012','Switzerland'),(10371,'LAMAI',1,'1996-12-03','1996-12-31','1996-12-24',1,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10372,'QUEEN',5,'1996-12-04','1997-01-01','1996-12-09',2,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10373,'HUNGO',4,'1996-12-05','1997-01-02','1996-12-11',3,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10374,'WOLZA',1,'1996-12-05','1997-01-02','1996-12-09',3,0,'Wolski Zajazd','ul. Filtrowa 68','Warszawa','','01-012','Poland'),(10375,'HUNGC',3,'1996-12-06','1997-01-03','1996-12-09',2,0,'Hungry Coyote Import Store','City Center Plaza\r\n516 Main St.','Elgin','OR','97827','United States'),(10376,'MEREP',1,'1996-12-09','1997-01-06','1996-12-13',2,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10377,'SEVES',1,'1996-12-09','1997-01-06','1996-12-13',3,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10378,'FOLKO',5,'1996-12-10','1997-01-07','1996-12-19',3,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10379,'QUEDE',2,'1996-12-11','1997-01-08','1996-12-13',1,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10380,'HUNGO',8,'1996-12-12','1997-01-09','1997-01-16',3,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10381,'LILAS',3,'1996-12-12','1997-01-09','1996-12-13',3,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10382,'ERNSH',4,'1996-12-13','1997-01-10','1996-12-16',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10383,'AROUT',8,'1996-12-16','1997-01-13','1996-12-18',3,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10384,'BERGS',3,'1996-12-16','1997-01-13','1996-12-20',3,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10385,'SPLIR',1,'1996-12-17','1997-01-14','1996-12-23',2,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10386,'FAMIA',9,'1996-12-18','1997-01-01','1996-12-25',3,0,'Familia Arquibaldo','Rua Or?s, 92','S?o Paulo','SP','05442-030','Brazil'),(10387,'SANTG',1,'1996-12-18','1997-01-15','1996-12-20',2,0,'Sant? Gourmet','Erling Skakkes gate 78','Stavern','','4110','Norway'),(10388,'SEVES',2,'1996-12-19','1997-01-16','1996-12-20',1,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10389,'BOTTM',4,'1996-12-20','1997-01-17','1996-12-24',2,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10390,'ERNSH',6,'1996-12-23','1997-01-20','1996-12-26',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10391,'DRACD',3,'1996-12-23','1997-01-20','1996-12-31',3,0,'Drachenblut Delikatessen','Walserweg 21','Aachen','','52066','Germany'),(10392,'PICCO',2,'1996-12-24','1997-01-21','1997-01-01',3,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10393,'SAVEA',1,'1996-12-25','1997-01-22','1997-01-03',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10394,'HUNGC',1,'1996-12-25','1997-01-22','1997-01-03',3,0,'Hungry Coyote Import Store','City Center Plaza\r\n516 Main St.','Elgin','OR','97827','United States'),(10395,'HILAA',6,'1996-12-26','1997-01-23','1997-01-03',1,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10396,'FRANK',1,'1996-12-27','1997-01-10','1997-01-06',3,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10397,'PRINI',5,'1996-12-27','1997-01-24','1997-01-02',1,0,'Princesa Isabel Vinhos','Estrada da sa?de n. 58','Lisboa','','1756','Portugal'),(10398,'SAVEA',2,'1996-12-30','1997-01-27','1997-01-09',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10399,'VAFFE',8,'1996-12-31','1997-01-14','1997-01-08',3,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10400,'EASTC',1,'1997-01-01','1997-01-29','1997-01-16',3,0,'Eastern Connection','35 King George','London','','WX3 6FW','United Kingdom'),(10401,'RATTC',1,'1997-01-01','1997-01-29','1997-01-10',1,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10402,'ERNSH',8,'1997-01-02','1997-02-13','1997-01-10',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10403,'ERNSH',4,'1997-01-03','1997-01-31','1997-01-09',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10404,'MAGAA',2,'1997-01-03','1997-01-31','1997-01-08',1,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10405,'LINOD',1,'1997-01-06','1997-02-03','1997-01-22',1,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10406,'QUEEN',7,'1997-01-07','1997-02-18','1997-01-13',1,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10407,'OTTIK',2,'1997-01-07','1997-02-04','1997-01-30',2,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(10408,'FOLIG',8,'1997-01-08','1997-02-05','1997-01-14',1,0,'Folies gourmandes','184, chauss?e de Tournai','Lille','','59000','France'),(10409,'OCEAN',3,'1997-01-09','1997-02-06','1997-01-14',1,0,'Oc?ano Atl?ntico Ltda.','Ing. Gustavo Moncada 8585\r\nPiso 20-A','Buenos Aires','','1010','Argentina'),(10410,'BOTTM',3,'1997-01-10','1997-02-07','1997-01-15',3,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10411,'BOTTM',9,'1997-01-10','1997-02-07','1997-01-21',3,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10412,'WARTH',8,'1997-01-13','1997-02-10','1997-01-15',2,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10413,'LAMAI',3,'1997-01-14','1997-02-11','1997-01-16',2,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10414,'FAMIA',2,'1997-01-14','1997-02-11','1997-01-17',3,0,'Familia Arquibaldo','Rua Or?s, 92','S?o Paulo','SP','05442-030','Brazil'),(10415,'HUNGC',3,'1997-01-15','1997-02-12','1997-01-24',1,0,'Hungry Coyote Import Store','City Center Plaza\r\n516 Main St.','Elgin','OR','97827','United States'),(10416,'WARTH',8,'1997-01-16','1997-02-13','1997-01-27',3,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10417,'SIMOB',4,'1997-01-16','1997-02-13','1997-01-28',3,0,'Simons bistro','Vinb?ltet 34','K?benhavn','','1734','Denmark'),(10418,'QUICK',4,'1997-01-17','1997-02-14','1997-01-24',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10419,'RICSU',4,'1997-01-20','1997-02-17','1997-01-30',2,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(10420,'WELLI',3,'1997-01-21','1997-02-18','1997-01-27',1,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10421,'QUEDE',8,'1997-01-21','1997-03-04','1997-01-27',1,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10422,'FRANS',2,'1997-01-22','1997-02-19','1997-01-31',1,0,'Franchi S.p.A.','Via Monte Bianco 34','Torino','','10100','Italy'),(10423,'GOURL',6,'1997-01-23','1997-02-06','1997-02-24',3,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(10424,'MEREP',7,'1997-01-23','1997-02-20','1997-01-27',2,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10425,'LAMAI',6,'1997-01-24','1997-02-21','1997-02-14',2,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10426,'GALED',4,'1997-01-27','1997-02-24','1997-02-06',1,0,'Galer?a del gastron?mo','Rambla de Catalu?a, 23','Barcelona','','8022','Spain'),(10427,'PICCO',4,'1997-01-27','1997-02-24','1997-03-03',2,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10428,'REGGC',7,'1997-01-28','1997-02-25','1997-02-04',1,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10429,'HUNGO',3,'1997-01-29','1997-03-12','1997-02-07',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10430,'ERNSH',4,'1997-01-30','1997-02-13','1997-02-03',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10431,'BOTTM',4,'1997-01-30','1997-02-13','1997-02-07',2,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10432,'SPLIR',3,'1997-01-31','1997-02-14','1997-02-07',2,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10433,'PRINI',3,'1997-02-03','1997-03-03','1997-03-04',3,0,'Princesa Isabel Vinhos','Estrada da sa?de n. 58','Lisboa','','1756','Portugal'),(10434,'FOLKO',3,'1997-02-03','1997-03-03','1997-02-13',2,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10435,'CONSH',8,'1997-02-04','1997-03-18','1997-02-07',2,0,'Consolidated Holdings','Berkeley Gardens\r\n12  Brewery','London','','WX1 6LT','United Kingdom'),(10436,'BLONP',3,'1997-02-05','1997-03-05','1997-02-11',2,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10437,'WARTH',8,'1997-02-05','1997-03-05','1997-02-12',1,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10438,'TOMSP',3,'1997-02-06','1997-03-06','1997-02-14',2,0,'Toms Spezialit?ten','Luisenstr. 48','M?nster','','44087','Germany'),(10439,'MEREP',6,'1997-02-07','1997-03-07','1997-02-10',3,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10440,'SAVEA',4,'1997-02-10','1997-03-10','1997-02-28',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10441,'OLDWO',3,'1997-02-10','1997-03-24','1997-03-14',2,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10442,'ERNSH',3,'1997-02-11','1997-03-11','1997-02-18',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10443,'REGGC',8,'1997-02-12','1997-03-12','1997-02-14',1,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10444,'BERGS',3,'1997-02-12','1997-03-12','1997-02-21',3,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10445,'BERGS',3,'1997-02-13','1997-03-13','1997-02-20',1,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10446,'TOMSP',6,'1997-02-14','1997-03-14','1997-02-19',1,0,'Toms Spezialit?ten','Luisenstr. 48','M?nster','','44087','Germany'),(10447,'RICAR',4,'1997-02-14','1997-03-14','1997-03-07',2,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10448,'RANCH',4,'1997-02-17','1997-03-17','1997-02-24',2,0,'Rancho grande','Av. del Libertador 900','Buenos Aires','','1010','Argentina'),(10449,'BLONP',3,'1997-02-18','1997-03-18','1997-02-27',2,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10450,'VICTE',8,'1997-02-19','1997-03-19','1997-03-11',2,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10451,'QUICK',4,'1997-02-19','1997-03-05','1997-03-12',3,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10452,'SAVEA',8,'1997-02-20','1997-03-20','1997-02-26',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10453,'AROUT',1,'1997-02-21','1997-03-21','1997-02-26',2,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10454,'LAMAI',4,'1997-02-21','1997-03-21','1997-02-25',3,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10455,'WARTH',8,'1997-02-24','1997-04-07','1997-03-03',2,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10456,'KOENE',8,'1997-02-25','1997-04-08','1997-02-28',2,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10457,'KOENE',2,'1997-02-25','1997-03-25','1997-03-03',1,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10458,'SUPRD',7,'1997-02-26','1997-03-26','1997-03-04',3,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10459,'VICTE',4,'1997-02-27','1997-03-27','1997-02-28',2,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10460,'FOLKO',8,'1997-02-28','1997-03-28','1997-03-03',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10461,'LILAS',1,'1997-02-28','1997-03-28','1997-03-05',3,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10462,'CONSH',2,'1997-03-03','1997-03-31','1997-03-18',1,0,'Consolidated Holdings','Berkeley Gardens\r\n12  Brewery','London','','WX1 6LT','United Kingdom'),(10463,'SUPRD',5,'1997-03-04','1997-04-01','1997-03-06',3,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10464,'FURIB',4,'1997-03-04','1997-04-01','1997-03-14',2,0,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa','','1675','Portugal'),(10465,'VAFFE',1,'1997-03-05','1997-04-02','1997-03-14',3,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10466,'COMMI',4,'1997-03-06','1997-04-03','1997-03-13',1,0,'Com?rcio Mineiro','Av. dos Lus?adas, 23','S?o Paulo','SP','05432-043','Brazil'),(10467,'MAGAA',8,'1997-03-06','1997-04-03','1997-03-11',2,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10468,'KOENE',3,'1997-03-07','1997-04-04','1997-03-12',3,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10469,'WHITC',1,'1997-03-10','1997-04-07','1997-03-14',1,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10470,'BONAP',4,'1997-03-11','1997-04-08','1997-03-14',2,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10471,'BSBEV',2,'1997-03-11','1997-04-08','1997-03-18',3,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10472,'SEVES',8,'1997-03-12','1997-04-09','1997-03-19',1,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10473,'ISLAT',1,'1997-03-13','1997-03-27','1997-03-21',3,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10474,'PERIC',5,'1997-03-13','1997-04-10','1997-03-21',2,0,'Pericles Comidas cl?sicas','Calle Dr. Jorge Cash 321','M?xico D.F.','','05033','Mexico'),(10475,'SUPRD',9,'1997-03-14','1997-04-11','1997-04-04',1,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10476,'HILAA',8,'1997-03-17','1997-04-14','1997-03-24',3,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10477,'PRINI',5,'1997-03-17','1997-04-14','1997-03-25',2,0,'Princesa Isabel Vinhos','Estrada da sa?de n. 58','Lisboa','','1756','Portugal'),(10478,'VICTE',2,'1997-03-18','1997-04-01','1997-03-26',3,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10479,'RATTC',3,'1997-03-19','1997-04-16','1997-03-21',3,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10480,'FOLIG',6,'1997-03-20','1997-04-17','1997-03-24',2,0,'Folies gourmandes','184, chauss?e de Tournai','Lille','','59000','France'),(10481,'RICAR',8,'1997-03-20','1997-04-17','1997-03-25',2,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10482,'LAZYK',1,'1997-03-21','1997-04-18','1997-04-10',3,0,'Lazy K Kountry Store','12 Orchestra Terrace','Walla Walla','WA','99362','United States'),(10483,'WHITC',7,'1997-03-24','1997-04-21','1997-04-25',2,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10484,'BSBEV',3,'1997-03-24','1997-04-21','1997-04-01',3,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10485,'LINOD',4,'1997-03-25','1997-04-08','1997-03-31',2,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10486,'HILAA',1,'1997-03-26','1997-04-23','1997-04-02',2,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10487,'QUEEN',2,'1997-03-26','1997-04-23','1997-03-28',2,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10488,'FRANK',8,'1997-03-27','1997-04-24','1997-04-02',2,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10489,'PICCO',6,'1997-03-28','1997-04-25','1997-04-09',2,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10490,'HILAA',7,'1997-03-31','1997-04-28','1997-04-03',2,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10491,'FURIB',8,'1997-03-31','1997-04-28','1997-04-08',3,0,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa','','1675','Portugal'),(10492,'BOTTM',3,'1997-04-01','1997-04-29','1997-04-11',1,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10493,'LAMAI',4,'1997-04-02','1997-04-30','1997-04-10',3,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10494,'COMMI',4,'1997-04-02','1997-04-30','1997-04-09',2,0,'Com?rcio Mineiro','Av. dos Lus?adas, 23','S?o Paulo','SP','05432-043','Brazil'),(10495,'LAUGB',3,'1997-04-03','1997-05-01','1997-04-11',3,0,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada'),(10496,'TRADH',7,'1997-04-04','1997-05-02','1997-04-07',2,0,'Tradi??o Hipermercados','Av. In?s de Castro, 414','S?o Paulo','SP','05634-030','Brazil'),(10497,'LEHMS',7,'1997-04-04','1997-05-02','1997-04-07',1,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10498,'HILAA',8,'1997-04-07','1997-05-05','1997-04-11',2,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10499,'LILAS',4,'1997-04-08','1997-05-06','1997-04-16',2,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10500,'LAMAI',6,'1997-04-09','1997-05-07','1997-04-17',1,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10501,'BLAUS',9,'1997-04-09','1997-05-07','1997-04-16',3,0,'Blauer See Delikatessen','Forsterstr. 57','Mannheim','','68306','Germany'),(10502,'PERIC',2,'1997-04-10','1997-05-08','1997-04-29',1,0,'Pericles Comidas cl?sicas','Calle Dr. Jorge Cash 321','M?xico D.F.','','05033','Mexico'),(10503,'HUNGO',6,'1997-04-11','1997-05-09','1997-04-16',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10504,'WHITC',4,'1997-04-11','1997-05-09','1997-04-18',3,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10505,'MEREP',3,'1997-04-14','1997-05-12','1997-04-21',3,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10506,'KOENE',9,'1997-04-15','1997-05-13','1997-05-02',2,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10507,'ANTON',7,'1997-04-15','1997-05-13','1997-04-22',1,0,'Antonio Moreno Taquer?a','Mataderos  2312','M?xico D.F.','','05023','Mexico'),(10508,'OTTIK',1,'1997-04-16','1997-05-14','1997-05-13',2,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(10509,'BLAUS',4,'1997-04-17','1997-05-15','1997-04-29',1,0,'Blauer See Delikatessen','Forsterstr. 57','Mannheim','','68306','Germany'),(10510,'SAVEA',6,'1997-04-18','1997-05-16','1997-04-28',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10511,'BONAP',4,'1997-04-18','1997-05-16','1997-04-21',3,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10512,'FAMIA',7,'1997-04-21','1997-05-19','1997-04-24',2,0,'Familia Arquibaldo','Rua Or?s, 92','S?o Paulo','SP','05442-030','Brazil'),(10513,'WANDK',7,'1997-04-22','1997-06-03','1997-04-28',1,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10514,'ERNSH',3,'1997-04-22','1997-05-20','1997-05-16',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10515,'QUICK',2,'1997-04-23','1997-05-07','1997-05-23',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10516,'HUNGO',2,'1997-04-24','1997-05-22','1997-05-01',3,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10517,'NORTS',3,'1997-04-24','1997-05-22','1997-04-29',3,0,'North/South','South House\r\n300 Queensbridge','London','','SW7 1RZ','United Kingdom'),(10518,'TORTU',4,'1997-04-25','1997-05-09','1997-05-05',2,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10519,'CHOPS',6,'1997-04-28','1997-05-26','1997-05-01',3,0,'Chop-suey Chinese','Hauptstr. 31','Bern','','3012','Switzerland'),(10520,'SANTG',7,'1997-04-29','1997-05-27','1997-05-01',1,0,'Sant? Gourmet','Erling Skakkes gate 78','Stavern','','4110','Norway'),(10521,'CACTU',8,'1997-04-29','1997-05-27','1997-05-02',2,0,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires','','1010','Argentina'),(10522,'LEHMS',4,'1997-04-30','1997-05-28','1997-05-06',1,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10523,'SEVES',7,'1997-05-01','1997-05-29','1997-05-30',2,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10524,'BERGS',1,'1997-05-01','1997-05-29','1997-05-07',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10525,'BONAP',1,'1997-05-02','1997-05-30','1997-05-23',2,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10526,'WARTH',4,'1997-05-05','1997-06-02','1997-05-15',2,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10527,'QUICK',7,'1997-05-05','1997-06-02','1997-05-07',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10528,'GREAL',6,'1997-05-06','1997-05-20','1997-05-09',2,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(10529,'MAISD',5,'1997-05-07','1997-06-04','1997-05-09',2,0,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles','','B-1180','Belgium'),(10530,'PICCO',3,'1997-05-08','1997-06-05','1997-05-12',2,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10531,'OCEAN',7,'1997-05-08','1997-06-05','1997-05-19',1,0,'Oc?ano Atl?ntico Ltda.','Ing. Gustavo Moncada 8585\r\nPiso 20-A','Buenos Aires','','1010','Argentina'),(10532,'EASTC',7,'1997-05-09','1997-06-06','1997-05-12',3,0,'Eastern Connection','35 King George','London','','WX3 6FW','United Kingdom'),(10533,'FOLKO',8,'1997-05-12','1997-06-09','1997-05-22',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10534,'LEHMS',8,'1997-05-12','1997-06-09','1997-05-14',2,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10535,'ANTON',4,'1997-05-13','1997-06-10','1997-05-21',1,0,'Antonio Moreno Taquer?a','Mataderos  2312','M?xico D.F.','','05023','Mexico'),(10536,'LEHMS',3,'1997-05-14','1997-06-11','1997-06-06',2,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10537,'RICSU',1,'1997-05-14','1997-05-28','1997-05-19',1,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(10538,'BSBEV',9,'1997-05-15','1997-06-12','1997-05-16',3,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10539,'BSBEV',6,'1997-05-16','1997-06-13','1997-05-23',3,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10540,'QUICK',3,'1997-05-19','1997-06-16','1997-06-13',3,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10541,'HANAR',2,'1997-05-19','1997-06-16','1997-05-29',1,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10542,'KOENE',1,'1997-05-20','1997-06-17','1997-05-26',3,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10543,'LILAS',8,'1997-05-21','1997-06-18','1997-05-23',2,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10544,'LONEP',4,'1997-05-21','1997-06-18','1997-05-30',1,0,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','United States'),(10545,'LAZYK',8,'1997-05-22','1997-06-19','1997-06-26',2,0,'Lazy K Kountry Store','12 Orchestra Terrace','Walla Walla','WA','99362','United States'),(10546,'VICTE',1,'1997-05-23','1997-06-20','1997-05-27',3,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10547,'SEVES',3,'1997-05-23','1997-06-20','1997-06-02',2,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10548,'TOMSP',3,'1997-05-26','1997-06-23','1997-06-02',2,0,'Toms Spezialit?ten','Luisenstr. 48','M?nster','','44087','Germany'),(10549,'QUICK',5,'1997-05-27','1997-06-10','1997-05-30',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10550,'GODOS',7,'1997-05-28','1997-06-25','1997-06-06',3,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(10551,'FURIB',4,'1997-05-28','1997-07-09','1997-06-06',3,0,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa','','1675','Portugal'),(10552,'HILAA',2,'1997-05-29','1997-06-26','1997-06-05',1,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10553,'WARTH',2,'1997-05-30','1997-06-27','1997-06-03',2,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10554,'OTTIK',4,'1997-05-30','1997-06-27','1997-06-05',3,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(10555,'SAVEA',6,'1997-06-02','1997-06-30','1997-06-04',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10556,'SIMOB',2,'1997-06-03','1997-07-15','1997-06-13',1,0,'Simons bistro','Vinb?ltet 34','K?benhavn','','1734','Denmark'),(10557,'LEHMS',9,'1997-06-03','1997-06-17','1997-06-06',2,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10558,'AROUT',1,'1997-06-04','1997-07-02','1997-06-10',2,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10559,'BLONP',6,'1997-06-05','1997-07-03','1997-06-13',1,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10560,'FRANK',8,'1997-06-06','1997-07-04','1997-06-09',1,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10561,'FOLKO',2,'1997-06-06','1997-07-04','1997-06-09',2,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10562,'REGGC',1,'1997-06-09','1997-07-07','1997-06-12',1,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10563,'RICAR',2,'1997-06-10','1997-07-22','1997-06-24',2,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10564,'RATTC',4,'1997-06-10','1997-07-08','1997-06-16',3,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10565,'MEREP',8,'1997-06-11','1997-07-09','1997-06-18',2,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10566,'BLONP',9,'1997-06-12','1997-07-10','1997-06-18',1,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10567,'HUNGO',1,'1997-06-12','1997-07-10','1997-06-17',1,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10568,'GALED',3,'1997-06-13','1997-07-11','1997-07-09',3,0,'Galer?a del gastron?mo','Rambla de Catalu?a, 23','Barcelona','','8022','Spain'),(10569,'RATTC',5,'1997-06-16','1997-07-14','1997-07-11',1,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10570,'MEREP',3,'1997-06-17','1997-07-15','1997-06-19',3,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10571,'ERNSH',8,'1997-06-17','1997-07-29','1997-07-04',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10572,'BERGS',3,'1997-06-18','1997-07-16','1997-06-25',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10573,'ANTON',7,'1997-06-19','1997-07-17','1997-06-20',3,0,'Antonio Moreno Taquer?a','Mataderos  2312','M?xico D.F.','','05023','Mexico'),(10574,'TRAIH',4,'1997-06-19','1997-07-17','1997-06-30',2,0,'Trail\'s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','United States'),(10575,'MORGK',5,'1997-06-20','1997-07-04','1997-06-30',1,0,'Morgenstern Gesundkost','Heerstr. 22','Leipzig','','04179','Germany'),(10576,'TORTU',3,'1997-06-23','1997-07-07','1997-06-30',3,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10577,'TRAIH',9,'1997-06-23','1997-08-04','1997-06-30',2,0,'Trail\'s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','United States'),(10578,'BSBEV',4,'1997-06-24','1997-07-22','1997-07-25',3,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10579,'LETSS',1,'1997-06-25','1997-07-23','1997-07-04',2,0,'Let\'s Stop N Shop','87 Polk St.\r\nSuite 5','San Francisco','CA','94117','United States'),(10580,'OTTIK',4,'1997-06-26','1997-07-24','1997-07-01',3,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(10581,'FAMIA',3,'1997-06-26','1997-07-24','1997-07-02',1,0,'Familia Arquibaldo','Rua Or?s, 92','S?o Paulo','SP','05442-030','Brazil'),(10582,'BLAUS',3,'1997-06-27','1997-07-25','1997-07-14',2,0,'Blauer See Delikatessen','Forsterstr. 57','Mannheim','','68306','Germany'),(10583,'WARTH',2,'1997-06-30','1997-07-28','1997-07-04',2,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10584,'BLONP',4,'1997-06-30','1997-07-28','1997-07-04',1,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10585,'WELLI',7,'1997-07-01','1997-07-29','1997-07-10',1,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10586,'REGGC',9,'1997-07-02','1997-07-30','1997-07-09',1,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10587,'QUEDE',1,'1997-07-02','1997-07-30','1997-07-09',1,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10588,'QUICK',2,'1997-07-03','1997-07-31','1997-07-10',3,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10589,'GREAL',8,'1997-07-04','1997-08-01','1997-07-14',2,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(10590,'MEREP',4,'1997-07-07','1997-08-04','1997-07-14',3,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10591,'VAFFE',1,'1997-07-07','1997-07-21','1997-07-16',1,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10592,'LEHMS',3,'1997-07-08','1997-08-05','1997-07-16',1,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10593,'LEHMS',7,'1997-07-09','1997-08-06','1997-08-13',2,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10594,'OLDWO',3,'1997-07-09','1997-08-06','1997-07-16',2,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10595,'ERNSH',2,'1997-07-10','1997-08-07','1997-07-14',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10596,'WHITC',8,'1997-07-11','1997-08-08','1997-08-12',1,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10597,'PICCO',7,'1997-07-11','1997-08-08','1997-07-18',3,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10598,'RATTC',1,'1997-07-14','1997-08-11','1997-07-18',3,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10599,'BSBEV',6,'1997-07-15','1997-08-26','1997-07-21',3,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10600,'HUNGC',4,'1997-07-16','1997-08-13','1997-07-21',1,0,'Hungry Coyote Import Store','City Center Plaza\r\n516 Main St.','Elgin','OR','97827','United States'),(10601,'HILAA',7,'1997-07-16','1997-08-27','1997-07-22',1,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10602,'VAFFE',8,'1997-07-17','1997-08-14','1997-07-22',2,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10603,'SAVEA',8,'1997-07-18','1997-08-15','1997-08-08',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10604,'FURIB',1,'1997-07-18','1997-08-15','1997-07-29',1,0,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa','','1675','Portugal'),(10605,'MEREP',1,'1997-07-21','1997-08-18','1997-07-29',2,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10606,'TRADH',4,'1997-07-22','1997-08-19','1997-07-31',3,0,'Tradi??o Hipermercados','Av. In?s de Castro, 414','S?o Paulo','SP','05634-030','Brazil'),(10607,'SAVEA',5,'1997-07-22','1997-08-19','1997-07-25',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10608,'TOMSP',4,'1997-07-23','1997-08-20','1997-08-01',2,0,'Toms Spezialit?ten','Luisenstr. 48','M?nster','','44087','Germany'),(10609,'DUMON',7,'1997-07-24','1997-08-21','1997-07-30',2,0,'Du monde entier','67, rue des Cinquante Otages','Nantes','','44000','France'),(10610,'LAMAI',8,'1997-07-25','1997-08-22','1997-08-06',1,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10611,'WOLZA',6,'1997-07-25','1997-08-22','1997-08-01',2,0,'Wolski Zajazd','ul. Filtrowa 68','Warszawa','','01-012','Poland'),(10612,'SAVEA',1,'1997-07-28','1997-08-25','1997-08-01',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10613,'HILAA',4,'1997-07-29','1997-08-26','1997-08-01',2,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10614,'BLAUS',8,'1997-07-29','1997-08-26','1997-08-01',3,0,'Blauer See Delikatessen','Forsterstr. 57','Mannheim','','68306','Germany'),(10615,'WILMK',2,'1997-07-30','1997-08-27','1997-08-06',3,0,'Wilman Kala','Keskuskatu 45','Helsinki','','21240','Finland'),(10616,'GREAL',1,'1997-07-31','1997-08-28','1997-08-05',2,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(10617,'GREAL',4,'1997-07-31','1997-08-28','1997-08-04',2,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(10618,'MEREP',1,'1997-08-01','1997-09-12','1997-08-08',1,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10619,'MEREP',3,'1997-08-04','1997-09-01','1997-08-07',3,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10620,'LAUGB',2,'1997-08-05','1997-09-02','1997-08-14',3,0,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada'),(10621,'ISLAT',4,'1997-08-05','1997-09-02','1997-08-11',2,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10622,'RICAR',4,'1997-08-06','1997-09-03','1997-08-11',3,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10623,'FRANK',8,'1997-08-07','1997-09-04','1997-08-12',2,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10624,'THECR',4,'1997-08-07','1997-09-04','1997-08-19',2,0,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','United States'),(10625,'ANATR',3,'1997-08-08','1997-09-05','1997-08-14',1,0,'Ana Trujillo Emparedados y helados','Avda. de la Constituci?n 2222','M?xico D.F.','','05021','Mexico'),(10626,'BERGS',1,'1997-08-11','1997-09-08','1997-08-20',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10627,'SAVEA',8,'1997-08-11','1997-09-22','1997-08-21',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10628,'BLONP',4,'1997-08-12','1997-09-09','1997-08-20',3,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10629,'GODOS',4,'1997-08-12','1997-09-09','1997-08-20',3,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(10630,'KOENE',1,'1997-08-13','1997-09-10','1997-08-19',2,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10631,'LAMAI',8,'1997-08-14','1997-09-11','1997-08-15',1,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10632,'WANDK',8,'1997-08-14','1997-09-11','1997-08-19',1,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10633,'ERNSH',7,'1997-08-15','1997-09-12','1997-08-18',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10634,'FOLIG',4,'1997-08-15','1997-09-12','1997-08-21',3,0,'Folies gourmandes','184, chauss?e de Tournai','Lille','','59000','France'),(10635,'MAGAA',8,'1997-08-18','1997-09-15','1997-08-21',3,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10636,'WARTH',4,'1997-08-19','1997-09-16','1997-08-26',1,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10637,'QUEEN',6,'1997-08-19','1997-09-16','1997-08-26',1,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10638,'LINOD',3,'1997-08-20','1997-09-17','1997-09-01',1,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10639,'SANTG',7,'1997-08-20','1997-09-17','1997-08-27',3,0,'Sant? Gourmet','Erling Skakkes gate 78','Stavern','','4110','Norway'),(10640,'WANDK',4,'1997-08-21','1997-09-18','1997-08-28',1,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10641,'HILAA',4,'1997-08-22','1997-09-19','1997-08-26',2,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10642,'SIMOB',7,'1997-08-22','1997-09-19','1997-09-05',3,0,'Simons bistro','Vinb?ltet 34','K?benhavn','','1734','Denmark'),(10643,'ALFKI',6,'1997-08-25','1997-09-22','1997-09-02',1,0,'Alfreds Futterkiste','Obere Str. 57','Berlin','','12209','Germany'),(10644,'WELLI',3,'1997-08-25','1997-09-22','1997-09-01',2,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10645,'HANAR',4,'1997-08-26','1997-09-23','1997-09-02',1,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10646,'HUNGO',9,'1997-08-27','1997-10-08','1997-09-03',3,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10647,'QUEDE',4,'1997-08-27','1997-09-10','1997-09-03',2,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10648,'RICAR',5,'1997-08-28','1997-10-09','1997-09-09',2,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10649,'MAISD',5,'1997-08-28','1997-09-25','1997-08-29',3,0,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles','','B-1180','Belgium'),(10650,'FAMIA',5,'1997-08-29','1997-09-26','1997-09-03',3,0,'Familia Arquibaldo','Rua Or?s, 92','S?o Paulo','SP','05442-030','Brazil'),(10651,'WANDK',8,'1997-09-01','1997-09-29','1997-09-11',2,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10652,'GOURL',4,'1997-09-01','1997-09-29','1997-09-08',2,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(10653,'FRANK',1,'1997-09-02','1997-09-30','1997-09-19',1,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10654,'BERGS',5,'1997-09-02','1997-09-30','1997-09-11',1,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10655,'REGGC',1,'1997-09-03','1997-10-01','1997-09-11',2,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10656,'GREAL',6,'1997-09-04','1997-10-02','1997-09-10',1,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(10657,'SAVEA',2,'1997-09-04','1997-10-02','1997-09-15',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10658,'QUICK',4,'1997-09-05','1997-10-03','1997-09-08',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10659,'QUEEN',7,'1997-09-05','1997-10-03','1997-09-10',2,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10660,'HUNGC',8,'1997-09-08','1997-10-06','1997-10-15',1,0,'Hungry Coyote Import Store','City Center Plaza\r\n516 Main St.','Elgin','OR','97827','United States'),(10661,'HUNGO',7,'1997-09-09','1997-10-07','1997-09-15',3,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10662,'LONEP',3,'1997-09-09','1997-10-07','1997-09-18',2,0,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','United States'),(10663,'BONAP',2,'1997-09-10','1997-09-24','1997-10-03',2,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10664,'FURIB',1,'1997-09-10','1997-10-08','1997-09-19',3,0,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa','','1675','Portugal'),(10665,'LONEP',1,'1997-09-11','1997-10-09','1997-09-17',2,0,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','United States'),(10666,'RICSU',7,'1997-09-12','1997-10-10','1997-09-22',2,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(10667,'ERNSH',7,'1997-09-12','1997-10-10','1997-09-19',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10668,'WANDK',1,'1997-09-15','1997-10-13','1997-09-23',2,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(10669,'SIMOB',2,'1997-09-15','1997-10-13','1997-09-22',1,0,'Simons bistro','Vinb?ltet 34','K?benhavn','','1734','Denmark'),(10670,'FRANK',4,'1997-09-16','1997-10-14','1997-09-18',1,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10671,'FRANR',1,'1997-09-17','1997-10-15','1997-09-24',1,0,'France restauration','54, rue Royale','Nantes','','44000','France'),(10672,'BERGS',9,'1997-09-17','1997-10-01','1997-09-26',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10673,'WILMK',2,'1997-09-18','1997-10-16','1997-09-19',1,0,'Wilman Kala','Keskuskatu 45','Helsinki','','21240','Finland'),(10674,'ISLAT',4,'1997-09-18','1997-10-16','1997-09-30',2,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10675,'FRANK',5,'1997-09-19','1997-10-17','1997-09-23',2,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10676,'TORTU',2,'1997-09-22','1997-10-20','1997-09-29',2,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10677,'ANTON',1,'1997-09-22','1997-10-20','1997-09-26',3,0,'Antonio Moreno Taquer?a','Mataderos  2312','M?xico D.F.','','05023','Mexico'),(10678,'SAVEA',7,'1997-09-23','1997-10-21','1997-10-16',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10679,'BLONP',8,'1997-09-23','1997-10-21','1997-09-30',3,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10680,'OLDWO',1,'1997-09-24','1997-10-22','1997-09-26',1,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10681,'GREAL',3,'1997-09-25','1997-10-23','1997-09-30',3,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(10682,'ANTON',3,'1997-09-25','1997-10-23','1997-10-01',2,0,'Antonio Moreno Taquer?a','Mataderos  2312','M?xico D.F.','','05023','Mexico'),(10683,'DUMON',2,'1997-09-26','1997-10-24','1997-10-01',1,0,'Du monde entier','67, rue des Cinquante Otages','Nantes','','44000','France'),(10684,'OTTIK',3,'1997-09-26','1997-10-24','1997-09-30',1,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(10685,'GOURL',4,'1997-09-29','1997-10-13','1997-10-03',2,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(10686,'PICCO',2,'1997-09-30','1997-10-28','1997-10-08',1,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10687,'HUNGO',9,'1997-09-30','1997-10-28','1997-10-30',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10688,'VAFFE',4,'1997-10-01','1997-10-15','1997-10-07',2,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10689,'BERGS',1,'1997-10-01','1997-10-29','1997-10-07',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10690,'HANAR',1,'1997-10-02','1997-10-30','1997-10-03',1,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10691,'QUICK',2,'1997-10-03','1997-11-14','1997-10-22',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10692,'ALFKI',4,'1997-10-03','1997-10-31','1997-10-13',2,0,'Alfreds Futterkiste','Obere Str. 57','Berlin','','12209','Germany'),(10693,'WHITC',3,'1997-10-06','1997-10-20','1997-10-10',3,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10694,'QUICK',8,'1997-10-06','1997-11-03','1997-10-09',3,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10695,'WILMK',7,'1997-10-07','1997-11-18','1997-10-14',1,0,'Wilman Kala','Keskuskatu 45','Helsinki','','21240','Finland'),(10696,'WHITC',8,'1997-10-08','1997-11-19','1997-10-14',3,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10697,'LINOD',3,'1997-10-08','1997-11-05','1997-10-14',1,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10698,'ERNSH',4,'1997-10-09','1997-11-06','1997-10-17',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10699,'MORGK',3,'1997-10-09','1997-11-06','1997-10-13',3,0,'Morgenstern Gesundkost','Heerstr. 22','Leipzig','','04179','Germany'),(10700,'SAVEA',3,'1997-10-10','1997-11-07','1997-10-16',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10701,'HUNGO',6,'1997-10-13','1997-10-27','1997-10-15',3,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10702,'ALFKI',4,'1997-10-13','1997-11-24','1997-10-21',1,0,'Alfreds Futterkiste','Obere Str. 57','Berlin','','12209','Germany'),(10703,'FOLKO',6,'1997-10-14','1997-11-11','1997-10-20',2,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10704,'QUEEN',6,'1997-10-14','1997-11-11','1997-11-07',1,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10705,'HILAA',9,'1997-10-15','1997-11-12','1997-11-18',2,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10706,'OLDWO',8,'1997-10-16','1997-11-13','1997-10-21',3,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10707,'AROUT',4,'1997-10-16','1997-10-30','1997-10-23',3,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10708,'THEBI',6,'1997-10-17','1997-11-28','1997-11-05',2,0,'The Big Cheese','89 Jefferson Way\r\nSuite 2','Portland','OR','97201','United States'),(10709,'GOURL',1,'1997-10-17','1997-11-14','1997-11-20',3,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(10710,'FRANS',1,'1997-10-20','1997-11-17','1997-10-23',1,0,'Franchi S.p.A.','Via Monte Bianco 34','Torino','','10100','Italy'),(10711,'SAVEA',5,'1997-10-21','1997-12-02','1997-10-29',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10712,'HUNGO',3,'1997-10-21','1997-11-18','1997-10-31',1,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10713,'SAVEA',1,'1997-10-22','1997-11-19','1997-10-24',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10714,'SAVEA',5,'1997-10-22','1997-11-19','1997-10-27',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10715,'BONAP',3,'1997-10-23','1997-11-06','1997-10-29',1,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10716,'RANCH',4,'1997-10-24','1997-11-21','1997-10-27',2,0,'Rancho grande','Av. del Libertador 900','Buenos Aires','','1010','Argentina'),(10717,'FRANK',1,'1997-10-24','1997-11-21','1997-10-29',2,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10718,'KOENE',1,'1997-10-27','1997-11-24','1997-10-29',3,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10719,'LETSS',8,'1997-10-27','1997-11-24','1997-11-05',2,0,'Let\'s Stop N Shop','87 Polk St.\r\nSuite 5','San Francisco','CA','94117','United States'),(10720,'QUEDE',8,'1997-10-28','1997-11-11','1997-11-05',2,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10721,'QUICK',5,'1997-10-29','1997-11-26','1997-10-31',3,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10722,'SAVEA',8,'1997-10-29','1997-12-10','1997-11-04',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10723,'WHITC',3,'1997-10-30','1997-11-27','1997-11-25',1,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10724,'MEREP',8,'1997-10-30','1997-12-11','1997-11-05',2,0,'M?re Paillarde','43 rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada'),(10725,'FAMIA',4,'1997-10-31','1997-11-28','1997-11-05',3,0,'Familia Arquibaldo','Rua Or?s, 92','S?o Paulo','SP','05442-030','Brazil'),(10726,'EASTC',4,'1997-11-03','1997-11-17','1997-12-05',1,0,'Eastern Connection','35 King George','London','','WX3 6FW','United Kingdom'),(10727,'REGGC',2,'1997-11-03','1997-12-01','1997-12-05',1,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10728,'QUEEN',4,'1997-11-04','1997-12-02','1997-11-11',2,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10729,'LINOD',8,'1997-11-04','1997-12-16','1997-11-14',3,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10730,'BONAP',5,'1997-11-05','1997-12-03','1997-11-14',1,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10731,'CHOPS',7,'1997-11-06','1997-12-04','1997-11-14',1,0,'Chop-suey Chinese','Hauptstr. 31','Bern','','3012','Switzerland'),(10732,'BONAP',3,'1997-11-06','1997-12-04','1997-11-07',1,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10733,'BERGS',1,'1997-11-07','1997-12-05','1997-11-10',3,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10734,'GOURL',2,'1997-11-07','1997-12-05','1997-11-12',3,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(10735,'LETSS',6,'1997-11-10','1997-12-08','1997-11-21',2,0,'Let\'s Stop N Shop','87 Polk St.\r\nSuite 5','San Francisco','CA','94117','United States'),(10736,'HUNGO',9,'1997-11-11','1997-12-09','1997-11-21',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10737,'VINET',2,'1997-11-11','1997-12-09','1997-11-18',2,0,'Vins et alcools Chevalier','59 rue de l\'Abbaye','Reims','','51100','France'),(10738,'SPECD',2,'1997-11-12','1997-12-10','1997-11-18',1,0,'Sp?cialit?s du monde','25, rue Lauriston','Paris','','75016','France'),(10739,'VINET',3,'1997-11-12','1997-12-10','1997-11-17',3,0,'Vins et alcools Chevalier','59 rue de l\'Abbaye','Reims','','51100','France'),(10740,'WHITC',4,'1997-11-13','1997-12-11','1997-11-25',2,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10741,'AROUT',4,'1997-11-14','1997-11-28','1997-11-18',3,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10742,'BOTTM',3,'1997-11-14','1997-12-12','1997-11-18',3,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10743,'AROUT',1,'1997-11-17','1997-12-15','1997-11-21',2,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10744,'VAFFE',6,'1997-11-17','1997-12-15','1997-11-24',1,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10745,'QUICK',9,'1997-11-18','1997-12-16','1997-11-27',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10746,'CHOPS',1,'1997-11-19','1997-12-17','1997-11-21',3,0,'Chop-suey Chinese','Hauptstr. 31','Bern','','3012','Switzerland'),(10747,'PICCO',6,'1997-11-19','1997-12-17','1997-11-26',1,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10748,'SAVEA',3,'1997-11-20','1997-12-18','1997-11-28',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10749,'ISLAT',4,'1997-11-20','1997-12-18','1997-12-19',2,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10750,'WARTH',9,'1997-11-21','1997-12-19','1997-11-24',1,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10751,'RICSU',3,'1997-11-24','1997-12-22','1997-12-03',3,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(10752,'NORTS',2,'1997-11-24','1997-12-22','1997-11-28',3,0,'North/South','South House\r\n300 Queensbridge','London','','SW7 1RZ','United Kingdom'),(10753,'FRANS',3,'1997-11-25','1997-12-23','1997-11-27',1,0,'Franchi S.p.A.','Via Monte Bianco 34','Torino','','10100','Italy'),(10754,'MAGAA',6,'1997-11-25','1997-12-23','1997-11-27',3,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10755,'BONAP',4,'1997-11-26','1997-12-24','1997-11-28',2,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10756,'SPLIR',8,'1997-11-27','1997-12-25','1997-12-02',2,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10757,'SAVEA',6,'1997-11-27','1997-12-25','1997-12-15',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10758,'RICSU',3,'1997-11-28','1997-12-26','1997-12-04',3,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(10759,'ANATR',3,'1997-11-28','1997-12-26','1997-12-12',3,0,'Ana Trujillo Emparedados y helados','Avda. de la Constituci?n 2222','M?xico D.F.','','05021','Mexico'),(10760,'MAISD',4,'1997-12-01','1997-12-29','1997-12-10',1,0,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles','','B-1180','Belgium'),(10761,'RATTC',5,'1997-12-02','1997-12-30','1997-12-08',2,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10762,'FOLKO',3,'1997-12-02','1997-12-30','1997-12-09',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10763,'FOLIG',3,'1997-12-03','1997-12-31','1997-12-08',3,0,'Folies gourmandes','184, chauss?e de Tournai','Lille','','59000','France'),(10764,'ERNSH',6,'1997-12-03','1997-12-31','1997-12-08',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10765,'QUICK',3,'1997-12-04','1998-01-01','1997-12-09',3,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10766,'OTTIK',4,'1997-12-05','1998-01-02','1997-12-09',1,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(10767,'SUPRD',4,'1997-12-05','1998-01-02','1997-12-15',3,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10768,'AROUT',3,'1997-12-08','1998-01-05','1997-12-15',2,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10769,'VAFFE',3,'1997-12-08','1998-01-05','1997-12-12',1,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10770,'HANAR',8,'1997-12-09','1998-01-06','1997-12-17',3,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10771,'ERNSH',9,'1997-12-10','1998-01-07','1998-01-02',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10772,'LEHMS',3,'1997-12-10','1998-01-07','1997-12-19',2,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10773,'ERNSH',1,'1997-12-11','1998-01-08','1997-12-16',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10774,'FOLKO',4,'1997-12-11','1997-12-25','1997-12-12',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10775,'THECR',7,'1997-12-12','1998-01-09','1997-12-26',1,0,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','United States'),(10776,'ERNSH',1,'1997-12-15','1998-01-12','1997-12-18',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10777,'GOURL',7,'1997-12-15','1997-12-29','1998-01-21',2,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(10778,'BERGS',3,'1997-12-16','1998-01-13','1997-12-24',1,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10779,'MORGK',3,'1997-12-16','1998-01-13','1998-01-14',2,0,'Morgenstern Gesundkost','Heerstr. 22','Leipzig','','04179','Germany'),(10780,'LILAS',2,'1997-12-16','1997-12-30','1997-12-25',1,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10781,'WARTH',2,'1997-12-17','1998-01-14','1997-12-19',3,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(10782,'CACTU',9,'1997-12-17','1998-01-14','1997-12-22',3,0,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires','','1010','Argentina'),(10783,'HANAR',4,'1997-12-18','1998-01-15','1997-12-19',2,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10784,'MAGAA',4,'1997-12-18','1998-01-15','1997-12-22',3,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10785,'GROSR',1,'1997-12-18','1998-01-15','1997-12-24',3,0,'GROSELLA-Restaurante','5? Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela'),(10786,'QUEEN',8,'1997-12-19','1998-01-16','1997-12-23',1,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10787,'LAMAI',2,'1997-12-19','1998-01-02','1997-12-26',1,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10788,'QUICK',1,'1997-12-22','1998-01-19','1998-01-19',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10789,'FOLIG',1,'1997-12-22','1998-01-19','1997-12-31',2,0,'Folies gourmandes','184, chauss?e de Tournai','Lille','','59000','France'),(10790,'GOURL',6,'1997-12-22','1998-01-19','1997-12-26',1,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(10791,'FRANK',6,'1997-12-23','1998-01-20','1998-01-01',2,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10792,'WOLZA',1,'1997-12-23','1998-01-20','1997-12-31',3,0,'Wolski Zajazd','ul. Filtrowa 68','Warszawa','','01-012','Poland'),(10793,'AROUT',3,'1997-12-24','1998-01-21','1998-01-08',3,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10794,'QUEDE',6,'1997-12-24','1998-01-21','1998-01-02',1,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10795,'ERNSH',8,'1997-12-24','1998-01-21','1998-01-20',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10796,'HILAA',3,'1997-12-25','1998-01-22','1998-01-14',1,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10797,'DRACD',7,'1997-12-25','1998-01-22','1998-01-05',2,0,'Drachenblut Delikatessen','Walserweg 21','Aachen','','52066','Germany'),(10798,'ISLAT',2,'1997-12-26','1998-01-23','1998-01-05',1,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10799,'KOENE',9,'1997-12-26','1998-02-06','1998-01-05',3,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10800,'SEVES',1,'1997-12-26','1998-01-23','1998-01-05',3,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10801,'BOLID',4,'1997-12-29','1998-01-26','1997-12-31',2,0,'B?lido Comidas preparadas','C/ Araquil, 67','Madrid','','28023','Spain'),(10802,'SIMOB',4,'1997-12-29','1998-01-26','1998-01-02',2,0,'Simons bistro','Vinb?ltet 34','K?benhavn','','1734','Denmark'),(10803,'WELLI',4,'1997-12-30','1998-01-27','1998-01-06',1,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10804,'SEVES',6,'1997-12-30','1998-01-27','1998-01-07',2,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10805,'THEBI',2,'1997-12-30','1998-01-27','1998-01-09',3,0,'The Big Cheese','89 Jefferson Way\r\nSuite 2','Portland','OR','97201','United States'),(10806,'VICTE',3,'1997-12-31','1998-01-28','1998-01-05',2,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10807,'FRANS',4,'1997-12-31','1998-01-28','1998-01-30',1,0,'Franchi S.p.A.','Via Monte Bianco 34','Torino','','10100','Italy'),(10808,'OLDWO',2,'1998-01-01','1998-01-29','1998-01-09',3,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10809,'WELLI',7,'1998-01-01','1998-01-29','1998-01-07',1,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10810,'LAUGB',2,'1998-01-01','1998-01-29','1998-01-07',3,0,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada'),(10811,'LINOD',8,'1998-01-02','1998-01-30','1998-01-08',1,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10812,'REGGC',5,'1998-01-02','1998-01-30','1998-01-12',1,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10813,'RICAR',1,'1998-01-05','1998-02-02','1998-01-09',1,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10814,'VICTE',3,'1998-01-05','1998-02-02','1998-01-14',3,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10815,'SAVEA',2,'1998-01-05','1998-02-02','1998-01-14',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10816,'GREAL',4,'1998-01-06','1998-02-03','1998-02-04',2,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(10817,'KOENE',3,'1998-01-06','1998-01-20','1998-01-13',2,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10818,'MAGAA',7,'1998-01-07','1998-02-04','1998-01-12',3,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10819,'CACTU',2,'1998-01-07','1998-02-04','1998-01-16',3,0,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires','','1010','Argentina'),(10820,'RATTC',3,'1998-01-07','1998-02-04','1998-01-13',2,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10821,'SPLIR',1,'1998-01-08','1998-02-05','1998-01-15',1,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10822,'TRAIH',6,'1998-01-08','1998-02-05','1998-01-16',3,0,'Trail\'s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','United States'),(10823,'LILAS',5,'1998-01-09','1998-02-06','1998-01-13',2,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10824,'FOLKO',8,'1998-01-09','1998-02-06','1998-01-30',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10825,'DRACD',1,'1998-01-09','1998-02-06','1998-01-14',1,0,'Drachenblut Delikatessen','Walserweg 21','Aachen','','52066','Germany'),(10826,'BLONP',6,'1998-01-12','1998-02-09','1998-02-06',1,0,'Blondel p?re et fils','24, place Kl?ber','Strasbourg','','67000','France'),(10827,'BONAP',1,'1998-01-12','1998-01-26','1998-02-06',2,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10828,'RANCH',9,'1998-01-13','1998-01-27','1998-02-04',1,0,'Rancho grande','Av. del Libertador 900','Buenos Aires','','1010','Argentina'),(10829,'ISLAT',9,'1998-01-13','1998-02-10','1998-01-23',1,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10830,'TRADH',4,'1998-01-13','1998-02-24','1998-01-21',2,0,'Tradi??o Hipermercados','Av. In?s de Castro, 414','S?o Paulo','SP','05634-030','Brazil'),(10831,'SANTG',3,'1998-01-14','1998-02-11','1998-01-23',2,0,'Sant? Gourmet','Erling Skakkes gate 78','Stavern','','4110','Norway'),(10832,'LAMAI',2,'1998-01-14','1998-02-11','1998-01-19',2,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10833,'OTTIK',6,'1998-01-15','1998-02-12','1998-01-23',2,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(10834,'TRADH',1,'1998-01-15','1998-02-12','1998-01-19',3,0,'Tradi??o Hipermercados','Av. In?s de Castro, 414','S?o Paulo','SP','05634-030','Brazil'),(10835,'ALFKI',1,'1998-01-15','1998-02-12','1998-01-21',3,0,'Alfreds Futterkiste','Obere Str. 57','Berlin','','12209','Germany'),(10836,'ERNSH',7,'1998-01-16','1998-02-13','1998-01-21',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10837,'BERGS',9,'1998-01-16','1998-02-13','1998-01-23',3,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10838,'LINOD',3,'1998-01-19','1998-02-16','1998-01-23',3,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10839,'TRADH',3,'1998-01-19','1998-02-16','1998-01-22',3,0,'Tradi??o Hipermercados','Av. In?s de Castro, 414','S?o Paulo','SP','05634-030','Brazil'),(10840,'LINOD',4,'1998-01-19','1998-03-02','1998-02-16',2,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10841,'SUPRD',5,'1998-01-20','1998-02-17','1998-01-29',2,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10842,'TORTU',1,'1998-01-20','1998-02-17','1998-01-29',3,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10843,'VICTE',4,'1998-01-21','1998-02-18','1998-01-26',2,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10844,'PICCO',8,'1998-01-21','1998-02-18','1998-01-26',2,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(10845,'QUICK',8,'1998-01-21','1998-02-04','1998-01-30',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10846,'SUPRD',2,'1998-01-22','1998-03-05','1998-01-23',3,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10847,'SAVEA',4,'1998-01-22','1998-02-05','1998-02-10',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10848,'CONSH',7,'1998-01-23','1998-02-20','1998-01-29',2,0,'Consolidated Holdings','Berkeley Gardens\r\n12  Brewery','London','','WX1 6LT','United Kingdom'),(10849,'KOENE',9,'1998-01-23','1998-02-20','1998-01-30',2,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10850,'VICTE',1,'1998-01-23','1998-03-06','1998-01-30',1,0,'Victuailles en stock','2, rue du Commerce','Lyon','','69004','France'),(10851,'RICAR',5,'1998-01-26','1998-02-23','1998-02-02',1,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10852,'RATTC',8,'1998-01-26','1998-02-09','1998-01-30',1,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10853,'BLAUS',9,'1998-01-27','1998-02-24','1998-02-03',2,0,'Blauer See Delikatessen','Forsterstr. 57','Mannheim','','68306','Germany'),(10854,'ERNSH',3,'1998-01-27','1998-02-24','1998-02-05',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10855,'OLDWO',3,'1998-01-27','1998-02-24','1998-02-04',1,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10856,'ANTON',3,'1998-01-28','1998-02-25','1998-02-10',2,0,'Antonio Moreno Taquer?a','Mataderos  2312','M?xico D.F.','','05023','Mexico'),(10857,'BERGS',8,'1998-01-28','1998-02-25','1998-02-06',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10858,'LACOR',2,'1998-01-29','1998-02-26','1998-02-03',1,0,'La corne d\'abondance','67, avenue de l\'Europe','Versailles','','78000','France'),(10859,'FRANK',1,'1998-01-29','1998-02-26','1998-02-02',2,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10860,'FRANR',3,'1998-01-29','1998-02-26','1998-02-04',3,0,'France restauration','54, rue Royale','Nantes','','44000','France'),(10861,'WHITC',4,'1998-01-30','1998-02-27','1998-02-17',2,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10862,'LEHMS',8,'1998-01-30','1998-03-13','1998-02-02',2,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10863,'HILAA',4,'1998-02-02','1998-03-02','1998-02-17',2,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10864,'AROUT',4,'1998-02-02','1998-03-02','1998-02-09',2,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10865,'QUICK',2,'1998-02-02','1998-02-16','1998-02-12',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10866,'BERGS',5,'1998-02-03','1998-03-03','1998-02-12',1,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10867,'LONEP',6,'1998-02-03','1998-03-17','1998-02-11',1,0,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','United States'),(10868,'QUEEN',7,'1998-02-04','1998-03-04','1998-02-23',2,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10869,'SEVES',5,'1998-02-04','1998-03-04','1998-02-09',1,0,'Seven Seas Imports','90 Wadhurst Rd.','London','','OX15 4NB','United Kingdom'),(10870,'WOLZA',5,'1998-02-04','1998-03-04','1998-02-13',3,0,'Wolski Zajazd','ul. Filtrowa 68','Warszawa','','01-012','Poland'),(10871,'BONAP',9,'1998-02-05','1998-03-05','1998-02-10',2,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10872,'GODOS',5,'1998-02-05','1998-03-05','1998-02-09',2,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(10873,'WILMK',4,'1998-02-06','1998-03-06','1998-02-09',1,0,'Wilman Kala','Keskuskatu 45','Helsinki','','21240','Finland'),(10874,'GODOS',5,'1998-02-06','1998-03-06','1998-02-11',2,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(10875,'BERGS',4,'1998-02-06','1998-03-06','1998-03-03',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10876,'BONAP',7,'1998-02-09','1998-03-09','1998-02-12',3,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10877,'RICAR',1,'1998-02-09','1998-03-09','1998-02-19',1,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(10878,'QUICK',4,'1998-02-10','1998-03-10','1998-02-12',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10879,'WILMK',3,'1998-02-10','1998-03-10','1998-02-12',3,0,'Wilman Kala','Keskuskatu 45','Helsinki','','21240','Finland'),(10880,'FOLKO',7,'1998-02-10','1998-03-24','1998-02-18',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10881,'CACTU',4,'1998-02-11','1998-03-11','1998-02-18',1,0,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires','','1010','Argentina'),(10882,'SAVEA',4,'1998-02-11','1998-03-11','1998-02-20',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10883,'LONEP',8,'1998-02-12','1998-03-12','1998-02-20',3,0,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','United States'),(10884,'LETSS',4,'1998-02-12','1998-03-12','1998-02-13',2,0,'Let\'s Stop N Shop','87 Polk St.\r\nSuite 5','San Francisco','CA','94117','United States'),(10885,'SUPRD',6,'1998-02-12','1998-03-12','1998-02-18',3,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10886,'HANAR',1,'1998-02-13','1998-03-13','1998-03-02',1,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10887,'GALED',8,'1998-02-13','1998-03-13','1998-02-16',3,0,'Galer?a del gastron?mo','Rambla de Catalu?a, 23','Barcelona','','8022','Spain'),(10888,'GODOS',1,'1998-02-16','1998-03-16','1998-02-23',2,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(10889,'RATTC',9,'1998-02-16','1998-03-16','1998-02-23',3,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10890,'DUMON',7,'1998-02-16','1998-03-16','1998-02-18',1,0,'Du monde entier','67, rue des Cinquante Otages','Nantes','','44000','France'),(10891,'LEHMS',7,'1998-02-17','1998-03-17','1998-02-19',2,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10892,'MAISD',4,'1998-02-17','1998-03-17','1998-02-19',2,0,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles','','B-1180','Belgium'),(10893,'KOENE',9,'1998-02-18','1998-03-18','1998-02-20',2,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(10894,'SAVEA',1,'1998-02-18','1998-03-18','1998-02-20',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10895,'ERNSH',3,'1998-02-18','1998-03-18','1998-02-23',1,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10896,'MAISD',7,'1998-02-19','1998-03-19','1998-02-27',3,0,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles','','B-1180','Belgium'),(10897,'HUNGO',3,'1998-02-19','1998-03-19','1998-02-25',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10898,'OCEAN',4,'1998-02-20','1998-03-20','1998-03-06',2,0,'Oc?ano Atl?ntico Ltda.','Ing. Gustavo Moncada 8585\r\nPiso 20-A','Buenos Aires','','1010','Argentina'),(10899,'LILAS',5,'1998-02-20','1998-03-20','1998-02-26',3,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10900,'WELLI',1,'1998-02-20','1998-03-20','1998-03-04',2,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10901,'HILAA',4,'1998-02-23','1998-03-23','1998-02-26',1,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10902,'FOLKO',1,'1998-02-23','1998-03-23','1998-03-03',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10903,'HANAR',3,'1998-02-24','1998-03-24','1998-03-04',3,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10904,'WHITC',3,'1998-02-24','1998-03-24','1998-02-27',3,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(10905,'WELLI',9,'1998-02-24','1998-03-24','1998-03-06',2,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10906,'WOLZA',4,'1998-02-25','1998-03-11','1998-03-03',3,0,'Wolski Zajazd','ul. Filtrowa 68','Warszawa','','01-012','Poland'),(10907,'SPECD',6,'1998-02-25','1998-03-25','1998-02-27',3,0,'Sp?cialit?s du monde','25, rue Lauriston','Paris','','75016','France'),(10908,'REGGC',4,'1998-02-26','1998-03-26','1998-03-06',2,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10909,'SANTG',1,'1998-02-26','1998-03-26','1998-03-10',2,0,'Sant? Gourmet','Erling Skakkes gate 78','Stavern','','4110','Norway'),(10910,'WILMK',1,'1998-02-26','1998-03-26','1998-03-04',3,0,'Wilman Kala','Keskuskatu 45','Helsinki','','21240','Finland'),(10911,'GODOS',3,'1998-02-26','1998-03-26','1998-03-05',1,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(10912,'HUNGO',2,'1998-02-26','1998-03-26','1998-03-18',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10913,'QUEEN',4,'1998-02-26','1998-03-26','1998-03-04',1,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10914,'QUEEN',6,'1998-02-27','1998-03-27','1998-03-02',1,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10915,'TORTU',2,'1998-02-27','1998-03-27','1998-03-02',2,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(10916,'RANCH',1,'1998-02-27','1998-03-27','1998-03-09',2,0,'Rancho grande','Av. del Libertador 900','Buenos Aires','','1010','Argentina'),(10917,'ROMEY',4,'1998-03-02','1998-03-30','1998-03-11',2,0,'Romero y tomillo','Gran V?a, 1','Madrid','','28001','Spain'),(10918,'BOTTM',3,'1998-03-02','1998-03-30','1998-03-11',3,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10919,'LINOD',2,'1998-03-02','1998-03-30','1998-03-04',2,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10920,'AROUT',4,'1998-03-03','1998-03-31','1998-03-09',2,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10921,'VAFFE',1,'1998-03-03','1998-04-14','1998-03-09',1,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10922,'HANAR',5,'1998-03-03','1998-03-31','1998-03-05',3,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10923,'LAMAI',7,'1998-03-03','1998-04-14','1998-03-13',3,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(10924,'BERGS',3,'1998-03-04','1998-04-01','1998-04-08',2,0,'Berglunds snabbk?p','Berguvsv?gen  8','Lule?','','S-958 22','Sweden'),(10925,'HANAR',3,'1998-03-04','1998-04-01','1998-03-13',1,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10926,'ANATR',4,'1998-03-04','1998-04-01','1998-03-11',3,0,'Ana Trujillo Emparedados y helados','Avda. de la Constituci?n 2222','M?xico D.F.','','05021','Mexico'),(10927,'LACOR',4,'1998-03-05','1998-04-02','1998-04-08',1,0,'La corne d\'abondance','67, avenue de l\'Europe','Versailles','','78000','France'),(10928,'GALED',1,'1998-03-05','1998-04-02','1998-03-18',1,0,'Galer?a del gastron?mo','Rambla de Catalu?a, 23','Barcelona','','8022','Spain'),(10929,'FRANK',6,'1998-03-05','1998-04-02','1998-03-12',1,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(10930,'SUPRD',4,'1998-03-06','1998-04-17','1998-03-18',3,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(10931,'RICSU',4,'1998-03-06','1998-03-20','1998-03-19',2,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(10932,'BONAP',8,'1998-03-06','1998-04-03','1998-03-24',1,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10933,'ISLAT',6,'1998-03-06','1998-04-03','1998-03-16',3,0,'Island Trading','Garden House\r\nCrowther Way','Cowes','Isle of Wight','PO31 7PJ','United Kingdom'),(10934,'LEHMS',3,'1998-03-09','1998-04-06','1998-03-12',3,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(10935,'WELLI',4,'1998-03-09','1998-04-06','1998-03-18',3,0,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil'),(10936,'GREAL',3,'1998-03-09','1998-04-06','1998-03-18',2,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(10937,'CACTU',7,'1998-03-10','1998-03-24','1998-03-13',3,0,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires','','1010','Argentina'),(10938,'QUICK',3,'1998-03-10','1998-04-07','1998-03-16',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10939,'MAGAA',2,'1998-03-10','1998-04-07','1998-03-13',2,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10940,'BONAP',8,'1998-03-11','1998-04-08','1998-03-23',3,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(10941,'SAVEA',7,'1998-03-11','1998-04-08','1998-03-20',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10942,'REGGC',9,'1998-03-11','1998-04-08','1998-03-18',3,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(10943,'BSBEV',4,'1998-03-11','1998-04-08','1998-03-19',2,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10944,'BOTTM',6,'1998-03-12','1998-03-26','1998-03-13',3,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10945,'MORGK',4,'1998-03-12','1998-04-09','1998-03-18',1,0,'Morgenstern Gesundkost','Heerstr. 22','Leipzig','','04179','Germany'),(10946,'VAFFE',1,'1998-03-12','1998-04-09','1998-03-19',2,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10947,'BSBEV',3,'1998-03-13','1998-04-10','1998-03-16',2,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(10948,'GODOS',3,'1998-03-13','1998-04-10','1998-03-19',3,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(10949,'BOTTM',2,'1998-03-13','1998-04-10','1998-03-17',3,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10950,'MAGAA',1,'1998-03-16','1998-04-13','1998-03-23',2,0,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo','','24100','Italy'),(10951,'RICSU',9,'1998-03-16','1998-04-27','1998-04-07',2,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(10952,'ALFKI',1,'1998-03-16','1998-04-27','1998-03-24',1,0,'Alfreds Futterkiste','Obere Str. 57','Berlin','','12209','Germany'),(10953,'AROUT',9,'1998-03-16','1998-03-30','1998-03-25',2,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(10954,'LINOD',5,'1998-03-17','1998-04-28','1998-03-20',1,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(10955,'FOLKO',8,'1998-03-17','1998-04-14','1998-03-20',2,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10956,'BLAUS',6,'1998-03-17','1998-04-28','1998-03-20',2,0,'Blauer See Delikatessen','Forsterstr. 57','Mannheim','','68306','Germany'),(10957,'HILAA',8,'1998-03-18','1998-04-15','1998-03-27',3,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10958,'OCEAN',7,'1998-03-18','1998-04-15','1998-03-27',2,0,'Oc?ano Atl?ntico Ltda.','Ing. Gustavo Moncada 8585\r\nPiso 20-A','Buenos Aires','','1010','Argentina'),(10959,'GOURL',6,'1998-03-18','1998-04-29','1998-03-23',2,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(10960,'HILAA',3,'1998-03-19','1998-04-02','1998-04-08',1,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10961,'QUEEN',8,'1998-03-19','1998-04-16','1998-03-30',1,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(10962,'QUICK',8,'1998-03-19','1998-04-16','1998-03-23',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10963,'FURIB',9,'1998-03-19','1998-04-16','1998-03-26',3,0,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa','','1675','Portugal'),(10964,'SPECD',3,'1998-03-20','1998-04-17','1998-03-24',2,0,'Sp?cialit?s du monde','25, rue Lauriston','Paris','','75016','France'),(10965,'OLDWO',6,'1998-03-20','1998-04-17','1998-03-30',3,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(10966,'CHOPS',4,'1998-03-20','1998-04-17','1998-04-08',1,0,'Chop-suey Chinese','Hauptstr. 31','Bern','','3012','Switzerland'),(10967,'TOMSP',2,'1998-03-23','1998-04-20','1998-04-02',2,0,'Toms Spezialit?ten','Luisenstr. 48','M?nster','','44087','Germany'),(10968,'ERNSH',1,'1998-03-23','1998-04-20','1998-04-01',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10969,'COMMI',1,'1998-03-23','1998-04-20','1998-03-30',2,0,'Com?rcio Mineiro','Av. dos Lus?adas, 23','S?o Paulo','SP','05432-043','Brazil'),(10970,'BOLID',9,'1998-03-24','1998-04-07','1998-04-24',1,0,'B?lido Comidas preparadas','C/ Araquil, 67','Madrid','','28023','Spain'),(10971,'FRANR',2,'1998-03-24','1998-04-21','1998-04-02',2,0,'France restauration','54, rue Royale','Nantes','','44000','France'),(10972,'LACOR',4,'1998-03-24','1998-04-21','1998-03-26',2,0,'La corne d\'abondance','67, avenue de l\'Europe','Versailles','','78000','France'),(10973,'LACOR',6,'1998-03-24','1998-04-21','1998-03-27',2,0,'La corne d\'abondance','67, avenue de l\'Europe','Versailles','','78000','France'),(10974,'SPLIR',3,'1998-03-25','1998-04-08','1998-04-03',3,0,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','United States'),(10975,'BOTTM',1,'1998-03-25','1998-04-22','1998-03-27',3,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10976,'HILAA',1,'1998-03-25','1998-05-06','1998-04-03',1,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(10977,'FOLKO',8,'1998-03-26','1998-04-23','1998-04-10',3,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10978,'MAISD',9,'1998-03-26','1998-04-23','1998-04-23',2,0,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles','','B-1180','Belgium'),(10979,'ERNSH',8,'1998-03-26','1998-04-23','1998-03-31',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10980,'FOLKO',4,'1998-03-27','1998-05-08','1998-04-17',1,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10981,'HANAR',1,'1998-03-27','1998-04-24','1998-04-02',2,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(10982,'BOTTM',2,'1998-03-27','1998-04-24','1998-04-08',1,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(10983,'SAVEA',2,'1998-03-27','1998-04-24','1998-04-06',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10984,'SAVEA',1,'1998-03-30','1998-04-27','1998-04-03',3,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(10985,'HUNGO',2,'1998-03-30','1998-04-27','1998-04-02',1,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(10986,'OCEAN',8,'1998-03-30','1998-04-27','1998-04-21',2,0,'Oc?ano Atl?ntico Ltda.','Ing. Gustavo Moncada 8585\r\nPiso 20-A','Buenos Aires','','1010','Argentina'),(10987,'EASTC',8,'1998-03-31','1998-04-28','1998-04-06',1,0,'Eastern Connection','35 King George','London','','WX3 6FW','United Kingdom'),(10988,'RATTC',3,'1998-03-31','1998-04-28','1998-04-10',2,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(10989,'QUEDE',2,'1998-03-31','1998-04-28','1998-04-02',1,0,'Que Del?cia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil'),(10990,'ERNSH',2,'1998-04-01','1998-05-13','1998-04-07',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(10991,'QUICK',1,'1998-04-01','1998-04-29','1998-04-07',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10992,'THEBI',1,'1998-04-01','1998-04-29','1998-04-03',3,0,'The Big Cheese','89 Jefferson Way\r\nSuite 2','Portland','OR','97201','United States'),(10993,'FOLKO',7,'1998-04-01','1998-04-29','1998-04-10',3,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(10994,'VAFFE',2,'1998-04-02','1998-04-16','1998-04-09',3,0,'Vaffeljernet','Smagsl?get 45','?rhus','','8200','Denmark'),(10995,'PERIC',1,'1998-04-02','1998-04-30','1998-04-06',3,0,'Pericles Comidas cl?sicas','Calle Dr. Jorge Cash 321','M?xico D.F.','','05033','Mexico'),(10996,'QUICK',4,'1998-04-02','1998-04-30','1998-04-10',2,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(10997,'LILAS',8,'1998-04-03','1998-05-15','1998-04-13',2,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(10998,'WOLZA',8,'1998-04-03','1998-04-17','1998-04-17',2,0,'Wolski Zajazd','ul. Filtrowa 68','Warszawa','','01-012','Poland'),(10999,'OTTIK',6,'1998-04-03','1998-05-01','1998-04-10',2,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(11000,'RATTC',2,'1998-04-06','1998-05-04','1998-04-14',3,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States'),(11001,'FOLKO',2,'1998-04-06','1998-05-04','1998-04-14',2,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(11002,'SAVEA',4,'1998-04-06','1998-05-04','1998-04-16',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(11003,'THECR',3,'1998-04-06','1998-05-04','1998-04-08',3,0,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','United States'),(11004,'MAISD',3,'1998-04-07','1998-05-05','1998-04-20',1,0,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles','','B-1180','Belgium'),(11005,'WILMK',2,'1998-04-07','1998-05-05','1998-04-10',1,0,'Wilman Kala','Keskuskatu 45','Helsinki','','21240','Finland'),(11006,'GREAL',3,'1998-04-07','1998-05-05','1998-04-15',2,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(11007,'PRINI',8,'1998-04-08','1998-05-06','1998-04-13',2,0,'Princesa Isabel Vinhos','Estrada da sa?de n. 58','Lisboa','','1756','Portugal'),(11008,'ERNSH',7,'1998-04-08','1998-05-06','0000-00-00',3,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(11009,'GODOS',2,'1998-04-08','1998-05-06','1998-04-10',1,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(11010,'REGGC',2,'1998-04-09','1998-05-07','1998-04-21',2,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(11011,'ALFKI',3,'1998-04-09','1998-05-07','1998-04-13',1,0,'Alfreds Futterkiste','Obere Str. 57','Berlin','','12209','Germany'),(11012,'FRANK',1,'1998-04-09','1998-04-23','1998-04-17',3,0,'Frankenversand','Berliner Platz 43','M?nchen','','80805','Germany'),(11013,'ROMEY',2,'1998-04-09','1998-05-07','1998-04-10',1,0,'Romero y tomillo','Gran V?a, 1','Madrid','','28001','Spain'),(11014,'LINOD',2,'1998-04-10','1998-05-08','1998-04-15',3,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(11015,'SANTG',2,'1998-04-10','1998-04-24','1998-04-20',2,0,'Sant? Gourmet','Erling Skakkes gate 78','Stavern','','4110','Norway'),(11016,'AROUT',9,'1998-04-10','1998-05-08','1998-04-13',2,0,'Around the Horn','Brook Farm\r\nStratford St. Mary','Colchester','Essex','CO7 6JX','United Kingdom'),(11017,'ERNSH',9,'1998-04-13','1998-05-11','1998-04-20',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(11018,'LONEP',4,'1998-04-13','1998-05-11','1998-04-16',2,0,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','United States'),(11019,'RANCH',6,'1998-04-13','1998-05-11','0000-00-00',3,0,'Rancho grande','Av. del Libertador 900','Buenos Aires','','1010','Argentina'),(11020,'OTTIK',2,'1998-04-14','1998-05-12','1998-04-16',2,0,'Ottilies K?seladen','Mehrheimerstr. 369','K?ln','','50739','Germany'),(11021,'QUICK',3,'1998-04-14','1998-05-12','1998-04-21',1,0,'QUICK-Stop','Taucherstra?e 10','Cunewalde','','01307','Germany'),(11022,'HANAR',9,'1998-04-14','1998-05-12','1998-05-04',2,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(11023,'BSBEV',1,'1998-04-14','1998-04-28','1998-04-24',2,0,'B\'s Beverages','Fauntleroy Circus','London','','EC2 5NT','United Kingdom'),(11024,'EASTC',4,'1998-04-15','1998-05-13','1998-04-20',1,0,'Eastern Connection','35 King George','London','','WX3 6FW','United Kingdom'),(11025,'WARTH',6,'1998-04-15','1998-05-13','1998-04-24',3,0,'Wartian Herkku','Torikatu 38','Oulu','','90110','Finland'),(11026,'FRANS',4,'1998-04-15','1998-05-13','1998-04-28',1,0,'Franchi S.p.A.','Via Monte Bianco 34','Torino','','10100','Italy'),(11027,'BOTTM',1,'1998-04-16','1998-05-14','1998-04-20',1,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(11028,'KOENE',2,'1998-04-16','1998-05-14','1998-04-22',1,0,'K?niglich Essen','Maubelstr. 90','Brandenburg','','14776','Germany'),(11029,'CHOPS',4,'1998-04-16','1998-05-14','1998-04-27',1,0,'Chop-suey Chinese','Hauptstr. 31','Bern','','3012','Switzerland'),(11030,'SAVEA',7,'1998-04-17','1998-05-15','1998-04-27',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(11031,'SAVEA',6,'1998-04-17','1998-05-15','1998-04-24',2,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(11032,'WHITC',2,'1998-04-17','1998-05-15','1998-04-23',3,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(11033,'RICSU',7,'1998-04-17','1998-05-15','1998-04-23',3,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(11034,'OLDWO',8,'1998-04-20','1998-06-01','1998-04-27',1,0,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','United States'),(11035,'SUPRD',2,'1998-04-20','1998-05-18','1998-04-24',2,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(11036,'DRACD',8,'1998-04-20','1998-05-18','1998-04-22',3,0,'Drachenblut Delikatessen','Walserweg 21','Aachen','','52066','Germany'),(11037,'GODOS',7,'1998-04-21','1998-05-19','1998-04-27',1,0,'Godos Cocina T?pica','C/ Romero, 33','Sevilla','','41101','Spain'),(11038,'SUPRD',1,'1998-04-21','1998-05-19','1998-04-30',2,0,'Supr?mes d?lices','Boulevard Tirou, 255','Charleroi','','B-6000','Belgium'),(11039,'LINOD',1,'1998-04-21','1998-05-19','0000-00-00',2,0,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela'),(11040,'GREAL',4,'1998-04-22','1998-05-20','0000-00-00',3,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(11041,'CHOPS',3,'1998-04-22','1998-05-20','1998-04-28',2,0,'Chop-suey Chinese','Hauptstr. 31','Bern','','3012','Switzerland'),(11042,'COMMI',2,'1998-04-22','1998-05-06','1998-05-01',1,0,'Com?rcio Mineiro','Av. dos Lus?adas, 23','S?o Paulo','SP','05432-043','Brazil'),(11043,'SPECD',5,'1998-04-22','1998-05-20','1998-04-29',2,0,'Sp?cialit?s du monde','25, rue Lauriston','Paris','','75016','France'),(11044,'WOLZA',4,'1998-04-23','1998-05-21','1998-05-01',1,0,'Wolski Zajazd','ul. Filtrowa 68','Warszawa','','01-012','Poland'),(11045,'BOTTM',6,'1998-04-23','1998-05-21','0000-00-00',2,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(11046,'WANDK',8,'1998-04-23','1998-05-21','1998-04-24',2,0,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart','','70563','Germany'),(11047,'EASTC',7,'1998-04-24','1998-05-22','1998-05-01',3,0,'Eastern Connection','35 King George','London','','WX3 6FW','United Kingdom'),(11048,'BOTTM',7,'1998-04-24','1998-05-22','1998-04-30',3,0,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada'),(11049,'GOURL',3,'1998-04-24','1998-05-22','1998-05-04',1,0,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil'),(11050,'FOLKO',8,'1998-04-27','1998-05-25','1998-05-05',2,0,'Folk och f? HB','?kergatan 24','Br?cke','','S-844 67','Sweden'),(11051,'LAMAI',7,'1998-04-27','1998-05-25','0000-00-00',3,0,'La maison d\'Asie','1 rue Alsace-Lorraine','Toulouse','','31000','France'),(11052,'HANAR',3,'1998-04-27','1998-05-25','1998-05-01',1,0,'Hanari Carnes','Rua do Pa?o, 67','Rio de Janeiro','RJ','05454-876','Brazil'),(11053,'PICCO',2,'1998-04-27','1998-05-25','1998-04-29',2,0,'Piccolo und mehr','Geislweg 14','Salzburg','','5020','Austria'),(11054,'CACTU',8,'1998-04-28','1998-05-26','0000-00-00',1,0,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires','','1010','Argentina'),(11055,'HILAA',7,'1998-04-28','1998-05-26','1998-05-05',2,0,'HILARI?N-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Crist?bal','T?chira','5022','Venezuela'),(11056,'EASTC',8,'1998-04-28','1998-05-12','1998-05-01',2,0,'Eastern Connection','35 King George','London','','WX3 6FW','United Kingdom'),(11057,'NORTS',3,'1998-04-29','1998-05-27','1998-05-01',3,0,'North/South','South House\r\n300 Queensbridge','London','','SW7 1RZ','United Kingdom'),(11058,'BLAUS',9,'1998-04-29','1998-05-27','0000-00-00',3,0,'Blauer See Delikatessen','Forsterstr. 57','Mannheim','','68306','Germany'),(11059,'RICAR',2,'1998-04-29','1998-06-10','0000-00-00',2,0,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil'),(11060,'FRANS',2,'1998-04-30','1998-05-28','1998-05-04',2,0,'Franchi S.p.A.','Via Monte Bianco 34','Torino','','10100','Italy'),(11061,'GREAL',4,'1998-04-30','1998-06-11','0000-00-00',3,0,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','United States'),(11062,'REGGC',4,'1998-04-30','1998-05-28','0000-00-00',2,0,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia','','42100','Italy'),(11063,'HUNGO',3,'1998-04-30','1998-05-28','1998-05-06',2,0,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork','','Ireland'),(11064,'SAVEA',1,'1998-05-01','1998-05-29','1998-05-04',1,0,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','United States'),(11065,'LILAS',8,'1998-05-01','1998-05-29','0000-00-00',1,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(11066,'WHITC',7,'1998-05-01','1998-05-29','1998-05-04',2,0,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','United States'),(11067,'DRACD',1,'1998-05-04','1998-05-18','1998-05-06',2,0,'Drachenblut Delikatessen','Walserweg 21','Aachen','','52066','Germany'),(11068,'QUEEN',8,'1998-05-04','1998-06-01','0000-00-00',2,0,'Queen Cozinha','Alameda dos Can?rios, 891','S?o Paulo','SP','05487-020','Brazil'),(11069,'TORTU',1,'1998-05-04','1998-06-01','1998-05-06',2,0,'Tortuga Restaurante','Avda. Azteca 123','M?xico D.F.','','05033','Mexico'),(11070,'LEHMS',2,'1998-05-05','1998-06-02','0000-00-00',1,0,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M.','','60528','Germany'),(11071,'LILAS',1,'1998-05-05','1998-06-02','0000-00-00',1,0,'LILA-Supermercado','Carrera 52 con Ave. Bol?var #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela'),(11072,'ERNSH',4,'1998-05-05','1998-06-02','0000-00-00',2,0,'Ernst Handel','Kirchgasse 6','Graz','','8010','Austria'),(11073,'PERIC',2,'1998-05-05','1998-06-02','0000-00-00',2,0,'Pericles Comidas cl?sicas','Calle Dr. Jorge Cash 321','M?xico D.F.','','05033','Mexico'),(11074,'SIMOB',7,'1998-05-06','1998-06-03','0000-00-00',2,0,'Simons bistro','Vinb?ltet 34','K?benhavn','','1734','Denmark'),(11075,'RICSU',8,'1998-05-06','1998-06-03','0000-00-00',2,0,'Richter Supermarkt','Starenweg 5','Gen?ve','','1204','Switzerland'),(11076,'BONAP',4,'1998-05-06','1998-06-03','0000-00-00',2,0,'Bon app\'','12, rue des Bouchers','Marseille','','13008','France'),(11077,'RATTC',1,'1998-05-06','1998-06-03','0000-00-00',2,0,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','United States');
UNLOCK TABLES;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `ProductID` int(11) NOT NULL AUTO_INCREMENT,
  `ProductName` varchar(40) DEFAULT NULL,
  `SupplierID` int(11) DEFAULT NULL,
  `CategoryID` int(11) DEFAULT NULL,
  `QuantityPerUnit` varchar(20) DEFAULT NULL,
  `UnitPrice` float(1,0) DEFAULT '0',
  `UnitsInStock` smallint(6) DEFAULT '0',
  `UnitsOnOrder` smallint(6) DEFAULT '0',
  `ReorderLevel` smallint(6) DEFAULT '0',
  `Discontinued` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`ProductID`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `products`
--


/*!40000 ALTER TABLE `products` DISABLE KEYS */;
LOCK TABLES `products` WRITE;
INSERT INTO `products` VALUES (1,'Chai',1,1,'10 boxes x 20 bags',0,39,0,10,0),(2,'Chang',1,1,'24 - 12 oz bottles',0,17,40,25,0),(3,'Aniseed Syrup',1,2,'12 - 550 ml bottles',0,13,70,25,0),(4,'Chef Anton\'s Cajun Seasoning',2,2,'48 - 6 oz jars',0,53,0,0,0),(5,'Chef Anton\'s Gumbo Mix',2,2,'36 boxes',0,0,0,0,1),(6,'Grandma\'s Boysenberry Spread',3,2,'12 - 8 oz jars',0,120,0,25,0),(7,'Uncle Bob\'s Organic Dried Pears',3,7,'12 - 1 lb pkgs.',0,15,0,10,0),(8,'Northwoods Cranberry Sauce',3,2,'12 - 12 oz jars',0,6,0,0,0),(9,'Mishi Kobe Niku',4,6,'18 - 500 g pkgs.',0,29,0,0,1),(10,'Ikura',4,8,'12 - 200 ml jars',0,31,0,0,0),(11,'Queso Cabrales',5,4,'1 kg pkg.',0,22,30,30,0),(12,'Queso Manchego La Pastora',5,4,'10 - 500 g pkgs.',0,86,0,0,0),(13,'Konbu',6,8,'2 kg box',0,24,0,5,0),(14,'Tofu',6,7,'40 - 100 g pkgs.',0,35,0,0,0),(15,'Genen Shouyu',6,2,'24 - 250 ml bottles',0,39,0,5,0),(16,'Pavlova',7,3,'32 - 500 g boxes',0,29,0,10,0),(17,'Alice Mutton',7,6,'20 - 1 kg tins',0,0,0,0,1),(18,'Carnarvon Tigers',7,8,'16 kg pkg.',0,42,0,0,0),(19,'Teatime Chocolate Biscuits',8,3,'10 boxes x 12 pieces',0,25,0,5,0),(20,'Sir Rodney\'s Marmalade',8,3,'30 gift boxes',0,40,0,0,0),(21,'Sir Rodney\'s Scones',8,3,'24 pkgs. x 4 pieces',0,3,40,5,0),(22,'Gustaf\'s Kn?ckebr?d',9,5,'24 - 500 g pkgs.',0,104,0,25,0),(23,'Tunnbr?d',9,5,'12 - 250 g pkgs.',0,61,0,25,0),(24,'Guaran? Fant?stica',10,1,'12 - 355 ml cans',0,20,0,0,1),(25,'NuNuCa Nu?-Nougat-Creme',11,3,'20 - 450 g glasses',0,76,0,30,0),(26,'Gumb?r Gummib?rchen',11,3,'100 - 250 g bags',0,15,0,0,0),(27,'Schoggi Schokolade',11,3,'100 - 100 g pieces',0,49,0,30,0),(28,'R?ssle Sauerkraut',12,7,'25 - 825 g cans',0,26,0,0,1),(29,'Th?ringer Rostbratwurst',12,6,'50 bags x 30 sausgs.',0,0,0,0,1),(30,'Nord-Ost Matjeshering',13,8,'10 - 200 g glasses',0,10,0,15,0),(31,'Gorgonzola Telino',14,4,'12 - 100 g pkgs',0,0,70,20,0),(32,'Mascarpone Fabioli',14,4,'24 - 200 g pkgs.',0,9,40,25,0),(33,'Geitost',15,4,'500 g',0,112,0,20,0),(34,'Sasquatch Ale',16,1,'24 - 12 oz bottles',0,111,0,15,0),(35,'Steeleye Stout',16,1,'24 - 12 oz bottles',0,20,0,15,0),(36,'Inlagd Sill',17,8,'24 - 250 g  jars',0,112,0,20,0),(37,'Gravad lax',17,8,'12 - 500 g pkgs.',0,11,50,25,0),(38,'C?te de Blaye',18,1,'12 - 75 cl bottles',0,17,0,15,0),(39,'Chartreuse verte',18,1,'750 cc per bottle',0,69,0,5,0),(40,'Boston Crab Meat',19,8,'24 - 4 oz tins',0,123,0,30,0),(41,'Jack\'s New England Clam Chowder',19,8,'12 - 12 oz cans',0,85,0,10,0),(42,'Singaporean Hokkien Fried Mee',20,5,'32 - 1 kg pkgs.',0,26,0,0,1),(43,'Ipoh Coffee',20,1,'16 - 500 g tins',0,17,10,25,0),(44,'Gula Malacca',20,2,'20 - 2 kg bags',0,27,0,15,0),(45,'R?gede sild',21,8,'1k pkg.',0,5,70,15,0),(46,'Spegesild',21,8,'4 - 450 g glasses',0,95,0,0,0),(47,'Zaanse koeken',22,3,'10 - 4 oz boxes',0,36,0,0,0),(48,'Chocolade',22,3,'10 pkgs.',0,15,70,25,0),(49,'Maxilaku',23,3,'24 - 50 g pkgs.',0,10,60,15,0),(50,'Valkoinen suklaa',23,3,'12 - 100 g bars',0,65,0,30,0),(51,'Manjimup Dried Apples',24,7,'50 - 300 g pkgs.',0,20,0,10,0),(52,'Filo Mix',24,5,'16 - 2 kg boxes',0,38,0,25,0),(53,'Perth Pasties',24,6,'48 pieces',0,0,0,0,1),(54,'Tourti?re',25,6,'16 pies',0,21,0,10,0),(55,'P?t? chinois',25,6,'24 boxes x 2 pies',0,115,0,20,0),(56,'Gnocchi di nonna Alice',26,5,'24 - 250 g pkgs.',0,21,10,30,0),(57,'Ravioli Angelo',26,5,'24 - 250 g pkgs.',0,36,0,20,0),(58,'Escargots de Bourgogne',27,8,'24 pieces',0,62,0,20,0),(59,'Raclette Courdavault',28,4,'5 kg pkg.',0,79,0,0,0),(60,'Camembert Pierrot',28,4,'15 - 300 g rounds',0,19,0,0,0),(61,'Sirop d\'?rable',29,2,'24 - 500 ml bottles',0,113,0,25,0),(62,'Tarte au sucre',29,3,'48 pies',0,17,0,0,0),(63,'Vegie-spread',7,2,'15 - 625 g jars',0,24,0,5,0),(64,'Wimmers gute Semmelkn?del',12,5,'20 bags x 4 pieces',0,22,80,30,0),(65,'Louisiana Fiery Hot Pepper Sauce',2,2,'32 - 8 oz bottles',0,76,0,0,0),(66,'Louisiana Hot Spiced Okra',2,2,'24 - 8 oz jars',0,4,100,20,0),(67,'Laughing Lumberjack Lager',16,1,'24 - 12 oz bottles',0,52,0,10,0),(68,'Scottish Longbreads',8,3,'10 boxes x 8 pieces',0,6,10,15,0),(69,'Gudbrandsdalsost',15,4,'10 kg pkg.',0,26,0,15,0),(70,'Outback Lager',7,1,'24 - 355 ml bottles',0,15,10,30,0),(71,'Fl?temysost',15,4,'10 - 500 g pkgs.',0,26,0,0,0),(72,'Mozzarella di Giovanni',14,4,'24 - 200 g pkgs.',0,14,0,0,0),(73,'R?d Kaviar',17,8,'24 - 150 g jars',0,101,0,5,0),(74,'Longlife Tofu',4,7,'5 kg pkg.',0,4,20,5,0),(75,'Rh?nbr?u Klosterbier',12,1,'24 - 0.5 l bottles',0,125,0,25,0),(76,'Lakkalik??ri',23,1,'500 ml',0,57,0,20,0),(77,'Original Frankfurter gr?ne So?e',12,2,'12 boxes',0,32,0,15,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `products` ENABLE KEYS */;

--
-- Table structure for table `shippers`
--

DROP TABLE IF EXISTS `shippers`;
CREATE TABLE `shippers` (
  `ShipperID` int(11) NOT NULL AUTO_INCREMENT,
  `CompanyName` varchar(40) DEFAULT NULL,
  `Phone` varchar(24) DEFAULT NULL,
  PRIMARY KEY (`ShipperID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `shippers`
--


/*!40000 ALTER TABLE `shippers` DISABLE KEYS */;
LOCK TABLES `shippers` WRITE;
INSERT INTO `shippers` VALUES (1,'Speedy Express','(503) 555-9831'),(2,'United Package','(503) 555-3199'),(3,'Federal Shipping','(503) 555-9931');
UNLOCK TABLES;
/*!40000 ALTER TABLE `shippers` ENABLE KEYS */;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
CREATE TABLE `suppliers` (
  `SupplierID` int(11) NOT NULL AUTO_INCREMENT,
  `CompanyName` varchar(40) DEFAULT NULL,
  `ContactName` varchar(30) DEFAULT NULL,
  `ContactTitle` varchar(30) DEFAULT NULL,
  `Address` varchar(60) DEFAULT NULL,
  `City` varchar(15) DEFAULT NULL,
  `Region` varchar(15) DEFAULT NULL,
  `PostalCode` varchar(10) DEFAULT NULL,
  `Country` varchar(15) DEFAULT NULL,
  `Phone` varchar(24) DEFAULT NULL,
  `Fax` varchar(24) DEFAULT NULL,
  `HomePage` text,
  PRIMARY KEY (`SupplierID`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `suppliers`
--


/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
LOCK TABLES `suppliers` WRITE;
INSERT INTO `suppliers` VALUES (1,'Exotic Liquids','Charlotte Cooper','Purchasing Manager','49 Gilbert St.','London','','EC1 4SD','United Kingdom','(171) 555-2222','',''),(2,'New Orleans Cajun Delights','Shelley Burke','Order Administrator','P.O. Box 78934','New Orleans','LA','70117','United States','(100) 555-4822','','#CAJUN.HTM#'),(3,'Grandma Kelly\'s Homestead','Regina Murphy','Sales Representative','707 Oxford Rd.','Ann Arbor','MI','48104','United States','(313) 555-5735','(313) 555-3349',''),(4,'Tokyo Traders','Yoshi Nagase','Marketing Manager','9-8 Sekimai\r\nMUnited Statesshino-shi','Tokyo','','100','Japan','(03) 3555-5011','',''),(5,'Cooperativa de Quesos \'Las Cabras\'','Antonio del Valle Saavedra','Export Administrator','Calle del Rosal 4','Oviedo','Asturias','33007','Spain','(98) 598 76 54','',''),(6,'Mayumi\'s','Mayumi Ohno','Marketing Representative','92 Setsuko\r\nChuo-ku','Osaka','','545','Japan','(06) 431-7877','','Mayumi\'s (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/mayumi.htm#'),(7,'Pavlova, Ltd.','Ian Devling','Marketing Manager','74 Rose St.\r\nMoonie Ponds','Melbourne','Victoria','3058','Australia','(03) 444-2343','(03) 444-6588',''),(8,'Specialty Biscuits, Ltd.','Peter Wilson','Sales Representative','29 King\'s Way','Manchester','','M14 GSD','United Kingdom','(161) 555-4448','',''),(9,'PB Kn?ckebr?d AB','Lars Peterson','Sales Agent','Kaloadagatan 13','G?teborg','','S-345 67','Sweden','031-987 65 43','031-987 65 91',''),(10,'Refrescos Americanas LTDA','Carlos Diaz','Marketing Manager','Av. das Americanas 12.890','S?o Paulo','','5442','Brazil','(11) 555 4640','',''),(11,'Heli S??waren GmbH & Co. KG','Petra Winkler','Sales Manager','Tiergartenstra?e 5','Berlin','','10785','Germany','(010) 9984510','',''),(12,'Plutzer Lebensmittelgro?m?rkte AG','Martin Bein','International Marketing Mgr.','Bogenallee 51','Frankfurt','','60439','Germany','(069) 992755','','Plutzer (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/plutzer.htm#'),(13,'Nord-Ost-Fisch Handelsgesellschaft mbH','Sven Petersen','Coordinator Foreign Markets','Frahmredder 112a','Cuxhaven','','27478','Germany','(04721) 8713','(04721) 8714',''),(14,'Formaggi Fortini s.r.l.','Elio Rossi','Sales Representative','Viale Dante, 75','Ravenna','','48100','Italy','(0544) 60323','(0544) 60603','#FORMAGGI.HTM#'),(15,'Norske Meierier','Beate Vileid','Marketing Manager','Hatlevegen 5','Sandvika','','1320','Norway','(0)2-953010','',''),(16,'Bigfoot Breweries','Cheryl Saylor','Regional Account Rep.','3400 - 8th Avenue\r\nSuite 210','Bend','OR','97101','United States','(503) 555-9931','',''),(17,'Svensk Sj?f?da AB','Michael Bj?rn','Sales Representative','Brovallav?gen 231','Stockholm','','S-123 45','Sweden','08-123 45 67','',''),(18,'Aux joyeux eccl?siastiques','Guyl?ne Nodier','Sales Manager','203, Rue des Francs-Bourgeois','Paris','','75004','France','(1) 03.83.00.68','(1) 03.83.00.62',''),(19,'New England Seafood Cannery','Robb Merchant','Wholesale Account Agent','Order Processing Dept.\r\n2100 Paul Revere Blvd.','Boston','MA','02134','United States','(617) 555-3267','(617) 555-3389',''),(20,'Leka Trading','Chandra Leka','Owner','471 Serangoon Loop, Suite #402','Singapore','','0512','Singapore','555-8787','',''),(21,'Lyngbysild','Niels Petersen','Sales Manager','Lyngbysild\r\nFiskebakken 10','Lyngby','','2800','Denmark','43844108','43844115',''),(22,'Zaanse Snoepfabriek','Dirk Luchte','Accounting Manager','Verkoop\r\nRijnweg 22','Zaandam','','9999 ZZ','Netherlands','(12345) 1212','(12345) 1210',''),(23,'Karkki Oy','Anne Heikkonen','Product Manager','Valtakatu 12','Lappeenranta','','53120','Finland','(953) 10956','',''),(24,'G\'day, Mate','Wendy Mackenzie','Sales Representative','170 Prince Edward Parade\r\nHunter\'s Hill','Sydney','NSW','2042','Australia','(02) 555-5914','(02) 555-4873','G\'day Mate (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/gdaymate.htm#'),(25,'Ma Maison','Jean-Guy Lauzon','Marketing Manager','2960 Rue St. Laurent','Montr?al','Qu?bec','H1J 1C3','Canada','(514) 555-9022','',''),(26,'Pasta Buttini s.r.l.','Giovanni Giudici','Order Administrator','Via dei Gelsomini, 153','Salerno','','84100','Italy','(089) 6547665','(089) 6547667',''),(27,'Escargots Nouveaux','Marie Delamare','Sales Manager','22, rue H. Voiron','Montceau','','71300','France','85.57.00.07','',''),(28,'Gai p?turage','Eliane Noz','Sales Representative','Bat. B\r\n3, rue des Alpes','Annecy','','74000','France','38.76.98.06','38.76.98.58',''),(29,'For?ts d\'?rables','Chantal Goulet','Accounting Manager','148 rue Chasseur','Ste-Hyacinthe','Qu?bec','J2S 7S8','Canada','(514) 555-2955','(514) 555-2921','');
UNLOCK TABLES;
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

