function setMunicipios(){
    var estado = $('#estado').val();
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'setMunicipios',
        estado: estado        
    }, function(data) {
        if (data.response){ 
            $('#ciudad').html(data.municipios); 
            $('#ciudad').select2("destroy"); 
            $('#ciudad').select2(); 
        }
    }, 'json');
}

function limpiarColonia(){
     $('#colonia').select2("val","0"); 
}

function setColonias(){
    var codigoPostal = $('#codigo_postal').val();
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'setColonias',
        codigoPostal: codigoPostal        
    }, function(data) {
        if (data.response){ 
            $('#colonia').html(data.colonias); 
            $('#colonia').select2("destroy"); 
            $('#colonia').select2(); 
        }
    }, 'json');
}

function scroll_to_class(element_class, removed_height) {
    var scroll_to = $(element_class).offset().top - removed_height;
    if($(window).scrollTop() != scroll_to) {
        $('html, body').stop().animate({scrollTop: scroll_to}, 0);
    }
}

function bar_progress(progress_line_object, direction) {
    var number_of_steps = progress_line_object.data('number-of-steps');
    var now_value = progress_line_object.data('now-value');
    var new_value = 0;
    if(direction == 'right') {
        new_value = now_value + ( 100 / number_of_steps );
    }
    else if(direction == 'left') {
        new_value = now_value - ( 100 / number_of_steps );
    }
    progress_line_object.attr('style', 'width: ' + new_value + '%;').data('now-value', new_value);
}

jQuery(document).ready(function() {	
    /*Fullscreen background*/
    $.backstretch("assets/img/backgrounds/1.jpg");    
    $('#top-navbar-1').on('shown.bs.collapse', function(){
    	$.backstretch("resize");
    });
    $('#top-navbar-1').on('hidden.bs.collapse', function(){
    	$.backstretch("resize");
    });
    
    /*Form*/
    $('.f1 fieldset:first').fadeIn('slow');
    
    $('.f1 input[type="text"], .f1 input[type="password"], .f1 textarea').on('focus', function() {
    	$(this).removeClass('input-error');
    });
    
     // submit
    $('.f1').on('submit', function(e) {    	
    	// fields validation
    	$(this).find('input[type="text"], input[type="password"], textarea').each(function() {
            if( $(this).val() == "" ) {
                    e.preventDefault();
                    $(this).addClass('input-error');
            }else {
                    $(this).removeClass('input-error');
            }
    	});
    	// fields validation
    	
    });
});

function validateRequired(btn){ 
    var parent_fieldset = $(btn).parents('fieldset');
    var next_step = true;
    
    parent_fieldset.find('.required').each(function() {
        if( $(this).val() == "" ) {
            $(this).addClass('input-error');
            next_step = false;
        }
        else {
           $(this).removeClass('input-error');
        }
    });
    
    return next_step;
}
    
/* next step*/
function goNextStep(btn) {
    $('#flashmessenger').html('');
    var parent_fieldset = $(btn).parents('fieldset');
    
    // navigation steps / progress steps
    var current_active_step = $(btn).parents('.f1').find('.f1-step.active');
    var progress_line = $(btn).parents('.f1').find('.f1-progress-line');   

    parent_fieldset.fadeOut(400, function() {
        // change icons
        current_active_step.removeClass('active').addClass('activated').next().addClass('active');
        // progress bar
        bar_progress(progress_line, 'right');
        // show next step 

        $(this).next().fadeIn();
        // scroll window to beginning of the form
        scroll_to_class( $('.f1'), 20 );
    });	
}
    
    // previous step
function goPreviousStep(btn) {
     // navigation steps / progress steps
     var current_active_step = $(btn).parents('.f1').find('.f1-step.active');
     var progress_line = $(btn).parents('.f1').find('.f1-progress-line');

     $(btn).parents('fieldset').fadeOut(400, function() {
         // change icons
         current_active_step.removeClass('active').prev().removeClass('activated').addClass('active');
         // progress bar
         bar_progress(progress_line, 'left');
         // show previous step
         $(this).prev().fadeIn();
         // scroll window to beginning of the form
         scroll_to_class( $('.f1'), 20 );
     });
 } 

function goStepCliente(btn){
    if(validateRequired(btn)){
        var options = $('#ticketForm :input').serializeArray();
        $.post('/Controller/Ajax.php', {
            action: 'ajax',
            request: 'validarTicket',
            options:options
        }, function(data) {
            if (data.response){ 
                if(data.status == '0'){
                    $('#id_ticket_table').val(data.id_ticket_table);
                    goNextStep(btn);
                }else if(data.status == '1'){
                    $('#flashmessenger').html(data.msg);
                }              
            }else{
                $('#flashmessenger').html(data.msg);
            }
        }, 'json');
    }  
}

function goStepFactura(btn){
    if(validateRequired(btn)){      
        goNextStep(btn);
    }              
}

function listDomiciliosFiscalesByRFC(){
    var rfc = $('#rfc').val();
     
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getDomiciliosFiscalesByRFC',
        rfc:rfc
    }, function(data) {
        if (data.response){ 
            $("#tblListaDomiciliosPorRFC").find('tbody').empty().append(data.domiciliosFiscales);
            $('#modalListaDomiciliosPorRFC').modal('show');
        }
    }, 'json');
}

function setDomicilioFiscalToEdit(data){
    for (var name in data) {
        $('#'+name).val(data[name]);
    } 
    
    if(data['pais']){
        $("#s2id_pais").select2("destroy");
        $("#pais").select2(); 
    }
    
    if(data['estado']){
        $("#s2id_estado").select2("destroy");
        $("#estado").select2(); 
    }    
    
    setMunicipios();
    setTimeout(function(){$("#ciudad").val(data['ciudad']).trigger('change')},1000);
}

function facturar(btn){
    var options = $("#ticketForm :input,#clienteForm :input, #email").serializeArray();
    $(btn).attr('disabled',true);
    
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'facturarTicket',
        options:options
    }, function(data) {
        if (data.response){ 
            $(':input').val('');
            $('button').remove();
            $('#step_factura_content').html(data.step_factura_content);
        }
        $('#flashmessenger').html(data.msg);
    }, 'json');
}