$('.daterange').daterangepicker({
    ranges   : {
        '1 año'     : [moment().subtract(1, 'years').startOf('year'), moment().endOf("year")],
        '2 años'    : [moment().subtract(2, 'years').startOf('year'), moment().endOf("year")],
        '3 años'    : [moment().subtract(3, 'years').startOf('year'), moment().endOf("year")]
    },
    startDate: moment().subtract(29, 'days'),
    endDate  : moment()
  }, function (start, end) {
        _salesChart(start.format('MM/DD/YYYY'),end.format('MM/DD/YYYY'),);
  });
  
  function _salesChart(startDate,endDate){
            $.post('/Controller/Factura.php', {
            action: 'ajax',
            request: 'getTotalFactura',
            start: startDate,
            end: endDate
        }, function(data) {
            $("#canvas_chart_sales").remove();
            $("#chart_sales").append('<canvas id="canvas_chart_sales"></canvas>');
            
            if (data.response){                
                $("#tbl_sales").find('caption').empty().append(data.caption);
                $("#tbl_sales").find('tbody').empty().append(data.salesData);
                var stores = [];
                var sales = [];
                for (var name in data.chartData) {
                    stores.push(name);
                    sales.push(data.chartData[name]);
                }     
                var barChartData = {
                        labels: stores,
                        datasets: [{
                            label: ['Ventas'],
                            backgroundColor: '#3b83bd',
                            borderColor: '#3b83bd',
                            borderWidth: 1,
                            data: sales
                        }]

                };             
                
                var ctx = document.getElementById('canvas_chart_sales').getContext('2d');
                window.myBar = new Chart(ctx, {
                        type: 'bar',
                        data: barChartData,
                        options: {
                                responsive: true,
                                legend: {
                                        position: 'top',
                                },
                                title: {
                                        display: true,
                                        text: ['Ventas por dia',data.caption,'Total ventas $'+data.totalSales.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")]
                                },scales: {
                                    yAxes: [{
                                        ticks: {                                                 
                                           min: 0
                                        }   
                                    }]
                               
                            },   
                            tooltips: {
                                callbacks: {
                                    label: function(tooltipItems, data) {
                                    return "$" + tooltipItems.yLabel.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                                    }
                                }
                            }
                        }
                });
            }else{
                $("#tbl_sales").find('tbody').empty().append("<td colspan='2' class='text-center' style='padding:10px'>No se encontraton resultados.</td>");             
            }
        }, 'json');
  }
  
  $('.daterange_sold_pacas').daterangepicker({
    ranges   : {
      'Today'       : [moment(), moment()],
      'Yesterday'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
      'Last 30 Days': [moment().subtract(29, 'days'), moment()],
      'This Month'  : [moment().startOf('month'), moment().endOf('month')],
      'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    },
    startDate: moment().subtract(29, 'days'),
    endDate  : moment()
  }, function (start, end) {
        _soldPacasChart(start.format('MM/DD/YYYY'),end.format('MM/DD/YYYY'),);
  });
  
  function _soldPacasChart(startDate,endDate){
            $.post('/Controller/Sales.php', {
            action: 'ajax',
            request: 'getTotalSoldPacas',
            start: startDate,
            end: endDate
        }, function(data) {
            $("#canvas_chart_sold_pacas").remove();
            $("#chart_sold_pacas").append('<canvas id="canvas_chart_sold_pacas"></canvas>');
            
            if (data.response){                
                $("#tbl_sold_pacas").find('caption').empty().append(data.caption);
                $("#tbl_sold_pacas").find('tbody').empty().append(data.salesData);
                var stores = [];
                var sales = [];
                for (var name in data.chartData) {
                    stores.push(name);
                    sales.push(data.chartData[name]);
                }     
                var barChartData = {
                        labels: stores,
                        datasets: [{
                                label: 'Pacas vendidas',
                                backgroundColor: '#3b83bd',
                                borderColor: '#3b83bd',
                                borderWidth: 1,
                                data: sales
                        }]
                };             
                
                var ctx = document.getElementById('canvas_chart_sold_pacas').getContext('2d');
                window.myBar = new Chart(ctx, {
                        type: 'bar',
                        data: barChartData,
                        options: {
                                responsive: true,
                                legend: {
                                        position: 'top',
                                },
                                title: {
                                        display: true,
                                        text: ['Pacas vendidas por dia',data.caption,'Total pacas vendidas '+data.totalPacas.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")]
                                },scales: {
                                    yAxes: [{
                                             ticks: {                                                 
                                                min: 0
                                              }   
                                            }]
                               
                            },   
                            tooltips: {
                                callbacks: {
                                    label: function(tooltipItems, data) {
                                    return tooltipItems.yLabel.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                                    }
                                }
                            }
                        }
                });
            }else{
                $("#tbl_sales").find('tbody').empty().append("<td colspan='2' class='text-center' style='padding:10px'>No se encontraton resultados.</td>");             
            }
        }, 'json');
  }