/*********************************/
/*****   MANUFACTURING   ********/
/*******************************/
$(document).ajaxStart($.blockUI).ajaxStop($.unblockUI);
$.fn.modal.Constructor.prototype.enforceFocus = $.noop;

function addMsgFlashmessenger(tipo,msg,messengerId){
    $('#msg').remove();
    $('#'+messengerId).append("<div id='msg' class='alert alert-"+tipo+"'></div>");
    var btnClose = "<button type='button' class='close' data-dismiss='alert'>&times;</button>";
    $('#msg').html(btnClose+msg);
    fadeOutAlert();
}

function _getTranslation(msj,callback){
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getTranslation',
        msj:msj
            }, function(data) {
                if(callback){
                    callback(data.translation);
                }else{
                    return data.translation;
                }
                
            }, 'json');
}

function validarForm(formName){
    if(formValida($("form[name='"+formName+"']")[0])){
        $("form[name='"+formName+"']").submit();
    }else{
        alert('');
    }
}

/*Lista pallets de lotes seleccionados desde select 'Ref#/Lote'*/
function setPalletListByLot(lot,callback){                      
    var date = $('#date').val();
    if(date === ''){    
        $('#lot').val('').trigger('change');
        alert('Para continuar necesita seleccionar fecha y hora de inicio'); 
        return null;
    }
   
    if($('#lot').val()=== '' || $('#lot').val()=== null){return null;}    
    
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'setPalletListByLot',
        lot: lot,
        date:date,
        token_form: $('#token_form').val()
    }, function(data) { 
        if (data.response){            
            destroyDataTable('palletsDetails');
            $('#palletsDetails').find('tbody').html(data.palletsDetails);
            setDataTable('palletsDetails');
            if(callback){callback();}
        }else{
            $('#lots').val('').trigger('change');  
            
            $.confirm({
                theme: 'material',
                columnClass: 'col-md-8 col-md-offset-2',
                icon: 'fa fa-info-circle',
                title: 'Error',
                content: data.msg,
                type:'red',
                buttons:{     
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red col-xs-6 pull-right',
                        action: function(){$(this).remove();}
                    }
                }
            });
        }
    }, 'json');    
}

/* Cambia status 1 - 2; y actualiza campo quantity_boxes_mfg
 * Se llama en onclick de checkbox */
function setInputPallet(pallet){
    var idDetail = $(pallet).data('iddetalle');
    var activeLot = $('#active_lot').val();
    //cambiar active_lot [por key_to_get_info (lot + type(Manifest o MFG))

    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'setInputPallet',
        idDetail: idDetail,
        activeLot: activeLot,
        token_form: $('#token_form').val()
    }, function(data) {
        if (data.response){
            destroyDataTable('palletsDetails');
            $('#palletsDetails').find('tbody').html(data.palletsDetails);
            setDataTable('palletsDetails');
            
            $("#inputSummary").find('tbody').html(data.inputSummary);          
            $("#distinctLots").html(data.distinctLots);
            
            //If activeLot != ''; data.lotDetails return details
            $("#tblInput").find('tbody').html(data.detailsByLot);
            
            if(activeLot !== '' && data.detailsByLot === ''){
                $('#setManufacturingDetails ').modal('hide');
            }
        }else{
            $(pallet).prop("checked",true);
            $.alert({content:data.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-4 col-md-offset-4'});      
        }
    }, 'json');
}

/*Muestra informacion en modal setManufacturingDetails de lote seleccionado
 * en pestaña Detalles Entrada & Salida */
function setMfgDetails(btn){
    var lot = $(btn).data('lot');
    $('#active_lot').val(lot);
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'setMfgDetails',
        lot: lot,
        token_form: $('#token_form').val()
    }, function(data) {
        if (data.response){
                $("#tblInput").find('tbody').html(data.inputDetails);
                $("#tblOutput").find('tbody').html(data.outputDetails);
                $("#tblWaste").find('tbody').html(data.wasteDetails);
                
                if($('#status').val()==='2'){
                    $('#tblInput tr td input').prop('disabled',true);
                    $('#tblInput tr td a').removeClass('editInputBoxes');
                    $('#tblOutput tr td a,#tblWaste tr td a').addClass('disabled');
                }
            }
    }, 'json');  
    
    $('#setManufacturingDetails ').modal('show');
}

/* Actualiza campo quantity_boxes_mfg; si activeLot != '' lista tblInput en modal abierto */
function editInputBoxes(){
    var idDetail = $('#idDetail').val();
    var quantity = _rawNumber($('#quantity_boxes_input').val());
    var activeLot = $('#active_lot').val();
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'editInputBoxes',
        idDetail: idDetail,
        quantity: quantity,
        activeLot: activeLot,
        token_form: $('#token_form').val()
    }, function(data) {
        if (data.response){
                destroyDataTable('palletsDetails');
                $('#palletsDetails').find('tbody').html(data.palletsDetails);
                setDataTable('palletsDetails');
            
                $("#inputSummary").find('tbody').html(data.inputSummary);
                
                if($("#setManufacturingDetails").is(':visible')){
                    $("#tblInput").find('tbody').html(data.detailsByLot);
                }                
                
                $('#modalEditInputBoxes ').modal('hide');
                $('#quantity_boxes_input').val('');
                $('#idDetail').val('');                
            }else{
                $.alert({content:data.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-6 col-md-offset-3'});
            }
    }, 'json');  
}

function setOutputBoxes(){
    var quantity = _rawNumber($('#quantity_boxes').val());
    if(!$.isNumeric(quantity)){quantity = 0;}
    if(quantity <= 0){
        _getTranslation('El campo Cajas debe ser mayor a 0.',function(msj){$.alert({content:msj,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-4 col-md-offset-4'});});        
        return null;
    }
    
    var activeLot = $('#active_lot').val();
    var idDetail = $('form[name=agregar_producto_a_manifiesto] #id').val();
    var options = $("form[name='agregar_producto_a_manifiesto']").serializeArray();
    options.push({name:'lot',value:activeLot});
    options.push({name:'token_form',value:$('#token_form').val()});
    
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'setOutputBoxes',
        idDetail: idDetail,
        options: options
    }, function(data) {
        if (data.response){                                       
            $("#tblOutput").find('tbody').html(data.outputDetails);
            $("#outputSummary").find('tbody').html(data.outputSummary);
            $("#outputSummaryByLot").find('tbody').html(data.outputSummaryByLot);
            
            setTimeout(function(){setDraggableTableToSplit();},500);
            
            /*Function declarated on functions.js*/
            clearFormAddProductToManifest();
            $('form[name=agregar_producto_a_manifiesto] #id').val('');
        }
    }, 'json');
}

function isEditableOB(id,callback){
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'isEditableOB',
        id: id,
        token_form: $('#token_form').val()
    }, function(data) {
            callback(data);
    }, 'json');
}

function setOutputBoxesToEdit(data){
    isEditableOB(data['id_output_detail'],function(r){
        if(r.response === false){
            $.alert({content:r.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-4 col-md-offset-4'});
            return null;
        }
        
         //Asigno manual el valor de id_producto para cuando se ejecute setListProductPropierties ya tenga el valor id_product.
        $('#id_product').val(data['id_product']).trigger('change');     
        
        setListProductPropierties(function(){
            for (var name in data) {
                $('form[name=agregar_producto_a_manifiesto] #'+name).val(data[name]).trigger('change');
            }     
            
            $('#quantity_boxes').val(number_format(data['quantity_boxes'],2,'.',','));
            $('#weight').val(number_format(data['weight'],2,'.',','));
            
            $('#modalAgregarProductoAManifiesto').modal('show'); 
        });
              
    });  
}

function deleteOutputBoxes(id){
     isEditableOB(id,function(r){
        if(r.response === false){
            $.alert({content:r.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-4 col-md-offset-4'});
            return null;
        }
        
         $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar registro',
            content: 'Desea eliminar el registro ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                            var activeLot = $('#active_lot').val();
                            $.post('/Controller/Manufacturing.php', {
                                  action: 'ajax',
                                  request: 'deleteOutputBoxes',
                                  id: id,
                                  activeLot:activeLot,
                                  token_form:$('#token_form').val()
                              }, function(data) {
                                  if (data.response){
                                          $("#tblOutput").find('tbody').html(data.outputDetails);
                                          $("#outputSummary").find('tbody').html(data.outputSummary);
                                          $("#outputSummaryByLot").find('tbody').html(data.outputSummaryByLot);
                                          
                                          setTimeout(function(){setDraggableTableToSplit();},500);

                                          /*Function declarated on functions.js*/
                                          clearFormAddProductToManifest();
                                  }else{
                                      $.alert({content:data.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-4 col-md-offset-4'});
                                  }
                              }, 'json');
                    }
                }
            }
        });
        return null;      
    });  
   
}

function setWasteBoxes(){
    var quantity = _rawNumber($('#quantity_boxes').val());
    if(!$.isNumeric(quantity)){quantity = 0;}
    if(quantity <= 0){
        _getTranslation('El campo Cajas debe ser mayor a 0.',function(msj){$.alert({content:msj,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-4 col-md-offset-4'});});        
        return null;
    }
    
    var activeLot = $('#active_lot').val();
    var idDetail = $('form[name=agregar_producto_a_manifiesto] #id').val();
    var options = $("form[name='agregar_producto_a_manifiesto']").serializeArray();
    options.push({name:'lot',value:activeLot});
    options.push({name:'token_form',value:$('#token_form').val()});
    
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'setWasteBoxes',
        idDetail: idDetail,
        options: options
    }, function(data) {
        if (data.response){                                       
            $("#tblWaste").find('tbody').html(data.wasteDetails);
            $("#wasteSummary").find('tbody').html(data.wasteSummary);
            
            /*Function declarated on functions.js*/
            clearFormAddProductToManifest();
            $('form[name=agregar_producto_a_manifiesto] #id').val('');
        }
    }, 'json');
}

function setWasteBoxesToEdit(data){
    for (var name in data) {
        $('form[name=agregar_producto_a_manifiesto] #'+name).val(data[name]).trigger('change');
    } 
    
    $('#quantity_boxes').val(number_format(data['quantity_boxes'],2,'.',','));
    $('#weight').val(number_format(data['weight'],2,'.',','));
    $('#modalAgregarProductoAManifiesto').modal('show');
}

function deleteWasteBoxes(id){
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar registro',
            content: 'Desea eliminar el registro ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                            var activeLot = $('#active_lot').val();
                            $.post('/Controller/Manufacturing.php', {
                                  action: 'ajax',
                                  request: 'deleteWasteBoxes',
                                  id: id,
                                  activeLot:activeLot,
                                  token_form:$('#token_form').val()
                              }, function(data) {
                                  if (data.response){
                                          $("#tblWaste").find('tbody').html(data.wasteDetails);
                                          $("#wasteSummary").find('tbody').html(data.wasteSummary);

                                          /*Function declarated on functions.js*/
                                          clearFormAddProductToManifest();
                                  }else{
                                      $("#flashmessenger").html(data.mensaje);
                                  }
                              }, 'json');
                    }
                }
            }
        });
        return null;
}

function clearInfoLote(lot,callback){
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'clearInfoLoteFromMFG',
        lot: lot,
        token_form: $('#token_form').val()
    }, function(data) {
        if (data.response){                                
            destroyDataTable('palletsDetails');
            $('#palletsDetails').find('tbody').html(data.palletsDetails);
            setDataTable('palletsDetails');
            
            $("#distinctLots").html(data.distinctLots);            
            $("#inputSummary").find('tbody').html(data.inputSummary);
            $("#outputSummary").find('tbody').html(data.outputSummary);
            $("#wasteSummary").find('tbody').html(data.wasteSummary);
            $("#outputSummaryByLot").find('tbody').html(data.outputSummaryByLot);
            $("#outputPalletsDetails").find('tbody').html(data.outputPallets);          
        }else{
            $.alert({content:data.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-6 col-md-offset-3'});            
        }
        
        callback(data.response);
        
    }, 'json');         
}

function allowEditManufacturing(){
    confirmAction(function(){
        var idManufacturing = $('form[name=manufacturing] input[name=id]').val();
        $.post('/Controller/Manufacturing.php', {
            action: 'ajax',
            request: 'allowEditManufacturing',
            idManufacturing:idManufacturing
        }, function(data) {
            if (data.response){
                document.location.reload();
            }else{
                $('#flashmessenger').html(data.message);
                fadeOutAlert();
            }
    }, 'json');
    });
}

function validateDateLots(e){
        var oldDate = e.oldDate.format('MM/DD/YYYY hh:mm A ');
        $.post('/Controller/Manufacturing.php', {
            action: 'ajax',
            request: 'validateDateLots',
            date: $('#date').val(),
            lots:$('#lots').val()
        }, function(data) {
            if (data.response){
                //document.location.reload();
            }else{
                $('#date').val(oldDate);            
                $.confirm({
                    theme: 'material',
                    columnClass: 'col-md-8 col-md-offset-2',
                    icon: 'fa fa-info-circle',
                    title: 'Error',
                    content: data.msg,
                    type:'red',
                    buttons:{     
                        confirm: {
                            text: 'OK',
                            btnClass: 'btn-red col-xs-6 pull-right',
                            action: function(){$(this).remove();}
                        }
                    }
                });
            }
    }, 'json');
}

function addByIdPallet(e,element){     
    var code = (e.keyCode ? e.keyCode : e.which);
    if(code===13){        
        var pallet = $(element).val();
        $.post('/Controller/Manufacturing.php', {
            action: 'ajax',
            request: 'getDataPalletById',
            pallet_id: pallet,
            token_form: $('#token_form').val()
        }, function(data) { 
            if (data.response){
                if(data.listed){
                    if(data.actived){  
                        /*mostrar mensaje*/
                        $.alert({content:data.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-4 col-md-offset-4'});
                    }else{
                        /*Activar lote*/
                        var pallet = $(element).val();
                        setInputPallet($('._'+pallet));
                    }
                }else{
                    var lot = [];
                    $.each($("#lot option:selected"), function(){
                        lot.push($(this).val());
                    });
                    lot.push(data.lot);
                    $('#lot').val(lot).trigger('change');
                    
                    var pallet = $(element).val();  
                    setPalletListByLot(data.lot,function(){setInputPallet($('._'+pallet));});
                }                
            }else{
                $.alert({content:data.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-4 col-md-offset-4'});
            }
            $('._add_pallet_id').val('').focus();
        }, 'json');
    }
}

/*NEW*/
function showAvailableInventoryByMfgOutput(){
    var id_product = $('#id_product').val();
    if(id_product === '0') return null;
    
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'getAvailableInventoryByMfgOutput',
        id_product: id_product,
        token_form: $('#token_form').val()
    }, function(data) {
        if(data.noShowDialog){return null;}
        
        $("#inventoryByMfgOutput").find('tbody').html('');
        $('#availableInventoryByMfgOutput_message').html('');
        
        if (data.response){
            $('#availableInventoryByMfgOutput_message').html(data.message);
            
            if ($.fn.dataTable.isDataTable( '#inventoryByMfgOutput' )) {
                var table = $('#inventoryByMfgOutput').DataTable();
                table.destroy();
            }  
            
            $("#inventoryByMfgOutput").find('tbody').html(data.availableInventory);            
            var table = $('#inventoryByMfgOutput').DataTable({
                paginate:false,
                filter:true,
                bFilter:true,
                aaSorting:[], 
                drawCallback: function () {
                    var api = this.api();
                    
                     _getTranslation('Total cajas',function(msj){
                         $('.sum_boxes').html(msj+':'+number_format(api.column( 10, {page:'current'} ).data().sum(),0,'.',','));
                    });     
                    
                     _getTranslation('Cajas disponibles',function(msj){
                         $('.sum_available').html(msj+':'+number_format(api.column( 11, {page:'current'} ).data().sum(),0,'.',','));
                    });     
                }
            });
        
            $('#inventoryByMfgOutput tfoot th.filter').each( function () {
                $(this).html( '<input type="text" placeholder="Buscar" style="width:100%" />' );
            } );     
            
            // Apply the search
            table.columns().every( function () {
                var that = this; 
                $( 'input', this.footer() ).on( 'keyup change', function () {
                    if ( that.search() !== this.value ) {
                        that
                            .search (this.value.replace("/;/g", "|"), true, false)
                            .draw();
                    }
                } );
            } );
        }
        
        $('#modalAvailableInventoryByMfgOutput').modal('show');
        clearFormAddProductToManifest();
    }, 'json');    
}

function setInfoProductOuputPallet(data){     
    for (var name in data) {
        $('form[name=agregar_producto_a_manifiesto] #'+name).val(data[name]).trigger('change');        
    }     
    
    denyEditProductInModalSR('#id_product'); /*Esta funcion esta en funciones.js*/
    
    $('#quantity_boxes').val(number_format(data['available'],2,'.',','));    
    $('#quantity_boxes').select().focus();    
    $('#modalAvailableInventoryByMfgOutput').modal('hide');
}

/*NEW OUTPUT PALLETS*/
function setOutputPalletsDetalles(){
    var cajas = _rawNumber($('#quantity_boxes').val());  
    var cajasPorPallet = _rawNumber($('#quantity_boxes_per_pallets').val());    
    
    if(!$.isNumeric(cajas)){cajas = '0';}
    if(!$.isNumeric(cajasPorPallet)){cajasPorPallet = '0';}
   
    if(cajas === '0' || cajasPorPallet === '0'){
        _getTranslation('El campo Cajas y Cajas por pallet deben ser mayor a 0.',function(msj){$.alert({content:msj,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-6 col-md-offset-3'});});        
        return null;
    }
    
    var options = $("form[name='agregar_producto_a_manifiesto']").serializeArray();
    options.push({name:'token_form',value:$('#token_form').val()});
    
    $.post('/Controller/Manufacturing.php', {
            action: 'ajax',
            request: 'setOutputPalletsDetalles',
            options: options
        }, function(data) {
            if (data.response){
                 $("#outputPalletsDetails").find('tbody').html(data.outputPalletsDetails);
                 clearFormAddProductToManifest();
                 $("form[name='agregar_producto_a_manifiesto'] #idDetalleTemp")
            }else{
                $.alert({content:data.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-6 col-md-offset-3'});     
                fadeOutAlert();
            }
    }, 'json');
}

function setDetalleOutputPallesDetailsToEdit(data,btn){
    $('#guardar').unbind('click').on('click',function(){setOutputPalletsDetalles();});
    $('#guardar_mixto').unbind('click').on('click',function(){setOutputPalletsDetallesMixto();}); 
    
    setFormAddProductToManifest(btn,function(){
        //Asigno manual el valor de id_producto para cuando se ejecute setListProductPropierties ya tenga el valor id_product.
        $('#id_product').val(data['id_product']).trigger('change');     
        $('#id_product').on('select2:select', function(){showAvailableInventoryByMfgOutput();});
        
        setListProductPropierties(function(){ 
            for (var name in data) {$('form[name=agregar_producto_a_manifiesto] #'+name).val(data[name]).trigger('change');}
            
            $('#quantity_boxes_per_pallets').prop('readOnly',true); 
            $('#quantity_boxes').val(number_format(data['quantity_boxes'],2,'.',','));
            $('#weight').val(number_format(data['weight'],2,'.',','));
            $('#quantity_boxes_per_pallets').val(number_format(data['quantity_boxes_per_pallets'],2,'.',','));
            $('#quantity_pallets').val(number_format(data['quantity_pallets'],0,'.',','));
            denyEditProductInModalSR('#id_product');              
        
            if($('#mixto').val() !== '0'){
                //Si es mixto, limpio form; mixto lo dejo con el valor
                var mixto = $('#mixto').val();   
                
                clearFormAddProductToManifest();
                $("form[name='agregar_producto_a_manifiesto'] #idDetalleTemp").val('');            
                $('#mixto').val(mixto);

                getListOutputPalletsDetailsMixto();
            }        

            $('#modalAgregarProductoAManifiesto').modal('show');
        });         
    });  
}

function deleteOutputPallesDetails(id){    
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar registro',
            content: 'Desea eliminar el registro ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                          $.post('/Controller/Manufacturing.php', {
                                action: 'ajax',
                                request: 'deleteDetalles',
                                id: id
                            }, function(data) {
                                if (data.response){
                                        $("#outputPalletsDetails").find('tbody').html(data.outputPalletsDetails);                                     
                                        $(".cajasTotal").html(number_format(data.cajasTotal,2,'.',','));
                                        $(".palletsTotal").html(number_format(data.palletsTotal,0,'.',','));
                                        $(".pesoTotal").html(number_format(data.pesoTotal,2,'.',','));
                                }else{
                                    $.alert({content:data.message,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-6 col-md-offset-3'});
                                }
                            }, 'json');
                    }
                }
            }
        });
        return null;
}

function deleteMultitpleOutputPallesDetails(){    
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar registro',
            content: 'Desea eliminar registros seleccionados ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $('._checkboxPalletId:checked').each(function(){        
                            $.post('/Controller/Manufacturing.php', {
                                  action: 'ajax',
                                  request: 'deleteDetalles',
                                  id: $(this).data('id')
                              }, function(data) {
                                  if (data.response){
                                          $("#outputPalletsDetails").find('tbody').html(data.outputPalletsDetails);                                     
                                          $(".cajasTotal").html(number_format(data.cajasTotal,2,'.',','));
                                          $(".palletsTotal").html(number_format(data.palletsTotal,0,'.',','));
                                          $(".pesoTotal").html(number_format(data.pesoTotal,2,'.',','));
                                  }else{
                                      $.alert({content:data.message,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-6 col-md-offset-3'});
                                  }
                              }, 'json');
                        });
                    }
                }
            }
        });
        return null;
}

function setOutputPalletsDetallesMixto(){ 
    var cajas = _rawNumber($('#quantity_boxes').val());  
    var cajasPorPallet = _rawNumber($('#quantity_boxes_per_pallets').val());    
    
    if(!$.isNumeric(cajas)){cajas = '0';}
    if(!$.isNumeric(cajasPorPallet)){cajasPorPallet = '0';}
   
    if(cajas === '0' || cajasPorPallet === '0'){
        _getTranslation('El campo Cajas y Cajas por pallet deben ser mayor a 0.',function(msj){$.alert({content:msj,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-6 col-md-offset-3'});});        
        return null;
    }
    
    var options = $("form[name='agregar_producto_a_manifiesto'] input,form[name='agregar_producto_a_manifiesto'] select,form[name='agregar_producto_a_manifiesto'] hidden").serializeArray();   
    options.push({name:'token_form',value:$('#token_form').val()});
    
    $.post('/Controller/Manufacturing.php', {
        action: 'ajax',
        request: 'setOutputPalletsDetalles',
        options: options        
    }, function(data) {
        if (data.response){
                $("#outputPalletsDetails").find('tbody').html(data.outputPalletsDetails);
                $(".cajasTotal").html(number_format(data.cajasTotal,2,'.',','));
                $(".pesoTotal").html(number_format(data.pesoTotal,2,'.',','));
                $(".palletsTotal").html(number_format(data.palletsTotal,0,'.',','));
                
                $("#manifestDetailsMixto").find('tbody').html(data.outputPalletsDetailsMixto);
                $(".cajasTotalMixto").html(number_format(data.cajasTotalMixto,2,'.',','));
                $(".pesoTotalMixto").html(number_format(data.pesoTotalMixto,2,'.',','));
                
                var mixto = $('#mixto').val();
                clearFormAddProductToManifest();              
                truncateSelect2InModalSR();
                
                $("form[name='agregar_producto_a_manifiesto'] #idDetalleTemp").val('');   
                $('#mixto').val(mixto);
        }else{
            $.alert({content:data.msg,title:"<i class='fa fa-info-circle'></i> Message", columnClass: 'col-md-6 col-md-offset-3'});
        }
    }, 'json');
}

function setDetalleOuputPalletsToEditMixto(data){
    //Asigno manual el valor de id_producto para cuando se ejecute setListProductPropierties ya tenga el valor id_product.
    $('#id_product').val(data['id_product']).trigger('change');     
    
    setListProductPropierties(function(){
        for (var name in data) {$('form[name=agregar_producto_a_manifiesto] #'+name).val(data[name]).trigger('change');} 
        $('#quantity_boxes_per_pallets').prop('readOnly',true);   
        $('#quantity_boxes').val(number_format(data['quantity_boxes'],2,'.',','));
        $('#quantity_boxes_per_pallets').val(number_format(data['quantity_boxes_per_pallets'],2,'.',','));
        $('#quantity_pallets').val(number_format(data['quantity_pallets'],0,'.',','));
        denyEditProductInModalSR('#id_product');
    });           
}

function getListOutputPalletsDetailsMixto(){
    var mixto = $('#mixto').val();
    $.post('/Controller/Manufacturing.php', {
            action: 'ajax',
            request: 'getListOuputPalletDetailsMixto',
            mixto: mixto,
            token_form: $('#token_form').val()
        }, function(data) {
            if (data.response){
                    $("#manifestDetailsMixto").find('tbody').html(data.outputPalletsDetailsMixto); 
                    $(".cajasTotalMixto").html(number_format(data.cajasTotalMixto,2,'.',','));
                    $(".pesoTotalMixto").html(number_format(data.pesoTotalMixto,2,'.',','));
            }else{
                $('#flashmessenger-agregarProductoM').html(data.message);
                fadeOutAlert();
            }
    }, 'json');
}

function deleteOutputPallesDetailsMixto(id){    
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar registro',
            content: 'Desea eliminar el registro ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                          $.post('/Controller/Manufacturing.php', {
                                action: 'ajax',
                                request: 'deleteOutputPallesDetailsMixto',
                                id: id
                            }, function(data) {
                                    if (data.response){
                                        destroyDataTable('shippingRequestDetails');
                                        $("#manifestDetailsMixto").find('tbody').html(data.outputPalletsDetailsMixto); 
                                        $(".cajasTotalMixto").html(number_format(data.cajasTotalMixto,2,'.',','));
                                        $(".pesoTotalMixto").html(number_format(data.pesoTotalMixto,2,'.',','));

                                        $("#outputPalletsDetails").find('tbody').html(data.outputPalletsDetails);                                      
                                        $(".cajasTotal").html(number_format(data.cajasTotal,2,'.',','));
                                        $(".palletsTotal").html(number_format(data.palletsTotal,0,'.',','));
                                        $(".pesoTotal").html(number_format(data.pesoTotal,2,'.',','));
                                        $(".precioTotal").html(number_format(data.precioTotal,2,'.',','));
                                        
                                        configShippingRequestColumnTable('shippingRequestDetails');
                                    }else{
                                        $("#flashmessenger").html(data.mensaje);
                                    }
                            }, 'json');
                    }
                }
            }
        });
        return null;
}